/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.service.mf.impl.AbstractAlterCreateEventTriggerOperationImpl;
import com.streamscape.sef.service.mf.operation.AlterEventTriggerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.tools.lexer.BufferUtils;

public class AlterEventTriggerOperationImpl
extends AbstractAlterCreateEventTriggerOperationImpl {
    public static final String NAME = "alter event trigger";

    public AlterEventTriggerOperationImpl() {
        super(NAME, "Alters existing event trigger on the specified component.See RPL syntax specification in corresponding docs.\n\nJavadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n");
        this.syntax.setExamples(AlterEventTriggerOperationImpl.getEventTriggerSamples());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        EventTriggerDefinition definition = ((AlterEventTriggerOperation)statement).getTriggerDefinition();
        EventTriggerManagerDelegate delegate = (EventTriggerManagerDelegate)((Object)this.callable);
        delegate.alterEventTrigger(definition.getFullSyntax());
        return new SLResponse("Trigger '" + definition.getName() + "' successfully altered.");
    }

    public static String removeEnableDisableFlag(String triggerSyntax) {
        StringBuilder builder = new StringBuilder(triggerSyntax);
        while (builder.length() > 0 && BufferUtils.isSpace(builder.charAt(builder.length() - 1))) {
            builder.setLength(builder.length() - 1);
        }
        if (builder.length() > 8) {
            String s = builder.substring(builder.length() - 8).toLowerCase();
            if (s.toLowerCase().endsWith("enabled")) {
                builder.setLength(builder.length() - 7);
            } else if (s.toLowerCase().endsWith("disabled")) {
                builder.setLength(builder.length() - 8);
            }
        }
        while (builder.length() > 0 && BufferUtils.isSpace(builder.charAt(builder.length() - 1))) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String replaceAlterWithCreate(String triggerSyntax) {
        int pos = BufferUtils.skipSpacesAndCommends(triggerSyntax, 0);
        if (triggerSyntax.length() < pos + "alter".length()) {
            return triggerSyntax;
        }
        if (!triggerSyntax.substring(pos, pos + "alter".length()).equalsIgnoreCase("alter")) {
            return triggerSyntax;
        }
        String create = "create";
        if (Character.isUpperCase(triggerSyntax.charAt(pos))) {
            create = Character.isUpperCase(triggerSyntax.charAt(pos + 1)) ? create.toUpperCase() : "Create";
        }
        return (pos > 0 ? triggerSyntax.substring(0, pos) : "") + create + triggerSyntax.substring(pos + "alter".length());
    }

    @Override
    protected SLStatement createEventTriggerOperation(EventTriggerDefinition definition) {
        return new AlterEventTriggerOperation(definition);
    }
}

