/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.impl.SetAdvancedPropertyOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.value.StatementValueList;

public class AddAdvancedPropertyOperation
extends AbstractServiceOperation {
    public static final String NAME = "add advanced property";

    public AddAdvancedPropertyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD ADVANCED PROPERTY");
        this.syntax.addModifier(SetAdvancedPropertyOperation.createAdvancedPropertyBlockModifier(false));
        this.syntax.setDescription("Adds new service advanced property.\nService should be restarted to apply properties changes.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        StatementValueList line = statement.getBlock("advancedPropertyBlockModifier").getLineByIndex(0);
        return new Definition(line.getParameter("name").getValue(), line.getParameter("value").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, ((ServiceContext)this.callable).getServiceConfiguration().getServiceName(), ((ServiceContext)this.callable).getServiceConfiguration().getServiceType(), true);
        ConfigurationProperty property = sco.getAdvancedProperty(definition.propertyName);
        if (property != null) {
            throw new Exception("Property '" + definition.propertyName + "' already exists.");
        }
        property = new ConfigurationProperty(definition.propertyName, definition.propertyName, "");
        sco.addAdvancedProperty(property);
        String propertyValue = definition.propertyValue.toString();
        if (propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false")) {
            property.setBooleanValue(Boolean.valueOf(propertyValue));
        } else {
            try {
                Long longValue = Long.valueOf(propertyValue);
                property.setNumericValue(longValue);
            }
            catch (NumberFormatException error) {
                property.setTextValue(propertyValue);
            }
        }
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        String propertyName;
        String propertyValue;

        Definition(String propertyName, String propertyValue) {
            super(AddAdvancedPropertyOperation.NAME);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }
}

