/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.Trace;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractPackageOperation
extends AbstractServiceOperation {
    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.pkg);
    }

    protected static PackageType getType(String type) throws FabricException {
        try {
            return PackageType.valueOf(type.toLowerCase());
        }
        catch (Exception exception) {
            throw new FabricException("Type '" + type + "' is not supported.");
        }
    }

    protected static String getSupportedTypes() {
        return "The following package types are supported: " + String.valueOf((Object)PackageType.client) + ", " + String.valueOf((Object)PackageType.collection) + ", " + String.valueOf((Object)PackageType.jdbc) + ", " + String.valueOf((Object)PackageType.sdo) + ", " + String.valueOf((Object)PackageType.service) + ", " + String.valueOf((Object)PackageType.transport) + ".";
    }

    protected void doRegisterPackage(ManifestDefinition definition, PackageManifestManager manifestManager) throws Exception {
        Package pkg = RuntimeContext.getInstance().getRepositoryAccessor().getPackage(AbstractPackageOperation.getType(definition.getPackageType()), definition.getPackageName());
        PackageDescriptor descriptor = PackageDescriptor.create(pkg, definition.isAutoload(), false);
        if (definition.getSequence() != -1) {
            manifestManager.addPackageAt(definition.getSequence(), descriptor);
        } else {
            manifestManager.addPackage(descriptor);
        }
    }

    protected void doUpdatePackageManifest(ManifestDefinition definition, PackageManifestManager manifestManager) throws Exception {
        String fullPackageName = definition.getPackageType() + "." + definition.getPackageName();
        PackageDescriptor pkg = manifestManager.getPackage(fullPackageName);
        if (pkg == null) {
            throw new FabricException("Package '" + fullPackageName + "' is not registered in manifest.");
        }
        manifestManager.removePackage(fullPackageName);
        if (definition.autoload != null) {
            pkg.setAutoload(definition.isAutoload());
        }
        if (definition.getSequence() != -1) {
            manifestManager.addPackageAt(definition.getSequence(), pkg);
        } else {
            manifestManager.addPackage(pkg);
        }
    }

    protected ManifestDefinition createManifestDefinition(String packageType, String packageName) {
        return null;
    }

    protected ManifestDefinition parseManifestSyntax(DSLStatement statement, ManifestDefinition result) throws ParsingException {
        if (result == null) {
            result = this.createManifestDefinition(this.getPackageType(statement), this.getPackageName(statement));
        }
        if (statement.getParameter("Autoload").isPresent()) {
            result.autoload = Boolean.parseBoolean(statement.getParameter("Autoload").getValue());
        }
        if (statement.getParameter("LoadSequence").isPresent()) {
            result.sequence = Integer.parseInt(statement.getParameter("LoadSequence").getValue());
        }
        return result;
    }

    protected PackageDefinition createPackageDefinition(String packageType, String packageName) {
        return null;
    }

    protected String getPackageType(DSLStatement statement) {
        return statement.getParameter("PackageType").getValue();
    }

    protected String getPackageName(DSLStatement statement) {
        return statement.getParameter("PackageName").getValue();
    }

    PackageDefinition parsePackageSyntax(DSLStatement statement) throws ParsingException {
        StatementSetValue archives;
        PackageDefinition result = this.createPackageDefinition(this.getPackageType(statement), this.getPackageName(statement));
        if (statement.getParameter("Description").isPresent()) {
            result.description = statement.getParameter("Description").getValue();
        }
        if ((archives = statement.getSet("ArchivesSet")).isPresent()) {
            for (int i = 0; i < archives.size(); ++i) {
                result.addArchive(archives.getElement(i).getParameter("Archive").getValue());
            }
        }
        return result;
    }

    protected void fillAllPackages(List<String> result) {
        try {
            List<String> packages = RuntimeContext.getInstance().getRepositoryAccessor().listPackages();
            Collections.sort(packages);
            result.addAll(packages);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    protected void fillLoadedPackages(List<String> packages) {
        ArrayList<String> registered = new ArrayList<String>();
        this.fillRegisteredPackages(registered);
        for (String pkg : registered) {
            if (!((ServiceContext)this.callable).getPackageManifestManager().isPackageLoaded(pkg)) continue;
            packages.add(pkg);
        }
    }

    protected void fillUnLoadedPackages(List<String> packages) {
        ArrayList<String> registered = new ArrayList<String>();
        this.fillRegisteredPackages(registered);
        for (String pkg : registered) {
            if (((ServiceContext)this.callable).getPackageManifestManager().isPackageLoaded(pkg)) continue;
            packages.add(pkg);
        }
    }

    protected void fillRegisteredPackages(List<String> packages) {
        packages.addAll(((ServiceContext)this.callable).getPackageManifestManager().listPackages());
    }

    protected void fillUnRegisteredPackages(List<String> result) {
        try {
            List<String> packages = RuntimeContext.getInstance().getRepositoryAccessor().listPackages();
            Collections.sort(packages);
            for (String pkgName : packages) {
                if (((ServiceContext)this.callable).getPackageManifestManager().existsPackage(pkgName)) continue;
                result.add(pkgName);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    public static class ManifestDefinition
    extends Definition {
        Boolean autoload;
        Integer sequence;

        protected ManifestDefinition(String name, String packageType, String packageName) {
            super(name, packageType, packageName);
        }

        protected ManifestDefinition(String name, String packageType, String packageName, boolean autoload, int sequence) {
            super(name, packageType, packageName);
            this.autoload = autoload;
            this.sequence = sequence;
        }

        public boolean isAutoload() {
            return this.autoload == null ? false : this.autoload;
        }

        public int getSequence() {
            return this.sequence == null ? -1 : this.sequence;
        }
    }

    public static class PackageDefinition
    extends Definition {
        String description;
        List<String> archives = new ArrayList<String>();

        protected PackageDefinition(String name, String packageType, String packageName) {
            super(name, packageType, packageName);
        }

        protected PackageDefinition(String name, String packageType, String packageName, String description) {
            super(name, packageType, packageName);
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void addArchive(String archive) {
            this.archives.add(archive);
        }

        public List<String> getArchives() {
            return this.archives;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        String packageType;
        String packageName;

        protected Definition(String name, String packageType, String packageName) {
            super(name);
            this.packageType = packageType;
            this.packageName = packageName;
        }

        public String getPackageType() {
            return this.packageType;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }
}

