/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.Trace;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.TriggerFunctionContextImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParser;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.impl.AlterEventTriggerOperationImpl;
import com.streamscape.sef.service.mf.impl.CreateEventTriggerOperationImpl;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.Token;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAlterCreateEventTriggerOperationImpl
extends AbstractServiceOperation {
    public AbstractAlterCreateEventTriggerOperationImpl(String name, String description) {
        this.createDSLSyntax(name);
        AbstractAlterCreateEventTriggerOperationImpl.fillEventTriggerSyntax(name, description, this.syntax);
    }

    protected abstract SLStatement createEventTriggerOperation(EventTriggerDefinition var1);

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        EventTriggerDefinition definition = AbstractAlterCreateEventTriggerOperationImpl.parseEventTriggerSlangDefinition(statement);
        return this.createEventTriggerOperation(definition);
    }

    public static void fillEventTriggerSyntax(String name, String description, DSLStatementSyntax syntax) {
        syntax.setAction(name.toUpperCase());
        syntax.addActionParameter(new IdentifierParameter("TriggerName"));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("EVENT SCOPE").addParameter(new EnumParameter("EventScope", EventScope.class))).setRequired(false));
        syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier().addModifier((AbstractModifier)new Modifier("BEFORE EVENT HANDLER").addParameter((SyntaxParameter)new IdentifierParameter("HandlerName").setCompletionAdviser(new EventHandlerCompletionAdviser())))).addModifier((AbstractModifier)new Modifier("AFTER EVENT").addParameter((SyntaxParameter)new EventIdParameter("ActionableEventId").setCompletionAdviser(new ActionableEventsCompletionAdviser()))));
        syntax.addModifier((AbstractModifier)new CompoundModifier("SOURCE_EVENT_AS").addModifier(new Modifier("SOURCE EVENT")).addModifier(new ChoiceModifier("_AS").addPossibleValue("AS", "_AS_1").addPossibleValue("=>", "_AS_2")).addParameter((AbstractParameter)new IdentifierParameter("Identifier").setName("SourceEventName")).setRequired(false));
        syntax.addModifier((AbstractModifier)new CompoundModifier("ACTIONABLE_EVENT_AS").addModifier(new Modifier("ACTIONABLE EVENT")).addModifier(new ChoiceModifier("__AS").addPossibleValue("AS", "__AS_1").addPossibleValue("=>", "__AS_2")).addParameter((AbstractParameter)new IdentifierParameter("Identifier").setName("ActionableEventName")).setRequired(false));
        syntax.addModifier((AbstractModifier)((Modifier)new Modifier("WHEN").addParameter(((ExpressionParameter)new ExpressionParameter("RPL Selector or Boolean Expression", '(', ')').setName("SelectorStatement")).setIgnoreQuotes(false))).setRequired(false));
        syntax.addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier("AS_TRIGGER_SCRIPT_COMPOUND").setCompactSyntax("as\n   {\n     <RPL Script>\n   }")).setSyntaxHint(new SyntaxHint("", true))).addModifier((AbstractModifier)new Modifier("AS").setName("AS_TRIGGER_SCRIPT")).addParameter(((ExpressionParameter)((ExpressionParameter)((ExpressionParameter)new ExpressionParameter("RPL Script", '{', '}').setCompleter(new ServiceEventTriggerCompleter())).setAlwaysComplete(true)).setName("TriggerScript")).setIgnoreQuotes(false).setSkipOneLineComments(true)));
        syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("ENABLED_DISABLED").addPossibleValues("ENABLED", "DISABLED", "ENABLE", "DISABLE").setRequired(false)).setCompactSyntax("[ enable ]")).setSyntaxHint(new SyntaxHint("", true)));
        syntax.setDescription(description);
    }

    public static String getEventTriggerSamples() {
        return "set delimiter ##\n\n/**\n * Logger trigger\n */\n create event trigger LoggerTrigger\n event scope inherited\n after event [event.response.employees]\n as\n {\n  event e = this.getCurrentEvent();\n  string text = 'sample header message';\n  log.error(text, e, 'xml');\n  log.debug(text, e, 'xml');\n  log.info(text, e, 'xml');\n  log.error(text, e, 'json');\n  log.debug(text, e, 'json');\n  log.info(text, e, 'json');\n  log.error(text, e.data, 'xml');\n  log.debug(text, e.data, 'json');\n  log.info(text, e.data, 'xml');\n}\n##\n\n// Event publisher trigger\n/**\n * Re-raises incoming event on the same event id.\n */\n create event trigger EventPublisherTrigger\n event scope inherited\n after event [event.response.employees]\n as\n {\n  raise event this.getCurrentEvent();\n }\n##\n\n/**\n * Re-raises incoming event on the new event id.\n */\n create event trigger EventPublisherTriggerOn\n event scope inherited\n after event [event.response.employees]\n as\n {\n  raise event this.getCurrentEvent() on [event.new.response.employees];\n }\n##\n\n/**\n * Raises employee events based on incoming event employees\n */\n create event trigger EventPublisherTriggerMulti\n event scope inherited\n after event [event.response.employees]\n as\n {\n  event e = this.getCurrentEvent();\n  for (Employee employee : (list)e.data.employees) {\n   event event1 = new [event.response.employee];\n   events.copyEIM(e, event1);\n   event1.data = employee;\n   raise event event1;\n  }\n }\n##\n\nset delimiter\n";
    }

    public static EventTriggerDefinition parseEventTriggerSlangDefinition(DSLStatement statement) throws ParsingException {
        try {
            EventTriggerDefinition result = new EventTriggerDefinition();
            result.setName(statement.getParameter("TriggerName").getValue());
            if (statement.getParameter("HandlerName").isPresent()) {
                result.setEventHandlerName(statement.getParameter("HandlerName").getValue());
            }
            if (statement.getParameter("ActionableEventId").isPresent()) {
                result.setActionableEventId(statement.getParameter("ActionableEventId").getValue());
            }
            if (statement.getParameter("EventScope").isPresent()) {
                result.setEventScope(EventScope.valueOf(statement.getParameter("EventScope").getValue().toUpperCase()));
            }
            if (statement.getParameter("SourceEventName").isPresent()) {
                result.setSourceEventAlias(statement.getParameter("SourceEventName").getValue());
            }
            if (statement.getParameter("ActionableEventName").isPresent()) {
                result.setActionableEventAlias(statement.getParameter("ActionableEventName").getValue());
            }
            if (statement.getParameter("SelectorStatement").isPresent()) {
                result.setEventSelector(statement.getParameter("SelectorStatement").getValue());
            }
            result.setTriggerScript("{" + statement.getParameter("TriggerScript").getValue() + "}");
            result.setAutoEnable(statement.existsModifier("ENABLED_DISABLED") && (statement.existsModifier("ENABLED") || statement.existsModifier("ENABLE")));
            result.setFullSyntax(statement.getOriginalStatement());
            return result;
        }
        catch (Exception exception) {
            throw new ParsingException(exception.getMessage());
        }
    }

    public static void mergeParametersForAlter(DSLStatement statement, EventTriggerDefinition oldDefinition, EventTriggerDefinition newDefinition) throws ParsingException {
        if (oldDefinition != null) {
            if (!statement.getParameter("EventScope").isPresent()) {
                try {
                    Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(newDefinition.getFullSyntax());
                    lexer.setSkipComments(true);
                    Token<LexerFactory.DummyTokenType> createToken = lexer.readToken("create");
                    lexer.readToken("event");
                    lexer.readToken("trigger");
                    lexer.readToken(CommonTokenType.LITERAL);
                    Object eventScope = " EVENT SCOPE " + String.valueOf((Object)oldDefinition.getEventScope());
                    if (!Character.isUpperCase(createToken.getValue().charAt(1))) {
                        eventScope = ((String)eventScope).toLowerCase();
                    }
                    newDefinition.setFullSyntax(lexer.substring(0, lexer.getCurrentPosition()) + (String)eventScope + lexer.substring(lexer.getCurrentPosition(), lexer.getLength()));
                }
                catch (LexerException exception) {
                    Trace.logError(AbstractAlterCreateEventTriggerOperationImpl.class, "Failed to parse new trigger full syntax '{}'. Cause: {}", newDefinition.getFullSyntax(), exception.getMessage());
                    throw new ParsingException(exception.getMessage());
                }
                newDefinition.setEventScope(oldDefinition.getEventScope());
            }
            if (!statement.existsModifier("ENABLED_DISABLED")) {
                newDefinition.setAutoEnable(oldDefinition.isAutoEnable());
            }
        }
    }

    public static class EventHandlerCompletionAdviser
    implements CompletionAdviser<ServiceContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, ServiceContext callable, MFSession session) {
            return callable.listEventHandlers();
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class ActionableEventsCompletionAdviser
    implements CompletionAdviser<ServiceContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, ServiceContext callable, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            for (String eventId : callable.listActionableEvents()) {
                result.add("[" + eventId + "]");
            }
            return result;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static class ServiceEventTriggerCompleter
    implements ScriptCompleter<ServiceContext> {
        private static CreateEventTriggerOperationImpl operation = new CreateEventTriggerOperationImpl();

        @Override
        public DSLCompletion complete(String script, String processedScript, ServiceContext callable, MFSession session) {
            processedScript = AlterEventTriggerOperationImpl.replaceAlterWithCreate((String)processedScript);
            processedScript = (String)processedScript + " {} enabled";
            try {
                TriggerFunctionContextImpl triggerFunctionContext;
                DSLStatement statement = operation.parseDsl((String)processedScript);
                EventTriggerDefinition definition = AbstractAlterCreateEventTriggerOperationImpl.parseEventTriggerSlangDefinition(statement);
                definition.setTriggerScript(script);
                TriggerFunctionContextImpl triggerFunctionParserContext = triggerFunctionContext = new TriggerFunctionContextImpl(DataspaceStoreManager.getRuntimeContext());
                String actionEventId = null;
                if (definition.getEventHandlerName() != null) {
                    try {
                        actionEventId = callable.getEventHandler(definition.getEventHandlerName()).getRequestEventId();
                    }
                    catch (ServiceConfigurationException e) {
                        throw new Exception("Event handler '" + definition.getEventHandlerName() + "' doesn't.");
                    }
                } else if (definition.getActionableEventId() != null) {
                    actionEventId = definition.getActionableEventId();
                }
                if (actionEventId == null) {
                    throw new Exception("No actionable event defined for trigger " + definition.getName());
                }
                triggerFunctionParserContext.setActionableEventType(actionEventId);
                if (definition.getSourceEventAlias() != null && definition.getSourceEventAlias().length() > 0) {
                    triggerFunctionParserContext.setSourceEventAlias(definition.getSourceEventAlias(), actionEventId);
                }
                if (definition.getActionableEventAlias() != null && definition.getActionableEventAlias().length() > 0) {
                    triggerFunctionParserContext.setActionableEventAlias(definition.getActionableEventAlias());
                }
                triggerFunctionContext.setComponent(callable);
                triggerFunctionContext.setEventTriggerDefinition(definition);
                TriggerFunctionParser parser = new TriggerFunctionParser(triggerFunctionParserContext);
                return parser.complete(script);
            }
            catch (Exception exception) {
                return new DSLCompletion(exception);
            }
        }
    }
}

