/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.metrics;

import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.advisory.ServiceMetricAdvisory;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRuntimeException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.metrics.Metric;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.sef.metrics.MetricThresholdListener;
import com.streamscape.sef.metrics.MetricsFactory;
import com.streamscape.sef.metrics.MetricsFactoryException;
import com.streamscape.sef.metrics.MetricsTimerManager;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.metrics.RuntimeServiceMetric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class ServiceMetricsFactory
implements MetricsFactory,
MetricThresholdListener {
    protected AdvisoryDatagramFactory advisoryFactory = AdvisoryDatagramFactory.getInstance();
    private ServiceContext serviceContext = null;
    private Hashtable<String, RuntimeServiceMetric> runtimeMetricsTable = new Hashtable();

    public ServiceMetricsFactory(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        for (MetricDefinition metricDef : serviceContext.getServiceConfiguration().getMetrics()) {
            RuntimeServiceMetric metric = new RuntimeServiceMetric(metricDef);
            metric.setListener(this);
            this.runtimeMetricsTable.put(metricDef.getName(), metric);
            MetricsTimerManager.getInstance().addMetric(metric);
        }
    }

    public void destroy() {
        for (RuntimeServiceMetric metric : this.runtimeMetricsTable.values()) {
            MetricsTimerManager.getInstance().removeMetric(metric);
        }
    }

    @Override
    public List<String> listMetricNames() {
        ArrayList<String> list = new ArrayList<String>(this.runtimeMetricsTable.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public long getMetricValue(String metricName) throws MetricsFactoryException {
        RuntimeServiceMetric metric = this.runtimeMetricsTable.get(metricName);
        if (metric == null) {
            throw new MetricsFactoryException("Metric '" + metricName + "' is not registered.");
        }
        return metric.getValue();
    }

    @Override
    public void resetMetrics() {
        Enumeration<RuntimeServiceMetric> metrics = this.runtimeMetricsTable.elements();
        while (metrics.hasMoreElements()) {
            RuntimeServiceMetric metric = metrics.nextElement();
            metric.setValue(0L);
        }
    }

    @Override
    public void setMetricValue(String metricName, long metricValue) throws MetricsFactoryException {
        RuntimeServiceMetric metric = this.runtimeMetricsTable.get(metricName);
        if (metric == null) {
            throw new MetricsFactoryException("Metric '" + metricName + "' is not registered.");
        }
        metric.setValue(metricValue);
    }

    @Override
    public void nextMetricValue(String metricName) throws MetricsFactoryException {
        RuntimeServiceMetric metric = this.runtimeMetricsTable.get(metricName);
        if (metric == null) {
            throw new MetricsFactoryException("Metric '" + metricName + "' is not registered.");
        }
        metric.nextValue();
    }

    @Override
    public void priorMetricValue(String metricName) throws MetricsFactoryException {
        RuntimeServiceMetric metric = this.runtimeMetricsTable.get(metricName);
        if (metric == null) {
            throw new MetricsFactoryException("Metric '" + metricName + "' is not registered.");
        }
        metric.priorValue();
    }

    @Override
    public Metric getMetric(String metricName) throws MetricsFactoryException {
        RuntimeServiceMetric metric = this.runtimeMetricsTable.get(metricName);
        if (metric == null) {
            throw new MetricsFactoryException("Metric '" + metricName + "' is ot registered.");
        }
        return metric;
    }

    @Override
    public void raiseMetricAdvisory(String metricName) throws MetricsFactoryException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        Metric metric = this.getMetric(metricName);
        ServiceMetricAdvisory e = new ServiceMetricAdvisory();
        e.init(metric);
        this.serviceContext.raiseAdvisory(e);
    }

    @Override
    public void onThreshold(String metric) {
        try {
            this.raiseMetricAdvisory(metric);
        }
        catch (Exception ex) {
            throw new FabricRuntimeException(ex);
        }
    }
}

