/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.dsl;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.service.dsl.ServiceHelpSLResponse;
import com.streamscape.sef.service.dsl.ServiceSystemDSLProvider;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.HelpOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.system.SystemHelpOperation;
import java.util.Set;
import java.util.TreeSet;
import org.antlr.v4.runtime.misc.OrderedHashSet;

public class ServiceSystemHelpOperation
extends SystemHelpOperation {
    private ServiceSystemDSLProvider provider;
    private Set<AbstractDSLProvider> customProviders = new OrderedHashSet();

    ServiceSystemHelpOperation(ServiceSystemDSLProvider provider) {
        this.provider = provider;
    }

    void addCustomProvider(AbstractDSLProvider customProvider) {
        this.customProviders.add(customProvider);
    }

    @Override
    protected Operation getNativeOperation(HelpOperation.Definition definition, MFSession session) {
        if (this.customProviders == null || this.customProviders.size() == 0) {
            return super.getNativeOperation(definition, session);
        }
        for (AbstractDSLProvider customProvider : this.customProviders) {
            Operation result = customProvider.getVisibleOperation(definition.getOperationName(), session);
            if (result == null) continue;
            return result;
        }
        return super.getNativeOperation(definition, session);
    }

    @Override
    protected Operation getForeignOperation(HelpOperation.Definition definition, MFSession session) {
        Operation<?> result = super.getForeignOperation(definition, session);
        return result != null ? result : this.provider.baseProcessor.getForeignOperation(definition.getOperationName(), session);
    }

    @Override
    protected SLResponse invokeHelpWithoutParameters(boolean isComplex, Set<String> operations, MFSession session, String pattern) {
        TreeSet<String> customOperations = new TreeSet<String>();
        this.customProviders.forEach(provider -> customOperations.addAll(provider.listVisibleOperations(session, pattern)));
        HelpSLResponse response = (HelpSLResponse)super.invokeHelpWithoutParameters(true, operations, session, pattern);
        response = new ServiceHelpSLResponse(response, !customOperations.isEmpty() ? customOperations : null, this.provider.baseProcessor.listForeignOperations(session, pattern));
        return isComplex ? response : response.convertToUserResponse();
    }

    @Override
    protected boolean isEmpty(HelpSLResponse response) {
        return super.isEmpty(response) && (!(response instanceof ServiceHelpSLResponse) || Utils.isEmpty(((ServiceHelpSLResponse)response).getCustomOperations()) && Utils.isEmpty(((ServiceHelpSLResponse)response).getDataspaceOperations()));
    }
}

