/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.dsl;

import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.service.dsl.DSLSyntaxFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DSLSyntaxFactoryManager
extends AbstractRuntimeFactory {
    static final String DSL_SYNTAX_NAMESPACE = "/sys/dsl";
    private Map<String, DSLSyntaxFactory> factories = new HashMap<String, DSLSyntaxFactory>();
    private ReferenceContext configContext;

    public DSLSyntaxFactoryManager() throws FabricException {
        DSLSyntaxFactoryManager.checkContext();
        this.init();
    }

    public List<DSLSyntaxFactory> getDSLSyntaxFactories() {
        return new ArrayList<DSLSyntaxFactory>(this.factories.values());
    }

    public List<String> listDSLSyntaxFactories() {
        return new ArrayList<String>(this.factories.keySet());
    }

    public DSLSyntaxFactory lookupDSLSyntaxFactory(String serviceType) {
        return this.factories.get(serviceType);
    }

    public DSLSyntaxFactory createDSLSyntaxFactory(String serviceType) throws FabricException {
        DSLSyntaxFactory factory = new DSLSyntaxFactory(serviceType);
        this.factories.put(serviceType, factory);
        return factory;
    }

    public void removeDSLSyntaxFactory(String serviceType) throws ObjectConfigurationException {
        DSLSyntaxFactory factory = this.factories.remove(serviceType);
        if (factory != null) {
            factory.remove();
        }
    }

    public void addDSLSyntaxFactory(DSLSyntaxFactory factory) throws FabricException {
        this.factories.put(factory.getServiceType(), factory);
    }

    protected void init() throws FabricException {
        DSLSyntaxFactoryManager.checkContext();
        try {
            this.configContext = SemanticObjectReferenceStore.lookupReferenceContext(DSL_SYNTAX_NAMESPACE);
            if (this.configContext == null) {
                SemanticObjectReferenceStore.beginXact();
                this.configContext = SemanticObjectReferenceStore.lookupReferenceContext(DSL_SYNTAX_NAMESPACE);
                if (this.configContext == null) {
                    this.configContext = SemanticObjectReferenceStore.createSubcontextFromNamespace(DSL_SYNTAX_NAMESPACE);
                }
                SemanticObjectReferenceStore.commitXact();
            }
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(this.configContext);
            List<String> subContexts = SemanticObjectReferenceStore.listSubcontexts();
            SemanticObjectReferenceStore.commitXact();
            for (String context : subContexts) {
                DSLSyntaxFactory factory = new DSLSyntaxFactory(context);
                this.factories.put(context, factory);
            }
        }
        catch (Exception exception) {
            throw new FabricException("Initialization of DSLSyntaxFactoryManager failed.", exception);
        }
    }
}

