/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.dsl;

import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.utils.Configurator;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DSLSyntaxFactory
extends AbstractRuntimeFactory {
    private String namespace;
    private String serviceType;
    private Map<String, DSLStatementSyntax> syntaxes = new HashMap<String, DSLStatementSyntax>();
    private Set<String> removedSyntaxes = new HashSet<String>();
    private Configurator<DSLStatementSyntax> configurator;

    DSLSyntaxFactory(String serviceType) throws FabricException {
        this.serviceType = serviceType;
        this.namespace = "/sys/dsl/" + serviceType;
        DSLSyntaxFactory.checkContext();
        this.init();
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public List<DSLStatementSyntax> getDSLSyntaxes() {
        return new ArrayList<DSLStatementSyntax>(this.syntaxes.values());
    }

    public List<String> listDSLSyntaxes() {
        return new ArrayList<String>(this.syntaxes.keySet());
    }

    public DSLStatementSyntax lookupDSLSyntax(String name) {
        return this.syntaxes.get(name);
    }

    public boolean existsDSLSyntax(String name) {
        return this.syntaxes.containsKey(name);
    }

    public void addDSLSyntax(DSLStatementSyntax syntax) {
        this.syntaxes.put(syntax.getName(), syntax);
    }

    public void removeDSLSyntax(String name) {
        this.syntaxes.remove(name);
        this.removedSyntaxes.add(name);
    }

    public void saveDSLSyntax(DSLStatementSyntax syntax) throws ObjectConfigurationException {
        this.configurator.bindObject(syntax.getName(), syntax);
        this.addDSLSyntax(syntax);
    }

    public void remove() throws ObjectConfigurationException {
        for (DSLStatementSyntax syntax : this.syntaxes.values()) {
            this.configurator.unbindObject(syntax.getName());
        }
        this.syntaxes.clear();
        this.configurator.destroyContext();
    }

    public void save() throws ObjectConfigurationException {
        for (String name : this.removedSyntaxes) {
            this.configurator.unbindObject(name);
        }
        this.removedSyntaxes.clear();
        for (DSLStatementSyntax syntax : this.syntaxes.values()) {
            this.configurator.bindObject(syntax.getName(), syntax);
        }
    }

    protected void init() throws FabricException {
        DSLSyntaxFactory.checkContext();
        try {
            this.configurator = new Configurator(this.namespace);
            this.addSemanticTypes();
            this.loadSyntaxes();
        }
        catch (Exception exception) {
            throw new FabricException("Initialization of DSLSyntaxFactory failed.", exception);
        }
    }

    protected void addSemanticTypes() throws SemanticTypeFactoryException {
        if (!TypeFactory.existsSemanticClass(DSLStatementSyntax.class)) {
            Configurator.addSemanticType(DSLStatementSyntax.class, "DSL Statement Syntax object.");
        }
    }

    protected void loadSyntaxes() throws Exception {
        for (String objectName : this.configurator.listBoundNames()) {
            DSLStatementSyntax object = this.configurator.loadObject(objectName);
            this.syntaxes.put(objectName, object);
        }
    }
}

