/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.advisories;

import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.advisory.ServiceStateAdvisory;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sef.advisories.AdvisoriesFactoryException;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.advisories.StateAdvisoryFactory;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.ServiceRuntimeException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class ServiceStateAdvisoriesFactory
implements StateAdvisoryFactory {
    private ServiceContext serviceContext = null;
    private Hashtable<String, ServiceStateAdvisory> runtimeStateAdvisoriesTable = new Hashtable();

    public ServiceStateAdvisoriesFactory(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        for (StateAdvisoryDefinition advisoryDefinition : serviceContext.getServiceConfiguration().getStateAdvisoryDefinitions()) {
            try {
                ServiceStateAdvisory advisory = new ServiceStateAdvisory();
                advisory.init(advisoryDefinition);
                this.runtimeStateAdvisoriesTable.put(advisoryDefinition.getName(), advisory);
            }
            catch (SDOFormatException ex) {
                throw new ServiceRuntimeException(ex);
            }
        }
    }

    @Override
    public StateAdvisory createAdvisory(String eventId) throws AdvisoriesFactoryException {
        if (this.runtimeStateAdvisoriesTable.containsKey(eventId)) {
            ServiceStateAdvisory advisory = this.runtimeStateAdvisoriesTable.get(eventId);
            return advisory.clone();
        }
        return null;
    }

    @Override
    public List<String> listAdvisoryNames() {
        List<String> list = this.serviceContext.listAdvisories();
        Collections.sort(list);
        return list;
    }
}

