/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service;

import java.util.HashMap;
import java.util.Map;

public class SuspectState {
    private Map<SuspectStateOriginator, String> originators = new HashMap<SuspectStateOriginator, String>();

    public boolean setSuspectState(SuspectStateOriginator originator, String lastError) {
        return this.originators.put(originator, lastError) == null;
    }

    public boolean resetSuspectState(SuspectStateOriginator originator) {
        return this.originators.remove(originator) != null;
    }

    public void reset() {
        this.originators.clear();
    }

    public boolean isSuspect() {
        return !this.originators.isEmpty();
    }

    public Map<SuspectStateOriginator, String> getOriginators() {
        return this.originators;
    }

    public static class ServiceOriginator
    extends SuspectStateOriginator {
        static ServiceOriginator instance = new ServiceOriginator();

        ServiceOriginator() {
        }

        public String toString() {
            return "service";
        }
    }

    public static class ServiceContextOriginator
    extends SuspectStateOriginator {
        static ServiceContextOriginator instance = new ServiceContextOriginator();

        ServiceContextOriginator() {
        }

        public String toString() {
            return "service context";
        }
    }

    public static class TriggerOriginator
    extends SuspectStateOriginator {
        protected String name;

        TriggerOriginator(String name) {
            this.name = name;
        }

        public String toString() {
            return "trigger '" + this.name + "'";
        }

        public int hashCode() {
            if (this.name == null) {
                return 31;
            }
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TriggerOriginator)) {
                return false;
            }
            TriggerOriginator oo = (TriggerOriginator)o;
            return oo.name == this.name || oo.name != null && oo.name.equals(this.name);
        }
    }

    public static abstract class SuspectStateOriginator {
        protected SuspectStateOriginator() {
        }

        public static SuspectStateOriginator service() {
            return ServiceOriginator.instance;
        }

        public static SuspectStateOriginator serviceContext() {
            return ServiceContextOriginator.instance;
        }

        public static SuspectStateOriginator trigger(String name) {
            return new TriggerOriginator(name);
        }
    }
}

