/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service;

import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.moderator.ModeratorUtils;
import java.util.Objects;
import java.util.StringTokenizer;

public class ServiceName
extends CloneableDataObject
implements Comparable<ServiceName> {
    private String type;
    private String name;

    public ServiceName(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public ServiceName(String fullName) {
        StringTokenizer tokenizer = new StringTokenizer(fullName, ".");
        if (tokenizer.countTokens() == 2) {
            this.type = tokenizer.nextToken();
            this.name = tokenizer.nextToken();
        }
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return ModeratorUtils.makeComponentFullName(this.type, this.name);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ServiceName && Utils.equalsNullSafe(this.type, ((ServiceName)other).type) && Utils.equalsNullSafe(this.name, ((ServiceName)other).name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    @Override
    public int compareTo(ServiceName other) {
        int result = this.type.compareTo(other.type);
        return result == 0 ? this.name.compareTo(other.name) : result;
    }
}

