/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManagerException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ServiceManifest
extends CloneableDataObject {
    protected boolean useManifest = true;
    protected boolean startOnSuspectDataspace = false;
    protected int startTimeout = 0;
    protected boolean abortOnFailure = false;
    protected Date timestamp = new Date(System.currentTimeMillis());
    protected List<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();

    public int getStartTimeout() {
        return this.startTimeout;
    }

    public void setStartTimeout(int timeout) {
        this.startTimeout = timeout;
    }

    public void setAbortOnFailure(boolean abort) {
        this.abortOnFailure = abort;
    }

    public boolean isAbortOnFailure() {
        return this.abortOnFailure;
    }

    public void setStartOnSuspectDataspace(boolean value) {
        this.startOnSuspectDataspace = value;
    }

    public boolean isStartOnSuspectDataspace() {
        return this.startOnSuspectDataspace;
    }

    public void addService(ServiceDescriptor service) {
        this.services.add(service);
    }

    public void addServiceAt(int index, ServiceDescriptor service) throws ServiceManagerException {
        if (index <= 0 || index > this.services.size() + 1) {
            throw new ServiceManagerException(6080, "Service index " + index + " is out of bounds.");
        }
        this.services.add(index - 1, service);
    }

    public void removeService(ServiceDescriptor service) {
        this.services.remove(service);
    }

    public boolean removeService(String type, String name) {
        Iterator<ServiceDescriptor> iter = this.services.iterator();
        while (iter.hasNext()) {
            ServiceDescriptor descriptor = iter.next();
            if (!descriptor.getType().equals(type) || !descriptor.getName().equals(name)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public boolean existsService(String serviceName) {
        return this.services.stream().anyMatch(service -> service.getFullName().equals(serviceName));
    }

    public ServiceDescriptor getService(String fullName) {
        return this.services.stream().filter(service -> service.getFullName().equals(fullName)).findFirst().orElse(null);
    }

    public void removeService(int position) {
        this.services.remove(position);
    }

    public List<ServiceDescriptor> services() {
        return this.services;
    }

    public boolean isManifestUsed() {
        return this.useManifest;
    }

    public void useManifest(boolean value) {
        this.useManifest = value;
    }

    public int getServiceSequence(String serviceName) {
        int index = 0;
        for (ServiceDescriptor service : this.services) {
            ++index;
            if (!service.getFullName().equals(serviceName)) continue;
            return index;
        }
        return -1;
    }

    public void setServiceSequence(String serviceName, int sequence) throws ServiceManagerException {
        int index = this.getServiceSequence(serviceName);
        if (index == -1) {
            throw new ServiceManagerException(6068, "Service '" + serviceName + "' does not exist.");
        }
        if (sequence <= 0 || sequence > this.services.size() + 1) {
            throw new ServiceManagerException(6080, "Service sequence " + sequence + " is out of bounds.");
        }
        if (index != sequence) {
            ServiceDescriptor descriptor = this.services.remove(index - 1);
            if (index < sequence) {
                this.services.add(sequence - 2, descriptor);
            } else {
                this.services.add(sequence - 1, descriptor);
            }
        }
    }

    public Date getLastModified() {
        return this.timestamp;
    }

    public void touch() {
        this.timestamp = new Date(System.currentTimeMillis());
    }

    public void clear() {
        this.services = new ArrayList<ServiceDescriptor>();
    }

    public void enableServiceManifest(boolean value) {
        this.useManifest = value;
    }

    @Override
    public ServiceManifest clone() {
        ServiceManifest manifest = (ServiceManifest)super.clone();
        manifest.services = new ArrayList<ServiceDescriptor>();
        for (ServiceDescriptor service : this.services) {
            manifest.services.add(service.clone());
        }
        return manifest;
    }
}

