/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service;

import com.streamscape.Trace;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.service.ServiceName;
import java.util.ArrayList;
import java.util.List;

public class ServiceDescriptor
extends CloneableDataObject {
    protected String type = null;
    protected String name = null;
    protected boolean autostart = false;
    protected Trace.Level logLevel = Trace.Level.INFO;
    protected boolean logBroadcast = false;
    protected byte[] credentials = null;
    protected List<String> dependencies = new ArrayList<String>();
    private transient String lastError;

    public ServiceDescriptor(String type, String name) {
        this.doInit(type, name);
    }

    public ServiceDescriptor(String fullName) {
        ServiceName serviceName = new ServiceName(fullName);
        this.doInit(serviceName.getType(), serviceName.getName());
    }

    private void doInit(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutostart() {
        return this.autostart;
    }

    public void setAutostart(boolean autostart) {
        this.autostart = autostart;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(String type, String name) {
        this.dependencies.add(type + "." + name);
    }

    public void clearDependencies() {
        this.dependencies.clear();
    }

    public void addDependency(String fullName) {
        this.dependencies.add(fullName);
    }

    public void removeDependency(String fullName) {
        this.dependencies.remove(fullName);
    }

    public void setCredentials(byte[] credentials) {
        this.credentials = credentials;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public void setLogLevel(Trace.Level level) {
        this.logLevel = level;
    }

    public Trace.Level getLogLevel() {
        return this.logLevel == null ? Trace.Level.INFO : this.logLevel;
    }

    public void setLogBroadcast(boolean broadcast) {
        this.logBroadcast = broadcast;
    }

    public String getFullName() {
        return ServiceDescriptor.getFullName(this.type, this.name);
    }

    public static String getFullName(String type, String name) {
        return type + "." + name;
    }

    public boolean getLogBroadcast() {
        return this.logBroadcast;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    @Override
    public ServiceDescriptor clone() {
        ServiceDescriptor descriptor = (ServiceDescriptor)super.clone();
        descriptor.dependencies = this.dependencies == null ? null : (List)((ArrayList)this.dependencies).clone();
        return descriptor;
    }
}

