/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sef.dispatcher.ServiceMFSession;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.slex.MFSession;

public abstract class AbstractService
implements Service,
SLCallable {
    protected ServiceContext ctx = null;
    protected RuntimeContext context = RuntimeContext.getInstance();
    protected ServiceConfigurationObject sco = null;

    protected AbstractService() {
    }

    @Override
    public void destroy() throws ServiceFrameworkException {
    }

    @Override
    public final void init() throws ServiceFrameworkException {
        try {
            this.ctx = this.context.lookupServiceContext(this);
            this.sco = this.ctx.getServiceConfiguration();
            this.doInit();
        }
        catch (ServiceFrameworkException exception) {
            throw exception;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            throw new ServiceFrameworkException(6065, (Throwable)exception);
        }
    }

    protected abstract void doInit() throws ServiceFrameworkException;

    @Override
    public void resume() throws ServiceFrameworkException {
    }

    @Override
    public void start() throws ServiceFrameworkException {
    }

    @Override
    public void stop() throws ServiceFrameworkException {
    }

    @Override
    public void suspend() throws ServiceFrameworkException {
    }

    protected void assertPropertyExist(String propName) throws ServiceConfigurationException {
        if (this.sco == null) {
            throw new IllegalStateException("Service Configuration Object is NULL. Could not validate configuration property.");
        }
        if (!this.sco.getServiceConfigurationProperties().hasProperty(propName)) {
            this.ctx.logError("'" + propName + "' service property is not specified.");
            throw new ServiceConfigurationException("Service configuration property '" + propName + "' does not exist in the configuration.");
        }
    }

    protected void assertPropertyExistAndNotNull(String propName) throws ServiceConfigurationException {
        if (this.sco == null) {
            throw new IllegalStateException("Service Configuration Object is NULL. Could not validate configuration property.");
        }
        ServiceConfigurationProperties props = this.sco.getServiceConfigurationProperties();
        if (!props.hasProperty(propName) || props.getProperty(propName).getValue() == null) {
            this.ctx.logError("'" + propName + "' service property value is NULL or does not exist.");
            throw new ServiceConfigurationException("Service configuration property '" + propName + "' is not set.");
        }
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof ServiceMFSession;
    }

    @Override
    public String getStartupDir() {
        return this.context.getStartupDir();
    }
}

