/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.DaemonServiceBlockedException;
import com.streamscape.service.osf.DaemonService;
import com.streamscape.service.osf.eim.EventIdentityPlugin;

public abstract class AbstractDaemonService
extends AbstractService
implements DaemonService,
Runnable {
    protected FabricThread<?> thread = null;
    protected volatile boolean activated = false;
    private ThreadLocal<EventIdentityPlugin> threadLocalEventIdentityPlugin;
    private EventIdentityPlugin defaultEimPlugin;
    private long maxIterationWorkTime = 0L;
    protected volatile long iterationStartTime = 0L;

    protected AbstractDaemonService() {
    }

    @Override
    protected void doInit() throws ServiceFrameworkException {
        Object value;
        this.maxIterationWorkTime = 3600000L;
        ConfigurationProperty property = this.sco.getAdvancedProperty("daemonServiceMaxWorkTime");
        if (property != null && (value = property.getValue()) != null && value instanceof Number) {
            this.maxIterationWorkTime = ((Number)value).intValue() * 1000;
        }
        this.ctx.logInfo("Max work time is set to " + this.maxIterationWorkTime / 1000L + " seconds.");
    }

    @Override
    public void run() {
        if (this.threadLocalEventIdentityPlugin != null) {
            this.threadLocalEventIdentityPlugin.set(this.defaultEimPlugin);
        }
        while (this.activated) {
            try {
                this.iterationStartTime = System.currentTimeMillis();
                this.doRepeatableServiceLogic();
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            catch (OutOfMemoryError error) {
                error.printStackTrace();
                this.ctx.logError("OutOfMemoryError was thrown by JVM. Please check memory usage.");
            }
            finally {
                this.iterationStartTime = 0L;
            }
        }
        this.threadLocalEventIdentityPlugin.remove();
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    @Override
    public void start() throws ServiceFrameworkException {
        super.start();
        this.createThread();
    }

    private void createThread() {
        this.thread = FabricThreadManager.getInstance().createThread("SVC:Daemon.Service", "Service '" + this.ctx.getType() + "." + this.ctx.getName() + "'", this);
        this.activated = true;
        this.thread.start();
    }

    @Override
    public void suspend() throws ServiceFrameworkException {
        super.suspend();
        this.terminateThread();
    }

    @Override
    public void resume() throws ServiceFrameworkException {
        super.resume();
        this.createThread();
    }

    @Override
    public void stop() throws ServiceFrameworkException {
        super.stop();
        this.terminateThread();
    }

    private void terminateThread() {
        this.activated = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    protected abstract void doRepeatableServiceLogic();

    public void setThreadLocalEventIdentityPlugin(ThreadLocal<EventIdentityPlugin> threadLocalEventIdentityPlugin, EventIdentityPlugin defaultEimPlugin) {
        this.threadLocalEventIdentityPlugin = threadLocalEventIdentityPlugin;
        this.defaultEimPlugin = defaultEimPlugin;
    }

    public void checkServiceIsNotBlocked() throws DaemonServiceBlockedException {
        long iterationStartTime = this.iterationStartTime;
        long passiveIterationInterval = this.getPassiveIterationInterval();
        long maxIterationWorkTime = this.getMaxIterationWorkTime();
        long currentTime = System.currentTimeMillis();
        if (iterationStartTime > 0L && currentTime - iterationStartTime > passiveIterationInterval + maxIterationWorkTime) {
            throw new DaemonServiceBlockedException(iterationStartTime, passiveIterationInterval, maxIterationWorkTime, currentTime);
        }
    }

    protected abstract long getPassiveIterationInterval();

    protected long getMaxIterationWorkTime() {
        return this.maxIterationWorkTime;
    }
}

