/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.vcard.PhoneUse;
import com.streamscape.sdo.vcard.Photo;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractSystemStore;
import com.streamscape.sef.security.SecurityManagerException;
import java.sql.SQLException;

class VCardStore
extends AbstractSystemStore {
    private static final String VCARD_TABLE_NAME = "VCARD";
    private static final String VCARD_PHOTO_TABLE_NAME = "VCARD_PHOTO";

    VCardStore() throws Exception {
    }

    @Override
    protected void initAccessor() throws Exception {
        SLResponse response;
        if (this.accessor.lookupCollection(VCARD_TABLE_NAME) == null) {
            response = this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE VCARD(USER_NAME varchar(255), FN varchar(255), N_FAMILY varchar(255), N_GIVEN varchar(255), N_MIDDLE varchar(255), NICKNAME varchar(255), URL varchar(255), BDAY varchar(32), AGE varchar(3), GENDER varchar(32), MARITALSTATUS varchar(32), LOCATION varchar(255), WORKCELL varchar(32), HOMECELL varchar(32), ORG_ORGNAME varchar(255), ORG_ORGUNIT varchar(255), TITLE varchar(255), ROLE varchar(255), TEL_WORK_VOICE varchar(32), TEL_WORK_FAX varchar(32), TEL_WORK_MSG varchar(32), TEL_WORK_PAGER varchar(32), TEL_WORK_CELL varchar(32), ADR_WORK_EXTADD varchar(255), ADR_WORK_STREET varchar(255), ADR_WORK_LOCALITY varchar(255), ADR_WORK_REGION varchar(255), ADR_WORK_PCODE varchar(16), ADR_WORK_CTRY varchar(255), ADR_WORK_COUNTRY varchar(255), TEL_HOME_VOICE varchar(32), TEL_HOME_FAX varchar(32), TEL_HOME_MSG varchar(32), TEL_HOME_PAGER varchar(32), TEL_HOME_CELL varchar(32), ADR_HOME_EXTADD varchar(255), ADR_HOME_STREET varchar(255), ADR_HOME_LOCALITY varchar(255), ADR_HOME_REGION varchar(255), ADR_HOME_PCODE varchar(32), ADR_HOME_CTRY varchar(255), ADR_HOME_COUNTRY varchar(255), EMAIL_HOME varchar(255), EMAIL_WORK varchar(255), JABBERID varchar(255), DESC varchar(255) )");
            this.checkWithException(response, "Creation of table 'VCARD'");
        }
        if (this.accessor.lookupCollection(VCARD_PHOTO_TABLE_NAME) == null) {
            response = this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE VCARD_PHOTO(USER_NAME varchar(255), TYPE varchar(32), PHOTO varchar(65536) )");
            this.checkWithException(response, "Creation of table 'VCARD_PHOTO'");
        }
    }

    RowSet getVCardTable() {
        return this.getTable(VCARD_TABLE_NAME);
    }

    void setVCardTable(RowSet table) throws SQLException {
        this.setTable(VCARD_TABLE_NAME, table);
    }

    RowSet getVCardPhotoTable() {
        return this.getTable(VCARD_PHOTO_TABLE_NAME);
    }

    void setVCardPhotoTable(RowSet table) throws SQLException {
        this.setTable(VCARD_PHOTO_TABLE_NAME, table);
    }

    synchronized void createVCard(String userName, vCard vcard) throws SecurityManagerException {
        SLResponse response = this.invokeStatement("INSERT INTO VCARD VALUES('" + userName.toLowerCase() + "', '" + this.toString(vcard.getFullName()) + "', '" + this.toString(vcard.getName() != null ? vcard.getName().getFamilyName() : null) + "', '" + this.toString(vcard.getName() != null ? vcard.getName().getGivenName() : null) + "', '" + this.toString(vcard.getName() != null ? vcard.getName().getMiddleName() : null) + "', '" + this.toString(vcard.getNickName()) + "', '" + this.toString(vcard.getURL()) + "', '" + this.toString(vcard.getBirthday()) + "', '" + this.toString(vcard.getAge()) + "', '" + this.toString(vcard.getGender()) + "', '" + this.toString(vcard.getMaritalStatus()) + "', '" + this.toString(vcard.getLocation()) + "', '" + this.toString(vcard.getWorkCell()) + "', '" + this.toString(vcard.getHomeCell()) + "', '" + this.toString(vcard.getOrganization() != null ? vcard.getOrganization().getOrganizationName() : null) + "', '" + this.toString(vcard.getOrganization() != null ? vcard.getOrganization().getOrganizationUnit() : null) + "', '" + this.toString(vcard.getTitle()) + "', '" + this.toString(vcard.getRole()) + "', '" + this.toString(vcard.getWorkPhone(PhoneUse.VOICE) != null ? vcard.getWorkPhone(PhoneUse.VOICE).getNumber() : null) + "', '" + this.toString(vcard.getWorkPhone(PhoneUse.FAX) != null ? vcard.getWorkPhone(PhoneUse.FAX).getNumber() : null) + "', '" + this.toString(vcard.getWorkPhone(PhoneUse.MSG) != null ? vcard.getWorkPhone(PhoneUse.MSG).getNumber() : null) + "', '" + this.toString(vcard.getWorkPhone(PhoneUse.PAGER) != null ? vcard.getWorkPhone(PhoneUse.PAGER).getNumber() : null) + "', '" + this.toString(vcard.getWorkPhone(PhoneUse.CELL) != null ? vcard.getWorkPhone(PhoneUse.CELL).getNumber() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getExtendedAddress() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getStreet() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getLocality() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getRegion() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getPostalCode() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getCountry() : null) + "', '" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getCountry2() : null) + "', '" + this.toString(vcard.getHomePhone(PhoneUse.VOICE) != null ? vcard.getHomePhone(PhoneUse.VOICE).getNumber() : null) + "', '" + this.toString(vcard.getHomePhone(PhoneUse.FAX) != null ? vcard.getHomePhone(PhoneUse.FAX).getNumber() : null) + "', '" + this.toString(vcard.getHomePhone(PhoneUse.MSG) != null ? vcard.getHomePhone(PhoneUse.MSG).getNumber() : null) + "', '" + this.toString(vcard.getHomePhone(PhoneUse.PAGER) != null ? vcard.getHomePhone(PhoneUse.PAGER).getNumber() : null) + "', '" + this.toString(vcard.getHomePhone(PhoneUse.CELL) != null ? vcard.getHomePhone(PhoneUse.CELL).getNumber() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getExtendedAddress() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getStreet() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getLocality() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getRegion() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getPostalCode() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getCountry() : null) + "', '" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getCountry2() : null) + "', '" + this.toString(vcard.getHomeEMail() != null ? vcard.getHomeEMail().getUserId() : null) + "', '" + this.toString(vcard.getWorkEMail() != null ? vcard.getWorkEMail().getUserId() : null) + "', '" + this.toString(vcard.getJID()) + "', '" + this.toString(vcard.getDescription()) + "')");
        this.checkWithException(response, "Creation of vCard", userName);
        this.createPhoto(userName, vcard.getPhoto());
    }

    synchronized void dropVCard(String userName) {
        this.invokeStatement("DELETE FROM VCARD WHERE USER_NAME='" + userName.toLowerCase() + "'");
        this.dropPhoto(userName);
    }

    boolean existsVCard(String userName) {
        return VCardStore.isOK(this.getVCardResponse(userName));
    }

    synchronized vCard getVCard(String userName) {
        SLResponse response = this.getVCardResponse(userName);
        if (!VCardStore.isOK(response)) {
            return null;
        }
        vCard result = VCardStore.getVCard(response.getRowSet());
        result.setPhoto(this.getPhoto(userName));
        return result;
    }

    static vCard getVCard(RowSet rowset) {
        try {
            vCard result = new vCard();
            result.setFullName(rowset.getObject("FN").toString());
            result.getName().setFamilyName(rowset.getObject("N_FAMILY").toString());
            result.getName().setGivenName(rowset.getObject("N_GIVEN").toString());
            result.getName().setMiddleName(rowset.getObject("N_MIDDLE").toString());
            result.setNickName(rowset.getObject("NICKNAME").toString());
            result.setURL(rowset.getObject("URL").toString());
            result.setBirthday(rowset.getObject("BDAY").toString());
            result.setAge(rowset.getObject("AGE").toString());
            result.setGender(rowset.getObject("GENDER").toString());
            result.setMaritalStatus(rowset.getObject("MARITALSTATUS").toString());
            result.setLocation(rowset.getObject("LOCATION").toString());
            result.setWorkCell(rowset.getObject("WORKCELL").toString());
            result.setHomeCell(rowset.getObject("HOMECELL").toString());
            result.getOrganization().setOrganizationName(rowset.getObject("ORG_ORGNAME").toString());
            result.getOrganization().setOrganizationUnit(rowset.getObject("ORG_ORGUNIT").toString());
            result.setTitle(rowset.getObject("TITLE").toString());
            result.setRole(rowset.getObject("ROLE").toString());
            result.getWorkPhone(PhoneUse.VOICE).setNumber(rowset.getObject("TEL_WORK_VOICE").toString());
            result.getWorkPhone(PhoneUse.FAX).setNumber(rowset.getObject("TEL_WORK_FAX").toString());
            result.getWorkPhone(PhoneUse.MSG).setNumber(rowset.getObject("TEL_WORK_MSG").toString());
            result.getWorkPhone(PhoneUse.PAGER).setNumber(rowset.getObject("TEL_WORK_PAGER").toString());
            result.getWorkPhone(PhoneUse.CELL).setNumber(rowset.getObject("TEL_WORK_CELL").toString());
            result.getWorkAddress().setExtendedAddress(rowset.getObject("ADR_WORK_EXTADD").toString());
            result.getWorkAddress().setStreet(rowset.getObject("ADR_WORK_STREET").toString());
            result.getWorkAddress().setLocality(rowset.getObject("ADR_WORK_LOCALITY").toString());
            result.getWorkAddress().setRegion(rowset.getObject("ADR_WORK_REGION").toString());
            result.getWorkAddress().setPostalCode(rowset.getObject("ADR_WORK_PCODE").toString());
            result.getWorkAddress().setCountry(rowset.getObject("ADR_WORK_CTRY").toString());
            if (result.getWorkAddress().getCountry() == null) {
                result.getWorkAddress().setCountry2(rowset.getObject("ADR_WORK_COUNTRY").toString());
            }
            result.getHomePhone(PhoneUse.VOICE).setNumber(rowset.getObject("TEL_HOME_VOICE").toString());
            result.getHomePhone(PhoneUse.FAX).setNumber(rowset.getObject("TEL_HOME_FAX").toString());
            result.getHomePhone(PhoneUse.MSG).setNumber(rowset.getObject("TEL_HOME_MSG").toString());
            result.getHomePhone(PhoneUse.PAGER).setNumber(rowset.getObject("TEL_HOME_PAGER").toString());
            result.getHomePhone(PhoneUse.CELL).setNumber(rowset.getObject("TEL_HOME_CELL").toString());
            result.getHomeAddress().setExtendedAddress(rowset.getObject("ADR_HOME_EXTADD").toString());
            result.getHomeAddress().setStreet(rowset.getObject("ADR_HOME_STREET").toString());
            result.getHomeAddress().setLocality(rowset.getObject("ADR_HOME_LOCALITY").toString());
            result.getHomeAddress().setRegion(rowset.getObject("ADR_HOME_REGION").toString());
            result.getHomeAddress().setPostalCode(rowset.getObject("ADR_HOME_PCODE").toString());
            result.getHomeAddress().setCountry(rowset.getObject("ADR_HOME_CTRY").toString());
            if (result.getHomeAddress().getCountry() == null) {
                result.getHomeAddress().setCountry2(rowset.getObject("ADR_HOME_COUNTRY").toString());
            }
            result.setHomeEMail(rowset.getObject("EMAIL_HOME").toString());
            result.setWorkEMail(rowset.getObject("EMAIL_WORK").toString());
            result.setJID(rowset.getObject("JABBERID").toString());
            result.setDescription(rowset.getObject("DESC").toString());
            return result;
        }
        catch (SQLException exception) {
            Trace.logException(VCardStore.class, exception, true);
            return null;
        }
    }

    synchronized void setVCard(String userName, vCard newVCard, boolean merge) throws SecurityManagerException, SQLException {
        vCard vcard;
        if (newVCard == null) {
            vcard = new vCard();
        } else {
            vcard = newVCard;
            if (merge) {
                vcard = this.getVCard(userName);
                if (vcard != null) {
                    vcard.update(newVCard);
                } else {
                    vcard = newVCard;
                }
            }
        }
        SLResponse response = this.invokeStatement("UPDATE VCARD SET FN='" + this.toString(vcard.getFullName()) + "', N_FAMILY='" + this.toString(vcard.getName() != null ? vcard.getName().getFamilyName() : null) + "', N_GIVEN='" + this.toString(vcard.getName() != null ? vcard.getName().getGivenName() : null) + "', N_MIDDLE='" + this.toString(vcard.getName() != null ? vcard.getName().getMiddleName() : null) + "', NICKNAME='" + this.toString(vcard.getNickName()) + "', URL='" + this.toString(vcard.getURL()) + "', BDAY='" + this.toString(vcard.getBirthday()) + "', AGE='" + this.toString(vcard.getAge()) + "', GENDER='" + this.toString(vcard.getGender()) + "', MARITALSTATUS='" + this.toString(vcard.getMaritalStatus()) + "', LOCATION='" + this.toString(vcard.getLocation()) + "', WORKCELL='" + this.toString(vcard.getWorkCell()) + "', HOMECELL='" + this.toString(vcard.getHomeCell()) + "', ORG_ORGNAME='" + this.toString(vcard.getOrganization() != null ? vcard.getOrganization().getOrganizationName() : null) + "', ORG_ORGUNIT='" + this.toString(vcard.getOrganization() != null ? vcard.getOrganization().getOrganizationUnit() : null) + "', TITLE='" + this.toString(vcard.getTitle()) + "', ROLE='" + this.toString(vcard.getRole()) + "', TEL_WORK_VOICE='" + this.toString(vcard.getWorkPhone(PhoneUse.VOICE) != null ? vcard.getWorkPhone(PhoneUse.VOICE).getNumber() : null) + "', TEL_WORK_FAX='" + this.toString(vcard.getWorkPhone(PhoneUse.FAX) != null ? vcard.getWorkPhone(PhoneUse.FAX).getNumber() : null) + "', TEL_WORK_MSG='" + this.toString(vcard.getWorkPhone(PhoneUse.MSG) != null ? vcard.getWorkPhone(PhoneUse.MSG).getNumber() : null) + "', TEL_WORK_PAGER='" + this.toString(vcard.getWorkPhone(PhoneUse.PAGER) != null ? vcard.getWorkPhone(PhoneUse.PAGER).getNumber() : null) + "', TEL_WORK_CELL='" + this.toString(vcard.getWorkPhone(PhoneUse.CELL) != null ? vcard.getWorkPhone(PhoneUse.CELL).getNumber() : null) + "', ADR_WORK_EXTADD='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getExtendedAddress() : null) + "', ADR_WORK_STREET='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getStreet() : null) + "', ADR_WORK_LOCALITY='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getLocality() : null) + "', ADR_WORK_REGION='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getRegion() : null) + "', ADR_WORK_PCODE='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getPostalCode() : null) + "', ADR_WORK_CTRY='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getCountry() : null) + "', ADR_WORK_COUNTRY='" + this.toString(vcard.getWorkAddress() != null ? vcard.getWorkAddress().getCountry2() : null) + "', TEL_HOME_VOICE='" + this.toString(vcard.getHomePhone(PhoneUse.VOICE) != null ? vcard.getHomePhone(PhoneUse.VOICE).getNumber() : null) + "', TEL_HOME_FAX='" + this.toString(vcard.getHomePhone(PhoneUse.FAX) != null ? vcard.getHomePhone(PhoneUse.FAX).getNumber() : null) + "', TEL_HOME_MSG='" + this.toString(vcard.getHomePhone(PhoneUse.MSG) != null ? vcard.getHomePhone(PhoneUse.MSG).getNumber() : null) + "', TEL_HOME_PAGER='" + this.toString(vcard.getHomePhone(PhoneUse.PAGER) != null ? vcard.getHomePhone(PhoneUse.PAGER).getNumber() : null) + "', TEL_HOME_CELL='" + this.toString(vcard.getHomePhone(PhoneUse.CELL) != null ? vcard.getHomePhone(PhoneUse.CELL).getNumber() : null) + "', ADR_HOME_EXTADD='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getExtendedAddress() : null) + "', ADR_HOME_STREET='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getStreet() : null) + "', ADR_HOME_LOCALITY='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getLocality() : null) + "', ADR_HOME_REGION='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getRegion() : null) + "', ADR_HOME_PCODE='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getPostalCode() : null) + "', ADR_HOME_CTRY='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getCountry() : null) + "', ADR_HOME_COUNTRY='" + this.toString(vcard.getHomeAddress() != null ? vcard.getHomeAddress().getCountry2() : null) + "', EMAIL_HOME='" + this.toString(vcard.getHomeEMail() != null ? vcard.getHomeEMail().getUserId() : null) + "', EMAIL_WORK='" + this.toString(vcard.getWorkEMail() != null ? vcard.getWorkEMail().getUserId() : null) + "', JABBERID='" + this.toString(vcard.getJID()) + "', DESC='" + this.toString(vcard.getDescription()) + "' WHERE USER_NAME='" + userName.toLowerCase() + "'");
        this.checkWithException(response, "Setting of vCard", userName);
        this.setPhoto(userName, vcard.getPhoto());
    }

    void createPhoto(String userName, Photo photo) throws SecurityManagerException {
        String type = photo != null ? photo.getType() : null;
        String data = photo != null ? photo.getData() : null;
        SLResponse response = this.invokeStatement("INSERT INTO VCARD_PHOTO VALUES('" + userName.toLowerCase() + "', '" + this.toString(type) + "', '" + (data != null ? data.replace("\n", "").replace("\r", "") : "") + "')");
        this.checkWithException(response, "Creation of vCard photo", userName);
    }

    void dropPhoto(String userName) {
        this.invokeStatement("DELETE FROM VCARD_PHOTO WHERE USER_NAME='" + userName.toLowerCase() + "'");
    }

    Photo getPhoto(String userName) {
        SLResponse response = this.getPhotoResponse(userName);
        return VCardStore.isOK(response) ? this.getPhoto(response.getRowSet()) : new Photo();
    }

    Photo getPhoto(RowSet rowset) {
        try {
            return new Photo(rowset.getObject("TYPE").toString(), rowset.getObject("PHOTO").toString());
        }
        catch (SQLException exception) {
            Trace.logException(VCardStore.class, exception, true);
            return null;
        }
    }

    void setPhoto(String userName, Photo photo) throws SecurityManagerException {
        String type = photo != null ? photo.getType() : null;
        String data = photo != null ? photo.getData() : null;
        SLResponse response = this.invokeStatement("UPDATE VCARD_PHOTO SET TYPE='" + this.toString(type) + "', PHOTO='" + (data != null ? data.replace("\n", "").replace("\r", "") : "") + "' WHERE USER_NAME='" + userName.toLowerCase() + "'");
        this.checkWithException(response, "Setting vCard photo", userName);
    }

    SLResponse getVCardResponse(String userName) {
        return this.invokeStatement("SELECT * FROM VCARD WHERE USER_NAME='" + userName.toLowerCase() + "'");
    }

    SLResponse getPhotoResponse(String userName) {
        return this.invokeStatement("SELECT * FROM VCARD_PHOTO WHERE USER_NAME='" + userName.toLowerCase() + "'");
    }

    private void checkWithException(SLResponse response, String operation, String userName) throws SecurityManagerException {
        this.checkWithException(response, operation + " for user " + userName);
    }

    @Override
    protected Class getExceptionClass() {
        return SecurityManagerException.class;
    }

    @Override
    protected int getErrorCode() {
        return 6100;
    }

    private String toString(String parameter) {
        return parameter != null ? parameter : "";
    }

    private String toString(Object outerParameter, String parameter) {
        return outerParameter != null && parameter != null ? parameter : "";
    }
}

