/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CIString;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.security.AbstractEntity;
import com.streamscape.sef.security.AbstractSecurityManagerImpl;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.EntityWithOrganization;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.UserState;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class User
extends AbstractEntity
implements ComponentOwner,
EntityWithOrganization {
    public static final String DEFAULT_MNODE_ATTRIBUTE = "defaultMnode";
    public static final String CREATION_TIMESTAMP_ATTRIBUTE = "creationTimestamp";
    public static final String LAST_ACCESS_TIMESTAMP_ATTRIBUTE = "lastAccessTimestamp";
    public static final String LAST_FAILED_ATTEMPT_TIMESTAMP_ATTRIBUTE = "lastFailedAttemptTimestamp";
    public static final String DROPBOX_OWNER_ATTRIBUTE = "dropBoxOwner";
    String password;
    String alias;
    CIString organization;
    HashSet<CIString> groups = new HashSet();
    AccessControlList accessControlList;
    String ldifRecord;
    boolean sudoCapable = false;
    boolean distinguishedEntity = false;
    UserState state = UserState.ENABLED;
    transient HashMap<String, String> attributes = new HashMap();
    transient Boolean isAnonymous = null;

    User(String name, String password, String description) {
        super(name, description);
        this.setPassword(password);
    }

    @Override
    public CIString getName() {
        return super.getName();
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = AbstractSecurityManagerImpl.normalizePassword(password);
    }

    @Override
    public boolean isSudoCapable() {
        return this.sudoCapable;
    }

    public void setSudoCapable(boolean sudoCapable) {
        this.sudoCapable = sudoCapable;
    }

    public boolean isDropBoxOwner() {
        String dropBoxOwner = this.getAttribute(DROPBOX_OWNER_ATTRIBUTE);
        return dropBoxOwner != null && Boolean.parseBoolean(dropBoxOwner);
    }

    public void setDropBoxOwner(boolean dropBoxOwner) {
        this.doSetAttribute(DROPBOX_OWNER_ATTRIBUTE, String.valueOf(dropBoxOwner));
    }

    public boolean isDistinguishedEntity() {
        return this.distinguishedEntity;
    }

    public void setDistinguishedEntity(boolean distinguishedEntity) {
        this.distinguishedEntity = distinguishedEntity;
    }

    void addGroup(CIString groupName) {
        this.groups.add(groupName);
    }

    void removeGroup(CIString groupName) {
        this.groups.remove(groupName);
    }

    public boolean isMemberOf(String groupName) {
        return this.isMemberOf(new CIString(groupName));
    }

    boolean isMemberOf(CIString groupName) {
        return this.groups.contains(groupName);
    }

    List<CIString> getGroups() {
        return new ArrayList<CIString>(this.groups);
    }

    int getGroupsNumber() {
        return this.groups.size();
    }

    public List<String> listGroups() {
        return this.groups.stream().map(CIString::toString).sorted().collect(Collectors.toList());
    }

    void setOrganization(CIString organization) {
        this.organization = organization;
    }

    @Override
    public CIString getOrganization() {
        return this.organization;
    }

    public void setAttribute(String key, String value) throws SecurityManagerException {
        this.checkSystemAttribute(key);
        this.doSetAttribute(key, value);
    }

    void doSetAttribute(String key, String value) {
        this.initAttributes();
        this.attributes.put(key, value);
        this.updateDNRecord();
    }

    public void removeAttribute(String key) throws SecurityManagerException {
        this.checkSystemAttribute(key);
        this.initAttributes();
        this.attributes.remove(key);
        this.updateDNRecord();
    }

    public static boolean isSystemAttribute(String name) {
        return name.equals(CREATION_TIMESTAMP_ATTRIBUTE) || name.equals(LAST_ACCESS_TIMESTAMP_ATTRIBUTE) || name.equals(LAST_FAILED_ATTEMPT_TIMESTAMP_ATTRIBUTE) || name.equals(DROPBOX_OWNER_ATTRIBUTE);
    }

    void checkSystemAttribute(String key) throws SecurityManagerException {
        if (User.isSystemAttribute(key)) {
            throw new SecurityManagerException(6133, "System attribute '" + key + "' cannot be changed.", this.name.toString());
        }
    }

    public String getAttribute(String key) {
        this.initAttributes();
        return this.attributes.get(key);
    }

    public List<String> listAttributes() {
        this.initAttributes();
        return new ArrayList<String>(this.attributes.keySet());
    }

    synchronized void initAttributes() {
        if (this.attributes == null) {
            this.readResolve();
        }
    }

    public String getDNRecord() {
        return this.ldifRecord;
    }

    public String getDNRecordWithoutSystemAttributes() {
        return this.formatDNRecord(this.attributes != null ? this.attributes.entrySet().stream().filter(entry -> !User.isSystemAttribute((String)entry.getKey())).collect(Collectors.toSet()) : null);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public boolean isAdministrator() {
        return this.getName().equals("sysadmin") || this.isMemberOf("Admins");
    }

    public boolean isAnonymous() {
        if (this.isAnonymous == null) {
            this.isAnonymous = this.getName().equals("anonymous");
        }
        return this.isAnonymous;
    }

    AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public boolean hasOwnPermissions() {
        return this.accessControlList != null;
    }

    void addAccessControlOperation(AccessControlOperation operation) {
        this.initAccessControlList();
        this.accessControlList.addOperation(operation);
    }

    void removeAccessControlOperation(AccessControlOperation operation) {
        this.initAccessControlList();
        this.accessControlList.removeOperation(operation);
    }

    void clearAccessControlList() {
        this.initAccessControlList();
        this.accessControlList.clear();
    }

    void resetAccessControlList() {
        this.setAccessControlList(null);
    }

    void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    void copyAccessControlList(AccessControlList other) {
        this.initAccessControlList();
        this.accessControlList.copy(other);
    }

    private void initAccessControlList() {
        if (this.accessControlList == null) {
            this.accessControlList = new AccessControlList();
        }
    }

    public UserState getState() {
        return this.state;
    }

    void setState(UserState state) {
        this.state = state;
    }

    void parseDNRecord() {
        if (this.ldifRecord != null && !this.ldifRecord.isEmpty()) {
            List<String> tuples = StringUtils.splitWithoutEmptyTokens(this.ldifRecord, ',');
            for (String tuple : tuples) {
                List<String> attribute = StringUtils.splitWithoutEmptyTokens(tuple, '=');
                if (attribute.size() != 2) continue;
                this.attributes.put(attribute.get(0), attribute.get(1));
            }
        }
    }

    void updateDNRecord() {
        this.ldifRecord = this.formatDNRecord(this.attributes.entrySet());
    }

    private String formatDNRecord(Set<Map.Entry<String, String>> entries) {
        if (entries != null) {
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry<String, String> entry : entries) {
                buffer.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            return buffer.length() > 0 ? buffer.substring(0, buffer.length() - 1) : null;
        }
        return null;
    }

    Object readResolve() {
        this.attributes = new HashMap();
        this.parseDNRecord();
        return this;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return super.getSecurityContext();
    }

    public Date getCreationTimestamp() {
        return this.doGetTimestamp(CREATION_TIMESTAMP_ATTRIBUTE);
    }

    public Date getLastAccessTimestamp() {
        return this.doGetTimestamp(LAST_ACCESS_TIMESTAMP_ATTRIBUTE);
    }

    public Date getLastFailedAttemptTimestamp() {
        return this.doGetTimestamp(LAST_FAILED_ATTEMPT_TIMESTAMP_ATTRIBUTE);
    }

    private Date doGetTimestamp(String attributeName) {
        String result = this.getAttribute(attributeName);
        try {
            if (result != null) {
                return new Date(Long.parseLong(result));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    synchronized void update(User other) {
        this.description = other.description;
        this.alias = other.alias;
        this.sudoCapable = other.sudoCapable;
        this.distinguishedEntity = other.distinguishedEntity;
        this.ldifRecord = other.ldifRecord;
        this.attributes = other.attributes;
    }

    @Override
    void synchronize(AbstractEntity from) {
        super.synchronize(from);
        User fromUser = (User)from;
        this.password = fromUser.password;
        this.alias = fromUser.alias;
        this.organization = fromUser.organization;
        this.groups = fromUser.groups;
        this.accessControlList = fromUser.accessControlList;
        this.ldifRecord = fromUser.ldifRecord;
        this.sudoCapable = fromUser.sudoCapable;
        this.distinguishedEntity = fromUser.distinguishedEntity;
        this.state = fromUser.state;
    }

    @Override
    public synchronized User clone() {
        User result = (User)super.clone();
        result.accessControlList = this.accessControlList != null ? this.accessControlList.clone() : null;
        result.groups = this.groups != null ? (HashSet)this.groups.clone() : null;
        result.attributes = this.attributes != null ? (HashMap)this.attributes.clone() : null;
        result.password = null;
        return result;
    }
}

