/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.List;

public interface SecurityManager {
    public static final String ANONYMOUS_USER = "anonymous";
    public static final String ADMINS_GROUP = "Admins";
    public static final String USERS_GROUP = "Users";
    public static final String HTTP_GROUP = "HTTP";
    public static final String OPERATORS_GROUP = "Operators";
    public static final String DOMAIN_ORGANIZATION = "Domain";

    public SecurityContext getSecurityContext();

    public User createUser(String var1, String var2, String var3) throws SecurityManagerException;

    public User createUser(String var1, String var2, String var3, vCard var4) throws SecurityManagerException;

    public void dropUser(String var1) throws SecurityManagerException;

    public void updateUser(User var1) throws SecurityManagerException;

    public boolean existsUser(String var1) throws SecurityManagerException;

    public User lookupUser(String var1) throws SecurityManagerException;

    public List<User> getUsers() throws SecurityManagerException;

    public List<String> listUsers() throws SecurityManagerException;

    public void addUserPermission(String var1, AccessControlOperation var2) throws SecurityManagerException;

    public void removeUserPermission(String var1, AccessControlOperation var2) throws SecurityManagerException;

    public void resetUserPermissions(String var1) throws SecurityManagerException;

    public AccessControlList getUserPermissions(String var1) throws SecurityManagerException;

    public void enableUser(String var1) throws SecurityManagerException;

    public void disableUser(String var1) throws SecurityManagerException;

    public vCard getVCard(String var1) throws SecurityManagerException;

    public void setVCard(String var1, vCard var2) throws SecurityManagerException;

    public Group createGroup(String var1, String var2) throws SecurityManagerException;

    public void dropGroup(String var1) throws SecurityManagerException;

    public void updateGroup(Group var1) throws SecurityManagerException;

    public boolean existsGroup(String var1) throws SecurityManagerException;

    public Group lookupGroup(String var1) throws SecurityManagerException;

    public List<Group> getGroups() throws SecurityManagerException;

    public List<String> listGroups() throws SecurityManagerException;

    public void addGroupPermission(String var1, AccessControlOperation var2) throws SecurityManagerException;

    public void removeGroupPermission(String var1, AccessControlOperation var2) throws SecurityManagerException;

    public AccessControlList getGroupPermissions(String var1) throws SecurityManagerException;

    public void addUserToGroup(String var1, String var2) throws SecurityManagerException;

    public void removeUserFromGroup(String var1, String var2) throws SecurityManagerException;

    public Organization createOrganization(String var1, String var2) throws SecurityManagerException;

    public void dropOrganization(String var1) throws SecurityManagerException;

    public void updateOrganization(Organization var1) throws SecurityManagerException;

    public boolean existsOrganization(String var1) throws SecurityManagerException;

    public Organization lookupOrganization(String var1) throws SecurityManagerException;

    public List<Organization> getOrganizations() throws SecurityManagerException;

    public List<String> listOrganizations() throws SecurityManagerException;

    public void setOrganizationDomain(String var1, String var2) throws SecurityManagerException;

    public void setUserOrganization(String var1, String var2) throws SecurityManagerException;

    public void setGroupOrganization(String var1, String var2) throws SecurityManagerException;

    public String resetPassword(String var1) throws SecurityManagerException;

    public void changePassword(String var1, String var2, String var3) throws SecurityManagerException;

    public List<ComponentReference> listBoundComponents(String var1, boolean var2) throws SecurityManagerException;
}

