/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.security.AbstractEntity;
import com.streamscape.sef.security.AbstractSecurityManagerImpl;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SecurityContext {
    protected AbstractEntity owner;
    protected Set<ComponentReference> boundComponents = new HashSet<ComponentReference>();
    private transient Object securityManager;

    protected SecurityContext(AbstractEntity owner, Object securityManager) {
        this.owner = owner;
        this.owner.setSecurityContext(this);
        this.securityManager = securityManager;
    }

    protected void destroy() {
        if (this.securityManager != null && this.securityManager instanceof AbstractSecurityManagerImpl) {
            ((AbstractSecurityManagerImpl)this.securityManager).removeSecurityContext(this.owner);
        }
        this.owner.setSecurityContext(null);
        this.owner = null;
    }

    public String getOwnerName() {
        return this.owner.getName().toString();
    }

    public User getUser() {
        return this.owner instanceof User ? ((User)this.owner).clone() : null;
    }

    public Group getGroup() {
        return this.owner instanceof Group ? ((Group)this.owner).clone() : null;
    }

    public synchronized List<ComponentReference> listBoundComponents() {
        return new ArrayList<ComponentReference>(this.boundComponents);
    }

    public synchronized boolean authorize(AccessControlOperation operation) {
        if (this.owner instanceof User && ((User)this.owner).isSudoCapable()) {
            return true;
        }
        AccessControlList acl = this.getAccessControlList();
        return acl != null && acl.isAllowed(operation);
    }

    private AccessControlList getAccessControlList() {
        AccessControlList result = null;
        try {
            if (this.securityManager instanceof AbstractSecurityManagerImpl) {
                result = this.owner instanceof User ? ((AbstractSecurityManagerImpl)this.securityManager).getUserPermissions((User)this.owner, this.getOwnerName()) : ((AbstractSecurityManagerImpl)this.securityManager).getGroupPermissions(null, this.getOwnerName());
            } else if (this.securityManager instanceof SecurityManager) {
                result = this.owner instanceof User ? ((SecurityManager)this.securityManager).getUserPermissions(this.getOwnerName()) : ((SecurityManager)this.securityManager).getGroupPermissions(this.getOwnerName());
            }
        }
        catch (SecurityManagerException securityManagerException) {
            // empty catch block
        }
        return result;
    }
}

