/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;

public class SHA1DigestCalculator
implements DigestCalculator {
    @Override
    public String calculateDigest(String userName, User user, Map<String, String> parameters) throws SecurityManagerException {
        return SHA1DigestCalculator.calculateDigest(userName != null ? userName : user.getName().toString(), parameters != null ? parameters.get("key") : null, user.getPassword());
    }

    public static String calculateDigest(String userName, String key, String password) throws SecurityManagerException {
        try {
            return CryptoUtils.calculateDigest(key, password, "SHA1");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SecurityManagerException(6084, (Throwable)exception, userName);
        }
    }

    public static boolean authenticate(User user, String credentials, String key) throws SecurityManagerException {
        return Objects.equals(SHA1DigestCalculator.calculateDigest(user.getName().toString(), key, user.getPassword()), credentials);
    }
}

