/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class MD5DigestCalculator
implements DigestCalculator {
    @Override
    public String calculateDigest(String userName, User user, Map<String, String> parameters) throws SecurityManagerException {
        if (parameters == null) {
            throw new SecurityManagerException(6084, "MD5DigestCalculator: Parameters for are null.");
        }
        return MD5DigestCalculator.calculateDigest(userName != null ? userName : user.getName().toString().toLowerCase(), user.getPassword(), parameters);
    }

    private static String calculateDigest(String userName, String password, Map<String, String> parameters) throws SecurityManagerException {
        try {
            String HA1 = MD5DigestCalculator.calculateDigest((userName + ":" + MD5DigestCalculator.getParameter(parameters, "realm") + ":" + (password != null ? password : "")).getBytes());
            String HA2 = MD5DigestCalculator.calculateDigest((MD5DigestCalculator.getParameter(parameters, "method") + ":" + MD5DigestCalculator.getParameter(parameters, "uri")).getBytes());
            return MD5DigestCalculator.calculateDigest((HA1 + ":" + MD5DigestCalculator.getParameter(parameters, "nonce") + ":" + HA2).getBytes());
        }
        catch (SecurityManagerException exception) {
            throw new SecurityManagerException(exception.getErrorCode(), exception.getErrorMessage(), userName);
        }
    }

    private static String calculateDigest(byte[] data) throws SecurityManagerException {
        try {
            return CryptoUtils.calculateDigest(data, "MD5");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SecurityManagerException(6084, (Throwable)exception);
        }
    }

    private static String getParameter(Map<String, String> parameters, String name) throws SecurityManagerException {
        String result = parameters.get(name);
        if (result == null) {
            throw new SecurityManagerException(6084, "MD5DigestCalculator: Parameter '" + name + "' is null.");
        }
        return result;
    }
}

