/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class HttpSecurityDigestCalculator
implements DigestCalculator {
    @Override
    public String calculateDigest(String userName, User user, Map<String, String> parameters) throws SecurityManagerException {
        return HttpSecurityDigestCalculator.calculateDigest(userName != null ? userName : user.getName().toString().toLowerCase(), user.getPassword());
    }

    public static String calculateDigest(String username, String password) {
        try {
            return CryptoUtils.calculateDigest(username.toLowerCase(), password, "SHA1");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException("No method SHA1", exception);
        }
    }
}

