/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CIString;
import com.streamscape.sef.security.AbstractComplexEntity;
import com.streamscape.sef.security.AbstractEntity;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.EntityWithOrganization;
import com.streamscape.sef.security.SecurityContext;
import java.util.List;

public class Group
extends AbstractComplexEntity
implements ComponentOwner,
EntityWithOrganization {
    CIString organization;
    AccessControlList accessControlList = new AccessControlList();

    Group(String name, String description) {
        super(name, description);
    }

    @Override
    public CIString getName() {
        return super.getName();
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
    }

    void setOrganization(CIString organization) {
        this.organization = organization;
        this.setValid();
    }

    void setOrganization(String organization) {
        this.setOrganization(new CIString(organization));
    }

    @Override
    public CIString getOrganization() {
        return this.organization;
    }

    public boolean hasUser(String userName) {
        return this.hasMember(userName);
    }

    public boolean hasUsers() {
        return this.hasMembers();
    }

    public List<String> listUsers() {
        return this.listMembers();
    }

    void addAccessControlOperation(AccessControlOperation operation) {
        this.accessControlList.addOperation(operation);
    }

    void removeAccessControlOperation(AccessControlOperation operation) {
        this.accessControlList.removeOperation(operation);
    }

    boolean containsOperation(AccessControlOperation operation) {
        return this.accessControlList.contains(operation);
    }

    AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    @Override
    public SecurityContext getSecurityContext() {
        return super.getSecurityContext();
    }

    @Override
    public boolean isSudoCapable() {
        return false;
    }

    @Override
    public boolean isAdministrator() {
        return this.getName().equals("Admins");
    }

    synchronized void update(Group other) {
        this.description = other.description;
    }

    @Override
    void synchronize(AbstractEntity from) {
        super.synchronize(from);
        this.organization = ((Group)from).organization;
        this.accessControlList = ((Group)from).accessControlList;
    }

    @Override
    public synchronized Group clone() {
        Group result = (Group)super.clone();
        result.accessControlList = this.accessControlList != null ? this.accessControlList.clone() : null;
        return result;
    }
}

