/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.sef.security.AbstractAuthenticationModule;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SHA1DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.Map;
import java.util.Objects;

public class FabricAuthenticationModule
extends AbstractAuthenticationModule {
    private static final DigestCalculator DEFAULT_CALCULATOR = new SHA1DigestCalculator();

    @Override
    protected boolean authenticateUserOnly(User user) throws SecurityManagerException {
        return user.getPassword() == null;
    }

    @Override
    protected boolean authenticatePasswordPlainText(User user, String credentials) throws SecurityManagerException {
        return user.getPassword() == null && credentials == null || user.getPassword() != null && credentials != null && user.getPassword().equals(credentials);
    }

    @Override
    protected boolean authenticateDigest(String userName, User user, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws SecurityManagerException {
        String digest = (calculator != null ? calculator : DEFAULT_CALCULATOR).calculateDigest(userName, user, parameters);
        return Objects.equals(digest, credentials);
    }
}

