/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AccessControlOperation {
    ALLOW_ALL,
    CLIENT_ALLOW_ALL,
    CLIENT_ACCESS_SLANG,
    CLIENT_ACCESS_REPOSITORY,
    CLIENT_ACCESS_PRODUCER,
    CLIENT_ACCESS_CONSUMER,
    CLIENT_ACCESS_EVENT_CACHE,
    CLIENT_ACCESS_DATA_CONSTRAINT,
    CLIENT_ACCESS_FABRIC_GROUPS,
    SERVICE_ALLOW_ALL,
    SERVICE_CREATE,
    SERVICE_ADMIN,
    SERVICE_ACCESS,
    SERVICE_USE,
    DATASPACE_ALLOW_ALL,
    DATASPACE_CREATE,
    DATASPACE_ADMIN,
    DATASPACE_ACCESS,
    DATASPACE_USE,
    CONNECTION_FACTORY_USE;

    private static final Map<AccessControlOperation, String> SLANG_NAMES_BY_OPERATION;
    private static final Map<String, AccessControlOperation> SLANG_OPERATIONS_BY_NAME;

    boolean isClient() {
        return this.ordinal() > CLIENT_ALLOW_ALL.ordinal() && this.ordinal() < SERVICE_ALLOW_ALL.ordinal();
    }

    boolean isService() {
        return this.ordinal() > SERVICE_ALLOW_ALL.ordinal() && this.ordinal() < DATASPACE_ALLOW_ALL.ordinal();
    }

    boolean isDataspace() {
        return this.ordinal() > DATASPACE_ALLOW_ALL.ordinal() && this.ordinal() < CONNECTION_FACTORY_USE.ordinal();
    }

    boolean isConnectionFactory() {
        return this == CONNECTION_FACTORY_USE;
    }

    public String toSlangName() {
        return SLANG_NAMES_BY_OPERATION.get((Object)this);
    }

    public static AccessControlOperation fromSlangName(String name) {
        return SLANG_OPERATIONS_BY_NAME.get(name);
    }

    public static List<String> slangValues() {
        return new ArrayList<String>(SLANG_OPERATIONS_BY_NAME.keySet());
    }

    static {
        SLANG_NAMES_BY_OPERATION = new HashMap<AccessControlOperation, String>();
        SLANG_OPERATIONS_BY_NAME = new HashMap<String, AccessControlOperation>();
        SLANG_NAMES_BY_OPERATION.put(ALLOW_ALL, "all");
        SLANG_NAMES_BY_OPERATION.put(SERVICE_ALLOW_ALL, "all on services");
        SLANG_NAMES_BY_OPERATION.put(SERVICE_CREATE, "create service");
        SLANG_NAMES_BY_OPERATION.put(SERVICE_ADMIN, "administer on services");
        SLANG_NAMES_BY_OPERATION.put(SERVICE_ACCESS, "access on services");
        SLANG_NAMES_BY_OPERATION.put(SERVICE_USE, "use on services");
        SLANG_NAMES_BY_OPERATION.put(DATASPACE_ALLOW_ALL, "all on dataspaces");
        SLANG_NAMES_BY_OPERATION.put(DATASPACE_CREATE, "create dataspace");
        SLANG_NAMES_BY_OPERATION.put(DATASPACE_ADMIN, "administer dataspaces");
        SLANG_NAMES_BY_OPERATION.put(DATASPACE_USE, "use on dataspaces");
        SLANG_NAMES_BY_OPERATION.put(CONNECTION_FACTORY_USE, "use on connection factories");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ALLOW_ALL, "all on clients");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_SLANG, "connect");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_REPOSITORY, "access on repository");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_PRODUCER, "create event producer");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_CONSUMER, "create event consumer");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_EVENT_CACHE, "create event cache");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_DATA_CONSTRAINT, "create data constraint");
        SLANG_NAMES_BY_OPERATION.put(CLIENT_ACCESS_FABRIC_GROUPS, "create communication group");
        for (Map.Entry<AccessControlOperation, String> entry : SLANG_NAMES_BY_OPERATION.entrySet()) {
            SLANG_OPERATIONS_BY_NAME.put(entry.getValue(), entry.getKey());
        }
    }
}

