/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.security.AccessControlOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class AccessControlList
extends CloneableDataObject {
    private HashSet<AccessControlOperation> operations = new HashSet();
    private static final Comparator<AccessControlOperation> COMPARATOR = Comparator.comparingInt(Enum::ordinal);

    AccessControlList() {
    }

    synchronized boolean addOperation(AccessControlOperation operation) {
        switch (operation) {
            case ALLOW_ALL: {
                if (!this.operations.contains((Object)AccessControlOperation.ALLOW_ALL)) {
                    this.operations.clear();
                    this.operations.add(AccessControlOperation.ALLOW_ALL);
                    return true;
                }
                return false;
            }
            case CLIENT_ALLOW_ALL: {
                if (!this.operations.contains((Object)AccessControlOperation.CLIENT_ALLOW_ALL)) {
                    this.clearClientOperations();
                    this.operations.add(AccessControlOperation.CLIENT_ALLOW_ALL);
                    return true;
                }
                return false;
            }
            case SERVICE_ALLOW_ALL: {
                if (!this.operations.contains((Object)AccessControlOperation.SERVICE_ALLOW_ALL)) {
                    this.clearServiceOperations();
                    this.operations.add(AccessControlOperation.SERVICE_ALLOW_ALL);
                    return true;
                }
                return false;
            }
            case DATASPACE_ALLOW_ALL: {
                if (!this.operations.contains((Object)AccessControlOperation.DATASPACE_ALLOW_ALL)) {
                    this.clearDataspaceOperations();
                    this.operations.add(AccessControlOperation.DATASPACE_ALLOW_ALL);
                    return true;
                }
                return false;
            }
        }
        return this.operations.add(operation);
    }

    synchronized boolean removeOperation(AccessControlOperation operation) {
        switch (operation) {
            case ALLOW_ALL: {
                if (!this.operations.isEmpty()) {
                    this.operations.clear();
                    return true;
                }
                return false;
            }
            case CLIENT_ALLOW_ALL: {
                return this.clearClientOperations();
            }
            case SERVICE_ALLOW_ALL: {
                return this.clearServiceOperations();
            }
            case DATASPACE_ALLOW_ALL: {
                return this.clearDataspaceOperations();
            }
        }
        if (!this.operations.remove((Object)operation)) {
            if (this.operations.contains((Object)AccessControlOperation.ALLOW_ALL)) {
                this.removeOperationFromAll(operation);
                return true;
            }
            if (operation.isClient()) {
                if (this.operations.contains((Object)AccessControlOperation.CLIENT_ALLOW_ALL)) {
                    this.operations.remove((Object)AccessControlOperation.CLIENT_ALLOW_ALL);
                    this.addClientOperations(operation);
                    return true;
                }
            } else if (operation.isService()) {
                if (this.operations.contains((Object)AccessControlOperation.SERVICE_ALLOW_ALL)) {
                    this.operations.remove((Object)AccessControlOperation.SERVICE_ALLOW_ALL);
                    this.addServiceOperations(operation);
                    return true;
                }
            } else if (operation.isDataspace() && this.operations.contains((Object)AccessControlOperation.DATASPACE_ALLOW_ALL)) {
                this.operations.remove((Object)AccessControlOperation.DATASPACE_ALLOW_ALL);
                this.addDataspaceOperations(operation);
                return true;
            }
            return false;
        }
        return true;
    }

    void clear() {
        this.operations.clear();
    }

    boolean clearClientOperations() {
        return this.clearOperations(AccessControlOperation.CLIENT_ALLOW_ALL.ordinal(), AccessControlOperation.SERVICE_ALLOW_ALL.ordinal());
    }

    boolean clearServiceOperations() {
        return this.clearOperations(AccessControlOperation.SERVICE_ALLOW_ALL.ordinal(), AccessControlOperation.DATASPACE_ALLOW_ALL.ordinal());
    }

    boolean clearDataspaceOperations() {
        return this.clearOperations(AccessControlOperation.DATASPACE_ALLOW_ALL.ordinal(), AccessControlOperation.CONNECTION_FACTORY_USE.ordinal());
    }

    private boolean clearOperations(int startIndex, int endIndex) {
        boolean result = false;
        for (int i = startIndex; i < endIndex; ++i) {
            if (!this.operations.remove((Object)AccessControlOperation.values()[i])) continue;
            result = true;
        }
        return result;
    }

    void removeOperationFromAll(AccessControlOperation operation) {
        this.operations.clear();
        if (operation.isClient()) {
            this.addClientOperations(operation);
            this.operations.add(AccessControlOperation.SERVICE_ALLOW_ALL);
            this.operations.add(AccessControlOperation.DATASPACE_ALLOW_ALL);
            this.operations.add(AccessControlOperation.CONNECTION_FACTORY_USE);
        } else if (operation.isService()) {
            this.addServiceOperations(operation);
            this.operations.add(AccessControlOperation.CLIENT_ALLOW_ALL);
            this.operations.add(AccessControlOperation.DATASPACE_ALLOW_ALL);
            this.operations.add(AccessControlOperation.CONNECTION_FACTORY_USE);
        } else if (operation.isDataspace()) {
            this.addDataspaceOperations(operation);
            this.operations.add(AccessControlOperation.CLIENT_ALLOW_ALL);
            this.operations.add(AccessControlOperation.SERVICE_ALLOW_ALL);
            this.operations.add(AccessControlOperation.CONNECTION_FACTORY_USE);
        } else {
            this.operations.add(AccessControlOperation.CLIENT_ALLOW_ALL);
            this.operations.add(AccessControlOperation.SERVICE_ALLOW_ALL);
            this.operations.add(AccessControlOperation.DATASPACE_ALLOW_ALL);
        }
    }

    void addClientOperations(AccessControlOperation excludedOperation) {
        this.addOperations(AccessControlOperation.CLIENT_ALLOW_ALL.ordinal() + 1, AccessControlOperation.SERVICE_ALLOW_ALL.ordinal(), excludedOperation);
    }

    void addServiceOperations(AccessControlOperation excludedOperation) {
        this.addOperations(AccessControlOperation.SERVICE_ALLOW_ALL.ordinal() + 1, AccessControlOperation.DATASPACE_ALLOW_ALL.ordinal(), excludedOperation);
    }

    void addDataspaceOperations(AccessControlOperation excludedOperation) {
        this.addOperations(AccessControlOperation.DATASPACE_ALLOW_ALL.ordinal() + 1, AccessControlOperation.CONNECTION_FACTORY_USE.ordinal(), excludedOperation);
    }

    void addOperations(int startIndex, int endIndex, AccessControlOperation excludedOperation) {
        for (int i = startIndex; i < endIndex; ++i) {
            AccessControlOperation operation = AccessControlOperation.values()[i];
            if (operation.equals((Object)excludedOperation)) continue;
            this.operations.add(operation);
        }
    }

    public synchronized List<AccessControlOperation> listOperations() {
        ArrayList<AccessControlOperation> result = new ArrayList<AccessControlOperation>(this.operations);
        result.sort(COMPARATOR);
        return result;
    }

    public synchronized boolean isAllowed(AccessControlOperation operation) {
        return !this.operations.isEmpty() && (this.operations.contains((Object)operation) || this.operations.contains((Object)AccessControlOperation.ALLOW_ALL) || this.isClientOperation(operation) || this.isServiceOperation(operation) || this.isDataspaceOperation(operation));
    }

    boolean isClientOperation(AccessControlOperation operation) {
        return operation.isClient() && this.operations.contains((Object)AccessControlOperation.CLIENT_ALLOW_ALL);
    }

    boolean isServiceOperation(AccessControlOperation operation) {
        return operation.isService() && this.operations.contains((Object)AccessControlOperation.SERVICE_ALLOW_ALL);
    }

    boolean isDataspaceOperation(AccessControlOperation operation) {
        return operation.isDataspace() && this.operations.contains((Object)AccessControlOperation.DATASPACE_ALLOW_ALL);
    }

    boolean contains(AccessControlOperation operation) {
        return this.operations.contains((Object)operation);
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    int size() {
        return this.operations.size();
    }

    void copy(AccessControlList other) {
        this.operations.addAll(other.operations);
    }

    @Override
    public AccessControlList clone() {
        AccessControlList result = (AccessControlList)super.clone();
        result.operations = this.operations != null ? (HashSet)this.operations.clone() : null;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (AccessControlOperation operation : this.operations) {
            if (i++ > 0) {
                builder.append(",");
            }
            builder.append((Object)operation);
        }
        return builder.toString();
    }
}

