/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CIString;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dataspace.DataspaceManagerException;
import com.streamscape.sef.dropbox.sdo.DropBox;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.network.xmpp.server.impl.JIDParser;
import com.streamscape.sef.security.AbstractEntity;
import com.streamscape.sef.security.AbstractEntityStore;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.AuthenticationModule;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.EntityWithOrganization;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Groups;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.Organizations;
import com.streamscape.sef.security.SHA1DigestCalculator;
import com.streamscape.sef.security.SecurityAdvisory;
import com.streamscape.sef.security.SecurityAdvisoryType;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.sef.security.UserState;
import com.streamscape.sef.security.Users;
import com.streamscape.sef.security.VCardStore;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractSecurityManagerImpl {
    protected static final String SECURITY_NAMESPACE = "/sys/security/";
    protected static final String ANONYMOUS_USER = "anonymous";
    protected static final String ANONYMOUS_PASSWORD = "anonymous";
    protected static final String ADMINS_GROUP = "Admins";
    protected static final String USERS_GROUP = "Users";
    protected static final String HTTP_GROUP = "HTTP";
    protected static final String OPERATORS_GROUP = "Operators";
    protected static final String DOMAIN_ORGANIZATION = "Domain";
    protected RuntimeContext context;
    protected AuthenticationModule authenticationModule;
    protected User sysadmin;
    protected Users users = new Users();
    protected Groups groups = new Groups();
    protected Organizations organizations = new Organizations();
    protected Map<CIString, SecurityContext> securityContexts = new HashMap<CIString, SecurityContext>();
    protected VCardStore vCardStore;
    protected boolean updateDomain = false;
    protected boolean oldVersion = false;
    protected static final String SYSADMIN_USER = "sysadmin";
    protected static final String SYSADMIN_PASSWORD = "]D}W;k!oX~!:{E7O";
    static final String ADMINS_DESCRIPTION = "Sysplex administrators (predefined group).";
    static final String USERS_DESCRIPTION = "Sysplex users (predefined group).";
    static final String HTTP_DESCRIPTION = "HTTP users (predefined group).";
    static final String OPERATORS_DESCRIPTION = "Ops console users (predefined group).";
    private static final List<Character> LETTERS = new ArrayList<Character>();
    private static final Set<String> RESERVED_NAMES;

    protected AbstractSecurityManagerImpl(RuntimeContext context) {
        this.context = context;
    }

    protected void init() throws Exception {
        this.initSysadmin();
        this.users.load(false);
        this.groups.load(false);
        this.organizations.load(false);
        this.validateStore();
    }

    private void initSysadmin() {
        this.sysadmin = this.users.createEntityInstance(SYSADMIN_USER, SYSADMIN_PASSWORD, "Sysplex administrator.");
        this.sysadmin.setSudoCapable(true);
        this.sysadmin.setDropBoxOwner(true);
    }

    protected boolean isSysadmin(User user) {
        return user != null && user.getName().equals(SYSADMIN_USER);
    }

    protected static boolean isSysadmin(String userName) {
        return userName != null && userName.equals(SYSADMIN_USER);
    }

    protected void validateStore() throws SecurityManagerException {
        if (this.users.isEmpty() && this.groups.isEmpty() && this.organizations.isEmpty()) {
            this.createCoreEntities();
        } else if (this.users.isEmpty() || this.groups.isEmpty() || this.organizations.isEmpty()) {
            this.recreateStore();
        }
        this.validateStoreContent();
        this.validateRuntimeUser();
    }

    private void recreateStore() {
        this.logError("Security store corrupted. Recreating...");
        this.users.recreate();
        this.groups.recreate();
        this.organizations.recreate();
        this.createCoreEntities();
    }

    private void createCoreEntities() {
        this.logDebug("Security core entities creation...");
        Organization organization = this.createCoreOrganization(DOMAIN_ORGANIZATION, "Sysplex domain organization (predefined).");
        Group group = this.createCoreGroup(ADMINS_GROUP, ADMINS_DESCRIPTION, organization);
        AbstractSecurityManagerImpl.setupDefaultAdminsGroup(group);
        group = this.createCoreGroup(USERS_GROUP, USERS_DESCRIPTION, organization);
        AbstractSecurityManagerImpl.setupDefaultUsersGroup(group);
        this.createAnonymousUser(organization, group);
        this.createCoreGroup(HTTP_GROUP, HTTP_DESCRIPTION, organization);
        this.createCoreGroup(OPERATORS_GROUP, OPERATORS_DESCRIPTION, organization);
        this.logInfo("Security core entities created.");
        this.saveAll();
    }

    private Organization createCoreOrganization(String name, String description) {
        Organization result = (Organization)this.organizations.createEntityWithoutCheck(name, description);
        result.setDomain(this.context.getDomain());
        return result;
    }

    private Group createCoreGroup(String name, String description, Organization organization) {
        Group result = (Group)this.groups.createEntityWithoutCheck(name, description);
        this.doSetGroupOrganization(result, organization);
        return result;
    }

    private void createAnonymousUser(Organization organization, Group group) {
        AbstractSecurityManagerImpl.setupAnonymousUser(this.createCoreUser("anonymous", "anonymous", "Anonymous user", organization, group));
    }

    private User createCoreUser(String name, String password, String description, Organization organization, Group group) {
        User result = (User)this.users.createEntityWithoutCheck(name, password, description);
        if (organization != null && group != null) {
            this.doSetUserOrganization(result, organization);
            this.doAddUserToGroup(result, group);
        }
        return result;
    }

    private void validateStoreContent() {
        this.logDebug("Security store validation...");
        this.validateCoreEntities();
        this.validateUserEntities();
        this.logInfo("Security store validated.");
    }

    private void validateCoreEntities() {
        this.logDebug("Security core entities validation...");
        this.validateDomainOrganization();
        this.validateAdminsGroup();
        this.validateUsersGroup();
        this.validateHTTPGroup();
        this.validateOperatorsGroup();
        this.validateSysadmin();
        this.validateAnonymousUser();
        this.logInfo("Security core entities validated.");
    }

    private void validateDomainOrganization() {
        Organization organization = (Organization)this.organizations.getEntity(DOMAIN_ORGANIZATION);
        this.validateCoreEntity("Organization", DOMAIN_ORGANIZATION, organization != null && organization.members != null && organization.hasMember(ADMINS_GROUP) && organization.hasMember(USERS_GROUP) && organization.hasMember("anonymous"));
        if (organization == null) {
            organization = (Organization)this.organizations.getEntity(DOMAIN_ORGANIZATION);
        }
        if (organization.removeMember(SYSADMIN_USER) | this.validateDomain(organization)) {
            this.saveOrganizations();
        }
    }

    private boolean validateDomain(Organization organization) {
        if (!organization.getDomain().equals(this.context.getDomain())) {
            this.updateDomain = true;
            organization.setDomain(this.context.getDomain());
            return true;
        }
        return false;
    }

    private void validateAdminsGroup() {
        Group group = (Group)this.groups.getEntity(ADMINS_GROUP);
        if (group != null && !group.getDescription().equals(ADMINS_DESCRIPTION)) {
            this.oldVersion = true;
            group.setDescription(ADMINS_DESCRIPTION);
            AbstractSecurityManagerImpl.setupDefaultAdminsGroup(group);
            this.saveGroups();
        }
        this.validateCoreEntity("Group", ADMINS_GROUP, group != null && group.members != null && group.accessControlList != null);
        if (group == null) {
            group = (Group)this.groups.getEntity(ADMINS_GROUP);
        }
        if (group.removeMember(SYSADMIN_USER)) {
            this.saveGroups();
        }
    }

    private static void setupDefaultAdminsGroup(Group group) {
        group.getAccessControlList().clear();
        group.getAccessControlList().addOperation(AccessControlOperation.CLIENT_ALLOW_ALL);
        group.getAccessControlList().addOperation(AccessControlOperation.SERVICE_ADMIN);
        group.getAccessControlList().addOperation(AccessControlOperation.SERVICE_CREATE);
        group.getAccessControlList().addOperation(AccessControlOperation.SERVICE_USE);
        group.getAccessControlList().addOperation(AccessControlOperation.DATASPACE_ADMIN);
        group.getAccessControlList().addOperation(AccessControlOperation.DATASPACE_CREATE);
        group.getAccessControlList().addOperation(AccessControlOperation.DATASPACE_USE);
        group.getAccessControlList().addOperation(AccessControlOperation.CONNECTION_FACTORY_USE);
    }

    private void validateUsersGroup() {
        Group group = (Group)this.groups.getEntity(USERS_GROUP);
        if (group != null && (this.oldVersion || !group.getDescription().equals(USERS_DESCRIPTION))) {
            this.oldVersion = true;
            group.setDescription(USERS_DESCRIPTION);
            AbstractSecurityManagerImpl.setupDefaultUsersGroup(group);
            this.saveGroups();
        }
        this.validateCoreEntity("Group", USERS_GROUP, group != null && group.organization != null && group.organization.equals(DOMAIN_ORGANIZATION) && group.members != null && group.hasMember("anonymous") && group.accessControlList != null);
        if (group == null) {
            group = (Group)this.groups.getEntity(USERS_GROUP);
        }
        if (group.removeMember(SYSADMIN_USER)) {
            this.saveGroups();
        }
    }

    private static void setupDefaultUsersGroup(Group group) {
        group.getAccessControlList().clear();
        group.getAccessControlList().addOperation(AccessControlOperation.CLIENT_ALLOW_ALL);
        group.getAccessControlList().addOperation(AccessControlOperation.SERVICE_CREATE);
        group.getAccessControlList().addOperation(AccessControlOperation.SERVICE_USE);
        group.getAccessControlList().addOperation(AccessControlOperation.DATASPACE_CREATE);
        group.getAccessControlList().addOperation(AccessControlOperation.DATASPACE_USE);
    }

    private void validateHTTPGroup() {
        Group group = (Group)this.groups.getEntity(HTTP_GROUP);
        if (group != null && (this.oldVersion || group.getDescription() == null || !group.getDescription().equals(HTTP_DESCRIPTION))) {
            this.oldVersion = true;
            group.setDescription(HTTP_DESCRIPTION);
            group.getAccessControlList().clear();
            this.saveGroups();
        }
        if (group == null) {
            group = this.createCoreGroup(HTTP_GROUP, HTTP_DESCRIPTION, (Organization)this.organizations.getEntity(DOMAIN_ORGANIZATION));
        }
        this.validateCoreEntity("Group", HTTP_GROUP, group != null && group.organization != null && group.organization.equals(DOMAIN_ORGANIZATION));
        if (group == null) {
            group = (Group)this.groups.getEntity(HTTP_GROUP);
        }
        if (group.removeMember(SYSADMIN_USER)) {
            this.saveGroups();
        }
    }

    private void validateOperatorsGroup() {
        Group group = (Group)this.groups.getEntity(OPERATORS_GROUP);
        if (group == null) {
            group = this.createCoreGroup(OPERATORS_GROUP, OPERATORS_DESCRIPTION, (Organization)this.organizations.getEntity(DOMAIN_ORGANIZATION));
        }
        if (group.removeMember(SYSADMIN_USER)) {
            this.saveGroups();
        }
    }

    private void validateSysadmin() {
        if (this.users.removeEntity(SYSADMIN_USER) != null) {
            this.saveUsers();
        }
    }

    private void validateAnonymousUser() {
        AccessControlList acl;
        User user = (User)this.users.getEntity("anonymous");
        this.validateCoreEntity("User", "anonymous", user != null && user.password != null && user.password.equals("anonymous") && user.organization != null && user.organization.equals(DOMAIN_ORGANIZATION) && user.groups != null && user.isMemberOf(USERS_GROUP));
        if (user == null) {
            user = (User)this.users.getEntity("anonymous");
        }
        if (!((acl = user.getAccessControlList()).size() == 3 && acl.contains(AccessControlOperation.DATASPACE_USE) && acl.contains(AccessControlOperation.SERVICE_USE) && acl.contains(AccessControlOperation.SERVICE_ACCESS))) {
            AbstractSecurityManagerImpl.setupAnonymousUser(user);
            this.saveUsers();
        }
    }

    private void validateCoreEntity(String type, String name, boolean condition) {
        if (!condition) {
            this.logError(type + " '" + name + "' is invalid.");
            this.recreateStore();
        }
    }

    private void validateUserEntities() {
        this.validateOrganizations();
        this.validateGroups();
        this.validateUsers();
    }

    private void validateOrganizations() {
        boolean needSave = false;
        this.logDebug("Organizations validation...");
        for (Organization organization : this.organizations.values()) {
            if (organization.getDomain() == null) {
                this.logError("Organization '" + String.valueOf(organization.getName()) + "' is invalid: null domain.");
                if (organization.isValid()) {
                    organization.setInvalid();
                    needSave = true;
                }
            } else if (!organization.isValid()) {
                organization.setValid();
                needSave = true;
            }
            int membersSize = organization.members.size();
            Iterator<CIString> iterator = organization.members.iterator();
            while (iterator.hasNext()) {
                User user;
                CIString member = (CIString)iterator.next();
                Group group = (Group)this.groups.getEntity(member);
                if (this.repairOrganizationMember(organization, group, iterator) || this.repairOrganizationMember(organization, user = (User)this.users.getEntity(member), iterator)) continue;
                this.logError("Organization '" + String.valueOf(organization.getName()) + "' has unknown member '" + String.valueOf(member) + "'. Repair...");
                iterator.remove();
            }
            if (organization.members.size() == membersSize) continue;
            needSave = true;
        }
        this.logInfo("Organizations validated.");
        if (needSave) {
            this.saveOrganizations();
        }
    }

    private boolean repairOrganizationMember(Organization organization, EntityWithOrganization member, Iterator<CIString> iterator) {
        if (member != null) {
            if (!member.getOrganization().equals(organization.getName())) {
                this.logError("Organization '" + String.valueOf(organization.getName()) + "' has illegal member '" + String.valueOf(member) + "'. Repair...");
                iterator.remove();
            }
            return true;
        }
        return false;
    }

    private void validateGroups() {
        boolean needSave = false;
        this.logDebug("Groups validation...");
        for (Group group : this.groups.values()) {
            Organization org;
            if (group.getOrganization() == null || (org = (Organization)this.organizations.getEntity(group.getOrganization())) == null || !org.isValid()) {
                this.logError("Group '" + String.valueOf(group.getName()) + "' is invalid: invalid organization '" + String.valueOf(group.getOrganization()) + "'.");
                if (group.isValid()) {
                    group.setInvalid();
                    needSave = true;
                }
            } else {
                if (!group.isValid()) {
                    group.setValid();
                    needSave = true;
                }
                this.repairOrganization(org, "group", group.getName());
            }
            int membersSize = group.members.size();
            Iterator iterator = group.members.iterator();
            while (iterator.hasNext()) {
                CIString member = (CIString)iterator.next();
                User user = (User)this.users.getEntity(member);
                if (user != null) {
                    if (user.isMemberOf(group.getName())) continue;
                    this.logError("Group '" + String.valueOf(group.getName()) + "' has illegal member '" + String.valueOf(member) + "'. Repair...");
                    iterator.remove();
                    continue;
                }
                this.logError("Group '" + String.valueOf(group.getName()) + "' has unknown member '" + String.valueOf(member) + "'. Repair...");
                iterator.remove();
            }
            if (group.members.size() == membersSize) continue;
            needSave = true;
        }
        this.logInfo("Groups validated.");
        if (needSave) {
            this.saveGroups();
        }
    }

    private void validateUsers() {
        Pair<Boolean, Boolean> needSave = new Pair<Boolean, Boolean>(false, false);
        this.logDebug("Users validation...");
        for (User user : this.users.values()) {
            this.validateUser(user, needSave);
            if (!this.oldVersion || user.getAccessControlList() == null || !user.getAccessControlList().isEmpty()) continue;
            user.resetAccessControlList();
            needSave.first = true;
        }
        this.logInfo("Users validated.");
        this.save(needSave);
    }

    private void validateRuntimeUser() throws SecurityManagerException {
        if (this.context.getUserName() == null) {
            throw new SecurityManagerException(6000, "Runtime security principal not specified.");
        }
        User user = (User)this.users.getEntity(this.context.getUserName());
        if (user != null) {
            try {
                this.authenticate(user.getName().toString(), this.getRuntimeUserPassword());
            }
            catch (SecurityManagerException exception) {
                throw new SecurityManagerException(6084, "Invalid Runtime security principal or credential.", user.getName().toString());
            }
            if (!user.isMemberOf(ADMINS_GROUP)) {
                this.doAddUserToGroup(user, this.getGroup(ADMINS_GROUP));
                this.saveUsersAndGroups();
            }
            if (!user.isMemberOf(HTTP_GROUP)) {
                this.doAddUserToGroup(user, this.getGroup(HTTP_GROUP));
                this.saveUsersAndGroups();
            }
            if (!user.isSudoCapable()) {
                user.setSudoCapable(true);
                this.saveAll();
            }
            if (!user.isDropBoxOwner()) {
                user.setDropBoxOwner(true);
                this.saveAll();
            }
        } else {
            user = this.doCreateUser(this.context.getUserName(), this.getRuntimeUserPassword(), "Runtime user.", null);
            this.doAddUserToGroup(user, this.getGroup(ADMINS_GROUP));
            this.doAddUserToGroup(user, this.getGroup(HTTP_GROUP));
            user.setSudoCapable(true);
            user.setDropBoxOwner(true);
            this.saveAll();
        }
    }

    protected abstract String getRuntimeUserPassword();

    protected void completeInitialization() throws Exception {
        this.initVCardStore();
    }

    void initVCardStore() throws Exception {
        if (this.context.isPresenceEnabled()) {
            this.vCardStore = new VCardStore();
            if (!this.existsVCard("anonymous")) {
                this.createVCard((User)this.users.getEntity("anonymous"), new vCard());
            }
            if (!this.existsVCard(this.context.getUserName())) {
                this.createVCard((User)this.users.getEntity(this.context.getUserName()), new vCard());
            }
            if (this.updateDomain) {
                this.updateVCards(this.getOrganization(DOMAIN_ORGANIZATION));
            }
        }
    }

    protected void copyStore(String toPath) throws Exception {
        this.users.copy(toPath);
        this.groups.copy(toPath);
        this.organizations.copy(toPath);
    }

    protected synchronized void synchronize(Users newUsers, Groups newGroups, Organizations newOrganizations) {
        this.logDebug("Security store synchronization...");
        this.synchronize(this.users, newUsers);
        this.synchronize(this.groups, newGroups);
        this.synchronize(this.organizations, newOrganizations);
        this.saveAll();
        this.logInfo("Security store synchronized.");
    }

    private <TEntity extends AbstractEntity> void synchronize(AbstractEntityStore<TEntity> existingEntities, AbstractEntityStore<TEntity> newEntities) {
        ArrayList<CIString> obsoleteEntities = new ArrayList<CIString>();
        for (AbstractEntity existingEntity : existingEntities.values()) {
            TEntity newEntity = newEntities.removeEntity(existingEntity.getName());
            if (newEntity == null) {
                obsoleteEntities.add(existingEntity.getName());
                continue;
            }
            existingEntity.synchronize((AbstractEntity)newEntity);
        }
        existingEntities.removeEntities(obsoleteEntities);
        existingEntities.addEntities(newEntities);
        newEntities.doSetStore(existingEntities);
    }

    private void resolveSecurityContexts() {
        for (Map.Entry<CIString, SecurityContext> entry : this.securityContexts.entrySet()) {
            User user = (User)this.users.getEntity(entry.getKey());
            if (user == null) continue;
            user.setSecurityContext(entry.getValue());
        }
    }

    protected synchronized void synchronize(RowSet vCardTable, RowSet vCardPhotoTable) {
        if (this.vCardStore != null) {
            this.logDebug("vCard store synchronization...");
            try {
                this.vCardStore.setVCardTable(vCardTable);
                this.vCardStore.setVCardPhotoTable(vCardPhotoTable);
            }
            catch (SQLException exception) {
                Trace.logError(this, "vCard store synchronization failed. Cause: " + exception.getMessage());
            }
            this.logInfo("vCard store synchronized.");
        }
    }

    protected User authenticate(String userName, String credentials) throws SecurityManagerException {
        return this.authenticate(AuthenticationType.PASSWORD_PLAIN_TEXT, userName, credentials, null, null);
    }

    protected User authenticate(AuthenticationType type, String userName, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws SecurityManagerException {
        User user = (User)this.users.getEntity(userName);
        if (user == null && userName.equalsIgnoreCase(SYSADMIN_USER)) {
            user = this.sysadmin;
        }
        if (user == null) {
            AbstractSecurityManagerImpl.throwAuthenticationFailed("Authentication failed: invalid user name or password.", userName);
        }
        if (!user.getState().equals((Object)UserState.ENABLED)) {
            AbstractSecurityManagerImpl.throwAuthenticationFailed("User is Disabled. Please contact System Administrator.", userName);
        }
        if (!this.authenticationModule.authenticate(type, userName, user, credentials, parameters, calculator)) {
            AbstractSecurityManagerImpl.throwAuthenticationFailed("Authentication failed: invalid user name or password.", userName);
        }
        return user;
    }

    protected synchronized SecurityContext getSecurityContext(ComponentOwner owner) {
        return this.securityContexts.get(owner.getName());
    }

    protected synchronized void putSecurityContext(AbstractEntity owner, SecurityContext securityContext) {
        this.securityContexts.put(owner.getName(), securityContext);
    }

    protected synchronized void removeSecurityContext(AbstractEntity owner) {
        this.securityContexts.remove(owner.getName());
    }

    protected synchronized User createUser(User currentUser, String name, String password, String description, vCard vcard, UserState state) throws SecurityManagerException {
        this.checkRights(currentUser);
        this.checkFormat("User name", name);
        this.checkName(name);
        if (vcard != null) {
            this.checkVCardStore();
        }
        User result = this.doCreateUser(name, password, description, vcard);
        if (state != null) {
            result.setState(state);
        }
        this.saveAll();
        this.onUpdate(SecurityAdvisoryType.USER_CREATED, name, "User '" + name + "' created.");
        return result.clone();
    }

    protected User doCreateUser(String name, String password, String description, vCard vcard) throws SecurityManagerException {
        User result = (User)this.users.createEntity(name, password, description);
        this.doSetUserOrganization(result, this.getOrganization(DOMAIN_ORGANIZATION));
        this.doAddUserToGroup(result, this.getGroup(USERS_GROUP));
        this.doSetDefaultMnode(result);
        this.doSetAttribute(result, "creationTimestamp", Long.toString(System.currentTimeMillis()));
        if (this.vCardStore != null) {
            try {
                this.createVCard(result, vcard != null ? vcard : new vCard());
            }
            catch (DataspaceManagerException exception) {
                this.logException(exception);
                this.logError("Creation of vCard for user '" + name + "' failed.");
            }
        }
        return result;
    }

    protected void doSetAttribute(User user, String key, String value) {
        user.doSetAttribute(key, value);
    }

    protected abstract void doSetDefaultMnode(User var1);

    protected synchronized void doSetTimestamp(String userName, String attributeName, long timestamp) {
        User user = this.getUserNoCheck(userName);
        if (user != null) {
            this.doSetAttribute(user, attributeName, Long.toString(timestamp));
            this.saveUsers();
        }
    }

    protected static User makeUser(String name, String password, boolean isAdmin) {
        User result = new User(name, password, "");
        if (isAdmin) {
            result.addGroup(new CIString(ADMINS_GROUP));
        }
        return result;
    }

    protected synchronized void dropUser(User currentUser, String name, boolean checkActive) throws SecurityManagerException {
        this.checkCoreUser(name, "dropped");
        this.checkRights(currentUser);
        User user = (User)this.users.getEntity(name);
        if (user != null) {
            if (checkActive) {
                SecurityContext securityContext = this.getSecurityContext(user);
                if (securityContext != null || this.isUserActive(name)) {
                    AbstractSecurityManagerImpl.throwIllegalOperation("User '" + name + "' is active and cannot be dropped.", name);
                }
                this.checkThatNoDropBoxOwnedByUser(name);
            }
            this.users.removeEntity(user.getName());
            for (CIString groupName : user.groups) {
                this.getGroup(groupName).removeMember(user.getName());
            }
            this.getOrganization(user.getOrganization()).removeMember(user.getName());
            this.saveAll();
            if (this.vCardStore != null) {
                this.vCardStore.dropVCard(name);
            }
            this.onUpdate(SecurityAdvisoryType.USER_DROPPED, name, "User '" + name + "' dropped.");
        }
    }

    private void checkThatNoDropBoxOwnedByUser(String name) throws SecurityManagerException {
        List ownedDropBoxes = this.context.getDropBoxManagerRemote().getDropBoxes().stream().filter(dropboxItem -> dropboxItem.getOwner().equalsIgnoreCase(name)).map(DropBox::getName).collect(Collectors.toList());
        if (ownedDropBoxes.size() > 0) {
            AbstractSecurityManagerImpl.throwIllegalOperation("User '" + name + "' is owner of the following DropBox '" + String.valueOf(ownedDropBoxes) + "' and cannot be dropped.", name);
        }
    }

    protected synchronized void updateUser(User currentUser, User user) throws SecurityManagerException {
        this.checkCoreUser(user.getName().toString(), "changed");
        this.checkRights(currentUser, user);
        this.doUpdateUser(user);
    }

    protected void doUpdateUser(User user) throws SecurityManagerException {
        this.getUser(user.getName()).update(user);
        this.saveUsers();
        this.onUpdate(SecurityAdvisoryType.USER_UPDATED, user.getName().toString(), "User '" + String.valueOf(user.getName()) + "' updated.");
    }

    private void checkRights(User currentUser, User updatedUser) throws SecurityManagerException {
        if ((currentUser = this.checkRights(currentUser, updatedUser.getName().toString())) != null) {
            User existingUser = this.getUser(updatedUser.getName());
            if (updatedUser.sudoCapable != existingUser.sudoCapable) {
                if (!currentUser.sudoCapable) {
                    AbstractSecurityManagerImpl.throwInsufficientRights("User '" + String.valueOf(currentUser.getName()) + "' has insufficient rights for changing 'sudoCapable' parameter.");
                }
                if (updatedUser.sudoCapable && !existingUser.isAdministrator()) {
                    AbstractSecurityManagerImpl.throwIllegalOperation("User '" + String.valueOf(existingUser.getName()) + "' is not administrator and cannot be sudo capable.", existingUser.getName().toString());
                }
            }
        }
    }

    private User checkRights(User currentUser) throws SecurityManagerException {
        return this.checkRights(currentUser, false);
    }

    private User checkRights(User currentUser, String updatedUserName) throws SecurityManagerException {
        return this.checkRights(currentUser, updatedUserName, false);
    }

    private User checkRights(User currentUser, boolean checkSudoCapable) throws SecurityManagerException {
        return this.checkRights(currentUser, null, checkSudoCapable);
    }

    private User checkRights(User currentUser, String updatedUserName, boolean checkSudoCapable) throws SecurityManagerException {
        if (currentUser != null) {
            currentUser = this.getUser(currentUser.getName());
            if (updatedUserName != null) {
                if (!currentUser.getName().equals(updatedUserName) && !currentUser.isAdministrator()) {
                    AbstractSecurityManagerImpl.throwInsufficientRights("User '" + String.valueOf(currentUser.getName()) + "' has insufficient rights for this operation.");
                }
            } else if (!currentUser.isAdministrator() || checkSudoCapable && !currentUser.isSudoCapable()) {
                AbstractSecurityManagerImpl.throwInsufficientRights("User '" + String.valueOf(currentUser.getName()) + "' has insufficient rights for this operation.");
            }
            return currentUser;
        }
        return null;
    }

    protected User lookupUser(String name) {
        return this.lookupUser(name, true);
    }

    protected User lookupUser(String name, boolean withoutSysadmin) {
        User result = (User)this.users.lookupEntity(name);
        if (result == null && name.equalsIgnoreCase(SYSADMIN_USER) && !withoutSysadmin) {
            result = this.sysadmin.clone();
        }
        return result;
    }

    protected boolean existsUser(String name) {
        return this.users.existsEntity(name);
    }

    protected List<User> getUsers() {
        return this.users.getEntities();
    }

    protected List<String> listUsers() {
        return this.users.listEntities();
    }

    protected synchronized void addUserPermission(User currentUser, String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, true);
        this.doAddUserPermission(this.getUser(userName), operation);
    }

    void doAddUserPermission(User user, AccessControlOperation operation) throws SecurityManagerException {
        AccessControlList acl = this.doGetUserPermissions(user);
        if (acl.addOperation(operation)) {
            user.setAccessControlList(acl);
            this.doChangeUserPermission(user);
        }
    }

    protected synchronized void removeUserPermission(User currentUser, String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, true);
        this.doRemoveUserPermission(this.getUser(userName), operation);
    }

    void doRemoveUserPermission(User user, AccessControlOperation operation) throws SecurityManagerException {
        AccessControlList acl = this.doGetUserPermissions(user);
        if (acl.removeOperation(operation)) {
            user.setAccessControlList(acl);
            this.doChangeUserPermission(user);
        }
    }

    private void doChangeUserPermission(User user) throws SecurityManagerException {
        this.users.updateEntity(user);
        this.saveUsers();
        this.onUpdate(SecurityAdvisoryType.USER_PERMISSIONS_CHANGED, user.getName().toString(), "Permissions of user '" + String.valueOf(user.getName()) + "' changed.");
    }

    protected synchronized void resetUserPermissions(User currentUser, String userName) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, true);
        this.doResetUserPermission(this.getUser(userName));
    }

    void doResetUserPermission(User user) throws SecurityManagerException {
        if (user.accessControlList != null) {
            user.resetAccessControlList();
            this.doChangeUserPermission(user);
        }
    }

    protected synchronized AccessControlList getUserPermissions(User currentUser, String userName) throws SecurityManagerException {
        this.checkRights(currentUser, userName);
        return this.doGetUserPermissions(this.getUser(userName));
    }

    private AccessControlList doGetUserPermissions(User user) throws SecurityManagerException {
        AccessControlList result = user.accessControlList;
        if (result == null) {
            result = this.addInheritedPermissions(user);
        }
        return result;
    }

    private AccessControlList addInheritedPermissions(User user) throws SecurityManagerException {
        AccessControlList result = new AccessControlList();
        for (CIString groupName : user.groups) {
            result.copy(this.getGroup(groupName).getAccessControlList());
        }
        return result;
    }

    protected synchronized void enableUser(User currentUser, String name) throws SecurityManagerException {
        this.checkCoreUser(name, "enabled");
        this.checkRights(currentUser);
        User user = this.getUser(name);
        if (!user.getState().equals((Object)UserState.ENABLED)) {
            Pair<Boolean, Boolean> needSave = new Pair<Boolean, Boolean>(false, false);
            if (!this.validateUser(user, needSave)) {
                this.save(needSave);
                AbstractSecurityManagerImpl.throwException(6088, "User '" + name + "' cannot be enabled.");
            }
            this.setUserState(user, UserState.ENABLED);
            this.onUpdate(SecurityAdvisoryType.USER_ENABLED, name, "User '" + name + "' enabled.");
        }
    }

    private boolean validateUser(User user, Pair<Boolean, Boolean> needSave) {
        Organization organization;
        if (user.getOrganization() == null || (organization = (Organization)this.organizations.getEntity(user.getOrganization())) == null || !organization.isValid()) {
            if (user.getState() != UserState.DISABLED_INVALID_ORGANIZATION) {
                user.setState(UserState.DISABLED_INVALID_ORGANIZATION);
                needSave.first = true;
            }
            this.logError("User '" + String.valueOf(user.getName()) + "' is invalid: invalid organization '" + String.valueOf(user.getOrganization()) + "'.");
            return false;
        }
        this.repairOrganization(organization, "user", user.getName());
        if (user.getGroupsNumber() == 0) {
            if (user.getState() != UserState.DISABLED_INVALID_GROUP) {
                user.setState(UserState.DISABLED_INVALID_GROUP);
                needSave.first = true;
            }
            this.logError("User '" + String.valueOf(user.getName()) + "' is not a member of any group.");
            return false;
        }
        for (CIString groupName : user.groups) {
            Group group = (Group)this.groups.getEntity(groupName);
            if (group == null || !group.isValid()) {
                if (user.getState() != UserState.DISABLED_INVALID_GROUP) {
                    user.setState(UserState.DISABLED_INVALID_GROUP);
                    needSave.first = true;
                }
                this.logError("User '" + String.valueOf(user.getName()) + " is invalid: invalid group '" + String.valueOf(groupName) + "'.");
                return false;
            }
            if (group.hasMember(user.getName())) continue;
            this.logError("Inconsistency for user '" + String.valueOf(user.getName()) + "' and group '" + String.valueOf(group.getName()) + "'. Repair...");
            group.addMember(user.getName());
            needSave.second = true;
        }
        return true;
    }

    private void save(Pair<Boolean, Boolean> needSave) {
        if (((Boolean)needSave.first).booleanValue()) {
            this.saveUsers();
        }
        if (((Boolean)needSave.second).booleanValue()) {
            this.saveGroups();
        }
    }

    private void repairOrganization(Organization organization, String memberType, CIString memberName) {
        if (!organization.hasMember(memberName)) {
            this.logError("Inconsistency for " + memberType + " '" + String.valueOf(memberName) + "' and organization '" + String.valueOf(organization.getName()) + "'. Repair...");
            this.organizations.values().stream().filter(org -> org.hasMember(memberName)).forEach(org -> org.removeMember(memberName));
            organization.addMember(memberName);
            this.saveOrganizations();
        }
    }

    protected synchronized void disableUser(User currentUser, String name) throws SecurityManagerException {
        this.checkCoreUser(name, "disabled");
        this.checkRights(currentUser);
        this.setUserState(this.getUser(name), UserState.DISABLED);
        this.onUpdate(SecurityAdvisoryType.USER_DISABLED, name, "User '" + name + "' disabled.");
    }

    void setUserState(User user, UserState state) {
        user.setState(state);
        this.saveUsers();
    }

    protected synchronized vCard getVCard(User currentUser, String userName) throws SecurityManagerException {
        this.checkRights(currentUser, userName);
        return this.doGetVCard(this.getUser(userName));
    }

    vCard doGetVCard(User user) {
        return this.vCardStore != null ? this.vCardStore.getVCard(user.getName().toString()) : null;
    }

    protected synchronized void setVCard(User currentUser, String userName, vCard vcard) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, userName);
        this.checkVCardStore();
        User user = this.getUser(userName);
        try {
            if (!this.existsVCard(user.getName().toString())) {
                this.createVCard(user, vcard);
            } else {
                this.checkVCard(user, vcard);
                this.vCardStore.setVCard(userName, vcard, true);
            }
        }
        catch (DataspaceManagerException exception) {
            throw new SecurityManagerException(6100, (Throwable)exception, userName);
        }
        catch (SQLException exception) {
            throw new SecurityManagerException(6100, (Throwable)exception, userName);
        }
        this.onUpdate(SecurityAdvisoryType.USER_UPDATED, user.getName().toString(), "User '" + String.valueOf(user.getName()) + "' updated.");
    }

    private void checkVCardStore() throws SecurityManagerException {
        if (this.vCardStore == null) {
            AbstractSecurityManagerImpl.throwException(6101, "Profile (vCard) cannot be set. Cause: Presence is disabled.");
        }
    }

    private void createVCard(User user, vCard vcard) throws SecurityManagerException, DataspaceManagerException {
        this.setVCardOrganization(user, this.getOrganization(user.getOrganization()), vcard);
        this.vCardStore.createVCard(user.getName().toString(), vcard);
    }

    private void checkVCard(User user, vCard vcard) {
        if (vcard != null) {
            vcard.updateOrganization(user.getOrganization().toString());
        }
    }

    protected boolean existsVCard(String userName) {
        return this.vCardStore != null && this.vCardStore.existsVCard(userName);
    }

    protected synchronized Group createGroup(User currentUser, String name, String description) throws SecurityManagerException {
        this.checkRights(currentUser);
        this.checkFormat("Group name", name);
        this.checkName(name);
        Group result = this.doCreateGroup(name, description);
        this.saveGroupsAndOrganizations();
        this.onUpdate(SecurityAdvisoryType.GROUP_CREATED, name, "Group '" + name + "' created.");
        return result.clone();
    }

    Group doCreateGroup(String name, String description) throws SecurityManagerException {
        Group result = (Group)this.groups.createEntity(name, description);
        this.doSetGroupOrganization(result, this.getOrganization(DOMAIN_ORGANIZATION));
        return result;
    }

    protected synchronized void dropGroup(User currentUser, String name, boolean checkActive) throws SecurityManagerException {
        this.checkCoreGroup(name, "dropped");
        this.checkRights(currentUser);
        Group group = (Group)this.groups.getEntity(name);
        if (group != null) {
            SecurityContext securityContext;
            if (group.hasMembers()) {
                AbstractSecurityManagerImpl.throwIllegalOperation("Group '" + name + "' has members and cannot be dropped.", name);
            }
            if (checkActive && ((securityContext = this.getSecurityContext(group)) != null || this.isGroupActive(name))) {
                AbstractSecurityManagerImpl.throwIllegalOperation("Group '" + name + "' is active and cannot be dropped.", name);
            }
            this.groups.removeEntity(group.getName());
            this.getOrganization(group.getOrganization()).removeMember(group.getName());
            this.saveGroupsAndOrganizations();
            this.onUpdate(SecurityAdvisoryType.GROUP_DROPPED, name, "Group '" + name + "' dropped.");
        }
    }

    protected synchronized void updateGroup(User currentUser, Group group) throws SecurityManagerException {
        this.checkCoreGroup(group.getName().toString(), "changed");
        this.checkRights(currentUser);
        this.doUpdateGroup(group);
    }

    protected void doUpdateGroup(Group group) throws SecurityManagerException {
        this.getGroup(group.getName()).update(group);
        this.saveGroups();
        this.onUpdate(SecurityAdvisoryType.GROUP_UPDATED, group.getName().toString(), "Group '" + String.valueOf(group.getName()) + "' updated.");
    }

    protected Group lookupGroup(String name) {
        return (Group)this.groups.lookupEntity(name);
    }

    protected boolean existsGroup(String name) {
        return this.groups.existsEntity(name);
    }

    protected List<Group> getGroups() {
        return this.groups.getEntities();
    }

    protected List<String> listGroups() {
        return this.groups.listEntities();
    }

    protected synchronized void addGroupPermission(User currentUser, String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.checkRights(currentUser, true);
        this.doAddGroupPermission(this.getGroup(groupName), operation);
    }

    void doAddGroupPermission(Group group, AccessControlOperation operation) throws SecurityManagerException {
        group.addAccessControlOperation(operation);
        this.doChangeGroupPermission(group);
    }

    protected synchronized void removeGroupPermission(User currentUser, String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.checkRights(currentUser, true);
        this.doRemoveGroupPermission(this.getGroup(groupName), operation);
    }

    void doRemoveGroupPermission(Group group, AccessControlOperation operation) throws SecurityManagerException {
        group.removeAccessControlOperation(operation);
        this.doChangeGroupPermission(group);
    }

    void doChangeGroupPermission(Group group) throws SecurityManagerException {
        this.groups.updateEntity(group);
        this.saveGroups();
        this.onUpdate(SecurityAdvisoryType.GROUP_PERMISSIONS_CHANGED, group.getName().toString(), "Permissions of group '" + String.valueOf(group.getName()) + "' changed.");
    }

    protected AccessControlList getGroupPermissions(User currentUser, String groupName) throws SecurityManagerException {
        Group group = this.getGroup(groupName);
        if (currentUser != null && !currentUser.isAdministrator() && !group.hasMember(currentUser.getName())) {
            AbstractSecurityManagerImpl.throwInsufficientRights("User '" + String.valueOf(currentUser.getName()) + "' has insufficient rights for this operation.");
        }
        return group.getAccessControlList();
    }

    protected synchronized void addUserToGroup(User currentUser, String userName, String groupName) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, true);
        this.doAddUserToGroup(this.getUser(userName), this.getGroup(groupName));
        this.saveUsersAndGroups();
        this.onUpdate(SecurityAdvisoryType.USER_ADDED_TO_GROUP, userName, groupName, "User '" + userName + "' added to group '" + groupName + "'.");
    }

    void doAddUserToGroup(User user, Group group) {
        group.addMember(user.getName());
        user.addGroup(group.getName());
    }

    protected synchronized void removeUserFromGroup(User currentUser, String userName, String groupName) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, true);
        User user = this.getUser(userName);
        Group group = this.getGroup(groupName);
        if (!user.isMemberOf(groupName)) {
            AbstractSecurityManagerImpl.throwIllegalOperation("User '" + userName + "' is not a member of '" + groupName + "' group.", userName);
        }
        if (user.getGroupsNumber() <= 1) {
            AbstractSecurityManagerImpl.throwIllegalOperation("User must be a member of at least one group.", userName);
        }
        if (user.isSudoCapable() && groupName.equalsIgnoreCase(ADMINS_GROUP)) {
            AbstractSecurityManagerImpl.throwIllegalOperation("Sudo capable user cannot be removed from '" + groupName + "' group.", userName);
        }
        this.onRemoveUserFromGroup(user, group);
        group.removeMember(user.getName());
        user.removeGroup(group.getName());
        this.saveUsersAndGroups();
        this.onUpdate(SecurityAdvisoryType.USER_REMOVED_FROM_GROUP, userName, groupName, "User '" + userName + "' removed from group '" + groupName + "'.");
    }

    protected abstract void onRemoveUserFromGroup(User var1, Group var2);

    protected synchronized Organization createOrganization(User currentUser, String name, String description) throws SecurityManagerException {
        this.checkRights(currentUser);
        this.checkFormat("Organization name", name);
        this.checkName(name);
        Organization result = this.doCreateOrganization(name, description);
        this.saveOrganizations();
        this.onUpdate(SecurityAdvisoryType.ORGANIZATION_CREATED, name, "Organization '" + name + "' created.");
        return result.clone();
    }

    Organization doCreateOrganization(String name, String description) throws SecurityManagerException {
        Organization result = (Organization)this.organizations.createEntity(name, description);
        result.setDomain(this.context.getDomain());
        return result;
    }

    protected synchronized void dropOrganization(User currentUser, String name) throws SecurityManagerException {
        if (name.equalsIgnoreCase(DOMAIN_ORGANIZATION)) {
            AbstractSecurityManagerImpl.throwIllegalOperation("Organization '" + name + "' cannot be dropped.", name);
        }
        this.checkRights(currentUser);
        Organization droppedOrganization = (Organization)this.organizations.getEntity(name);
        if (droppedOrganization != null) {
            if (droppedOrganization.hasMembers()) {
                AbstractSecurityManagerImpl.throwIllegalOperation("Organization '" + name + "' has members and cannot be dropped.", name);
            }
            this.organizations.removeEntity(droppedOrganization.getName());
            this.saveOrganizations();
            this.onUpdate(SecurityAdvisoryType.ORGANIZATION_DROPPED, name, "Organization '" + name + "' dropped.");
        }
    }

    protected synchronized void updateOrganization(User currentUser, Organization organization) throws SecurityManagerException {
        this.checkRights(currentUser);
        this.doUpdateOrganization(organization);
    }

    protected void doUpdateOrganization(Organization organization) throws SecurityManagerException {
        this.getOrganization(organization.getName()).update(organization);
        this.saveOrganizations();
        this.onUpdate(SecurityAdvisoryType.ORGANIZATION_UPDATED, organization.getName().toString(), "Organization '" + String.valueOf(organization.getName()) + "' updated.");
    }

    protected Organization lookupOrganization(String name) {
        return (Organization)this.organizations.lookupEntity(name);
    }

    protected boolean existsOrganization(String name) {
        return this.organizations.existsEntity(name);
    }

    protected List<Organization> getOrganizations() {
        return this.organizations.getEntities();
    }

    protected List<String> listOrganizations() {
        return this.organizations.listEntities();
    }

    protected synchronized void setOrganizationDomain(User currentUser, String organizationName, String domain) throws SecurityManagerException {
        this.checkRights(currentUser);
        this.checkFormat("Domain name", domain);
        this.doSetOrganizationDomain(this.getOrganization(organizationName), domain);
        this.saveOrganizations();
        this.onUpdate(SecurityAdvisoryType.ORGANIZATION_SET_DOMAIN, organizationName, domain, "Domain '" + domain + "' set to organization '" + organizationName + "'.");
    }

    void doSetOrganizationDomain(Organization organization, String domain) throws SecurityManagerException {
        if (!organization.getDomain().equals(domain)) {
            if (organization.getName().equals(DOMAIN_ORGANIZATION)) {
                AbstractSecurityManagerImpl.throwIllegalOperation("Domain cannot be changed for organization '" + String.valueOf(organization.getName()) + "'.", organization.getName().toString());
            }
            organization.setDomain(domain);
            if (this.vCardStore != null) {
                this.updateVCards(organization);
            }
        }
    }

    void updateVCards(Organization organization) throws SecurityManagerException {
        for (CIString member : organization.members) {
            User user = (User)this.users.getEntity(member);
            if (user == null) continue;
            this.setVCardOrganization(user, organization);
        }
    }

    protected synchronized void setUserOrganization(User currentUser, String userName, String organizationName) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser);
        User user = this.getUser(userName);
        Organization organization = this.getOrganization(organizationName);
        if (!user.getOrganization().equals(organization.getName())) {
            this.getOrganization(user.getOrganization()).removeMember(user.getName());
            this.doSetUserOrganization(user, organization);
            if (this.vCardStore != null) {
                this.setVCardOrganization(user, organization);
            }
            this.saveUsersAndOrganizations();
            this.onUpdate(SecurityAdvisoryType.USER_SET_ORGANIZATION, userName, organizationName, "Organization '" + organizationName + "' set to user '" + userName + "'.");
        }
    }

    void doSetUserOrganization(User user, Organization organization) {
        user.setOrganization(organization.getName());
        organization.addMember(user.getName());
    }

    protected synchronized void setGroupOrganization(User currentUser, String groupName, String organizationName) throws SecurityManagerException {
        this.checkCoreGroup(groupName, "changed");
        this.checkRights(currentUser);
        Group group = this.getGroup(groupName);
        Organization organization = this.getOrganization(organizationName);
        if (!group.getOrganization().equals(organization.getName())) {
            this.getOrganization(group.getOrganization()).removeMember(group.getName());
            this.doSetGroupOrganization(this.getGroup(groupName), this.getOrganization(organizationName));
            this.saveGroupsAndOrganizations();
            this.onUpdate(SecurityAdvisoryType.GROUP_SET_ORGANIZATION, groupName, organizationName, "Organization '" + organizationName + "' set to group '" + groupName + "'.");
        }
    }

    void doSetGroupOrganization(Group group, Organization organization) {
        group.setOrganization(organization.getName());
        organization.addMember(group.getName());
    }

    protected synchronized String resetPassword(User currentUser, String userName) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser);
        String newPassword = AbstractSecurityManagerImpl.generatePassword();
        this.doSetPassword(this.getUser(userName), newPassword);
        return newPassword;
    }

    private static String generatePassword() {
        return IntStream.range(0, 8).mapToObj(i -> String.valueOf(LETTERS.get(new Random().nextInt(LETTERS.size())))).collect(Collectors.joining());
    }

    protected synchronized void changePassword(User currentUser, String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        this.checkCoreUser(userName, "changed");
        this.checkRights(currentUser, userName);
        User user = this.getUser(userName);
        if (!StringUtils.equalsNullSafe(user.password, AbstractSecurityManagerImpl.normalizePassword(oldPassword))) {
            AbstractSecurityManagerImpl.throwAuthenticationFailed("Authentication failed: invalid password.");
        }
        this.doSetPassword(user, newPassword);
    }

    protected void setPassword(String userName, String password) throws SecurityManagerException {
        this.doSetPassword(this.getUser(userName), password);
    }

    void doSetPassword(User user, String newPassword) throws SecurityManagerException {
        user.setPassword(newPassword);
        this.users.updateEntity(user);
        this.saveUsers();
        this.updateDeploymentDescriptor(user, newPassword);
        this.onUpdate(SecurityAdvisoryType.USER_PASSWORD_CHANGED, user.getName().toString(), "Password of user '" + String.valueOf(user.getName()) + "' changed.");
    }

    protected static String normalizePassword(String password) {
        return password != null && password.length() == 0 ? null : password;
    }

    private void updateDeploymentDescriptor(User user, String newPassword) {
        if (this.getRuntimeUser().getName().equals(user.getName())) {
            try {
                File ddxLocation = DeployUtils.getDdxLocation(this.context);
                CtxDeploymentDescriptor descriptor = DeployUtils.getDeploymentDescriptor(ddxLocation);
                descriptor.setSecurityCredentials(newPassword);
                StDeployGenerator.generate(ddxLocation, descriptor);
            }
            catch (Exception exception) {
                this.logException(exception);
                this.logError("Update password of Runtime user in Deployment Descriptor failed.");
            }
        }
    }

    protected synchronized List<ComponentReference> listBoundComponents(String ownerName, boolean inSysplex) throws SecurityManagerException {
        ComponentOwner owner = this.getComponentOwner(ownerName, true);
        ArrayList<ComponentReference> result = new ArrayList<ComponentReference>();
        SecurityContext securityContext = this.getSecurityContext(owner);
        if (securityContext != null) {
            result.addAll(securityContext.listBoundComponents());
        }
        if (inSysplex) {
            result.addAll(this.listRemoteBoundComponents(ownerName));
        }
        return result;
    }

    void checkCoreGroup(String groupName, String action) throws SecurityManagerException {
        if (groupName.equalsIgnoreCase(ADMINS_GROUP) || groupName.equalsIgnoreCase(USERS_GROUP) || groupName.equalsIgnoreCase(HTTP_GROUP) || groupName.equalsIgnoreCase(OPERATORS_GROUP)) {
            AbstractSecurityManagerImpl.throwIllegalOperation("Group '" + groupName + "' cannot be " + action + ".", groupName);
        }
    }

    void checkCoreUser(String userName, String action) throws SecurityManagerException {
        if (userName.equalsIgnoreCase("anonymous")) {
            AbstractSecurityManagerImpl.throwIllegalOperation("User '" + userName + "' cannot be " + action + ".", userName);
        }
    }

    private void checkName(String name) throws SecurityManagerException {
        String upperName = name.toUpperCase();
        for (String reservedName : RESERVED_NAMES) {
            if (!upperName.startsWith(reservedName)) continue;
            AbstractSecurityManagerImpl.throwException(6047, "Word '" + name + "' reserved for system purposes.", name);
        }
        CIString ciName = new CIString(name);
        if (this.users.existsEntity(ciName)) {
            this.users.throwAlreadyExists(name);
        }
        if (this.groups.existsEntity(name)) {
            this.groups.throwAlreadyExists(name);
        }
        if (this.organizations.existsEntity(name)) {
            this.organizations.throwAlreadyExists(name);
        }
    }

    protected User getUser(String name) throws SecurityManagerException {
        return this.doGetUser(name, (User)this.users.getEntity(name), true, true);
    }

    protected User getUser(CIString name) throws SecurityManagerException {
        return this.doGetUser(name.toString(), (User)this.users.getEntity(name), false, true);
    }

    protected User getUserNoCheck(String name) {
        return this.getUserNoCheck(name, false);
    }

    protected User getUserNoCheck(String name, boolean withoutSysadmin) {
        return this.doGetUser(name, (User)this.users.getEntity(name), withoutSysadmin);
    }

    private User doGetUser(String name, User user, boolean withoutSysadmin, boolean checkExistence) throws SecurityManagerException {
        if ((user = this.doGetUser(name, user, withoutSysadmin)) == null && checkExistence) {
            AbstractSecurityManagerImpl.throwException(6098, "User '" + name + "' does not exist.", name);
        }
        return user;
    }

    private User doGetUser(String name, User user, boolean withoutSysadmin) {
        if (user == null && !withoutSysadmin && name.equalsIgnoreCase(SYSADMIN_USER)) {
            user = this.sysadmin;
        }
        return user;
    }

    Group getGroup(String name) throws SecurityManagerException {
        return this.doGetGroup(name, (Group)this.groups.getEntity(name), true);
    }

    Group getGroup(CIString name) throws SecurityManagerException {
        return this.doGetGroup(name.toString(), (Group)this.groups.getEntity(name), true);
    }

    protected Group getGroupNoCheck(String name) {
        return (Group)this.groups.getEntity(name);
    }

    protected Group doGetGroup(String name, Group group, boolean checkExistence) throws SecurityManagerException {
        if (group == null && checkExistence) {
            AbstractSecurityManagerImpl.throwException(6090, "Group '" + name + "' does not exist.", name);
        }
        return group;
    }

    Organization getOrganization(String name) throws SecurityManagerException {
        return this.doGetOrganization(name, (Organization)this.organizations.getEntity(name));
    }

    Organization getOrganization(CIString name) throws SecurityManagerException {
        return this.doGetOrganization(name.toString(), (Organization)this.organizations.getEntity(name));
    }

    Organization doGetOrganization(String name, Organization organization) throws SecurityManagerException {
        if (organization == null) {
            AbstractSecurityManagerImpl.throwException(6094, "Organization '" + name + "' does not exist.", name);
        }
        return organization;
    }

    void setVCardOrganization(User user, Organization organization) {
        vCard vcard = this.doGetVCard(user);
        if (vcard != null) {
            this.setVCardOrganization(user, organization, vcard);
            try {
                this.vCardStore.setVCard(user.getName().toString(), vcard, false);
            }
            catch (Exception exception) {
                this.logException(exception);
                this.logError("Set organization to vCard for user '" + String.valueOf(user.getName()) + "' failed.");
            }
        }
    }

    void setVCardOrganization(User user, Organization organization, vCard vcard) {
        vcard.setJID(JIDParser.getJID(user.getName().toString(), organization.getDomain().toString()));
        vcard.updateOrganization(organization.getName().toString());
    }

    protected RowSet getVCardTable() {
        return this.vCardStore != null ? this.vCardStore.getVCardTable() : null;
    }

    protected RowSet getVCardPhotoTable() {
        return this.vCardStore != null ? this.vCardStore.getVCardPhotoTable() : null;
    }

    protected User getAnonymousUser() {
        return (User)this.users.getEntity("anonymous");
    }

    protected User getRuntimeUser() {
        return (User)this.users.getEntity(this.context.getUserName());
    }

    protected String createRuntimeUserDigest(String key) throws SecurityManagerException {
        return SHA1DigestCalculator.calculateDigest(this.context.getUserName(), key, this.getRuntimeUser().getPassword());
    }

    protected static User createAnonymousUser() {
        User result = new User("anonymous", "anonymous", "Anonymous user.");
        AbstractSecurityManagerImpl.setupAnonymousUser(result);
        return result;
    }

    private static void setupAnonymousUser(User user) {
        user.clearAccessControlList();
        user.addAccessControlOperation(AccessControlOperation.DATASPACE_USE);
        user.addAccessControlOperation(AccessControlOperation.SERVICE_USE);
        user.addAccessControlOperation(AccessControlOperation.SERVICE_ACCESS);
    }

    protected ComponentOwner getComponentOwner(String name, boolean withoutSysadmin) throws SecurityManagerException {
        AbstractEntity result = this.getUserNoCheck(name, withoutSysadmin);
        if (result == null) {
            result = this.getGroupNoCheck(name);
        }
        if (result == null) {
            AbstractSecurityManagerImpl.throwException(6132, "Owner '" + name + "' does not exist.");
        }
        return result;
    }

    void checkFormat(String type, String value) throws SecurityManagerException {
        if (!StringUtils.validateObjectName(value)) {
            AbstractSecurityManagerImpl.throwException(6006, type + " '" + value + "' has invalid format.");
        }
    }

    void saveUsers() {
        this.users.save();
    }

    void saveGroups() {
        this.groups.save();
    }

    void saveOrganizations() {
        this.organizations.save();
    }

    void saveUsersAndGroups() {
        this.users.save();
        this.groups.save();
    }

    void saveUsersAndOrganizations() {
        this.users.save();
        this.organizations.save();
    }

    void saveGroupsAndOrganizations() {
        this.groups.save();
        this.organizations.save();
    }

    void saveAll() {
        this.users.save();
        this.groups.save();
        this.organizations.save();
    }

    void onUpdate(SecurityAdvisoryType advisoryType, String advisoryEntity, String traceMessage) {
        this.onUpdate(new SecurityAdvisory(advisoryType, advisoryEntity));
        this.logDebug(traceMessage);
    }

    void onUpdate(SecurityAdvisoryType advisoryType, String advisoryEntity, String advisoryInfo, String traceMessage) {
        this.onUpdate(new SecurityAdvisory(advisoryType, advisoryEntity, advisoryInfo));
        this.logDebug(traceMessage);
    }

    protected abstract void onUpdate(SecurityAdvisory var1);

    protected abstract boolean isUserActive(String var1);

    protected abstract boolean isGroupActive(String var1);

    protected abstract List<ComponentReference> listRemoteBoundComponents(String var1);

    protected void logError(String message) {
        Trace.logError(this, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }

    protected static void throwException(int errorCode, String message) throws SecurityManagerException {
        throw new SecurityManagerException(errorCode, message);
    }

    protected static void throwException(int errorCode, String message, String entity) throws SecurityManagerException {
        throw new SecurityManagerException(errorCode, message, entity);
    }

    protected static void throwIllegalOperation(String message, String entity) throws SecurityManagerException {
        AbstractSecurityManagerImpl.throwException(6091, message, entity);
    }

    protected static void throwAuthenticationFailed(String message) throws SecurityManagerException {
        AbstractSecurityManagerImpl.throwException(6084, message);
    }

    protected static void throwAuthenticationFailed(String message, String userName) throws SecurityManagerException {
        AbstractSecurityManagerImpl.throwException(6084, message, userName);
    }

    protected static void throwInsufficientRights(String message) throws SecurityManagerException {
        AbstractSecurityManagerImpl.throwException(6092, message);
    }

    static {
        for (char c = 'A'; c <= 'z'; c = (char)(c + '\u0001')) {
            LETTERS.add(Character.valueOf(c));
        }
        RESERVED_NAMES = new HashSet<String>();
        RESERVED_NAMES.add("anonymous".toUpperCase());
        RESERVED_NAMES.add(SYSADMIN_USER.toUpperCase());
        RESERVED_NAMES.add(ADMINS_GROUP.toUpperCase());
        RESERVED_NAMES.add(USERS_GROUP.toUpperCase());
        RESERVED_NAMES.add(DOMAIN_ORGANIZATION.toUpperCase());
        RESERVED_NAMES.add("Quilt".toUpperCase());
    }
}

