/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CIString;
import com.streamscape.repository.cache.SystemTableFile;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.sef.security.AbstractEntity;
import com.streamscape.sef.security.SecurityManagerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractEntityStore<TEntity extends AbstractEntity>
extends SystemTableFile<Map<CIString, TEntity>> {
    AbstractEntityStore(String name, String fileName, ArtifactState recreatedState) {
        super(name, fileName, recreatedState);
        this.createStore();
    }

    TEntity createEntity(String name, String ... parameters) {
        TEntity result = this.createEntityInstance(name, parameters);
        ((Map)this.store).put(((AbstractEntity)result).getName(), result);
        return result;
    }

    TEntity createEntityWithoutCheck(String name, String ... parameters) {
        TEntity result = this.createEntityInstance(name, parameters);
        ((Map)this.store).put(((AbstractEntity)result).getName(), result);
        return result;
    }

    abstract void throwAlreadyExists(String var1) throws SecurityManagerException;

    abstract TEntity createEntityInstance(String var1, String ... var2);

    TEntity dropEntity(String name) {
        return (TEntity)((AbstractEntity)((Map)this.store).remove(new CIString(name)));
    }

    void updateEntity(TEntity entity) throws SecurityManagerException {
        if (!((Map)this.store).containsKey(((AbstractEntity)entity).getName())) {
            this.throwDoesNotExist(((AbstractEntity)entity).getName());
        }
        ((Map)this.store).put(((AbstractEntity)entity).getName(), entity);
    }

    void updateEntityWithoutCheck(TEntity entity) {
        ((Map)this.store).put(((AbstractEntity)entity).getName(), entity);
    }

    TEntity removeEntity(CIString name) {
        return (TEntity)((AbstractEntity)((Map)this.store).remove(name));
    }

    TEntity removeEntity(String name) {
        return this.removeEntity(new CIString(name));
    }

    void addEntities(AbstractEntityStore<TEntity> from) {
        ((Map)this.store).putAll((Map)from.store);
    }

    void removeEntities(List<CIString> names) {
        ((Map)this.store).keySet().removeAll(names);
    }

    abstract void throwDoesNotExist(CIString var1) throws SecurityManagerException;

    TEntity getEntity(String name) {
        return this.getEntity(new CIString(name));
    }

    TEntity getEntity(CIString name) {
        return (TEntity)((AbstractEntity)((Map)this.store).get(name));
    }

    synchronized TEntity lookupEntity(String name) {
        TEntity result = this.getEntity(name);
        return (TEntity)(result != null ? (AbstractEntity)((CloneableDataObject)result).clone() : null);
    }

    boolean existsEntity(String name) {
        return this.existsEntity(new CIString(name));
    }

    synchronized boolean existsEntity(CIString name) {
        return ((Map)this.store).containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TEntity> getEntities() {
        ArrayList result;
        AbstractEntityStore abstractEntityStore = this;
        synchronized (abstractEntityStore) {
            result = new ArrayList(((Map)this.store).values());
        }
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, (AbstractEntity)((AbstractEntity)result.get(i)).clone());
        }
        return result;
    }

    synchronized List<String> listEntities() {
        return ((Map)this.store).keySet().stream().map(CIString::toString).sorted().collect(Collectors.toList());
    }

    Set<CIString> keySet() {
        return ((Map)this.store).keySet();
    }

    Collection<TEntity> values() {
        return ((Map)this.store).values();
    }

    int size() {
        return ((Map)this.store).size();
    }

    boolean isEmpty() {
        return ((Map)this.store).isEmpty();
    }

    @Override
    protected void recreate() {
        super.recreate();
    }

    @Override
    protected void createStore() {
        this.store = new HashMap();
    }

    void setStore(AbstractEntityStore<TEntity> from) {
        this.doSetStore(from);
        this.save();
    }

    void doSetStore(AbstractEntityStore<TEntity> from) {
        this.store = from.store;
    }

    @Override
    protected synchronized Map<CIString, TEntity> cloneStore() {
        HashMap<CIString, AbstractEntity> result = new HashMap<CIString, AbstractEntity>();
        for (Map.Entry entry : ((Map)this.store).entrySet()) {
            result.put((CIString)entry.getKey(), (AbstractEntity)((AbstractEntity)entry.getValue()).clone());
        }
        return result;
    }

    @Override
    protected void copy(String toPath) throws Exception {
        super.copy(toPath);
    }
}

