/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.lib.utils.CIString;
import com.streamscape.sef.security.AbstractEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractComplexEntity
extends AbstractEntity {
    HashSet<CIString> members = new HashSet();
    boolean valid = true;

    AbstractComplexEntity(String name, String description) {
        super(name, description);
    }

    boolean addMember(CIString memberName) {
        return this.members.add(memberName);
    }

    boolean removeMember(CIString memberName) {
        return this.members.remove(memberName);
    }

    boolean removeMember(String memberName) {
        return this.removeMember(new CIString(memberName));
    }

    boolean hasMember(String memberName) {
        return this.hasMember(new CIString(memberName));
    }

    boolean hasMember(CIString memberName) {
        return this.members.contains(memberName);
    }

    boolean hasMembers() {
        return !this.members.isEmpty();
    }

    Set<CIString> getMembers() {
        return new HashSet<CIString>(this.members);
    }

    List<String> listMembers() {
        return this.members.stream().map(CIString::toString).sorted().collect(Collectors.toList());
    }

    boolean isValid() {
        return this.valid;
    }

    void setValid() {
        this.valid = true;
    }

    void setInvalid() {
        this.valid = false;
    }

    @Override
    void synchronize(AbstractEntity from) {
        super.synchronize(from);
        this.members = ((AbstractComplexEntity)from).members;
        this.valid = ((AbstractComplexEntity)from).valid;
    }

    @Override
    public AbstractComplexEntity clone() {
        AbstractComplexEntity result = (AbstractComplexEntity)super.clone();
        result.members = this.members != null ? (HashSet)this.members.clone() : null;
        return result;
    }
}

