/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.security;

import com.streamscape.sef.mf.admin.module.AbstractModule;
import com.streamscape.sef.security.AuthenticationModule;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.Map;

public abstract class AbstractAuthenticationModule
extends AbstractModule
implements AuthenticationModule {
    @Override
    public boolean authenticate(AuthenticationType type, String userName, User user, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws SecurityManagerException {
        switch (type) {
            case USER_ONLY: {
                return this.authenticateUserOnly(user);
            }
            case PASSWORD_PLAIN_TEXT: {
                return this.authenticatePasswordPlainText(user, credentials);
            }
            case DIGEST: {
                return this.authenticateDigest(userName, user, credentials, parameters, calculator);
            }
            case CREDENTIALS_WITH_KEY: {
                return this.authenticateCredentialsWithKey(user, credentials, parameters);
            }
            case CREDENTIALS_WITH_KEYSTORE: {
                return this.authenticateCredentialsWithKeystore(user, credentials, parameters);
            }
        }
        throw new RuntimeException("Invalid AuthenticationType!");
    }

    protected boolean authenticateUserOnly(User user) throws SecurityManagerException {
        throw AbstractAuthenticationModule.createException(AuthenticationType.USER_ONLY);
    }

    protected boolean authenticatePasswordPlainText(User user, String credentials) throws SecurityManagerException {
        throw AbstractAuthenticationModule.createException(AuthenticationType.PASSWORD_PLAIN_TEXT);
    }

    protected boolean authenticateDigest(String userName, User user, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws SecurityManagerException {
        throw AbstractAuthenticationModule.createException(AuthenticationType.DIGEST);
    }

    protected boolean authenticateCredentialsWithKey(User user, String credentials, Map<String, String> parameters) throws SecurityManagerException {
        throw AbstractAuthenticationModule.createException(AuthenticationType.CREDENTIALS_WITH_KEY);
    }

    protected boolean authenticateCredentialsWithKeystore(User user, String credentials, Map<String, String> parameters) throws SecurityManagerException {
        throw AbstractAuthenticationModule.createException(AuthenticationType.CREDENTIALS_WITH_KEYSTORE);
    }

    private static SecurityManagerException createException(AuthenticationType type) {
        return new SecurityManagerException(6085, "Authentication type '" + String.valueOf((Object)type) + "' is not supported.");
    }
}

