/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.sef.scheduler.AbstractExecution;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.SchedulerCompletionEvent;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class TaskListExecution
extends AbstractExecution {
    private transient TaskList taskList;
    private UUID eid;
    private String owner;
    private ExecutionMode executionMode;
    private String jobName;
    private Long taskListWindow;
    private TimeUnit taskListWindowUnit;
    private Boolean autoComplete;
    private Boolean unordered;
    private Boolean transacted;
    private Date untilTime;
    private String metasetName;
    private Map<String, Object> beforeMetasetValues;
    private Map<String, Object> afterMetasetValues;
    private SchedulerCompletionEvent completionEvent;
    private List<TaskExecution> taskExecutions = new ArrayList<TaskExecution>();
    private TaskListState state;
    private boolean isCompleted = false;
    private String errorMessage;
    private int errorCode;
    private transient List<TaskExecution> executedTasks = new ArrayList<TaskExecution>();
    private transient Map<String, TaskExecution> pendingTasks = new LinkedHashMap<String, TaskExecution>();

    TaskListExecution(TaskList taskList, String owner, ExecutionMode executionMode, Date startTime) {
        this.doSetStartTime(startTime);
        this.taskList = taskList;
        this.eid = UUID.randomUUID();
        this.owner = owner;
        this.executionMode = executionMode;
        this.taskListWindow = taskList.getTaskListWindow();
        this.taskListWindowUnit = taskList.getTaskListWindowUnit();
        this.autoComplete = taskList.isAutoComplete();
        this.unordered = taskList.isUnordered();
        this.transacted = taskList.isTransacted();
        this.untilTime = taskList.getExpirationDate();
        if (executionMode == ExecutionMode.SCHEDULED && taskList.hasJob()) {
            this.jobName = taskList.getJobName();
        }
        if (taskList.executionMetaset != null) {
            this.metasetName = taskList.executionMetaset.getName();
            this.beforeMetasetValues = taskList.executionMetaset.getValues();
        }
    }

    void init(TaskList taskList) {
        this.taskList = taskList;
    }

    TaskListExecution init() {
        this.taskExecutions.forEach(task -> task.init(this));
        return this;
    }

    void initOnLoad(OldFormatVersion oldFormatVersion) {
        if (oldFormatVersion == OldFormatVersion.FORMAT_2024_1) {
            this.transacted = false;
        }
        this.taskExecutions.forEach(task -> task.initOnLoad(oldFormatVersion));
    }

    public UUID getEID() {
        return this.eid;
    }

    public String getCaller() {
        return this.owner;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public String getJobName() {
        return this.jobName;
    }

    void setEndTime() {
        this.doSetEndTime();
        this.update();
    }

    public String getMetasetName() {
        return this.metasetName;
    }

    public Map<String, Object> getBeforeMetasetValues() {
        return this.beforeMetasetValues;
    }

    Map<String, Object> doGetBeforeMetasetValues() {
        return this.beforeMetasetValues != null ? new HashMap<String, Object>(this.beforeMetasetValues) : null;
    }

    public Map<String, Object> getAfterMetasetValues() {
        return this.afterMetasetValues != null ? new HashMap<String, Object>(this.afterMetasetValues) : null;
    }

    Map<String, Object> doGetAfterMetasetValues() {
        return this.afterMetasetValues;
    }

    SchedulerCompletionEvent getCompletionEvent() {
        return this.completionEvent;
    }

    public TaskExecution getTaskExecution(String taskName) {
        return this.taskExecutions.stream().filter(execution -> execution.getTaskName().equals(taskName)).findFirst().orElse(null);
    }

    public List<TaskExecution> getTaskExecutions() {
        return new ArrayList<TaskExecution>(this.taskExecutions);
    }

    public List<TaskState> getTaskStates() {
        return this.taskExecutions.stream().map(execution -> {
            if (execution.getCompletionState() == TaskState.EXPIRED_INCOMPLETE || execution.getCompletionState() == TaskState.INTERRUPTED_INCOMPLETE) {
                return execution.getCompletionState();
            }
            return execution.getState() != null ? execution.getState() : execution.getCompletionState();
        }).collect(Collectors.toList());
    }

    public double getTotalProgress() {
        return this.taskExecutions.stream().filter(exec -> exec.getState() == TaskState.EXECUTION_COMPLETED || exec.getState() == TaskState.CONDITIONAL || exec.getCompletionState() == TaskState.COMPLETED && exec.getState() != TaskState.PENDING).mapToDouble(TaskExecution::getWeight).sum();
    }

    double getNormalizedWeight() {
        return TaskList.doGetNormalizedWeight(this.taskExecutions.size());
    }

    void addPendingTask(AbstractTask task, TaskState state) {
        TaskExecution execution = new TaskExecution(this, task, task.getState(state));
        if (!this.autoComplete.booleanValue()) {
            execution.doSetCompletionState(state);
        }
        this.pendingTasks.put(execution.getTaskName(), execution);
    }

    List<String> listPendingTasks() {
        return new ArrayList<String>(this.pendingTasks.keySet());
    }

    void addExecutedTask(TaskExecution execution) {
        this.pendingTasks.remove(execution.getTaskName());
        this.doAddExecutedTask(execution);
    }

    List<String> listExecutedTasks() {
        return this.executedTasks.stream().map(TaskExecution::getTaskName).collect(Collectors.toList());
    }

    void addExceptionTask(AbstractTask task, Date startTime) {
        TaskExecution execution = new TaskExecution(this, task, task.getRunningState());
        execution.doSetStartTime(startTime);
        this.doAddExecutedTask(execution);
    }

    private void doAddExecutedTask(TaskExecution execution) {
        if (execution.isNeverUndone()) {
            this.executedTasks.add(execution);
            this.adjustTaskExecutions();
        }
    }

    void adjustTaskExecutions() {
        ArrayList<TaskExecution> newTaskExecutions = new ArrayList<TaskExecution>();
        newTaskExecutions.addAll(this.executedTasks);
        newTaskExecutions.addAll(this.pendingTasks.values());
        this.taskExecutions = newTaskExecutions;
    }

    public Long getTaskListWindow() {
        return this.taskListWindow;
    }

    public TimeUnit getTaskListWindowUnit() {
        return this.taskListWindowUnit;
    }

    public Boolean isAutoComplete() {
        return this.autoComplete;
    }

    public Boolean isUnordered() {
        return this.unordered;
    }

    public Boolean isTransacted() {
        return this.transacted;
    }

    public Date getUntilTime() {
        return this.untilTime;
    }

    public TaskListState getState() {
        return this.state;
    }

    void doSetState(TaskListState state) {
        this.state = state;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    void complete(TaskListState state) {
        this.doSetEndTime();
        this.setCompleted(state);
    }

    void interruptCompletion(TaskList taskList) {
        if (!this.isCompleted) {
            this.taskList = taskList;
            this.taskExecutions.forEach(execution -> {
                if (execution.getState() == TaskState.RUNNING || execution.getState() == TaskState.WAITING_ACK) {
                    execution.doSetState(TaskState.EXECUTION_INTERRUPTED);
                    execution.doSetErrorMessage("Probably, the node was forcibly stopped (or crashed).");
                } else if (execution.getCompletionState() == TaskState.WAITING_COMPLETION) {
                    execution.doSetCompletionState(TaskState.INTERRUPTED_INCOMPLETE);
                    execution.doSetErrorMessage("Probably, the node was forcibly stopped (or crashed).");
                } else if (execution.getState() == TaskState.PENDING) {
                    execution.doSetState(TaskState.SKIPPED);
                    execution.doSetErrorMessage("Probably, the node was forcibly stopped (or crashed).");
                } else if (execution.getCompletionState() == TaskState.PENDING) {
                    execution.doSetCompletionState(TaskState.SKIPPED);
                    execution.doSetErrorMessage("Probably, the node was forcibly stopped (or crashed).");
                }
            });
            this.setCompleted(TaskListState.INTERRUPTED);
        }
    }

    private void setCompleted(TaskListState state) {
        this.doSetState(state);
        this.setAfterMetasetValues();
        this.isCompleted = true;
        this.update();
    }

    void setAfterMetasetValues() {
        if (this.taskList.executionMetaset != null) {
            this.afterMetasetValues = this.taskList.executionMetaset.getValues();
        }
    }

    void setCompletionEvent(SchedulerCompletionEvent completionEvent) {
        this.doSetCompletionEvent((SchedulerCompletionEvent)completionEvent.clone());
        this.update();
    }

    void resetCompletionEvent() {
        if (this.completionEvent != null) {
            this.doSetCompletionEvent(null);
            this.update();
        }
    }

    void doSetCompletionEvent(SchedulerCompletionEvent completionEvent) {
        this.completionEvent = completionEvent;
    }

    Set<String> resumeUnordered() {
        this.executedTasks = new ArrayList<TaskExecution>();
        this.pendingTasks = new LinkedHashMap<String, TaskExecution>();
        HashSet<String> runningTasks = new HashSet<String>();
        for (TaskExecution taskExecution : this.taskExecutions) {
            this.executedTasks.add(taskExecution);
            if (taskExecution.getCompletionState() != TaskState.WAITING_COMPLETION && taskExecution.getState() != TaskState.PENDING && taskExecution.getState() != TaskState.RUNNING && taskExecution.getState() != TaskState.WAITING_ACK) continue;
            runningTasks.add(taskExecution.getTaskName());
        }
        return runningTasks;
    }

    void setFailed(String errorMessage, int errorCode) {
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.setCompleted(TaskListState.FAILED);
    }

    void reset() {
        this.taskList.resetTaskExecutions();
    }

    void update() {
        this.taskList.updateExecution(this);
    }

    @Override
    public TaskListExecution clone() {
        TaskListExecution result = (TaskListExecution)super.clone();
        result.taskExecutions = this.doCloneTaskExecutions(this.taskExecutions);
        return result;
    }

    private List<TaskExecution> doCloneTaskExecutions(List<TaskExecution> executions) {
        return executions != null ? executions.stream().map(TaskExecution::clone).collect(Collectors.toList()) : null;
    }

    public boolean matchesTaskCondition(SelectorExpression condition) {
        return this.taskExecutions.stream().anyMatch(taskExecution -> taskExecution.matchesCondition(condition));
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TaskListExecution && Utils.equalsNullSafe(this.eid, ((TaskListExecution)other).eid);
    }

    public String toString() {
        return String.valueOf(this.getEID()) + "(caller=" + this.owner + ", tasks(" + String.valueOf(this.taskExecutions) + ")";
    }
}

