/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.mf.operation.scheduler.tasklist.DescribeTaskListOperation;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.dispatcher.DataspaceAccessorProviderForTaskList;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.scheduler.AbstractExecutableObject;
import com.streamscape.sef.scheduler.AbstractJob;
import com.streamscape.sef.scheduler.AbstractSchedulerObject;
import com.streamscape.sef.scheduler.AbstractSchedulerOperation;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.CompletionState;
import com.streamscape.sef.scheduler.EventTask;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.ExecutableObject;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.Rule;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.SchedulerAdvisoryType;
import com.streamscape.sef.scheduler.SchedulerCompletionEvent;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class TaskList
extends AbstractExecutableObject
implements ExecutableObject {
    public static final String MODEL_TAG = "model@";
    public static final String MODEL_IMPORT_TAG = "modelImport@";
    private Long retentionInterval = -1L;
    private TimeUnit retentionIntervalUnit = TimeUnit.SECONDS;
    private long taskDelay = 0L;
    private EventScope eventScope = EventScope.GLOBAL;
    private UUID metasetId;
    transient Metaset metaset;
    private List<AbstractTask> tasks = new ArrayList<AbstractTask>();
    private List<AbstractTask> exceptionTasks = new ArrayList<AbstractTask>();
    private AbstractTask exceptionTask;
    private Boolean model = false;
    private Boolean unordered = false;
    private Boolean transacted = false;
    private Long taskListWindow = -1L;
    private TimeUnit taskListWindowUnit = TimeUnit.SECONDS;
    private volatile TaskListState state = TaskListState.DISABLED;
    transient AbstractJob job;
    transient boolean isScheduled;
    transient String currentUser;
    transient ExecNode execNode;
    transient List<AbstractTask> skippedTasks;
    transient TaskListExecution execution;
    transient Metaset executionMetaset;
    transient AbstractTask executedTask;
    transient Throwable lastException;
    volatile transient boolean isInterrupted;
    volatile transient boolean isSleeping;
    volatile transient boolean expiresImmediately;
    transient EventReceiver completionEventReceiver;
    transient SchedulerCompletionEvent completionEvent;
    transient long taskListWindowMsec;
    transient long remainingTimeMsec;
    transient LongNumberAllocatorSimple taskNamesAllocator;
    transient DataspaceAccessorProviderForTaskList dataspaceAccessorProvider;
    private static final Predicate<AbstractTask> REGULAR_TASK_FILTER = task -> task.getType() != TaskType.EXCEPTION;
    private static final Predicate<AbstractTask> EXCEPTION_TASK_FILTER = task -> task.getType() == TaskType.EXCEPTION;
    private static final Predicate<AbstractTask> ALL_TASK_FILTER = task -> true;
    private static final RowMetaData TASK_ORDER_LIST_DESCRIPTOR = AbstractDSLOperation.createResultDescriptor("seq", "name");
    private static final String DESCRIBE_TASKLIST = "describe tasklist";
    private static final String DESCRIBE_EXEC_COMMAND = "describe tasklist %s exec %s";
    public static final String METASET_START = "$metaset:{";
    public static final String METASET_END = "}";

    TaskList(String name, String author) {
        super(name, author);
        this.setCurrentUser(author);
    }

    TaskList(String name, TaskList sourceList, boolean asModel, String owner) {
        super(name, sourceList, owner);
        this.setCurrentUser(owner);
        HashMap<UUID, UUID> taskIdMap = new HashMap<UUID, UUID>();
        this.copyFields(sourceList, this.taskCopier(this.tasks, owner, taskIdMap), this.taskCopier(this.exceptionTasks, owner, taskIdMap));
        this.copyTaskLinks(sourceList, this.tasks, taskIdMap);
        this.copyTaskLinks(sourceList, this.exceptionTasks, taskIdMap);
        if (sourceList.isModel().booleanValue() && !asModel) {
            this.doAddTag(MODEL_TAG + sourceList.getName());
            this.doSetModel(false);
        }
        this.state = TaskListState.DISABLED;
    }

    private Consumer<AbstractTask> taskCopier(List<AbstractTask> tasks, String owner, Map<UUID, UUID> taskIdMap) {
        return task -> tasks.add(task.copy(owner, taskIdMap));
    }

    private void copyTaskLinks(TaskList sourceList, List<AbstractTask> tasks, Map<UUID, UUID> taskIdMap) {
        tasks.forEach(task -> task.copyLinks(sourceList, taskIdMap));
    }

    TaskList(TaskList other, String currentUser) {
        super(other);
        this.setCurrentUser(currentUser);
        this.copyFields(other, this.taskCopier(this.tasks), this.taskCopier(this.exceptionTasks));
        this.state = other.state;
        this.job = other.job;
        this.isScheduled = other.isScheduled;
        this.execNode = other.execNode;
        this.skippedTasks = other.skippedTasks;
        this.execution = other.execution;
        this.executionMetaset = other.executionMetaset;
        this.executedTask = other.executedTask;
        this.lastException = other.lastException;
        this.isInterrupted = other.isInterrupted;
        this.isSleeping = other.isSleeping;
        this.expiresImmediately = other.expiresImmediately;
        this.taskListWindowMsec = other.taskListWindowMsec;
        this.remainingTimeMsec = other.remainingTimeMsec;
        this.completionEventReceiver = other.completionEventReceiver;
        this.completionEvent = other.completionEvent;
        this.taskNamesAllocator = other.taskNamesAllocator != null ? other.taskNamesAllocator.clone() : null;
        this.dataspaceAccessorProvider = other.dataspaceAccessorProvider;
    }

    protected void update(TaskList other) throws SchedulerException {
        super.update(other);
        this.checkTaskNamesUniqueness(other.tasks);
        this.copyFields(other, this.taskCopier(this.tasks), this.taskCopier(this.exceptionTasks));
    }

    private void checkTaskNamesUniqueness(List<AbstractTask> tasks) throws SchedulerException {
        HashSet<String> names = new HashSet<String>();
        for (AbstractTask task : tasks) {
            if (names.contains(task.getName())) {
                throw new SchedulerException(6146, "Task " + TaskList.toLogName(task) + " already exists.");
            }
            names.add(task.getName());
        }
    }

    private void copyFields(TaskList other, Consumer<AbstractTask> taskCopier, Consumer<AbstractTask> exceptionTaskCopier) {
        this.retentionInterval = other.retentionInterval;
        this.retentionIntervalUnit = other.retentionIntervalUnit;
        this.taskDelay = other.taskDelay;
        this.metasetId = other.metasetId;
        this.metaset = other.metaset;
        this.eventScope = other.eventScope;
        this.model = other.model;
        this.unordered = other.unordered;
        this.transacted = other.transacted;
        this.taskListWindow = other.taskListWindow;
        this.taskListWindowUnit = other.taskListWindowUnit;
        this.copyTasks(this.tasks, other.tasks, taskCopier);
        this.copyTasks(this.exceptionTasks, other.exceptionTasks, exceptionTaskCopier);
        this.exceptionTask = other.exceptionTask != null ? other.exceptionTask.copy() : null;
        this.initTasks();
    }

    private Consumer<AbstractTask> taskCopier(List<AbstractTask> tasks) {
        return task -> tasks.add(task.copy());
    }

    private void copyTasks(List<AbstractTask> tasks, List<AbstractTask> otherTasks, Consumer<AbstractTask> taskCopier) {
        tasks.clear();
        CollectionUtils.emptyIfNull(otherTasks).forEach(taskCopier);
    }

    @Override
    protected void init(SchedulerImpl scheduler) {
        super.init(scheduler);
        this.initTasks();
        this.taskNamesAllocator = new LongNumberAllocatorSimple();
        this.setCurrentUser(this.getOwner());
    }

    private void initTasks() {
        this.tasks.forEach(task -> task.init(this));
        this.exceptionTasks.forEach(task -> task.init(this));
        if (this.exceptionTask != null) {
            this.exceptionTask.init(this);
        }
    }

    @Override
    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        boolean result = super.checkOnLoad(oldFormatVersion);
        if (this.metasetId != null) {
            this.metaset = this.scheduler.getMetaset(this.metasetId);
        }
        return result |= this.doCheckOnLoad(oldFormatVersion);
    }

    private boolean doCheckOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        if (oldFormatVersion != null) {
            if (oldFormatVersion == OldFormatVersion.FORMAT_2022) {
                this.initForOldFormat2022();
                this.initForOldFormat2023_1();
                this.initForOldFormat2023_2();
                this.initForOldFormat2024_1();
            } else if (oldFormatVersion == OldFormatVersion.FORMAT_2023_1) {
                this.initForOldFormat2023_1();
                this.initForOldFormat2023_2();
                this.initForOldFormat2024_1();
            } else if (oldFormatVersion == OldFormatVersion.FORMAT_2023_2) {
                this.initForOldFormat2023_2();
                this.initForOldFormat2024_1();
            } else if (oldFormatVersion == OldFormatVersion.FORMAT_2024_1) {
                this.initForOldFormat2024_1();
            }
        }
        this.doCheckTasksOnLoad(this.tasks, oldFormatVersion);
        this.doCheckTasksOnLoad(this.exceptionTasks, oldFormatVersion);
        if (this.existsExceptionTask()) {
            this.exceptionTask.checkOnLoad(oldFormatVersion);
        }
        return oldFormatVersion != null;
    }

    private void initForOldFormat2022() {
        UUID afterTaskOID = Task.START_TASK_OID;
        for (AbstractTask task : this.tasks) {
            task.setAfterTaskId(afterTaskOID);
            afterTaskOID = task.getOID();
        }
    }

    private void initForOldFormat2023_1() {
        this.eventScope = EventScope.GLOBAL;
        this.exceptionTasks = new ArrayList<AbstractTask>();
    }

    private void initForOldFormat2023_2() {
        this.model = false;
        this.unordered = false;
        this.taskListWindow = -1L;
        this.taskListWindowUnit = TimeUnit.SECONDS;
    }

    private void initForOldFormat2024_1() {
        this.transacted = false;
    }

    private void doCheckTasksOnLoad(List<AbstractTask> tasks, OldFormatVersion oldFormatVersion) throws SchedulerException {
        for (AbstractTask task : tasks) {
            task.checkOnLoad(oldFormatVersion);
        }
    }

    void enable() throws SchedulerException {
        if (this.state == TaskListState.DISABLED) {
            if (this.isModel().booleanValue()) {
                throw new SchedulerException(6151, "Model Task List cannot be enabled.");
            }
            this.doEnable();
            this.state = TaskListState.ENABLED;
            this.updateInStorage();
            this.raiseAdvisory(SchedulerAdvisoryType.TASKLIST_ENABLED, null, null);
        }
    }

    void enableOnLoad() throws SchedulerException {
        try {
            this.doEnable();
        }
        catch (SchedulerException exception) {
            this.doDisable();
            throw exception;
        }
    }

    private void doEnable() throws SchedulerException {
        this.checkAutocompleteUnordered();
        try {
            this.enableTasks();
        }
        catch (SchedulerException exception) {
            this.disableTasks();
            throw exception;
        }
        this.execNode = this.buildExecutionTree();
        this.skippedTasks = new LinkedList<AbstractTask>(this.tasks);
        this.skippedTasks.removeAll(this.execNode.pendingTasks);
    }

    private void enableTasks() throws SchedulerException {
        if (this.tasks.isEmpty()) {
            throw new SchedulerException(6137, "No Tasks are specified in " + this.toLogNameWithPrefix() + ".");
        }
        this.checkTaskWeights();
        this.doEnableTasks(this.tasks);
        this.doEnableTasks(this.exceptionTasks);
        if (this.existsExceptionTask()) {
            this.exceptionTask.enable();
        }
    }

    private void doEnableTasks(List<AbstractTask> tasks) throws SchedulerException {
        for (AbstractTask task : tasks) {
            task.enable();
        }
    }

    private void checkTaskWeights() throws SchedulerException {
        List noWeightTasks = this.tasks.stream().filter(task -> task.doGetWeight() == 0).map(AbstractSchedulerObject::getName).collect(Collectors.toList());
        if (!noWeightTasks.isEmpty()) {
            if (noWeightTasks.size() != this.tasks.size()) {
                throw new SchedulerException(6007, "Weight not set for Tasks: " + String.valueOf(noWeightTasks) + ".");
            }
        } else if (this.tasks.stream().mapToInt(AbstractTask::doGetWeight).sum() != 100) {
            throw new SchedulerException(6007, "Sum of Task weights not equal to 100.");
        }
    }

    double getNormalizedWeight() {
        return TaskList.doGetNormalizedWeight(this.tasks.size());
    }

    static double doGetNormalizedWeight(int tasksCount) {
        return 100.0 / (double)tasksCount;
    }

    void disable(boolean force) throws SchedulerException {
        if (this.state != TaskListState.DISABLED) {
            if (this.job != null && this.job.getState() == JobState.ENABLED) {
                throw new SchedulerException(6116, "Associated Job " + TaskList.toLogName(this.job) + " is enabled. Disable it first.");
            }
            if (!this.isModel().booleanValue() && this.isImportedFromModel()) {
                throw new SchedulerException(6151, "Task List imported from Model cannot be disabled.");
            }
            if (this.isRunning()) {
                if (force) {
                    this.state = TaskListState.DISABLED;
                    try {
                        this.stop();
                        Utils.sleep(500L);
                    }
                    catch (Throwable exception) {
                        this.logError(exception, "Forcible stopping " + this.toLogNameWithPrefix() + " failed.");
                    }
                } else {
                    throw new SchedulerException(6140, this.toLogNameWithPrefix() + " is running.");
                }
            }
            this.disableTasks();
            this.doDisable();
        }
    }

    private void disableTasks() {
        this.doDisableTasks(this.tasks);
        this.doDisableTasks(this.exceptionTasks);
        if (this.existsExceptionTask()) {
            this.exceptionTask.disable();
        }
    }

    private void doDisableTasks(List<AbstractTask> tasks) {
        for (AbstractTask task : tasks) {
            task.disable();
        }
    }

    private void doDisable() {
        this.resetExecutionTree();
        this.state = TaskListState.DISABLED;
        this.updateInStorage();
        this.raiseAdvisory(SchedulerAdvisoryType.TASKLIST_DISABLED, null, null);
    }

    void onDrop() {
        if (this.job != null) {
            this.job.clearTaskList();
        }
    }

    void setJob(AbstractJob job) {
        this.job = job;
    }

    void clearJob() {
        this.setJob(null);
    }

    public ScheduledJob getJob() {
        return this.scheduler.doCopy(this.job);
    }

    public boolean hasJob() {
        return this.job != null;
    }

    public String getJobName() {
        return this.job != null ? this.job.getName() : null;
    }

    @Override
    protected void checkNameUniqueness(String name) throws SchedulerException {
        if (this.scheduler.existsTaskList(name)) {
            throw new SchedulerException(6136, this.toLogNameWithPrefix() + " already exists.");
        }
    }

    private void setCurrentUser(String user) {
        this.currentUser = user;
    }

    public void update() throws SchedulerException {
        this.scheduler.updateTaskList(this, this.currentUser);
    }

    public Long getTaskListWindow() {
        return this.taskListWindow;
    }

    public synchronized void setTaskListWindow(long taskListWindow) {
        this.taskListWindow = taskListWindow;
    }

    public TimeUnit getTaskListWindowUnit() {
        return this.taskListWindowUnit;
    }

    public void setTaskListWindowUnit(TimeUnit unit) throws SchedulerException {
        if (unit == null) {
            throw new SchedulerException(6004, "Task List Window Unit is null.");
        }
        this.taskListWindowUnit = unit;
    }

    @Override
    public void setTaskWindowUnit(TimeUnit unit) throws SchedulerException {
        super.setTaskWindowUnit(unit);
    }

    @Override
    public void enableResumptionOn(TaskState state) throws SchedulerException {
        super.enableResumptionOn(state);
    }

    @Override
    public void enableResumptionTotally() throws SchedulerException {
        super.enableResumptionTotally();
    }

    @Override
    public void disableResumptionOn(TaskState state) throws SchedulerException {
        super.disableResumptionOn(state);
    }

    @Override
    public void disableResumptionTotally() throws SchedulerException {
        super.disableResumptionTotally();
    }

    @Override
    protected void doSetTaskWindow(long taskWindow) {
        this.tasks.forEach(task -> task.doSetTaskWindow(taskWindow));
    }

    @Override
    protected void doSetTaskWindowUnit(TimeUnit unit) {
        this.tasks.forEach(task -> task.doSetTaskWindowUnit(unit));
    }

    @Override
    protected void doEnableResumptionOn(byte state) {
        this.tasks.forEach(task -> task.doEnableResumptionOn(state));
    }

    @Override
    protected void doEnableResumptionTotally() {
        this.tasks.forEach(AbstractTask::doEnableResumptionTotally);
    }

    @Override
    protected void doDisableResumptionOn(byte state) {
        this.tasks.forEach(task -> task.doDisableResumptionOn(state));
    }

    @Override
    protected void doDisableResumptionTotally() {
        this.tasks.forEach(AbstractTask::doDisableResumptionTotally);
    }

    public long getRetentionInterval() {
        return this.retentionInterval;
    }

    public synchronized void setRetentionInterval(long retentionInterval) throws SchedulerException {
        this.retentionInterval = retentionInterval < 0L ? -1L : retentionInterval;
    }

    public TimeUnit getRetentionIntervalUnit() {
        return this.retentionIntervalUnit;
    }

    public synchronized void setRetentionIntervalUnit(TimeUnit retentionIntervalUnit) throws SchedulerException {
        this.retentionIntervalUnit = retentionIntervalUnit;
    }

    private long getRetentionIntervalMsec() {
        return this.retentionIntervalUnit.toMillis(this.retentionInterval);
    }

    @Override
    public void setAutoComplete(boolean autoComplete) {
        super.setAutoComplete(autoComplete);
    }

    @Override
    protected void doSetAutoComplete(boolean autoComplete) {
        super.doSetAutoComplete(autoComplete);
        this.tasks.forEach(task -> task.doSetAutoComplete(autoComplete));
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public synchronized void setUnordered(boolean unordered) throws SchedulerException {
        this.unordered = unordered;
    }

    private void checkAutocompleteUnordered() throws SchedulerException {
        if (this.isUnordered() && this.isAutoComplete()) {
            throw new SchedulerException(6007, this.toLogNameWithPrefix() + " is Auto Complete and cannot be in Unordered mode.");
        }
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public synchronized void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public synchronized void setEventScope(EventScope eventScope) throws SchedulerException {
        if (eventScope != EventScope.OBSERVABLE && eventScope != EventScope.GLOBAL) {
            throw new SchedulerException(6017, this.toLogNameWithPrefix() + " cannot have " + String.valueOf((Object)eventScope) + " event scope.");
        }
        this.eventScope = eventScope;
    }

    public Boolean isModel() {
        return this.model;
    }

    public synchronized void setModel() {
        this.doSetModel(true);
    }

    private void doSetModel(boolean model) {
        this.model = model;
    }

    public boolean isCreatedFromModel() {
        return this.listTags().stream().anyMatch(this::isModelTag);
    }

    public boolean isImportedFromModel() {
        return this.listTags().stream().anyMatch(this::isModelImportTag);
    }

    public String getBaseModel() {
        String modelTag = this.listTags().stream().filter(this::isReservedTag).findFirst().orElse(null);
        return modelTag != null ? modelTag.substring(modelTag.indexOf(64) + 1) : null;
    }

    @Override
    protected void checkReservedTag(String tag) throws SchedulerException {
        this.doCheckReservedTag(tag, this::isModelTag, MODEL_TAG);
        this.doCheckReservedTag(tag, this::isModelImportTag, MODEL_IMPORT_TAG);
    }

    private void doCheckReservedTag(String tag, Predicate<String> predicate, String reservedWord) throws SchedulerException {
        if (predicate.test(tag)) {
            throw new SchedulerException(6047, "Word '" + tag + "' is reserved for system purposes.");
        }
    }

    @Override
    protected boolean canHaveReservedTags() {
        return true;
    }

    @Override
    protected boolean isUnreservedTag(String tag) {
        return !this.isReservedTag(tag);
    }

    protected boolean isReservedTag(String tag) {
        return this.isModelTag(tag) || this.isModelImportTag(tag);
    }

    protected boolean isModelTag(String tag) {
        return tag.startsWith(MODEL_TAG);
    }

    protected boolean isModelImportTag(String tag) {
        return tag.startsWith(MODEL_IMPORT_TAG);
    }

    public ActionTask addActionTask(String taskName) throws SchedulerException {
        return this.addActionTask(taskName, null, null, this.getOwner(), null);
    }

    public ActionTask addActionTask(String taskName, String script) throws SchedulerException {
        return this.addActionTask(taskName, null, null, this.getOwner(), script);
    }

    public ActionTask addActionTask(String taskName, String sourceListName, String sourceTaskName) throws SchedulerException {
        return this.addActionTask(taskName, sourceListName, sourceTaskName, this.getOwner(), null);
    }

    public ActionTask addActionTask(String taskName, ActionTask source) throws SchedulerException {
        return (ActionTask)this.addTask(taskName, new ActionTask(taskName, source, this.getOwner()), (Object[])null);
    }

    ActionTask addActionTask(String taskName, String sourceListName, String sourceTaskName, String owner, String script) throws SchedulerException {
        return (ActionTask)this.addTask(TaskType.ACTION, taskName, sourceListName, sourceTaskName, owner, script);
    }

    public EventTask addEventTask(String taskName) throws SchedulerException {
        return this.addEventTask(taskName, null, null);
    }

    public EventTask addEventTask(String taskName, String sourceListName, String sourceTaskName) throws SchedulerException {
        return this.addEventTask(taskName, sourceListName, sourceTaskName, this.getOwner());
    }

    public EventTask addEventTask(String taskName, EventTask source) throws SchedulerException {
        return (EventTask)this.addTask(taskName, new EventTask(taskName, source, this.getOwner()), (Object[])null);
    }

    EventTask addEventTask(String taskName, String sourceListName, String sourceTaskName, String owner) throws SchedulerException {
        return (EventTask)this.addTask(TaskType.EVENT, taskName, sourceListName, sourceTaskName, owner, new Object[0]);
    }

    public ExceptionTask addExceptionTask(String taskName, String script) throws SchedulerException {
        return this.addExceptionTask(taskName, null, null, this.getOwner(), script);
    }

    public ExceptionTask addExceptionTask(String taskName, String sourceListName, String sourceTaskName) throws SchedulerException {
        return this.addExceptionTask(taskName, sourceListName, sourceTaskName, this.getOwner(), null);
    }

    public ExceptionTask addExceptionTask(String taskName, ExceptionTask source) throws SchedulerException {
        return (ExceptionTask)this.addTask(taskName, new ExceptionTask(taskName, source, this.getOwner()), (Object[])null);
    }

    ExceptionTask addExceptionTask(String taskName, String sourceListName, String sourceTaskName, String owner, String script) throws SchedulerException {
        return (ExceptionTask)this.addTask(TaskType.EXCEPTION, taskName != null ? taskName : "Exception", sourceListName, sourceTaskName, owner, script);
    }

    private synchronized AbstractTask addTask(TaskType type, String taskName, String sourceListName, String sourceTaskName, String owner, Object ... parameters) throws SchedulerException {
        if (!StringUtils.isEmpty(taskName)) {
            SchedulerImpl.validateName(taskName);
        }
        return this.addTask(taskName, this.createTaskInstance(type, taskName, sourceListName, sourceTaskName, owner), parameters);
    }

    private synchronized AbstractTask addTask(String taskName, AbstractTask task, Object ... parameters) throws SchedulerException {
        this.resetExecutionTree();
        this.checkTaskName(task);
        this.initTask(task, parameters);
        this.doAddTask(task);
        return task;
    }

    private void doAddTask(AbstractTask task) {
        if (task instanceof ExceptionTask) {
            if (((ExceptionTask)task).isForTaskList()) {
                this.exceptionTask = task;
            } else {
                this.exceptionTasks.add(task);
            }
        } else {
            this.tasks.add(task);
        }
    }

    private AbstractTask createTaskInstance(TaskType type, String taskName, String sourceListName, String sourceTaskName, String owner) throws SchedulerException {
        if (sourceListName != null && sourceTaskName != null) {
            TaskList sourceList = this.scheduler.getTaskList(sourceListName, this.currentUser);
            if (sourceList == null) {
                throw new SchedulerException(6135, "Task List " + TaskList.toLogName(sourceListName) + " does not exist.");
            }
            AbstractTask sourceTask = (AbstractTask)sourceList.getTask(sourceTaskName);
            if (sourceTask == null) {
                throw new SchedulerException(6145, "Task " + TaskList.toLogName(sourceTaskName) + " does not exist.");
            }
            if (sourceTask.getType() != type) {
                throw new SchedulerException(6144, "Task " + TaskList.toLogName(sourceTask.getFullName()) + " is not " + String.valueOf((Object)type) + " Task.");
            }
            switch (type) {
                case ACTION: {
                    return new ActionTask(taskName, (ActionTask)sourceTask, owner);
                }
                case EVENT: {
                    return new EventTask(taskName, (EventTask)sourceTask, owner);
                }
                case EXCEPTION: {
                    return new ExceptionTask(taskName, (ExceptionTask)sourceTask, owner);
                }
            }
        }
        switch (type) {
            case ACTION: {
                return new ActionTask(taskName, owner);
            }
            case EVENT: {
                return new EventTask(taskName, owner);
            }
            case EXCEPTION: {
                return new ExceptionTask(taskName, owner);
            }
        }
        throw new SchedulerException(6007, "TaskType is invalid!");
    }

    private void checkTaskName(AbstractTask task) throws SchedulerException {
        if (task instanceof ExceptionTask) {
            if (((ExceptionTask)task).isForTaskList()) {
                if (this.existsExceptionTask()) {
                    throw new SchedulerException(6146, "Exception for " + this.toLogNameWithPrefix() + " already exists.");
                }
            } else if (this.existsExceptionTask(task.getName())) {
                throw new SchedulerException(6146, "Exception for Task " + TaskList.toLogName(task) + " already exists.");
            }
        } else if (!StringUtils.isEmpty(task.getName())) {
            if (this.existsTask(task.getName())) {
                throw new SchedulerException(6146, "Task " + TaskList.toLogName(task) + " already exists.");
            }
            if (AbstractTask.isStartTask(task.getName())) {
                throw new SchedulerException(6047, "Name 'Start' is reserved for system purposes.");
            }
            if (AbstractTask.isExceptionTask(task.getName())) {
                throw new SchedulerException(6047, "Name 'Exception' is reserved for system purposes.");
            }
        } else {
            do {
                task.doSetName("Task" + this.taskNamesAllocator.getNumber());
            } while (this.existsTask(task.getName()));
        }
    }

    private void initTask(AbstractTask task, Object ... parameters) throws SchedulerException {
        if (task instanceof ExceptionTask) {
            ExceptionTask exceptionTask = (ExceptionTask)task;
            if (parameters[0] != null) {
                exceptionTask.doSetScript((String)parameters[0]);
            }
            if (!exceptionTask.isForTaskList()) {
                AbstractTask triggerTask = this.getTaskWithCheck(task.getName());
                ((ExceptionTask)task).setTriggerTask(triggerTask);
            }
        } else if (task instanceof ActionTask && parameters != null && parameters[0] != null) {
            ((ActionTask)task).doSetScript((String)parameters[0]);
        }
        task.init(this);
        task.doSetAutoComplete(this.isAutoComplete());
    }

    public ActionTask insertActionTask(String taskName, String afterTaskName) throws SchedulerException {
        return (ActionTask)this.insertTask(() -> this.addActionTask(taskName), afterTaskName);
    }

    public EventTask insertEventTask(String taskName, String afterTaskName) throws SchedulerException {
        return (EventTask)this.insertTask(() -> this.addEventTask(taskName), afterTaskName);
    }

    private synchronized AbstractTask insertTask(TaskAdder<AbstractTask> taskAdder, String afterTaskName) throws SchedulerException {
        UUID afterTaskId = this.getAfterTaskId(afterTaskName);
        AbstractTask nextTask = (AbstractTask)this.getNextTaskAfter(afterTaskId);
        this.resetExecutionTree();
        AbstractTask newTask = taskAdder.get();
        newTask.setAfterTaskId(afterTaskId);
        if (nextTask != null) {
            nextTask.setAfterTaskId(newTask.getOID());
        }
        return newTask;
    }

    public synchronized void moveTask(String taskName, String afterTaskName) throws SchedulerException {
        AbstractTask thisTask = this.getTaskWithCheck(taskName);
        UUID oldAfterTaskId = thisTask.getAfterTaskOID();
        UUID newAfterTaskId = this.getAfterTaskId(afterTaskName);
        AbstractTask.checkRecursiveTransition(taskName, afterTaskName);
        this.checkAbsenceRuleSet(thisTask, "Existing State Transition cannot be changed.");
        this.checkAbsenceRuleSetByExecTask(thisTask);
        if (!Utils.equalsNullSafe(oldAfterTaskId, newAfterTaskId)) {
            this.resetExecutionTree();
            AbstractTask nextTaskAfterNewAfterTask = (AbstractTask)this.getNextTaskAfter(newAfterTaskId);
            AbstractTask nextTaskAfterThisTask = (AbstractTask)this.getNextTaskAfter(thisTask.getOID());
            thisTask.setAfterTaskId(newAfterTaskId);
            if (nextTaskAfterNewAfterTask != null) {
                nextTaskAfterNewAfterTask.setAfterTaskId(thisTask.getOID());
            }
            if (nextTaskAfterThisTask != null) {
                nextTaskAfterThisTask.setAfterTaskId(oldAfterTaskId);
            }
        }
    }

    UUID getAfterTaskId(String afterTaskName) throws SchedulerException {
        if (afterTaskName == null) {
            throw new SchedulerException(6004, "After Task name is null.");
        }
        UUID afterTaskId = Task.START_TASK_OID;
        if (!AbstractTask.isStartTask(afterTaskName)) {
            AbstractTask task = this.getTaskWithCheck(afterTaskName);
            this.checkAbsenceRuleSet(task, "It cannot be the starting node of new State Transition.");
            afterTaskId = task.getOID();
        }
        return afterTaskId;
    }

    public synchronized void removeTask(String taskName) {
        AbstractTask task = (AbstractTask)this.getTask(taskName);
        if (task != null) {
            this.resetExecutionTree();
            AbstractTask nextTask = (AbstractTask)this.getNextTaskAfter(task.getOID());
            if (nextTask != null) {
                nextTask.setAfterTaskId(null);
            }
            if (task.hasRuleSet()) {
                this.removeRuleSet(task.getRuleSet().getName());
            }
            this.removeRuleByExecTask(task.getOID());
            this.doRemoveTask(task);
        }
    }

    public synchronized void deleteTask(String taskName) throws SchedulerException {
        AbstractTask task = (AbstractTask)this.getTask(taskName);
        if (task != null) {
            this.checkAbsenceRuleSet(task, "It cannot be removed.");
            this.resetExecutionTree();
            AbstractTask nextTask = (AbstractTask)this.getNextTaskAfter(task.getOID());
            if (nextTask != null) {
                UUID afterTaskId = task.getAfterTaskOID();
                if (afterTaskId != null) {
                    nextTask.setAfterTaskId(afterTaskId);
                } else {
                    Rule rule;
                    RuleSet ruleSet = this.getRuleSetByExecTask(task.getOID());
                    if (ruleSet != null && (rule = ruleSet.getRuleByExecTask(task.getOID())) != null) {
                        nextTask.setAfterTaskId(null);
                        rule.setExecTaskId(nextTask.getOID());
                    }
                }
            } else {
                this.removeRuleByExecTask(task.getOID());
            }
            this.doRemoveTask(task);
        }
    }

    private void doRemoveTask(AbstractTask task) {
        this.removeExceptionTask(task.getName());
        this.tasks.remove(task);
    }

    public synchronized void removeExceptionTask(String taskName) {
        ExceptionTask task = this.getExceptionTask(taskName);
        if (task != null) {
            this.exceptionTasks.remove(task);
        }
    }

    public synchronized void removeExceptionTask() {
        this.exceptionTask = null;
    }

    synchronized void removeRuleByExecTask(UUID taskOID) {
        AbstractTask task;
        RuleSet ruleSet;
        this.resetExecutionTree();
        Iterator<AbstractTask> iterator = this.tasks.iterator();
        while (iterator.hasNext() && ((ruleSet = (task = iterator.next()).getRuleSet()) == null || !ruleSet.removeRuleByExecTask(taskOID))) {
        }
    }

    public synchronized boolean existsNextTaskAfter(UUID taskOID) {
        return this.tasks.stream().anyMatch(task -> task.getAfterTaskOID() != null && task.getAfterTaskOID().equals(taskOID));
    }

    public synchronized Task getNextTaskAfter(UUID taskOID) {
        return this.tasks.stream().filter(task -> task.getAfterTaskOID() != null && task.getAfterTaskOID().equals(taskOID)).findFirst().orElse(null);
    }

    public synchronized boolean existsNextTaskAfter(String taskName) {
        if (AbstractTask.isStartTask(taskName)) {
            return this.existsNextTaskAfter(Task.START_TASK_OID);
        }
        Task task = this.getTask(taskName);
        return task != null && this.existsNextTaskAfter(task.getOID());
    }

    public synchronized Task getNextTaskAfter(String taskName) {
        return AbstractTask.isStartTask(taskName) ? this.getNextTaskAfter(Task.START_TASK_OID) : this.doGetNextTaskAfter(this.getTask(taskName));
    }

    public Task getConsequentTask(String taskName) {
        return this.getNextTaskAfter(taskName);
    }

    Task doGetNextTaskAfter(Task task) {
        return task != null ? this.getNextTaskAfter(task.getOID()) : null;
    }

    public synchronized boolean existsTaskBefore(String taskName) {
        if (AbstractTask.isStartTask(taskName)) {
            return false;
        }
        Task task = this.getTask(taskName);
        if (task != null) {
            UUID afterTaskId = task.getAfterTaskOID();
            return afterTaskId != null && !AbstractTask.isStartTask(afterTaskId);
        }
        return false;
    }

    public synchronized Task getTaskBefore(String taskName) {
        return AbstractTask.isStartTask(taskName) ? null : this.doGetTaskBefore(this.getTask(taskName));
    }

    public Task getPrecedentTask(String taskName) {
        return this.getTaskBefore(taskName);
    }

    Task doGetTaskBefore(Task task) {
        UUID afterTaskId;
        if (task != null && (afterTaskId = task.getAfterTaskOID()) != null && !AbstractTask.isStartTask(afterTaskId)) {
            return this.getTask(afterTaskId);
        }
        return null;
    }

    public boolean existsTask(String taskName) {
        return AbstractTask.isStartTask(taskName) || this.doExistsTask(this.tasks, taskName);
    }

    public boolean existsTask(UUID taskOID) {
        return AbstractTask.isStartTask(taskOID) || this.doExistsTask(this.tasks, taskOID);
    }

    public Task getTask(String taskName) {
        return this.doGetTask(this.tasks, taskName);
    }

    public Task getTask(UUID taskOID) {
        return this.doGetTask(this.tasks, taskOID);
    }

    public boolean existsExceptionTask() {
        return this.exceptionTask != null;
    }

    public ExceptionTask getExceptionTask() {
        return (ExceptionTask)this.exceptionTask;
    }

    public boolean existsExceptionTask(String taskName) {
        return this.doExistsTask(this.exceptionTasks, taskName);
    }

    public boolean existsExceptionTask(UUID taskOID) {
        return this.doExistsTask(this.exceptionTasks, taskOID);
    }

    public ExceptionTask getExceptionTask(String taskName) {
        return (ExceptionTask)this.doGetTask(this.exceptionTasks, taskName);
    }

    public ExceptionTask getExceptionTask(UUID taskOID) {
        return (ExceptionTask)this.doGetTask(this.exceptionTasks, taskOID);
    }

    private synchronized boolean doExistsTask(List<AbstractTask> tasks, String taskName) {
        return tasks.stream().anyMatch(task -> task.getName().equals(taskName));
    }

    private synchronized boolean doExistsTask(List<AbstractTask> tasks, UUID taskOID) {
        return tasks.stream().anyMatch(task -> task.getOID().equals(taskOID));
    }

    private synchronized AbstractTask doGetTask(List<AbstractTask> tasks, String taskName) {
        return tasks.stream().filter(task -> task.getName().equals(taskName)).findFirst().orElse(null);
    }

    private synchronized AbstractTask doGetTask(List<AbstractTask> tasks, UUID taskOID) {
        return tasks.stream().filter(task -> task.getOID().equals(taskOID)).findFirst().orElse(null);
    }

    AbstractTask getTaskWithCheck(String taskName) throws SchedulerException {
        return TaskList.doGetTaskWithCheck(taskName, (AbstractTask)this.getTask(taskName));
    }

    AbstractTask getTaskWithCheck(UUID taskOID) throws SchedulerException {
        return TaskList.doGetTaskWithCheck(taskOID.toString(), (AbstractTask)this.getTask(taskOID));
    }

    private static AbstractTask doGetTaskWithCheck(String id, AbstractTask task) throws SchedulerException {
        if (task == null) {
            throw new SchedulerException(6145, "Task " + TaskList.toLogName(id) + " does not exist.");
        }
        return task;
    }

    public synchronized List<Task> getTasks() {
        return new ArrayList<Task>(this.tasks);
    }

    public List<String> listTasks() {
        return this.doListTasks(this.tasks);
    }

    public synchronized List<ExceptionTask> getExceptionTasks() {
        return this.exceptionTasks.stream().map(ExceptionTask.class::cast).collect(Collectors.toList());
    }

    public List<String> listExceptionTasks() {
        return this.doListTasks(this.exceptionTasks);
    }

    private synchronized <T extends Task> List<String> doListTasks(List<T> tasks) {
        return tasks.stream().map(NamedObject::getName).collect(Collectors.toList());
    }

    public synchronized boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    public synchronized boolean hasExceptionTasks() {
        return !this.exceptionTasks.isEmpty();
    }

    public long getTaskDelay() {
        return this.taskDelay;
    }

    public synchronized void setTaskDelay(long taskDelay) throws SchedulerException {
        TaskList.checkTaskDelay(taskDelay);
        this.taskDelay = taskDelay;
    }

    private static void checkTaskDelay(long taskDelay) throws SchedulerException {
        if (taskDelay < 0L) {
            throw new SchedulerException(6007, "Task delay must not be negative.");
        }
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public void setLastException(Throwable lastException) {
        this.lastException = lastException;
    }

    public UUID getMetasetOID() {
        return this.metasetId;
    }

    public synchronized String getMetasetName() {
        return this.metaset != null ? this.metaset.getName() : null;
    }

    public synchronized void setMetaset(String name) throws SchedulerException {
        if (name == null) {
            if (this.metasetId != null) {
                this.metasetId = null;
                this.metaset = null;
                this.scheduler.setMetasetInstance(this.getOID(), null);
            }
        } else {
            Metaset metaset = this.scheduler.getMetaset(name);
            if (metaset == null) {
                throw new SchedulerException(6153, "Metaset '" + name + "' does not exist.");
            }
            if (this.metasetId == null || !this.metasetId.equals(metaset.getOID())) {
                this.metaset = metaset;
                this.metasetId = metaset.getOID();
                this.scheduler.setMetasetInstance(this.getOID(), null);
            }
        }
    }

    boolean hasMetaset() {
        return this.metasetId != null;
    }

    public synchronized void setMetasetInstance(Metaset metaset) throws SchedulerException {
        if (this.metasetId == null) {
            throw new SchedulerException(6152, this.toLogNameWithPrefix() + " has no associated Metaset.");
        }
        if (metaset != null) {
            this.checkMetasetModel(metaset);
        }
        this.scheduler.setMetasetInstance(this.getOID(), metaset);
    }

    public Metaset getMetasetInstance() throws SchedulerException {
        return this.scheduler.getMetasetInstance(this.getOID());
    }

    public boolean existsMetasetInstance() {
        return this.scheduler.existsMetasetInstance(this.getOID());
    }

    private void checkMetasetModel(Metaset metaset) throws SchedulerException {
        if (!metaset.getOID().equals(this.metasetId)) {
            throw new SchedulerException(6152, "Metaset instance does not match Metaset associated with " + this.toLogNameWithPrefix() + ".");
        }
    }

    public TaskListState getState() {
        return this.state;
    }

    private void setState(TaskListState state) {
        this.state = state;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }

    public boolean isDisabled() {
        return this.state == TaskListState.DISABLED;
    }

    void fillTaskStates(List<TaskState> result) {
        for (Task task : this.tasks) {
            result.add(task.getState());
        }
    }

    void setScheduled() {
        this.setScheduled(true);
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    void setScheduled(boolean scheduled) {
        this.isScheduled = scheduled;
    }

    public synchronized ExecNode buildExecutionTree() throws SchedulerException {
        AbstractTask firstTask = (AbstractTask)this.getNextTaskAfter(Task.START_TASK_OID);
        if (firstTask == null) {
            throw new SchedulerException(6162, "No Task defined after Start.");
        }
        ExecNode result = this.buildExecutionTree(firstTask);
        if (this.isUnordered()) {
            result.pendingTasks.clear();
            result.pendingTasks.addAll(this.tasks);
        }
        return result;
    }

    private ExecNode buildExecutionTree(AbstractTask firstTask) {
        if (firstTask == null) {
            return new ExecNode(null);
        }
        ExecNode result = new ExecNode(firstTask);
        this.addNodeToExecTree(result);
        return result;
    }

    private void addNodeToExecTree(ExecNode node) {
        RuleSet ruleSet = node.task.getRuleSet();
        if (ruleSet != null) {
            node.nextNodesConditional = new LinkedList<Pair<Rule, ExecNode>>();
            for (Rule rule : ruleSet.getRules()) {
                ExecNode conditionalNode = node.createNextNode((AbstractTask)this.getTask(rule.getExecTaskOID()));
                node.nextNodesConditional.add(new Pair<Rule, ExecNode>(rule, conditionalNode));
                this.addNodeToExecTree(conditionalNode);
                node.addPendingNodes(conditionalNode);
            }
        } else {
            AbstractTask nextTask = (AbstractTask)this.getNextTaskAfter(node.task.getOID());
            if (nextTask != null) {
                node.nextNodeDirect = node.createNextNode(nextTask);
                this.addNodeToExecTree(node.nextNodeDirect);
                node.addPendingNodes(node.nextNodeDirect);
            }
        }
    }

    void resetExecutionTree() {
        this.execNode = null;
    }

    public List<List<Pair<String, String>>> getAllExecChains() throws SchedulerException {
        ExecNode node = this.getExecNode();
        return node.getAllExecChains();
    }

    public List<Pair<String, String>> testExecution(Metaset metaset) throws SchedulerException {
        metaset = this.checkExecutionMetaset(metaset);
        return this.getExecNode().testExecution(metaset);
    }

    private synchronized ExecNode getExecNode() throws SchedulerException {
        return this.execNode != null ? this.execNode : this.buildExecutionTree();
    }

    public int getTaskOrder(String taskName) {
        try {
            return this.doGetTaskOrder(this.getAllExecChains(), taskName);
        }
        catch (SchedulerException schedulerException) {
            return -1;
        }
    }

    public RowSet getTaskOrderList() {
        RowSet rowSet = new RowSet(TASK_ORDER_LIST_DESCRIPTOR);
        this.doGetTaskOrderList().forEach(pair -> AbstractDSLOperation.addValues(rowSet, pair.first, pair.second));
        return rowSet;
    }

    public Task getTaskByOrder(int order) {
        Pair result = this.doGetTaskOrderList().stream().filter(pair -> (Integer)pair.first == order).findFirst().orElse(null);
        return result != null ? this.getTask((String)result.second) : null;
    }

    private List<Pair<Integer, String>> doGetTaskOrderList() {
        ArrayList<Pair<Integer, String>> result = new ArrayList<Pair<Integer, String>>();
        try {
            List<List<Pair<String, String>>> execChains = this.getAllExecChains();
            this.listTasks().forEach(taskName -> result.add(new Pair<Integer, String>(this.doGetTaskOrder(execChains, (String)taskName), (String)taskName)));
            result.sort(Comparator.comparing(o -> (Integer)o.first));
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
        return result;
    }

    private int doGetTaskOrder(List<List<Pair<String, String>>> execChains, String taskName) {
        for (List<Pair<String, String>> chain : execChains) {
            int order = 1;
            for (Pair<String, String> node : chain) {
                if (((String)node.second).equals(taskName)) {
                    return order;
                }
                ++order;
            }
        }
        return -1;
    }

    @Override
    protected ExecutionMode getDirectMode() {
        return ExecutionMode.TASKLIST_DIRECT;
    }

    @Override
    protected void createExecutionInstance(String userName, ExecutionMode executionMode, Date startTime) throws SchedulerException {
        this.doCreateExecutionInstance(userName, executionMode, startTime, null);
    }

    protected void doCreateExecutionInstance(String userName, ExecutionMode executionMode, Date startTime, AbstractTask taskToExecute) throws SchedulerException {
        this.execution = new TaskListExecution(this, userName, executionMode, startTime);
        if (taskToExecute != null) {
            this.execution.doSetState(TaskListState.TASK_RUNNING);
            this.tasks.forEach(task -> this.execution.addPendingTask((AbstractTask)task, task.equals(taskToExecute) ? TaskState.PENDING : TaskState.SKIPPED));
        } else {
            this.execution.doSetState(TaskListState.RUNNING);
            this.execNode.pendingTasks.forEach(task -> this.execution.addPendingTask((AbstractTask)task, TaskState.PENDING));
            this.skippedTasks.forEach(task -> this.execution.addPendingTask((AbstractTask)task, TaskState.SKIPPED));
        }
        this.execution.adjustTaskExecutions();
        this.scheduler.addExecution(this.getOID(), this.execution, this.getRetentionIntervalMsec());
    }

    @Override
    protected TaskListState executeDirect(ExecutionListener listener) {
        return (TaskListState)((Object)this.doExecute((ExecutionListener)listener, (boolean)false).second);
    }

    private Pair<CompletionState, TaskListState> doExecute(ExecutionListener listener, boolean isResuming) {
        Date startTime = this.execution.getStartTime();
        this.setInterrupted(false);
        if (!isResuming) {
            this.calculateEndTime(startTime);
            this.startExecution(listener);
        }
        ExecutionState state = new ExecutionState();
        if (this.unordered.booleanValue()) {
            this.doExecuteUnordered(listener, state, isResuming);
        } else {
            this.doExecute(this.execNode, listener, state);
        }
        if (this.transacted.booleanValue()) {
            try {
                if (state.completionState == CompletionState.TASKLIST_COMPLETED) {
                    this.dataspaceAccessorProvider.commit();
                } else {
                    this.dataspaceAccessorProvider.rollback();
                }
            }
            catch (Exception exception) {
                this.logError(exception, "Committing transaction for " + this.toLogNameWithPrefix() + " failed.");
                state.completionState = CompletionState.TASKLIST_TRANSACTED_FAIL;
            }
        }
        TaskListState resultState = this.completeExecution(state.completionState, listener);
        return new Pair<CompletionState, TaskListState>(state.completionState, resultState);
    }

    void startExecution(ExecutionListener listener) {
        this.logExecInfo("Execution started.");
        this.onExecution(SchedulerAdvisoryType.TASKLIST_EXECUTION_STARTED, null, listener, ExecutionListener::onTaskListStarted);
    }

    private void doExecute(ExecNode node, ExecutionListener listener, ExecutionState state) {
        if (this.isInterrupted()) {
            node.setState(TaskState.SKIPPED, TaskState.SKIPPED);
            state.completionState = CompletionState.TASKLIST_INTERRUPTED;
        } else {
            if (!state.firstTime.booleanValue()) {
                CompletionState delayState;
                if (this.taskDelay > 0L && (delayState = this.sleep(this.taskDelay, node.task, listener, false)) != null) {
                    state.completionState = delayState;
                    node.setState(TaskState.SKIPPED, TaskState.SKIPPED);
                    return;
                }
            } else {
                state.firstTime = false;
            }
            AbstractTask.ExecutionResult taskResult = this.executeTask(node.task, () -> node.task.doExecute(new Date(), listener));
            CompletionState completionState = taskResult.state;
            if (completionState == CompletionState.TASKLIST_COMPLETED) {
                TaskList.resolvePendingTask(node, TaskState.COMPLETED);
            } else if (completionState == CompletionState.TASKLIST_FAILED) {
                TaskList.resolvePendingTask(node, TaskState.FAILED);
                state.completionState = CompletionState.TASKLIST_FAILED;
            } else if (completionState == CompletionState.TASKLIST_EXPIRED) {
                TaskList.resolvePendingTask(node, TaskState.SKIPPED);
                state.completionState = CompletionState.TASKLIST_EXPIRED;
            } else if (completionState == CompletionState.TASK_FAILED && !node.task.isResumptionEnabled()) {
                TaskList.resolvePendingTask(node, TaskState.SKIPPED);
                state.completionState = CompletionState.TASKLIST_FAILED;
            } else if (completionState == CompletionState.TASK_UNDONE) {
                completionState = this.completeTaskUndo(node.task, listener);
                if (completionState != null) {
                    state.completionState = completionState;
                    node.setState(TaskState.SKIPPED, TaskState.SKIPPED);
                    return;
                }
                this.doExecute(node, listener, state);
            } else if (node.nextNodeDirect != null) {
                this.doExecute(node.nextNodeDirect, listener, state);
            } else if (!Utils.isEmpty(node.nextNodesConditional)) {
                LinkedList<Pair<Rule, ExecNode>> matchedNodes = new LinkedList<Pair<Rule, ExecNode>>();
                for (Pair<Rule, ExecNode> entry2 : node.nextNodesConditional) {
                    if (((Rule)entry2.first).matchesCondition()) {
                        matchedNodes.add(entry2);
                        continue;
                    }
                    ((ExecNode)entry2.second).setState(TaskState.CONDITIONAL, TaskState.CONDITIONAL);
                }
                if (matchedNodes.size() == 1) {
                    Pair entry3 = (Pair)matchedNodes.getFirst();
                    this.doExecute((ExecNode)entry3.second, listener, state);
                } else {
                    if (matchedNodes.isEmpty()) {
                        this.onRuleSetError(node, "No Condition matches Metaset or Completion event.", 6163, listener);
                    } else if (matchedNodes.size() > 1) {
                        this.onRuleSetError(node, "Multiple Conditions match Metaset or Completion event.", 6164, listener);
                        matchedNodes.forEach(entry -> ((ExecNode)entry.second).setState(TaskState.SKIPPED, TaskState.SKIPPED));
                    }
                    state.completionState = CompletionState.TASKLIST_FAILED;
                }
            }
        }
    }

    private void doExecuteUnordered(ExecutionListener listener, ExecutionState state, boolean isResuming) {
        Map<String, AbstractTask> pendingTasks;
        if (!isResuming) {
            this.tasks.forEach(task -> task.onCompletionStarted(null));
            this.onCompletionStarted(listener);
            pendingTasks = this.tasks.stream().collect(Collectors.toMap(AbstractSchedulerObject::getName, Function.identity()));
        } else {
            Set<String> runningTasks = this.execution.resumeUnordered();
            pendingTasks = this.tasks.stream().filter(task -> runningTasks.contains(task.getName())).collect(Collectors.toMap(AbstractSchedulerObject::getName, Function.identity()));
        }
        this.doExecuteUnordered(listener, state, pendingTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExecuteUnordered(ExecutionListener listener, ExecutionState state, Map<String, AbstractTask> pendingTasks) {
        try {
            while (!this.isInterrupted() && !pendingTasks.isEmpty()) {
                try {
                    Pair<CompletionState, SchedulerCompletionEvent> completion = this.receiveCompletionEvent(null, this.remainingTimeMsec);
                    SchedulerCompletionEvent event = (SchedulerCompletionEvent)completion.second;
                    if (event == null) break;
                    this.execution.setCompletionEvent(event);
                    if (event.isForTaskList()) {
                        if (event.isFailed()) {
                            TaskList.resolvePendingTask(pendingTasks, TaskState.FAILED);
                            state.completionState = CompletionState.TASKLIST_FAILED;
                        } else {
                            TaskList.resolvePendingTask(pendingTasks, TaskState.COMPLETED);
                        }
                        this.execution.doSetFacets(event.getValues());
                        return;
                    }
                    AbstractTask task = pendingTasks.remove(event.getTaskName());
                    if (task == null) continue;
                    if (!event.isOK()) {
                        if (event.isFailed() && task.execution.getCompletionState() != TaskState.FAILED) {
                            task.onCompletionFailed(listener, false, event.getValues());
                        } else if (event.isExpired() && task.execution.getCompletionState() != TaskState.EXPIRED_INCOMPLETE) {
                            task.onCompletionExpired(listener, (CompletionState)((Object)completion.first));
                        }
                        if (task.needsExecution()) {
                            task.execution.doSetState(TaskState.SKIPPED);
                        }
                        if (task.isResumptionEnabled()) continue;
                        TaskList.resolvePendingTask(pendingTasks, TaskState.SKIPPED);
                        state.completionState = CompletionState.TASKLIST_FAILED;
                        return;
                    }
                    if (task.execution.getCompletionState() != TaskState.COMPLETED) {
                        task.onCompletionCompleted(listener, false, event.getValues());
                    }
                    if (!task.needsExecution()) continue;
                    CompletionState completionState = this.executeTask(task, () -> task.doExecutionPart(new Date(), listener));
                    if (completionState == CompletionState.TASK_FAILED && !task.isResumptionEnabled()) {
                        TaskList.resolvePendingTask(pendingTasks, TaskState.SKIPPED);
                        state.completionState = CompletionState.TASKLIST_FAILED;
                        return;
                    }
                    if (completionState == CompletionState.TASK_UNDONE) {
                        task.onTaskUndone(listener);
                        pendingTasks.put(task.getName(), task);
                        completionState = this.completeTaskUndo(task, listener);
                        if (completionState != null) {
                            state.completionState = completionState;
                            break;
                        } else {
                            task.onCompletionStarted(listener);
                            continue;
                        }
                    }
                    if (completionState != CompletionState.TASKLIST_EXPIRED) continue;
                    break;
                }
                catch (SchedulerException exception) {
                    this.logError(exception, "Waiting for Completion Event interrupted.");
                    this.isInterrupted = true;
                }
                finally {
                    this.execution.resetCompletionEvent();
                }
            }
        }
        finally {
            this.execution.resetCompletionEvent();
        }
        if (this.isInterrupted()) {
            TaskList.resolvePendingTask(pendingTasks, TaskState.INTERRUPTED_INCOMPLETE);
            state.completionState = CompletionState.TASKLIST_INTERRUPTED;
            return;
        }
        if (pendingTasks.isEmpty()) return;
        TaskList.resolvePendingTask(pendingTasks, TaskState.EXPIRED_INCOMPLETE);
        state.completionState = CompletionState.TASKLIST_EXPIRED;
    }

    TaskListState completeExecution(CompletionState completionState, ExecutionListener listener) {
        TaskListState listState = TaskList.convertCompletionState(completionState);
        this.execution.complete(listState);
        this.logExecInfo("Execution completed (State: " + String.valueOf((Object)listState) + ").");
        if (this.execution.getExecutionMode() != ExecutionMode.TASK_DIRECT) {
            if (completionState == CompletionState.TASKLIST_COMPLETED) {
                this.onExecution(SchedulerAdvisoryType.TASKLIST_EXECUTION_COMPLETED, this.execution.doGetFacets(), listener, ExecutionListener::onTaskListCompleted);
            } else if (completionState == CompletionState.TASKLIST_FAILED || completionState == CompletionState.TASKLIST_TRANSACTED_FAIL) {
                this.onExecution(SchedulerAdvisoryType.TASKLIST_EXECUTION_FAILED, this.execution.doGetFacets(), listener, ExecutionListener::onTaskListFailed);
            } else if (completionState == CompletionState.TASKLIST_EXPIRED) {
                this.onExecution(SchedulerAdvisoryType.TASKLIST_EXECUTION_EXPIRED, this.execution.doGetFacets(), listener, ExecutionListener::onTaskListExpired);
            } else if (completionState == CompletionState.TASKLIST_INTERRUPTED) {
                this.onExecution(SchedulerAdvisoryType.TASKLIST_EXECUTION_INTERRUPTED, this.execution.doGetFacets(), listener, ExecutionListener::onTaskListInterrupted);
            }
        }
        this.execution.reset();
        this.execution = null;
        this.executionMetaset = null;
        this.executedTask = null;
        this.completionEvent = null;
        this.lastException = null;
        this.clearExecutionTimes();
        this.destroyExecutionContext();
        this.doSetThread(null);
        this.setNotRunning();
        return listState;
    }

    private void clearExecutionTimes() {
        this.endTimeMsec = null;
        this.taskListWindowMsec = 0L;
        this.remainingTimeMsec = 0L;
        this.expiresImmediately = false;
    }

    private static TaskListState convertCompletionState(CompletionState completionState) {
        switch (completionState) {
            case TASKLIST_COMPLETED: {
                return TaskListState.COMPLETED;
            }
            case TASKLIST_FAILED: {
                return TaskListState.FAILED;
            }
            case TASKLIST_EXPIRED: {
                return TaskListState.EXPIRED;
            }
            case TASKLIST_INTERRUPTED: {
                return TaskListState.INTERRUPTED;
            }
            case TASKLIST_TRANSACTED_FAIL: {
                return TaskListState.TRANSACTED_FAIL;
            }
        }
        return TaskListState.ENABLED;
    }

    protected CompletionState completeTaskUndo(AbstractTask task, ExecutionListener listener) {
        CompletionState state = this.sleep(task.getUndoDelay(), task, listener, true);
        task.resetUndo();
        return state;
    }

    private void onRuleSetError(ExecNode node, String errorMessage, int errorCode, ExecutionListener listener) {
        node.task.execution.doSetError(errorMessage, errorCode);
        node.task.onExecution(SchedulerAdvisoryType.RULE_SET_ERROR, listener, ExecutionListener::onRuleSetError);
    }

    void executeExceptionTask(AbstractTask task, ExecutionListener listener) {
        ExceptionTask exceptionTask = this.getExceptionTaskForExecution(task);
        if (exceptionTask != null) {
            this.executeTask(exceptionTask, () -> exceptionTask.doExecute(new Date(), listener));
        }
    }

    private ExceptionTask getExceptionTaskForExecution(AbstractTask task) {
        ExceptionTask exceptionTask = task.getExceptionTask();
        return exceptionTask != null ? exceptionTask : this.getExceptionTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeTask(AbstractTask task, Supplier<R> executor) {
        try {
            this.executedTask = task;
            R r = executor.get();
            return r;
        }
        finally {
            this.executedTask = null;
        }
    }

    Pair<CompletionState, SchedulerCompletionEvent> receiveCompletionEvent(String taskName, long timeWindowMsec) throws SchedulerException {
        if (this.execution.getCompletionEvent() != null) {
            this.completionEvent = this.execution.getCompletionEvent();
            return this.doProcessCompletionEvent();
        }
        if (this.isTimeExpired()) {
            return new Pair<CompletionState, Object>(CompletionState.TASKLIST_EXPIRED, null);
        }
        try {
            timeWindowMsec = this.adjustTimeAgainstTaskListWindow(timeWindowMsec);
            this.logExecInfo("Remaining Time for Completion: " + TaskList.formatInterval(timeWindowMsec) + ".");
            if (taskName != null) {
                long endTimeMsec = timeWindowMsec <= 0L ? -1L : System.currentTimeMillis() + timeWindowMsec;
                long remainingTimeMsec = timeWindowMsec;
                while (!this.isInterrupted() && !TaskList.isTimeExpired(endTimeMsec, remainingTimeMsec)) {
                    this.completionEvent = this.doReceiveCompletionEvent(remainingTimeMsec);
                    if (this.completionEvent != null && !this.completionEvent.isForTaskList() && !this.completionEvent.getTaskName().equals(taskName)) {
                        remainingTimeMsec = TaskList.calculateRemainingTime(endTimeMsec);
                        continue;
                    }
                    break;
                }
            } else {
                this.completionEvent = this.doReceiveCompletionEvent(timeWindowMsec);
            }
            if (this.completionEvent != null) {
                this.logExecInfo("Received Completion Event (" + String.valueOf(this.completionEvent) + ").");
                return this.doProcessCompletionEvent();
            }
            this.logExecInfo("No Completion Event received.");
            return TaskList.onCompletionEventExpired(this.isTimeExpired());
        }
        catch (Exception exception) {
            throw new SchedulerException(6151, (Throwable)exception);
        }
    }

    private SchedulerCompletionEvent doReceiveCompletionEvent(long timeWindowMsec) throws Exception {
        return timeWindowMsec > 0L ? (SchedulerCompletionEvent)this.completionEventReceiver.receive(timeWindowMsec) : (SchedulerCompletionEvent)this.completionEventReceiver.receive();
    }

    private Pair<CompletionState, SchedulerCompletionEvent> doProcessCompletionEvent() {
        if (this.completionEvent.isExpired()) {
            if (this.isUnordered()) {
                return this.completionEvent.isForTaskList() ? TaskList.onCompletionEventExpired(true) : new Pair<CompletionState, SchedulerCompletionEvent>(CompletionState.TASK_FAILED, this.completionEvent);
            }
            return TaskList.onCompletionEventExpired(this.completionEvent.isForTaskList());
        }
        return new Pair<Object, SchedulerCompletionEvent>(null, this.completionEvent);
    }

    SchedulerCompletionEvent doGetCompletionEvent() {
        return this.completionEvent;
    }

    private static Pair<CompletionState, SchedulerCompletionEvent> onCompletionEventExpired(boolean isForTaskList) {
        return new Pair<CompletionState, Object>(isForTaskList ? CompletionState.TASKLIST_EXPIRED : CompletionState.TASK_FAILED, null);
    }

    private static boolean isTimeExpired(long endTimeMsec, long remainingTimeMsec) {
        return endTimeMsec > 0L && remainingTimeMsec <= 0L;
    }

    private static long calculateRemainingTime(long endTimeMsec) {
        return endTimeMsec <= 0L ? -1L : endTimeMsec - System.currentTimeMillis();
    }

    private boolean isInfiniteTaskListWindow() {
        return this.taskListWindowMsec <= 0L;
    }

    @Override
    protected void setUntilTime(Date untilTime, boolean autoExpire) throws SchedulerException {
        if (untilTime != null) {
            if (untilTime.before(new Date())) {
                if (!autoExpire) {
                    throw new SchedulerException(6165, "Value of parameter 'untilTime' must be after the current time.");
                }
                this.expiresImmediately = true;
            }
            this.endTimeMsec = untilTime.getTime();
        }
    }

    void calculateEndTime(Date startTime) {
        long startTimeMsec = startTime.getTime();
        if (this.endTimeMsec == null) {
            this.taskListWindowMsec = this.getTaskListWindowMsec();
            this.endTimeMsec = this.getEndTimeMsec(startTimeMsec);
        } else {
            this.taskListWindowMsec = this.endTimeMsec - startTimeMsec;
        }
        this.remainingTimeMsec = this.getRemainingTime(this.endTimeMsec);
        this.logExecInfo("End Time: " + AbstractSchedulerOperation.formatExecTime(this.getExpirationDate()) + ", Time Window: " + TaskList.formatInterval(this.taskListWindowMsec) + ", Remaining Time: " + TaskList.formatInterval(this.remainingTimeMsec) + ".");
    }

    private long getTaskListWindowMsec() {
        return this.taskListWindow > 0L ? this.taskListWindowUnit.toMillis(this.taskListWindow) : this.taskListWindow.longValue();
    }

    private long getEndTimeMsec(long startTimeMsec) {
        return this.isInfiniteTaskListWindow() ? -1L : startTimeMsec + this.taskListWindowMsec;
    }

    boolean isTimeExpired() {
        this.calculateRemainingTime();
        if (this.isTimeExpired(this.remainingTimeMsec)) {
            this.logExecInfo("Execution Time expired.");
            return true;
        }
        return false;
    }

    private boolean isTimeExpired(long remainingTimeMsec) {
        return this.expiresImmediately || !this.isInfiniteTaskListWindow() && remainingTimeMsec <= 0L;
    }

    private void calculateRemainingTime() {
        this.remainingTimeMsec = this.getRemainingTime(this.endTimeMsec);
        this.logExecInfo("Total Remaining Time: " + TaskList.formatInterval(this.remainingTimeMsec) + ".");
    }

    private long getRemainingTime(long endTimeMsec) {
        return this.isInfiniteTaskListWindow() && !this.expiresImmediately ? -1L : endTimeMsec - System.currentTimeMillis();
    }

    long adjustTimeAgainstTaskListWindow(long timeMsec) {
        return this.isInfiniteTaskListWindow() ? timeMsec : (timeMsec > 0L ? Math.min(this.remainingTimeMsec, timeMsec) : this.remainingTimeMsec);
    }

    private static void resolvePendingTask(ExecNode node, TaskState completionState) {
        TaskList.resolvePendingTask(node.pendingTasks, completionState);
    }

    private static void resolvePendingTask(Map<String, AbstractTask> tasks, TaskState completionState) {
        TaskList.resolvePendingTask(tasks.values(), completionState);
    }

    private static void resolvePendingTask(Collection<AbstractTask> tasks, TaskState completionState) {
        tasks.forEach(task -> task.execution.setStates(task.getState(TaskState.SKIPPED), completionState));
    }

    void resetTaskExecutions() {
        this.doResetTaskExecutions(this.tasks);
        this.doResetTaskExecutions(this.exceptionTasks);
    }

    void doResetTaskExecutions(List<AbstractTask> tasks) {
        tasks.forEach(AbstractTask::reset);
    }

    public TaskListExecution getExecution() {
        return this.execution;
    }

    public TaskListExecution getLastExecution() {
        return this.scheduler.getLastExecution(this.getOID());
    }

    public TaskListExecution getExecution(String eid) throws SchedulerException {
        return this.scheduler.getExecution(this.getOID(), eid);
    }

    public List<TaskListExecution> getExecutions() throws SchedulerException {
        return this.getExecutions(true);
    }

    public List<TaskListExecution> getExecutions(boolean orderByAsc) throws SchedulerException {
        return this.scheduler.getExecutions(this.getOID(), orderByAsc);
    }

    public List<TaskListExecution> getExecutions(Date fromTime, Date toTime) throws SchedulerException {
        return this.getExecutions(fromTime, toTime, true);
    }

    public List<TaskListExecution> getExecutions(Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        return this.scheduler.getExecutions(this.getOID(), fromTime, toTime, orderByAsc);
    }

    public List<TaskListExecution> getExecutions(Date fromTime, Date toTime, String condition) throws SchedulerException {
        return this.scheduler.getExecutions(this.getOID(), fromTime, toTime, condition);
    }

    public List<TaskListExecution> getExecutions(String condition) throws SchedulerException {
        return this.getExecutions(null, null, condition);
    }

    public List<TaskListExecution> getLastExecutions(int count) throws SchedulerException {
        return this.getLastExecutions(count, false);
    }

    public List<TaskListExecution> getLastExecutions(int count, boolean orderByAsc) throws SchedulerException {
        return this.scheduler.getLastExecutions(this.getOID(), count, orderByAsc);
    }

    public void setPostComplete(Date endTime) throws SchedulerException {
        this.setPostComplete(null, endTime);
    }

    public void setPostComplete(String eid, Date endTime) throws SchedulerException {
        this.scheduler.setPostCompleteState(this.getOID(), eid, null, endTime, this.currentUser);
    }

    public void setPostCompleteTask(String taskName, Date endTime) throws SchedulerException {
        this.setPostCompleteTask(null, taskName, endTime);
    }

    public void setPostCompleteTask(String eid, String taskName, Date endTime) throws SchedulerException {
        if (StringUtils.isEmpty(taskName)) {
            throw new SchedulerException(6005, "Task name cannot be null or empty.");
        }
        this.scheduler.setPostCompleteState(this.getOID(), eid, taskName, endTime, this.currentUser);
    }

    public RowSet describeExec(String whereClause) throws SchedulerException {
        DescribeTaskListOperation operation = (DescribeTaskListOperation)this.scheduler.getDSLOperation(DESCRIBE_TASKLIST);
        String command = String.format(DESCRIBE_EXEC_COMMAND, this.getName(), whereClause);
        try {
            return DescribeTaskListOperation.describeExec(operation, command, this.scheduler.getScheduler(this.getOwner()));
        }
        catch (Exception exception) {
            throw new SchedulerException(6151, (Throwable)exception);
        }
    }

    @Override
    protected UUID getEID() {
        return this.execution != null ? this.execution.getEID() : null;
    }

    public Metaset getExecutionMetaset() {
        return this.scheduler.doCopy(this.executionMetaset);
    }

    Metaset doGetExecutionMetaset() {
        return this.executionMetaset;
    }

    @Override
    protected void setExecutionMetaset(Metaset executionMetaset) throws SchedulerException {
        this.doSetExecutionMetaset(this.checkExecutionMetaset(executionMetaset));
    }

    void setNonNullExecutionMetaset(Metaset executionMetaset) throws SchedulerException {
        this.doSetExecutionMetaset(this.checkNonNullExecutionMetaset(executionMetaset));
    }

    void doSetExecutionMetaset(Metaset executionMetaset) throws SchedulerException {
        this.executionMetaset = executionMetaset;
    }

    Metaset checkExecutionMetaset(Metaset executionMetaset) throws SchedulerException {
        if (executionMetaset == null) {
            if (this.metasetId != null) {
                executionMetaset = this.getMetasetInstance();
                return executionMetaset != null ? executionMetaset : this.scheduler.newMetasetInstance(this.metasetId);
            }
            return new Metaset(this.getName() + "$ExecutionMetaset", this.currentUser);
        }
        return this.checkNonNullExecutionMetaset(executionMetaset);
    }

    Metaset checkNonNullExecutionMetaset(Metaset executionMetaset) throws SchedulerException {
        if (this.metasetId != null) {
            this.checkMetasetModel(executionMetaset);
            return this.scheduler.doCopy(executionMetaset);
        }
        throw new SchedulerException(6152, this.toLogNameWithPrefix() + " has no associated Metaset.");
    }

    @Override
    protected Object resolveMetaset(String source) {
        if (this.metasetId != null || this.executionMetaset != null) {
            return this.doResolveMetaset(source, this.executionMetaset != null ? this.executionMetaset : this.scheduler.getMetaset(this.metasetId));
        }
        return source;
    }

    private Object doResolveMetaset(String source, Metaset metaset) {
        int iMetasetEnd;
        int iMetasetStart = source.indexOf(METASET_START);
        if (iMetasetStart != -1 && (iMetasetEnd = source.indexOf(METASET_END, iMetasetStart + METASET_END.length())) != -1) {
            return metaset.get(source.substring(iMetasetStart + METASET_START.length(), iMetasetEnd));
        }
        return source;
    }

    @Override
    protected void stop() throws SchedulerException {
        this.logInfo("Trying to forcible stop " + this.toLogNameWithPrefix() + "...");
        this.setInterrupted(true);
        if (this.executedTask != null) {
            this.executedTask.stop();
        }
        this.wakeUp();
        this.destroyCompletionEventReceiver();
    }

    private synchronized boolean isInterrupted() {
        return this.isInterrupted;
    }

    private synchronized void setInterrupted(boolean isInterrupted) {
        this.isInterrupted = isInterrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionState sleep(long delay, AbstractTask task, ExecutionListener listener, boolean forUndo) {
        if (delay > 0L) {
            try {
                if (this.isTimeExpired()) {
                    CompletionState completionState = CompletionState.TASKLIST_EXPIRED;
                    return completionState;
                }
                this.isSleeping = true;
                if (forUndo) {
                    task.onDelay(SchedulerAdvisoryType.TASK_UNDO_DELAY_STARTED, listener, ExecutionListener::onTaskUndoDelayStarted, delay);
                } else {
                    task.onDelay(SchedulerAdvisoryType.TASK_DELAY_STARTED, listener, ExecutionListener::onTaskDelayStarted, delay);
                }
                if (!Utils.sleepNoInterrupt(this.adjustTimeAgainstTaskListWindow(delay * 1000L))) {
                    CompletionState completionState = CompletionState.TASKLIST_INTERRUPTED;
                    return completionState;
                }
                if (this.isTimeExpired()) {
                    CompletionState completionState = CompletionState.TASKLIST_EXPIRED;
                    return completionState;
                }
            }
            finally {
                this.isSleeping = false;
            }
            if (forUndo) {
                task.onExecution(SchedulerAdvisoryType.TASK_UNDO_DELAY_COMPLETED, listener, ExecutionListener::onTaskUndoDelayCompleted);
            } else {
                task.onExecution(SchedulerAdvisoryType.TASK_DELAY_COMPLETED, listener, ExecutionListener::onTaskDelayCompleted);
            }
        }
        return null;
    }

    private void wakeUp() {
        if (this.isSleeping && this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void complete() throws SchedulerException {
        this.complete(null, null);
    }

    public void complete(String eventKey, String correlationId) throws SchedulerException {
        this.doComplete(eventKey, correlationId, false);
    }

    public void fail() throws SchedulerException {
        this.fail(null, null);
    }

    public void fail(String eventKey, String correlationId) throws SchedulerException {
        this.doComplete(eventKey, correlationId, true);
    }

    private void doComplete(String eventKey, String correlationId, boolean failed) throws SchedulerException {
        HashMap<String, Object> facets = null;
        if (!StringUtils.isEmpty(eventKey) || !StringUtils.isEmpty(correlationId)) {
            facets = new HashMap<String, Object>();
            if (!StringUtils.isEmpty(eventKey)) {
                facets.put("eventKey", eventKey);
            }
            if (!StringUtils.isEmpty(correlationId)) {
                facets.put("correlationId", correlationId);
            }
        }
        this.scheduler.completeTask(null, this.getName(), null, this.getOwner(), facets, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TaskListState resume() throws SchedulerException {
        TaskListExecution execution = this.getLastExecution();
        if (execution != null && !execution.isCompleted()) {
            this.logInfo("Last Execution was not completed. Trying to resume...");
            if (execution.getUntilTime() != null) {
                this.endTimeMsec = execution.getUntilTime().getTime();
                if (execution.getUntilTime().before(execution.getStartTime())) {
                    this.expiresImmediately = true;
                }
            }
            this.calculateEndTime(execution.getStartTime());
            if (this.isTimeExpired(this.remainingTimeMsec)) {
                return this.interruptExecution(execution, "Last Execution time expired. Moving to interrupted state...");
            }
            if (!this.isUnordered()) return this.interruptExecution(execution, "Moving to interrupted state...");
            try {
                this.execution = execution;
                this.execution.init(this);
                this.tasks.forEach(task -> {
                    task.execution = execution.getTaskExecution(task.getName());
                });
                this.setExecutionMetaset();
                this.initExecutionContext();
                if (this.isScheduled()) {
                    return this.doResume();
                }
                FabricThreadManager.getInstance().createThread("FSYS:Scheduler.Executor:TaskList", "Resumes a task list.", () -> this.doResume()).start();
                return TaskListState.COMPLETED;
            }
            catch (SchedulerException exception) {
                this.interruptExecution(execution, "Resuming Last Execution failed. Moving to interrupted state...");
                throw exception;
            }
        } else {
            this.logError("Last Execution was not found or marked as completed, but state is RUNNING. Moving to ENABLED state...");
            this.doEnable();
            this.state = TaskListState.ENABLED;
            this.updateInStorage();
        }
        return TaskListState.COMPLETED;
    }

    private void setExecutionMetaset() throws SchedulerException {
        if (this.metaset != null) {
            Map<String, Object> values = this.execution.doGetAfterMetasetValues();
            if (values == null) {
                values = this.execution.doGetBeforeMetasetValues();
            }
            if (values != null) {
                this.executionMetaset = this.metaset.clone();
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    this.executionMetaset.set(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private TaskListState doResume() {
        this.setExecutionThread();
        return (TaskListState)((Object)this.doExecute(null, (boolean)true).second);
    }

    void interruptExecution(String message) {
        TaskListExecution execution = this.getLastExecution();
        if (execution != null && !execution.isCompleted()) {
            this.interruptExecution(execution, message);
        }
    }

    private TaskListState interruptExecution(TaskListExecution execution, String message) {
        this.logInfo(message);
        execution.interruptCompletion(this);
        this.clearExecutionTimes();
        this.setNotRunning();
        return TaskListState.EXPIRED;
    }

    @Override
    protected void checkEnabled() throws SchedulerException {
        if (this.state == TaskListState.DISABLED) {
            throw new SchedulerException(6139, this.toLogNameWithPrefix() + " is disabled.");
        }
    }

    @Override
    protected void checkDisabled() throws SchedulerException {
        if (this.state != TaskListState.DISABLED) {
            throw new SchedulerException(6138, this.toLogNameWithPrefix() + " is enabled and cannot be changed.");
        }
    }

    @Override
    protected boolean isRunning() {
        return this.state == TaskListState.RUNNING || this.state == TaskListState.TASK_RUNNING;
    }

    @Override
    protected void checkNotRunning() throws SchedulerException {
        if (this.isRunning()) {
            throw new SchedulerException(6140, this.toLogNameWithPrefix() + " is running.");
        }
    }

    protected void checkRunning() throws SchedulerException {
        if (!this.isRunning()) {
            throw new SchedulerException(6141, this.toLogNameWithPrefix() + " is not running.");
        }
    }

    @Override
    protected void setRunning() {
        this.setRunning(false);
    }

    protected void setRunning(boolean fromTask) {
        this.state = fromTask ? TaskListState.TASK_RUNNING : TaskListState.RUNNING;
        this.updateInStorage();
    }

    @Override
    protected void setNotRunning() {
        if (this.state != TaskListState.DISABLED) {
            this.state = TaskListState.ENABLED;
            this.updateInStorage();
        }
    }

    @Override
    protected void checkExecutionMode(ExecutionMode executionMode) throws SchedulerException {
        if (this.isScheduled() && executionMode != ExecutionMode.SCHEDULED) {
            throw new SchedulerException(6143, this.toLogNameWithPrefix() + " is scheduled and cannot be executed directly.");
        }
    }

    void onCompletionStarted(ExecutionListener listener) {
        if (listener != null) {
            listener.onTaskListWaiting(this, this.execution);
        }
    }

    void onExecution(SchedulerAdvisoryType type, Map<String, Object> facets, ExecutionListener listener, ListenerHelper listenerHelper) {
        if (listener != null) {
            listenerHelper.listen(listener, this, this.execution);
        }
        this.raiseAdvisory(type, this.execution, facets);
    }

    private void raiseAdvisory(SchedulerAdvisoryType type, TaskListExecution execution, Map<String, Object> facets) {
        this.raiseAdvisory(type, null, execution, facets, null);
    }

    void raiseAdvisory(SchedulerAdvisoryType type, Task task, TaskListExecution execution, Map<String, Object> facets, Long delay) {
        if (execution != null && execution.getExecutionMode() == ExecutionMode.SCHEDULED && this.job != null) {
            this.job.raiseAdvisory(type, task, execution, facets, delay);
        } else {
            this.scheduler.raiseAdvisory(type, null, this.getName(), task != null ? task.getName() : null, execution, facets, delay, this.getEventScope());
        }
    }

    void raiseException(Throwable cause, Task task, TaskListExecution execution) {
        if (execution != null && execution.getExecutionMode() == ExecutionMode.SCHEDULED && this.job != null) {
            this.job.raiseException(cause, task, execution);
        } else {
            this.scheduler.raiseException(cause, null, this.getName(), task != null ? task.getName() : null, execution, this.getEventScope());
        }
    }

    @Override
    protected void initExecutionContext() throws SchedulerException {
        this.initCompletionEventReceiver();
        this.initDataspaceAccessorProvider();
    }

    private void initCompletionEventReceiver() throws SchedulerException {
        try {
            if (this.isManuallyCompleted()) {
                this.completionEventReceiver = this.scheduler.createCompletionEventReceiver(this);
            }
        }
        catch (SchedulerException exception) {
            this.execution.setFailed(Utils.formatException(exception, "\n"), exception.getErrorCode());
            throw exception;
        }
    }

    private void destroyExecutionContext() {
        this.destroyCompletionEventReceiver();
        this.destroyDataspaceAccessorProvider();
    }

    private void destroyCompletionEventReceiver() {
        if (this.completionEventReceiver != null) {
            this.completionEventReceiver.close();
            this.completionEventReceiver = null;
        }
    }

    private void initDataspaceAccessorProvider() {
        this.dataspaceAccessorProvider = new DataspaceAccessorProviderForTaskList(this.transacted);
    }

    private void destroyDataspaceAccessorProvider() {
        if (this.dataspaceAccessorProvider != null) {
            this.dataspaceAccessorProvider.close();
            this.dataspaceAccessorProvider = null;
        }
    }

    DataspaceAccessorProviderForTaskList getDataspaceAccessorProvider() {
        return this.dataspaceAccessorProvider;
    }

    @Override
    protected void doUpdateInStorage() {
        this.scheduler.doUpdate(this);
    }

    void updateExecution(TaskListExecution execution) {
        this.scheduler.doUpdate(this.getOID(), execution);
    }

    public synchronized RuleSet addRuleSet(String name, String description, String taskName) throws SchedulerException {
        this.checkRuleSetName(name);
        AbstractTask task = this.getTaskWithCheck(taskName);
        this.checkAbsenceRuleSet(task, "");
        this.checkAbsenceNextTaskAfter(task.getOID(), taskName);
        RuleSet result = new RuleSet(name, description);
        task.setRuleSet(result);
        return result;
    }

    void checkRuleSetName(String ruleSetName) throws SchedulerException {
        TaskList.doCheckName(ruleSetName, this::existsRuleSet, "Rule Set", 6157);
    }

    static void doCheckName(String name, Predicate<String> existencePredicate, String namePrefix, int errorCode) throws SchedulerException {
        SchedulerImpl.checkName(name);
        if (existencePredicate.test(name)) {
            throw new SchedulerException(errorCode, namePrefix + " " + TaskList.toLogName(name) + " already exists.");
        }
    }

    public synchronized void removeRuleSet(String name) {
        this.tasks.stream().filter(task -> TaskList.hasRuleSet(task, name)).findFirst().ifPresent(task -> task.setRuleSet(null));
    }

    public RuleSet getRuleSet(String name) {
        return this.tasks.stream().filter(task -> TaskList.hasRuleSet(task, name)).findFirst().map(AbstractTask::getRuleSet).orElse(null);
    }

    public synchronized boolean existsRuleSet(String name) {
        return this.tasks.stream().anyMatch(task -> TaskList.hasRuleSet(task, name));
    }

    public synchronized List<String> listRules() {
        return this.tasks.stream().filter(AbstractTask::hasRuleSet).map(task -> task.getRuleSet().getName()).collect(Collectors.toList());
    }

    public synchronized List<RuleSet> getRuleSets() {
        return this.tasks.stream().filter(AbstractTask::hasRuleSet).map(AbstractTask::getRuleSet).collect(Collectors.toList());
    }

    public synchronized RuleSet getRuleSetByExecTask(UUID taskOID) {
        return this.tasks.stream().filter(AbstractTask::hasRuleSet).filter(task -> task.getRuleSet().existsRuleByExecTask(taskOID)).findFirst().map(AbstractTask::getRuleSet).orElse(null);
    }

    void checkAbsenceNextTaskAfter(UUID taskOID, String taskName) throws SchedulerException {
        String afterTask = taskOID == Task.START_TASK_OID ? "Start" : "Task " + TaskList.toLogName(taskName);
        Task nextTask = this.getNextTaskAfter(taskOID);
        if (nextTask != null) {
            throw new SchedulerException(6147, "State Transition after " + afterTask + " already exists (" + TaskList.toLogName(taskName) + " -> " + TaskList.toLogName(nextTask) + ").");
        }
    }

    void checkAbsenceRuleSet(AbstractTask task, String extendedError) throws SchedulerException {
        if (task.hasRuleSet()) {
            throw new SchedulerException(6161, "Task " + TaskList.toLogName(task) + " has Rule Set." + extendedError);
        }
    }

    void checkAbsenceRuleSetByExecTask(Task execTask) throws SchedulerException {
        RuleSet ruleSet = this.getRuleSetByExecTask(execTask.getOID());
        if (ruleSet != null) {
            throw new SchedulerException(6147, "Conditional State Transition to Task " + TaskList.toLogName(execTask) + " already exists (in Rule Set " + TaskList.toLogName(ruleSet) + ").");
        }
    }

    private static boolean hasRuleSet(AbstractTask task, String ruleSetName) {
        return task.hasRuleSet() && task.getRuleSet().getName().equals(ruleSetName);
    }

    @Override
    public String toString() {
        return this.getName() + "(" + super.toString() + ", state=" + String.valueOf((Object)this.getState()) + ", tasks(" + String.valueOf(this.tasks) + "))";
    }

    @Override
    public TaskList clone() {
        return new TaskList(this, this.currentUser);
    }

    void logExecInfo(String message) {
        this.logInfo((String)(this.execution != null ? "[" + String.valueOf(this.execution.getEID()) + "] " : "") + message);
    }

    @Override
    String toLogNameWithPrefix() {
        return TaskList.toLogNameWithPrefix(this.getName());
    }

    static String toLogNameWithPrefix(String name) {
        return "Task List " + TaskList.toLogName(name);
    }

    static String formatInterval(long interval) {
        return interval > 0L ? interval + " milliseconds" : (interval == -1L ? "infinite" : "none");
    }

    public static class ExecNode {
        AbstractTask task;
        List<AbstractTask> pendingTasks;
        ExecNode nextNodeDirect;
        List<Pair<Rule, ExecNode>> nextNodesConditional;

        ExecNode(AbstractTask task) {
            this.task = task;
            this.pendingTasks = new LinkedList<AbstractTask>();
        }

        ExecNode createNextNode(AbstractTask execTask) {
            this.pendingTasks.add(execTask);
            return new ExecNode(execTask);
        }

        void addPendingNodes(ExecNode nextNode) {
            this.pendingTasks.addAll(nextNode.pendingTasks);
        }

        public Task getTask() {
            return this.task;
        }

        public List<Task> getPendingTasks() {
            return new ArrayList<Task>(this.pendingTasks);
        }

        public ExecNode getNextNodeDirect() {
            return this.nextNodeDirect;
        }

        public List<Pair<Rule, ExecNode>> getNodesConditional() {
            return this.nextNodesConditional != null ? new ArrayList<Pair<Rule, ExecNode>>(this.nextNodesConditional) : null;
        }

        public List<List<Pair<String, String>>> getAllExecChains() {
            LinkedList<List<Pair<String, String>>> result = new LinkedList<List<Pair<String, String>>>();
            this.addNodeToExecChain(null, this, new LinkedList<Pair<String, String>>(), result);
            return result;
        }

        private void addNodeToExecChain(Rule rule, ExecNode node, List<Pair<String, String>> chain, List<List<Pair<String, String>>> result) {
            if (node.task == null) {
                return;
            }
            chain.add(new Pair<String, String>(rule != null ? rule.getCondition() : null, node.task.getName()));
            if (node.nextNodeDirect != null) {
                this.addNodeToExecChain(null, node.nextNodeDirect, chain, result);
            } else if (!Utils.isEmpty(node.nextNodesConditional)) {
                for (Pair<Rule, ExecNode> execEntry : node.nextNodesConditional) {
                    this.addNodeToExecChain((Rule)execEntry.first, (ExecNode)execEntry.second, new LinkedList<Pair<String, String>>(chain), result);
                }
            } else {
                result.add(chain);
            }
        }

        public List<Pair<String, String>> testExecution(Metaset metaset) throws SchedulerException {
            LinkedList<Pair<String, String>> result = new LinkedList<Pair<String, String>>();
            this.addNodeToExecChain(null, this, metaset, result);
            return result;
        }

        private void addNodeToExecChain(Rule rule, ExecNode node, Metaset metaset, LinkedList<Pair<String, String>> result) {
            result.add(new Pair<String, String>(rule != null ? rule.getCondition() : null, node.task.getName()));
            if (node.nextNodeDirect != null) {
                this.addNodeToExecChain(null, node.nextNodeDirect, metaset, result);
            } else if (!Utils.isEmpty(node.nextNodesConditional)) {
                LinkedList matchedNodes = node.nextNodesConditional.stream().filter(entry -> ((Rule)entry.first).matchesCondition(metaset)).collect(Collectors.toCollection(LinkedList::new));
                if (matchedNodes.isEmpty()) {
                    result.add(new Pair<Object, String>(null, "No Condition matches Metaset or Completion event."));
                } else if (matchedNodes.size() > 1) {
                    result.add(new Pair<Object, String>(null, "Ambiguity: Multiple Conditions match Metaset or Completion event."));
                } else {
                    Pair entry2 = (Pair)matchedNodes.getFirst();
                    this.addNodeToExecChain((Rule)entry2.first, (ExecNode)entry2.second, metaset, result);
                }
            }
        }

        void setState(TaskState state, TaskState completionState) {
            this.task.execution.setStates(state, completionState);
            this.pendingTasks.forEach(task -> task.execution.setStates(state, completionState));
        }
    }

    private static interface TaskAdder<T> {
        public T get() throws SchedulerException;
    }

    static class ExecutionState {
        Boolean firstTime = true;
        CompletionState completionState = CompletionState.TASKLIST_COMPLETED;

        ExecutionState() {
        }
    }

    public static interface ListenerHelper {
        public void listen(ExecutionListener var1, TaskList var2, TaskListExecution var3);
    }
}

