/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.sef.scheduler.AbstractExecution;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.sef.utils.Utils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class TaskExecution
extends AbstractExecution {
    transient TaskListExecution taskListExecution;
    private String taskName;
    private TaskType taskType;
    private long taskWindow;
    private TimeUnit taskWindowUnit;
    private byte resumptionStates;
    private byte weight;
    private Boolean autoComplete;
    private int undoLimit;
    private TaskState state;
    private Date completionStartTime;
    private Date completionEndTime;
    private TaskState completionState;
    private String errorMessage;
    private int errorCode;
    private int undoCount;
    private transient boolean isUndone = false;
    private transient long undoDelay = 0L;

    TaskExecution(TaskListExecution taskListExecution, AbstractTask task, TaskState state) {
        this.init(taskListExecution);
        this.taskName = task.getName();
        this.taskType = task.getType();
        this.weight = task.doGetWeight();
        this.taskWindow = task.getTaskWindow();
        this.taskWindowUnit = task.getTaskWindowUnit();
        this.resumptionStates = task.getResumptionStates();
        this.autoComplete = task.isAutoComplete();
        this.undoLimit = task instanceof ActionTask ? ((ActionTask)task).getUndoLimit() : 0;
        this.undoCount = 0;
        this.state = state;
        task.execution = this;
    }

    void init(TaskListExecution taskListExecution) {
        this.taskListExecution = taskListExecution;
    }

    void initOnLoad(OldFormatVersion oldFormatVersion) {
        this.autoComplete = true;
    }

    public UUID getEID() {
        return this.taskListExecution.getEID();
    }

    public String getCaller() {
        return this.taskListExecution.getCaller();
    }

    public ExecutionMode getExecutionMode() {
        return this.state == null || this.state == TaskState.SKIPPED ? null : this.taskListExecution.getExecutionMode();
    }

    public String getTaskName() {
        return this.taskName;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public double getWeight() {
        return this.weight > 0 ? (double)this.weight : this.taskListExecution.getNormalizedWeight();
    }

    public long getTaskWindow() {
        return this.taskWindow;
    }

    public TimeUnit getTaskWindowUnit() {
        return this.taskWindowUnit;
    }

    public List<TaskState> listResumptionStates() {
        return AbstractTask.doListResumptionStates(this.resumptionStates);
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public int getUndoCount() {
        return this.undoCount;
    }

    boolean isUnordered() {
        return this.taskListExecution.isUnordered();
    }

    void setStates(TaskState state, TaskState completionState) {
        this.doSetState(state);
        if (!this.isAutoComplete()) {
            this.doSetCompletionState(completionState);
            if (this.isUnordered()) {
                this.doSetCompletionEndTime();
            } else if (completionState == TaskState.COMPLETED || completionState == TaskState.FAILED) {
                this.doSetCompletionStartTime();
                this.doSetCompletionEndTime(this.completionStartTime);
            }
        }
        this.update();
    }

    public TaskState getState() {
        return this.state;
    }

    public TaskState getExecutionState() {
        return this.getState();
    }

    void doSetState(TaskState state) {
        this.state = state;
    }

    public TaskState getCompletionState() {
        return this.completionState;
    }

    void doSetCompletionState(TaskState state) {
        this.completionState = state;
    }

    public Date getCompletionStartTime() {
        return this.completionStartTime;
    }

    void doSetCompletionStartTime(Date startTime) {
        this.completionStartTime = startTime;
    }

    private void doSetCompletionStartTime() {
        this.doSetCompletionStartTime(new Date());
    }

    public Date getCompletionEndTime() {
        return this.completionEndTime;
    }

    void doSetCompletionEndTime(Date endTime) {
        this.completionEndTime = endTime;
    }

    private void doSetCompletionEndTime() {
        this.doSetCompletionEndTime(new Date());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    void doSetErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    void doSetErrorCode(Integer errorCode) {
        this.errorCode = errorCode != null ? errorCode : 0;
    }

    void onExecutionStarted(Date startTime, TaskState state) {
        this.doSetState(state);
        this.doSetStartTime(startTime);
        if (this.autoComplete.booleanValue()) {
            this.taskListExecution.addExecutedTask(this);
        }
        this.update();
    }

    void onExecutionCompleted() {
        this.doSetState(TaskState.EXECUTION_COMPLETED);
        this.doSetEndTime();
        this.taskListExecution.setAfterMetasetValues();
        this.update();
    }

    void onExecutionExpired() {
        this.doSetError(TaskState.EXECUTION_EXPIRED, null, null);
        this.update();
    }

    void onExecutionFailed(String errorMessage, int errorCode) {
        this.doSetError(TaskState.EXECUTION_EXCEPTION, errorMessage, errorCode);
        this.update();
    }

    void onExecutionInterrupted(String errorMessage, Integer errorCode) {
        this.doSetError(TaskState.EXECUTION_INTERRUPTED, errorMessage, errorCode);
        this.update();
    }

    void doSetError(String errorMessage, Integer errorCode) {
        this.doSetEndTime();
        this.doSetErrorMessage(errorMessage);
        this.doSetErrorCode(errorCode);
    }

    private void doSetError(TaskState state, String errorMessage, Integer errorCode) {
        this.doSetState(state);
        this.doSetError(errorMessage, errorCode);
    }

    void onCompletionStarted() {
        this.doSetCompletionState(TaskState.WAITING_COMPLETION);
        this.doSetCompletionStartTime();
        this.taskListExecution.addExecutedTask(this);
        this.update();
    }

    void onCompletionCompleted(boolean forTaskList, Map<String, Object> facets) {
        this.onCompletion(TaskState.COMPLETED, false, forTaskList ? null : facets);
        if (forTaskList) {
            this.taskListExecution.doSetFacets(facets);
        }
    }

    void onCompletionFailed(boolean skipExecution, boolean forTaskList, Map<String, Object> facets) {
        this.onCompletion(TaskState.FAILED, skipExecution, forTaskList ? null : facets);
        if (forTaskList) {
            this.taskListExecution.doSetFacets(facets);
        }
    }

    void onCompletionExpired(boolean skipExecution) {
        this.onCompletion(TaskState.EXPIRED_INCOMPLETE, skipExecution, null);
    }

    void onCompletionInterrupted(boolean skipExecution) {
        this.onCompletion(TaskState.INTERRUPTED_INCOMPLETE, skipExecution, null);
    }

    private void onCompletion(TaskState state, boolean skipExecution, Map<String, Object> facets) {
        this.doSetCompletionState(state);
        this.doSetCompletionEndTime();
        this.doSetFacets(facets);
        if (skipExecution) {
            this.doSetState(TaskState.SKIPPED);
        }
        this.update();
    }

    boolean isUndone() {
        return this.isUndone;
    }

    void setUndone(long undoDelay) {
        this.isUndone = true;
        this.undoDelay = undoDelay;
        ++this.undoCount;
    }

    void resetUndone() {
        this.isUndone = false;
        this.undoDelay = 0L;
    }

    boolean isNeverUndone() {
        return this.undoCount == 0;
    }

    long getUndoDelay() {
        return this.undoDelay;
    }

    private void update() {
        this.taskListExecution.update();
    }

    @Override
    public TaskExecution clone() {
        return (TaskExecution)super.clone();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof TaskExecution && Utils.equalsNullSafe(this.taskName, ((TaskExecution)other).taskName);
    }

    public String toString() {
        return this.taskName + "(state=" + String.valueOf((Object)this.state) + ")";
    }
}

