/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.ExecutableObject;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public interface Task
extends ExecutableObject {
    public static final String START_TASK_NAME = "Start";
    public static final UUID START_TASK_OID = new UUID(0L, 0L);

    public static String getFullName(String listName, String taskName) {
        return listName + "." + taskName;
    }

    @Override
    public String getOwner();

    public TaskType getType();

    public TaskList getTaskList();

    public UUID getAfterTaskOID();

    public String getAfterTaskName();

    public void setAfterTask(String var1) throws SchedulerException;

    public Task getPrecedent();

    public Task getConsequent();

    public RuleSet getRuleSet();

    public Long getTaskWindow();

    @Override
    public void setTaskWindow(long var1);

    public TimeUnit getTaskWindowUnit();

    @Override
    public void setTaskWindowUnit(TimeUnit var1) throws SchedulerException;

    public boolean isResumptionEnabledOn(TaskState var1);

    public boolean isResumptionEnabledTotally();

    public List<TaskState> listResumptionStates();

    @Override
    public void enableResumptionOn(TaskState var1) throws SchedulerException;

    @Override
    public void enableResumptionTotally() throws SchedulerException;

    @Override
    public void disableResumptionOn(TaskState var1) throws SchedulerException;

    @Override
    public void disableResumptionTotally() throws SchedulerException;

    public double getWeight();

    public void setWeight(byte var1) throws SchedulerException;

    public boolean isAutoComplete();

    public TaskState getState();

    public TaskExecution getExecution();

    public List<String> listEventIds();

    public ExceptionTask getExceptionTask();

    public Throwable getLastException();

    public int getOrder();

    public void undo() throws SchedulerException;

    public void undo(long var1) throws SchedulerException;
}

