/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.ds.schema.collection.CollectionMetaData;
import com.streamscape.ds.schema.collection.Tuple;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.java.SerialSupport;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dispatcher.AbstractSystemStore;
import com.streamscape.sef.scheduler.AbstractExecutableObject;
import com.streamscape.sef.scheduler.AbstractExecution;
import com.streamscape.sef.scheduler.AbstractJob;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.EventTask;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.SchedulerObject;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TemplateType;
import com.streamscape.sef.scheduler.trigger.SystemTaskFactory;
import com.streamscape.sef.scheduler.trigger.SystemTaskImpl;
import com.streamscape.sef.scheduler.trigger.SystemTaskTriggerImpl;
import com.streamscape.sef.utils.RepositoryUtils;
import com.streamscape.sef.utils.Utils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Triple;

class SchedulerStore
extends AbstractSystemStore {
    private static final String TIME_WINDOWS_TABLE_NAME = "TIME_WINDOWS";
    private static final String METASETS_TABLE_NAME = "SCHEDULER_METASETS";
    private static final String METASET_INSTANCES_TABLE_NAME = "SCHEDULER_METASET_INSTANCES";
    private static final String TASK_LISTS_TABLE_NAME = "SCHEDULER_TASK_LISTS";
    private static final String JOBS_TABLE_NAME = "SCHEDULER_JOBS";
    private static final String EXECUTIONS_TABLE_NAME = "SCHEDULER_EXECUTIONS";
    private static final String TRIGGERS_TABLE_NAME = "SCHEDULER_EVENT_TRIGGERS";
    private static final String TEMPLATES_TABLE_NAME = "SCHEDULER_TEMPLATES";
    private SchedulerImpl scheduler;
    private Map<String, TimeWindow> timeWindows = new ConcurrentHashMap<String, TimeWindow>();
    private Map<UUID, Metaset> metasets = new ConcurrentHashMap<UUID, Metaset>();
    private Map<UUID, TaskList> taskLists = new ConcurrentHashMap<UUID, TaskList>();
    private Map<UUID, AbstractJob> jobs = new ConcurrentHashMap<UUID, AbstractJob>();
    private Map<UUID, EventTaskTrigger> triggers = new ConcurrentHashMap<UUID, EventTaskTrigger>();
    private JSONSerializer serializer;

    SchedulerStore(SchedulerImpl scheduler) throws Exception {
        super("SCH");
        this.scheduler = scheduler;
        this.serializer = ((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder(SchedulerStore.getContext().getJSONSerializer()).setName("sys$Scheduler")).setSkipNulls(true)).build();
        scheduler.initEmailSerializer(this.serializer);
    }

    void init() throws Exception {
        if (this.accessor != null) {
            this.convertDataInSDSDataspace();
            this.migrateSDSToSCH();
            this.dropOldTables();
            this.createTables();
            this.alterTablesAddModified();
            this.initTimeWindows();
            this.initMetasets();
            this.initTaskLists(false);
            this.initJobs();
            this.initTriggers();
        }
    }

    void open() {
        if (this.accessor != null) {
            Map<UUID, TaskList> runningTaskLists = this.enableTaskLists();
            List<AbstractJob> runningJobs = this.enableJobs(runningTaskLists);
            this.resumeJobs(runningJobs);
            this.resumeTaskLists(runningTaskLists);
            this.enableTriggers();
        }
    }

    protected void createTables() throws Exception {
        this.createTimeWindowsTable();
        this.createMetasetsTable();
        this.createMetasetInstancesTable();
        this.createTaskListsTable();
        this.createExecutionsTable();
        this.createJobsTable();
        this.createTemplatesTable();
        this.createTriggersTable();
    }

    protected void alterTablesAddModified() throws Exception {
        this.addModifiedColumnToTable(TIME_WINDOWS_TABLE_NAME);
        this.addModifiedColumnToTable(METASETS_TABLE_NAME);
        this.addModifiedColumnToTable(TASK_LISTS_TABLE_NAME);
        this.addModifiedColumnToTable(JOBS_TABLE_NAME);
        this.addModifiedColumnToTable(EXECUTIONS_TABLE_NAME);
        this.addModifiedColumnToTable(TRIGGERS_TABLE_NAME);
        this.addModifiedColumnToTable(TEMPLATES_TABLE_NAME);
    }

    private void initMetasets() throws SchedulerException {
        Trace.logInfo(this, "Loading Metasets...");
        try {
            ArrayList<String> invalidMetasets = new ArrayList<String>();
            RowSet rowSet = this.getTableWithCheck(METASETS_TABLE_NAME);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    this.initMetaset((Metaset)this.getData(rowSet));
                }
                catch (SchedulerException exception) {
                    Trace.logException(this, exception, true);
                    String oid = rowSet.getObject("OID").toString();
                    invalidMetasets.add(oid);
                    Trace.logError(this, "Initialization of Metaset [" + oid + "] failed. It will be removed.");
                }
            }
            for (String oid : invalidMetasets) {
                this.removeMetaset(UUID.fromString(oid));
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Loading Metasets failed.", exception);
        }
        Trace.logInfo(this, "Metasets loaded.");
    }

    private void initMetaset(Metaset metaset) throws SchedulerException {
        this.metasets.put(metaset.getOID(), metaset);
        metaset.initOnLoad(this.scheduler, null);
    }

    private void initTaskLists(boolean fromSDS) throws SchedulerException {
        OldFormatVersion version = null;
        String logFromSDS = fromSDS ? " from SDS" : "";
        try {
            Trace.logInfo(this, "Loading Task Lists" + logFromSDS + "...");
            ArrayList<String> invalidTaskLists = new ArrayList<String>();
            Pair<RowSet, OldFormatVersion> table = this.loadTaskLists();
            ((RowSet)table.first).beforeFirst();
            while (((RowSet)table.first).next()) {
                try {
                    this.initTaskList((TaskList)this.getData((RowSet)table.first), (OldFormatVersion)((Object)table.second));
                }
                catch (SchedulerException exception) {
                    Trace.logException(this, exception, true);
                    String oid = ((RowSet)table.first).getObject("OID").toString();
                    invalidTaskLists.add(oid);
                    Trace.logError(this, "Initialization of Task List [" + oid + "] failed. It will be removed.");
                }
            }
            for (String oid : invalidTaskLists) {
                this.removeTaskList(UUID.fromString(oid));
            }
            Trace.logInfo(this, "Task Lists loaded" + logFromSDS + ".");
            version = (OldFormatVersion)((Object)table.second);
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Loading Task Lists failed.", exception);
        }
        if (version == OldFormatVersion.FORMAT_2023_1) {
            this.loadTaskExecutionsFromOldFormatInSDS_2023_1();
        } else if (version == OldFormatVersion.FORMAT_2023_2) {
            this.loadTaskExecutionsFromOldFormatInSDS_2023_2();
        } else if (version == OldFormatVersion.FORMAT_2024_1) {
            this.loadTaskExecutionsFromOldFormat_2024_1();
        } else {
            this.loadTaskExecutions();
        }
    }

    private Pair<RowSet, OldFormatVersion> loadTaskLists() throws SchedulerException {
        try {
            return Pair.of(this.getTableWithCheck(TASK_LISTS_TABLE_NAME), null);
        }
        catch (Throwable exception) {
            RowSet result = this.loadTaskListsFromOldFormat_2024_1();
            if (result == null) {
                result = this.loadTaskListsFromOldFormat_2023_2();
                if (result == null) {
                    result = this.loadTaskListsFromOldFormat_2023_1();
                    if (result == null) {
                        result = this.loadTaskListsFromOldFormat_2022();
                        if (result == null) {
                            throw exception;
                        }
                        return Pair.of(result, OldFormatVersion.FORMAT_2022);
                    }
                    return Pair.of(result, OldFormatVersion.FORMAT_2023_1);
                }
                return Pair.of(result, OldFormatVersion.FORMAT_2023_2);
            }
            return Pair.of(result, OldFormatVersion.FORMAT_2024_1);
        }
    }

    private OldFormatVersion loadTaskExecutions() throws SchedulerException {
        try {
            this.checkTable(EXECUTIONS_TABLE_NAME);
        }
        catch (Throwable exception) {
            RowSet result = this.loadTaskExecutionsFromOldFormat_2024_4();
            if (result == null) {
                result = this.loadTaskExecutionsFromOldFormat_2024_3();
                if (result == null) {
                    result = this.loadTaskExecutionsFromOldFormat_2024_2();
                    if (result == null) {
                        throw exception;
                    }
                    return OldFormatVersion.FORMAT_2024_2;
                }
                return OldFormatVersion.FORMAT_2024_3;
            }
            return OldFormatVersion.FORMAT_2024_4;
        }
        return null;
    }

    private void initTaskList(TaskList taskList, OldFormatVersion oldFormatVersion) throws SchedulerException {
        this.taskLists.put(taskList.getOID(), taskList);
        taskList.initOnLoad(this.scheduler, oldFormatVersion);
    }

    private Map<UUID, TaskList> enableTaskLists() {
        HashMap<UUID, TaskList> runningTaskLists = new HashMap<UUID, TaskList>();
        Trace.logInfo(this, "Enabling Task Lists...");
        for (TaskList taskList : this.taskLists.values()) {
            try {
                if (taskList.getState() != TaskListState.ENABLED && !taskList.isRunning()) continue;
                taskList.enableOnLoad();
                if (!taskList.isRunning()) continue;
                runningTaskLists.put(taskList.getOID(), taskList);
            }
            catch (SchedulerException exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Enabling " + taskList.toLogNameWithPrefix() + " failed. Moved to disabled state.");
            }
        }
        Trace.logInfo(this, "Task Lists enabled.");
        return runningTaskLists;
    }

    private void resumeTaskLists(Map<UUID, TaskList> runningTaskLists) {
        Trace.logInfo(this, "Resuming incomplete Task Lists...");
        for (TaskList taskList : runningTaskLists.values()) {
            try {
                taskList.resume();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Resuming incomplete " + taskList.toLogNameWithPrefix() + " failed.");
            }
        }
    }

    private void initJobs() throws SchedulerException {
        Trace.logInfo(this, "Loading Jobs...");
        try {
            ArrayList<String> invalidJobs = new ArrayList<String>();
            RowSet rowSet = this.getTableWithCheck(JOBS_TABLE_NAME);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    this.initJob((AbstractJob)this.getData(rowSet));
                }
                catch (SchedulerException exception) {
                    Trace.logException(this, exception, true);
                    String oid = rowSet.getObject("OID").toString();
                    invalidJobs.add(oid);
                    Trace.logError(this, "Initialization of Job [" + oid + "] failed. It will be removed.");
                }
            }
            for (String oid : invalidJobs) {
                this.removeJob(UUID.fromString(oid));
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Loading Jobs failed.", exception);
        }
        Trace.logInfo(this, "Jobs loaded.");
    }

    private void initJob(AbstractJob job) throws SchedulerException {
        this.jobs.put(job.getOID(), job);
        job.initOnLoad(this.scheduler, null);
    }

    private List<AbstractJob> enableJobs(Map<UUID, TaskList> runningTaskLists) {
        ArrayList<AbstractJob> runningJobs = new ArrayList<AbstractJob>();
        Trace.logInfo(this, "Enabling Jobs...");
        for (AbstractJob job : this.jobs.values()) {
            try {
                if (job.getState() != JobState.ENABLED || job.enableOnLoad()) continue;
                runningJobs.add(job);
                runningTaskLists.remove(job.getTaskListOID());
            }
            catch (SchedulerException exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Enabling " + job.toLogNameWithPrefix() + " failed. Moved to disabled state.");
                if (!job.taskList.isRunning()) continue;
                job.taskList.interruptExecution("Associated Job disabled. Moving Execution to interrupted state...");
                runningTaskLists.remove(job.getTaskListOID());
            }
        }
        Trace.logInfo(this, "Jobs enabled.");
        return runningJobs;
    }

    private void resumeJobs(List<AbstractJob> runningJobs) {
        Trace.logInfo(this, "Resuming incomplete Jobs...");
        for (AbstractJob job : runningJobs) {
            try {
                job.resume();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Resuming incomplete " + job.toLogNameWithPrefix() + " failed.");
            }
        }
    }

    @Override
    protected void destroy() {
        this.jobs.values().forEach(AbstractJob::destroy);
        this.jobs.clear();
        super.destroy();
    }

    private void createTimeWindowsTable() throws Exception {
        if (this.accessor.lookupCollection(TIME_WINDOWS_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE TIME_WINDOWS(NAME varchar(255) PRIMARY KEY, START_TIME long, END_TIME long, MODIFIED SQLTIMESTAMP)"), "Creating table [TIME_WINDOWS]");
        }
    }

    private void initTimeWindows() throws SchedulerException {
        Trace.logInfo(this, "Loading Time Windows...");
        try {
            RowSet rowSet = this.getTableWithCheck(TIME_WINDOWS_TABLE_NAME);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                TimeWindow window = new TimeWindow(rowSet.getObject("NAME").toString(), new Date((Long)rowSet.getObject("START_TIME")), new Date((Long)rowSet.getObject("END_TIME")));
                this.timeWindows.put(window.getName(), window);
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Loading Time Windows failed.", exception);
        }
        Trace.logInfo(this, "Time Windows loaded.");
    }

    synchronized void addTimeWindow(TimeWindow window) throws SchedulerException {
        if (window.getName() == null) {
            throw new SchedulerException(6007, "Time Window is unnamed.");
        }
        if (this.timeWindows.containsKey(window.getName())) {
            throw new SchedulerException(6119, "Time Window '" + window.getName() + "' already exists.");
        }
        this.doInsertTimeWindow(window);
    }

    synchronized void addOrUpdateTimeWindow(TimeWindow window) throws SchedulerException {
        TimeWindow oldWindow = this.timeWindows.get(window.getName());
        if (oldWindow != null) {
            if (!oldWindow.equals(window)) {
                this.doUpdateTimeWindow(window);
            }
        } else {
            this.doInsertTimeWindow(window);
        }
    }

    private void doInsertTimeWindow(TimeWindow window) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO TIME_WINDOWS VALUES('" + window.getName() + "', " + window.getStartTime().getTime() + ", " + window.getEndTime().getTime() + ", now())"), "Adding Time Window [" + window.getName() + "]");
        this.timeWindows.put(window.getName(), window);
    }

    private static Timestamp toTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    synchronized boolean removeTimeWindow(String name) throws SchedulerException {
        if (this.timeWindows.remove(name) != null) {
            this.checkWithException(this.invokeStatement("DELETE FROM TIME_WINDOWS WHERE NAME='" + name + "'"), "Removing Time Window [" + name + "]");
            return true;
        }
        return false;
    }

    synchronized boolean setTimeWindow(TimeWindow window) throws SchedulerException {
        if (window.getName() == null) {
            throw new SchedulerException(6007, "Time Window is unnamed.");
        }
        TimeWindow oldWindow = this.timeWindows.get(window.getName());
        if (oldWindow == null) {
            throw new SchedulerException(6120, "Time Window [" + window.getName() + "] does not exist.");
        }
        if (!oldWindow.equals(window)) {
            this.doUpdateTimeWindow(window);
            return true;
        }
        return false;
    }

    private void doUpdateTimeWindow(TimeWindow window) throws SchedulerException {
        this.checkWithException(this.invokeStatement("UPDATE TIME_WINDOWS SET START_TIME=" + window.getStartTime().getTime() + ", END_TIME=" + window.getEndTime().getTime() + ", MODIFIED=NOW() WHERE NAME='" + window.getName() + "'"), "Updating Time Window [" + window.getName() + "]");
        this.timeWindows.put(window.getName(), window);
    }

    boolean existsTimeWindow(String name) {
        return this.timeWindows.containsKey(name);
    }

    TimeWindow getTimeWindow(String name) {
        return this.timeWindows.get(name);
    }

    Map<String, TimeWindow> getTimeWindowMap() {
        return this.timeWindows;
    }

    List<TimeWindow> getTimeWindows() {
        return new ArrayList<TimeWindow>(this.timeWindows.values());
    }

    List<String> listTimeWindows() {
        return new ArrayList<String>(this.timeWindows.keySet());
    }

    private void createMetasetsTable() throws Exception {
        if (this.accessor.lookupCollection(METASETS_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_METASETS(OID varchar(36) PRIMARY KEY, DATA Metaset, MODIFIED SQLTIMESTAMP)"), "Creating table [SCHEDULER_METASETS]");
        }
    }

    synchronized void addMetaset(Metaset metaset) throws SchedulerException {
        this.doAddMetaset(metaset);
        this.metasets.put(metaset.getOID(), metaset);
    }

    private void doAddMetaset(Metaset metaset) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_METASETS VALUES('" + String.valueOf(metaset.getOID()) + "', ?, NOW())", metaset), "Adding " + metaset.toLogNameWithPrefix());
    }

    synchronized Metaset removeMetaset(UUID objectId) throws SchedulerException {
        Metaset result = this.metasets.remove(objectId);
        if (result != null) {
            this.doRemoveMetaset(result.getOID(), result.getName());
        }
        return result;
    }

    private void doRemoveMetaset(UUID oid, String name) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_METASETS WHERE OID='" + String.valueOf(oid) + "'"), "Removing " + Metaset.toLogNameWithPrefix(name));
    }

    boolean existsMetaset(UUID objectId) {
        return this.metasets.containsKey(objectId);
    }

    boolean existsMetaset(String name) {
        return this.metasets.values().stream().anyMatch(metaset -> metaset.getName().equals(name));
    }

    Metaset getMetaset(UUID objectId) {
        return this.metasets.get(objectId);
    }

    Metaset getMetaset(String name) {
        return this.metasets.values().stream().filter(metaset -> metaset.getName().equals(name)).findFirst().orElse(null);
    }

    List<Metaset> getMetasets() {
        return new ArrayList<Metaset>(this.metasets.values());
    }

    List<UUID> listMetasetOIDs() {
        return new ArrayList<UUID>(this.metasets.keySet());
    }

    List<String> listMetasetNames() {
        return this.metasets.values().stream().map(NamedObject::getName).collect(Collectors.toList());
    }

    synchronized void updateMetaset(Metaset metaset) throws SchedulerException {
        if (this.metasets.containsKey(metaset.getOID())) {
            this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_METASETS SET DATA=?, MODIFIED=NOW() WHERE OID='" + String.valueOf(metaset.getOID()) + "'", metaset), "Update " + metaset.toLogNameWithPrefix());
            this.metasets.put(metaset.getOID(), metaset);
        }
    }

    private void createMetasetInstancesTable() throws Exception {
        if (this.accessor.lookupCollection(METASET_INSTANCES_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_METASET_INSTANCES(OID varchar(36) PRIMARY KEY, DATA Metaset, MODIFIED SQLTIMESTAMP)"), "Creating table [SCHEDULER_METASET_INSTANCES]");
        }
    }

    synchronized void setMetasetInstance(UUID oid, Metaset metaset) throws SchedulerException {
        if (this.existsMetasetInstance(oid)) {
            this.updateMetasetInstance(oid, metaset);
        } else {
            this.addMetasetInstance(oid, metaset);
        }
    }

    void addMetasetInstance(UUID oid, Metaset metaset) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_METASET_INSTANCES VALUES('" + String.valueOf(oid) + "', ?, NOW())", metaset), "Adding Metaset instance for Task List [" + String.valueOf(oid) + "]");
    }

    void updateMetasetInstance(UUID oid, Metaset metaset) throws SchedulerException {
        this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_METASET_INSTANCES SET DATA=?, MODIFIED=NOW() WHERE OID = '" + String.valueOf(oid) + "'", metaset), "Update Metaset instance for Task List [" + String.valueOf(oid) + "]");
    }

    synchronized void removeMetasetInstance(UUID oid) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_METASET_INSTANCES WHERE OID = '" + String.valueOf(oid) + "'"), "Removing Metaset instance for Task List [" + String.valueOf(oid) + "]");
    }

    Metaset getMetasetInstance(UUID oid) throws SchedulerException {
        try {
            RowSet rowSet = this.doGetMetasetInstance(oid);
            if (rowSet != null && rowSet.getRowCount() == 1) {
                rowSet.first();
                return this.doGetMetasetInstance(rowSet);
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Obtaining Metaset instance for Task List [" + String.valueOf(oid) + "] failed.", exception);
        }
        return null;
    }

    boolean existsMetasetInstance(UUID oid) throws SchedulerException {
        RowSet rowSet = this.doGetMetasetInstance(oid);
        return rowSet != null && !rowSet.isEmpty();
    }

    private RowSet doGetMetasetInstance(UUID oid) throws SchedulerException {
        SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_METASET_INSTANCES WHERE OID='" + String.valueOf(oid) + "'");
        this.checkWithException(response, "Obtaining Metaset instance for Task List [" + String.valueOf(oid) + "]");
        return response.getRowSet();
    }

    Map<UUID, Metaset> getAllMetasetInstances() throws SchedulerException {
        SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_METASET_INSTANCES");
        this.checkWithException(response, "Obtaining Metaset instances");
        HashMap<UUID, Metaset> result = new HashMap<UUID, Metaset>();
        try {
            RowSet rowSet = response.getRowSet();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    result.put(this.getOID(rowSet), this.doGetMetasetInstance(rowSet));
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Obtaining Executions failed.", exception);
        }
        return result;
    }

    private Metaset doGetMetasetInstance(RowSet rowSet) throws SchedulerException {
        try {
            return (Metaset)this.getData(rowSet);
        }
        catch (Exception exception) {
            throw new SchedulerException(6113, (Throwable)exception);
        }
    }

    private void createTaskListsTable() throws Exception {
        if (this.accessor.lookupCollection(TASK_LISTS_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_TASK_LISTS(OID varchar(36) PRIMARY KEY, DATA TaskList, MODIFIED SQLTIMESTAMP)"), "Creating table [SCHEDULER_TASK_LISTS]");
        }
    }

    synchronized void addTaskList(TaskList taskList) throws SchedulerException {
        this.doAddTaskList(taskList);
        this.taskLists.put(taskList.getOID(), taskList);
    }

    private void doAddTaskList(TaskList taskList) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_TASK_LISTS VALUES('" + String.valueOf(taskList.getOID()) + "', ?, NOW())", taskList), "Adding " + taskList.toLogNameWithPrefix());
    }

    synchronized TaskList removeTaskList(UUID objectId) throws SchedulerException {
        TaskList result = this.taskLists.remove(objectId);
        if (result != null) {
            this.doRemoveTaskList(result.getOID(), result.getName());
        }
        return result;
    }

    private void doRemoveTaskList(UUID oid, String name) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_TASK_LISTS WHERE OID='" + String.valueOf(oid) + "'"), "Removing " + TaskList.toLogNameWithPrefix(name));
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "'"), "Removing iterations for " + TaskList.toLogNameWithPrefix(name));
    }

    boolean existsTaskList(UUID objectId) {
        return this.taskLists.containsKey(objectId);
    }

    boolean existsTaskList(String name) {
        return this.taskLists.values().stream().anyMatch(taskList -> taskList.getName().equals(name));
    }

    TaskList getTaskList(UUID objectId) {
        return this.taskLists.get(objectId);
    }

    TaskList getTaskList(String name) {
        return this.taskLists.values().stream().filter(taskList -> taskList.getName().equals(name)).findFirst().orElse(null);
    }

    List<TaskList> getTaskLists() {
        return new ArrayList<TaskList>(this.taskLists.values());
    }

    List<UUID> listTaskListOIDs() {
        return new ArrayList<UUID>(this.taskLists.keySet());
    }

    List<String> listTaskListNames() {
        return this.taskLists.values().stream().map(NamedObject::getName).collect(Collectors.toList());
    }

    synchronized void updateTaskList(TaskList taskList) throws SchedulerException {
        if (this.taskLists.containsKey(taskList.getOID())) {
            this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_TASK_LISTS SET DATA=?, MODIFIED=NOW() WHERE OID='" + String.valueOf(taskList.getOID()) + "'", taskList), "Update " + taskList.toLogNameWithPrefix());
            this.taskLists.put(taskList.getOID(), taskList);
        }
    }

    private void createJobsTable() throws Exception {
        if (this.accessor.lookupCollection(JOBS_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_JOBS(OID varchar(36) PRIMARY KEY, DATA ScheduledJob, MODIFIED SQLTIMESTAMP)"), "Creating table [SCHEDULER_JOBS]");
        }
    }

    synchronized void addJob(AbstractJob job) throws SchedulerException {
        this.doAddJob(job);
        this.jobs.put(job.getOID(), job);
    }

    private void doAddJob(AbstractJob job) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_JOBS VALUES('" + String.valueOf(job.getOID()) + "', ?, NOW())", job), "Adding " + job.toLogNameWithPrefix());
    }

    synchronized AbstractJob removeJob(UUID objectId) throws SchedulerException {
        AbstractJob result = this.jobs.remove(objectId);
        if (result != null) {
            this.doRemoveJob(result.getOID(), result.getName());
        }
        return result;
    }

    private void doRemoveJob(UUID oid, String name) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_JOBS WHERE OID='" + String.valueOf(oid) + "'"), "Removing " + AbstractJob.toLogNameWithPrefix(name));
    }

    boolean existsJob(UUID oid) {
        return this.jobs.containsKey(oid);
    }

    boolean existsJob(String name) {
        return this.jobs.values().stream().anyMatch(job -> job.getName().equals(name));
    }

    AbstractJob getJob(UUID oid) {
        return this.jobs.get(oid);
    }

    AbstractJob getJob(String name) {
        return this.jobs.values().stream().filter(job -> job.getName().equals(name)).findFirst().orElse(null);
    }

    List<ScheduledJob> getJobs() {
        return new ArrayList<ScheduledJob>(this.jobs.values());
    }

    List<UUID> listJobOIDs() {
        return new ArrayList<UUID>(this.jobs.keySet());
    }

    List<String> listJobNames() {
        return this.jobs.values().stream().map(NamedObject::getName).collect(Collectors.toList());
    }

    synchronized void updateJob(AbstractJob job) throws SchedulerException {
        if (this.jobs.containsKey(job.getOID())) {
            this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_JOBS SET DATA=?, MODIFIED=NOW() WHERE OID='" + String.valueOf(job.getOID()) + "'", job), "Update " + job.toLogNameWithPrefix());
            this.jobs.put(job.getOID(), job);
        }
    }

    private void createExecutionsTable() throws Exception {
        if (this.accessor.lookupCollection(EXECUTIONS_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_EXECUTIONS(OID varchar(36), EID varchar(36), TIME long, DATA TaskListExecution, MODIFIED SQLTIMESTAMP, PRIMARY KEY(OID,EID))"), "Creating table [SCHEDULER_EXECUTIONS]");
        }
    }

    synchronized void addExecution(UUID oid, TaskListExecution execution, long backlogInterval) throws SchedulerException {
        if (backlogInterval != 0L) {
            if (backlogInterval > 0L) {
                this.removeExecutions(oid, null, new Date(System.currentTimeMillis() - backlogInterval));
            }
            if (!this.existsExecution(oid, execution.getEID())) {
                this.doAddExecution(oid, execution);
            }
        }
    }

    private void doAddExecution(UUID oid, TaskListExecution execution) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_EXECUTIONS VALUES('" + String.valueOf(oid) + "', '" + String.valueOf(execution.getEID()) + "', '" + SchedulerStore.roundMilliseconds(execution.getStartTime()).getTime() + "', ?, NOW())", execution), "Adding Execution for Task List [" + String.valueOf(oid) + "]");
    }

    private static Date roundMilliseconds(Date date) {
        long msec = Math.floorMod(date.getTime(), 1000);
        return msec < 500L ? new Date(date.getTime() - msec) : new Date(date.getTime() - msec + 1000L);
    }

    boolean existsExecution(UUID oid, UUID eid) throws SchedulerException {
        RowSet rowSet = this.doGetTaskListExecution(oid, eid);
        return rowSet != null && !rowSet.isEmpty();
    }

    TaskListExecution getExecution(UUID oid, UUID eid) throws SchedulerException {
        try {
            RowSet rowSet = this.doGetTaskListExecution(oid, eid);
            if (rowSet != null && rowSet.getRowCount() == 1) {
                rowSet.first();
                return this.doGetTaskListExecution(rowSet);
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Obtaining execution '" + String.valueOf(eid) + "' for Task List '" + String.valueOf(oid) + "' failed.", exception);
        }
        return null;
    }

    private RowSet doGetTaskListExecution(UUID oid, UUID eid) throws SchedulerException {
        SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "' AND EID = '" + String.valueOf(eid) + "'");
        this.checkWithException(response, "Obtaining Execution [" + String.valueOf(eid) + "] for Task List [" + String.valueOf(oid) + "]");
        return response.getRowSet();
    }

    Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        String timeCondition = SchedulerStore.timeCondition(fromTime, toTime, false);
        SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_EXECUTIONS" + (String)(timeCondition.isEmpty() ? "" : " WHERE " + timeCondition) + " " + SchedulerStore.orderBy(orderByAsc));
        this.checkWithException(response, "Obtaining Executions");
        HashMap<UUID, List<TaskListExecution>> result = new HashMap<UUID, List<TaskListExecution>>();
        try {
            RowSet rowSet = response.getRowSet();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    UUID oid = this.getOID(rowSet);
                    List executions = (List)result.get(oid);
                    if (executions == null) {
                        result.put(oid, new ArrayList());
                        executions = (List)result.get(oid);
                    }
                    executions.add(this.doGetTaskListExecution(rowSet));
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Obtaining Executions failed.", exception);
        }
        return result;
    }

    List<TaskListExecution> getExecutions(UUID oid, boolean orderByAsc) throws SchedulerException {
        return this.doGetExecutions(oid, "", orderByAsc);
    }

    List<TaskListExecution> getExecutions(UUID oid, Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        return this.doGetExecutions(oid, SchedulerStore.timeCondition(fromTime, toTime, true), orderByAsc);
    }

    private List<TaskListExecution> doGetExecutions(UUID oid, String timeCondition, boolean orderByAsc) throws SchedulerException {
        ArrayList<TaskListExecution> result = new ArrayList<TaskListExecution>();
        this.doGetExecutions(oid, "SELECT * FROM SCHEDULER_EXECUTIONS" + (String)(oid != null ? " WHERE OID='" + String.valueOf(oid) + "'" : "") + timeCondition, orderByAsc, result);
        return result;
    }

    List<TaskListExecution> getExecutions(UUID oid, int fromIndex, int toIndex) throws SchedulerException {
        if (toIndex >= 0 && fromIndex > toIndex) {
            throw new SchedulerException(6007, "Invalid range: fromIndex (" + fromIndex + ") > toIndex (" + toIndex + ").");
        }
        ArrayList<TaskListExecution> result = new ArrayList<TaskListExecution>();
        if (toIndex != 0 && fromIndex != toIndex) {
            if (toIndex > 0) {
                this.doGetExecutions(oid, "SELECT TOP " + toIndex + " * FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "'", true, result);
            } else {
                this.doGetExecutions(oid, "SELECT * FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "'", true, result);
            }
            if (fromIndex >= 0) {
                result = fromIndex >= result.size() ? new ArrayList() : new ArrayList(result.subList(fromIndex, result.size()));
            }
        }
        return result;
    }

    private void doGetExecutions(UUID oid, String statement, boolean orderByAsc, List<TaskListExecution> result) throws SchedulerException {
        SLResponse response = this.invokeStatement(statement + " " + SchedulerStore.orderBy(orderByAsc));
        this.checkWithException(response, "Obtaining Executions for Task List [" + String.valueOf(oid) + "]");
        this.fillList(oid, response.getRowSet(), result);
    }

    private void fillList(UUID oid, RowSet rowSet, List<TaskListExecution> result) throws SchedulerException {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                result.add(this.doGetTaskListExecution(rowSet));
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Obtaining Executions for Task List [" + String.valueOf(oid) + "] failed.", exception);
        }
    }

    int getExecutionsNumber(UUID oid) throws SchedulerException {
        return this.doGetExecutionsNumber(oid, "");
    }

    int getExecutionsNumber(UUID oid, Date fromTime, Date toTime) throws SchedulerException {
        return this.doGetExecutionsNumber(oid, SchedulerStore.timeCondition(fromTime, toTime, true));
    }

    private int doGetExecutionsNumber(UUID oid, String timeCondition) throws SchedulerException {
        SLResponse response = this.invokeStatement("SELECT COUNT(*) FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "'" + timeCondition);
        this.checkWithException(response, "Obtaining Executions number for Task List [" + String.valueOf(oid) + "]");
        try {
            response.getRowSet().first();
            return response.getRowSet().getInt(1);
        }
        catch (Exception exception) {
            throw new SchedulerException(6113, (Throwable)exception);
        }
    }

    void removeExecutions(UUID oid) throws SchedulerException {
        this.doRemoveExecutions(oid, "");
    }

    void removeExecutions(UUID oid, Date fromTime, Date toTime) throws SchedulerException {
        this.doRemoveExecutions(oid, SchedulerStore.timeCondition(fromTime, toTime, true));
    }

    private void doRemoveExecutions(UUID oid, String timeCondition) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "'" + timeCondition), "Removing Executions for Task List [" + String.valueOf(oid) + "]");
    }

    TaskListExecution getLastExecution(UUID oid) {
        try {
            SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "'AND TIME = (SELECT MAX(TIME) from SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "')");
            if (response.isOK() && response.getRowSet() != null) {
                RowSet rowSet = response.getRowSet();
                if (response.getRowSet().getRowCount() == 1) {
                    response.getRowSet().first();
                    return this.doGetTaskListExecution(response.getRowSet());
                }
                TaskListExecution result = null;
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    TaskListExecution execution = this.doGetTaskListExecution(rowSet);
                    if (result != null && !execution.getStartTime().after(result.getStartTime())) continue;
                    result = execution;
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    List<TaskListExecution> getLastExecutions(UUID oid, int count, boolean orderByAsc) {
        if (count > 0) {
            try {
                SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_EXECUTIONS WHERE OID='" + String.valueOf(oid) + "' ORDER BY TIME DESC LIMIT " + count);
                if (response.isOK() && response.getRowSet() != null) {
                    TreeMap execs = new TreeMap(Comparator.reverseOrder());
                    RowSet rowSet = response.getRowSet();
                    rowSet.beforeFirst();
                    while (rowSet.next()) {
                        TaskListExecution execution = this.doGetTaskListExecution(rowSet);
                        execs.put(execution.getStartTime().getTime(), execution);
                    }
                    List<TaskListExecution> result = execs.values().stream().limit(count).collect(Collectors.toList());
                    if (orderByAsc) {
                        Collections.reverse(result);
                    }
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private TaskListExecution doGetTaskListExecution(RowSet rowSet) throws SchedulerException {
        try {
            TaskListExecution result = (TaskListExecution)this.getData(rowSet);
            result.init();
            return result;
        }
        catch (Exception exception) {
            throw new SchedulerException(6113, (Throwable)exception);
        }
    }

    synchronized void updateExecution(UUID oid, TaskListExecution execution) throws SchedulerException {
        this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_EXECUTIONS SET DATA=?, MODIFIED=NOW() WHERE OID='" + String.valueOf(oid) + "' AND EID='" + String.valueOf(execution.getEID()) + "'", execution), "Update Execution [" + String.valueOf(execution.getEID()) + "]");
    }

    private static String timeCondition(Date fromTime, Date toTime, boolean complex) {
        Object result;
        String prefix;
        if (fromTime == null && toTime == null) {
            return "";
        }
        String string = prefix = complex ? " AND " : "";
        if (Utils.equalsNullSafe(fromTime, toTime)) {
            return prefix + "TIME = " + fromTime.getTime();
        }
        result = (String)result + SchedulerStore.toTimeCondition(((String)(result = SchedulerStore.fromTimeCondition(prefix, fromTime))).isEmpty() ? prefix : " AND ", toTime);
        return result;
    }

    private static String fromTimeCondition(String prefix, Date fromTime) {
        return fromTime != null ? prefix + "TIME >= " + fromTime.getTime() : "";
    }

    private static String toTimeCondition(String prefix, Date toTime) {
        return toTime != null ? prefix + "TIME <= " + toTime.getTime() : "";
    }

    private static String orderBy(boolean isAsc) {
        String statement = "ORDER BY TIME";
        return isAsc ? statement : statement + " DESC";
    }

    private void createTemplatesTable() throws Exception {
        if (this.accessor.lookupCollection(TEMPLATES_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_TEMPLATES(TYPE varchar(16), NAME varchar(255), VALUE string, MODIFIED SQLTIMESTAMP, PRIMARY KEY(TYPE,NAME))"), "Creating table [SCHEDULER_TEMPLATES]");
        }
    }

    synchronized void addTemplate(TemplateType type, String name, String value) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_TEMPLATES VALUES('" + type.name() + "', '" + name + "', '" + value + "', NOW())"), "Adding Template [" + type.getFullName(name) + "]");
    }

    synchronized void removeTemplate(TemplateType type, String name) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_TEMPLATES WHERE TYPE='" + type.name() + "' AND NAME = '" + name + "'"), "Removing Template [" + type.getFullName(name) + "]");
    }

    synchronized void setTemplate(TemplateType type, String name, String value) throws SchedulerException {
        this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_TEMPLATES SET VALUE = '" + value + "', MODIFIED=NOW() WHERE TYPE='" + type.name() + "' AND NAME = '" + name + "'"), "Update Template [" + type.getFullName(name) + "]");
    }

    boolean existsTemplate(TemplateType type, String name) {
        try {
            RowSet rowSet = this.doGetTemplate(type, name);
            return rowSet != null && !rowSet.isEmpty();
        }
        catch (SchedulerException exception) {
            return false;
        }
    }

    String getTemplate(TemplateType type, String name) {
        try {
            RowSet rowSet = this.doGetTemplate(type, name);
            if (rowSet != null && rowSet.getRowCount() == 1) {
                rowSet.first();
                return this.doGetTemplate(rowSet);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    List<String> listTemplates(TemplateType type) {
        ArrayList<String> result = new ArrayList<String>();
        SLResponse response = this.invokeStatement("SELECT NAME FROM SCHEDULER_TEMPLATES WHERE TYPE = '" + type.name() + "'");
        if (response != null && response.isOK()) {
            try {
                RowSet rowSet = response.getRowSet();
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    result.add(rowSet.getString("NAME"));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private RowSet doGetTemplate(TemplateType type, String name) throws SchedulerException {
        SLResponse response = this.invokeStatement("SELECT * FROM SCHEDULER_TEMPLATES WHERE TYPE = '" + type.name() + "' AND NAME = '" + name + "'");
        this.checkWithException(response, "Obtaining Template [" + type.getFullName(name) + "]");
        return response.getRowSet();
    }

    private String doGetTemplate(RowSet rowSet) throws SchedulerException {
        try {
            return rowSet.getObject("VALUE").toString();
        }
        catch (Throwable exception) {
            throw new SchedulerException(6113, exception);
        }
    }

    private <T> T getData(RowSet rowSet) throws SQLException {
        return (T)rowSet.getObject("DATA");
    }

    private UUID getOID(RowSet rowSet) throws SQLException {
        return UUID.fromString(rowSet.getString("OID"));
    }

    @Override
    protected Class getExceptionClass() {
        return SchedulerException.class;
    }

    @Override
    protected int getErrorCode() {
        return 6113;
    }

    private void initTriggers() throws SchedulerException {
        Trace.logDebug(this, "Loading Event Task Triggers...");
        try {
            ArrayList<String> invalidTriggers = new ArrayList<String>();
            RowSet rowSet = this.getTableWithCheck(TRIGGERS_TABLE_NAME);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    this.initTrigger((EventTaskTrigger)this.getData(rowSet));
                }
                catch (SchedulerException exception) {
                    Trace.logException(this, exception, true);
                    String oid = rowSet.getObject("OID").toString();
                    invalidTriggers.add(oid);
                    Trace.logError(this, "Initialization of Trigger [" + oid + "] failed. It will be removed.");
                }
            }
            for (String oid : invalidTriggers) {
                this.removeTrigger(UUID.fromString(oid));
            }
        }
        catch (SQLException exception) {
            throw new SchedulerException(6113, "Loading Event Task Triggers failed.", exception);
        }
        Trace.logDebug(this, "Event Task Triggers loaded.");
    }

    private void initTrigger(EventTaskTrigger trigger) throws SchedulerException {
        this.triggers.put(trigger.getOID(), trigger);
        trigger.init(this.scheduler);
    }

    private void enableTriggers() {
        Trace.logDebug(this, "Enabling Event Task Triggers...");
        for (EventTaskTrigger trigger : this.triggers.values()) {
            try {
                if (!trigger.isEnabled()) continue;
                trigger.enableOnInit();
            }
            catch (SchedulerException exception) {
                Trace.logException(this, exception, false);
                Trace.logError(this, "Enabling Trigger [" + trigger.getName() + "] failed. Moved to disabled state.");
            }
        }
        Trace.logDebug(this, "Event Task Triggers enabled.");
    }

    private void createTriggersTable() throws Exception {
        if (this.accessor.lookupCollection(TRIGGERS_TABLE_NAME) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE SCHEDULER_EVENT_TRIGGERS(OID varchar(36) PRIMARY KEY, DATA EventTaskTrigger, MODIFIED SQLTIMESTAMP)"), "Creating table [SCHEDULER_EVENT_TRIGGERS]");
        }
    }

    synchronized void addTrigger(EventTaskTrigger trigger) throws SchedulerException {
        this.doAddTrigger(trigger);
        this.triggers.put(trigger.getOID(), trigger);
    }

    private void doAddTrigger(EventTaskTrigger trigger) throws SchedulerException {
        this.checkWithException(this.invokeStatement("INSERT INTO SCHEDULER_EVENT_TRIGGERS VALUES('" + String.valueOf(trigger.getOID()) + "', ?, NOW())", trigger), "Adding Trigger [" + trigger.getName() + "]");
    }

    synchronized EventTaskTrigger removeTrigger(UUID oid) throws SchedulerException {
        EventTaskTrigger result = this.triggers.remove(oid);
        if (result != null) {
            this.doRemoveTrigger(result.getOID(), result.getName());
        }
        return result;
    }

    private void doRemoveTrigger(UUID oid, String name) throws SchedulerException {
        this.checkWithException(this.invokeStatement("DELETE FROM SCHEDULER_EVENT_TRIGGERS WHERE OID='" + String.valueOf(oid) + "'"), "Removing Trigger [" + name + "]");
    }

    boolean existsTrigger(UUID objectId) {
        return this.triggers.containsKey(objectId);
    }

    boolean existsTrigger(String name) {
        return this.triggers.values().stream().anyMatch(trigger -> trigger.getName().equals(name));
    }

    EventTaskTrigger getTrigger(UUID oid) {
        return this.triggers.get(oid);
    }

    EventTaskTrigger getTrigger(String name) {
        return this.triggers.values().stream().filter(trigger -> trigger.getName().equals(name)).findFirst().orElse(null);
    }

    List<EventTaskTrigger> getTriggers() {
        return new ArrayList<EventTaskTrigger>(this.triggers.values());
    }

    List<UUID> listTriggerOIDs() {
        return new ArrayList<UUID>(this.triggers.keySet());
    }

    List<String> listTriggerNames() {
        return this.triggers.values().stream().map(NamedObject::getName).collect(Collectors.toList());
    }

    synchronized void updateTrigger(EventTaskTrigger trigger) throws SchedulerException {
        if (this.triggers.containsKey(trigger.getOID())) {
            this.checkWithException(this.invokeStatement("UPDATE SCHEDULER_EVENT_TRIGGERS SET DATA=?, MODIFIED=NOW() WHERE OID='" + String.valueOf(trigger.getOID()) + "'", trigger), "Update Trigger [" + trigger.getName() + "]");
            this.triggers.put(trigger.getOID(), trigger);
        }
    }

    private void convertDataInSDSDataspace() throws Exception {
        if (this.existsTableInSDS(TASK_LISTS_TABLE_NAME)) {
            DataspaceAccessor accessorSch = this.accessor;
            try {
                this.accessor = SchedulerStore.doCreateAccessor("SDS");
                this.convertToNewFormatInSDSDataspace();
                this.initTaskLists(true);
                this.taskLists.clear();
            }
            finally {
                if (this.accessor != null) {
                    this.accessor.close();
                }
                this.accessor = accessorSch;
            }
        }
    }

    private void migrateSDSToSCH() throws Exception {
        this.migrateTable(TIME_WINDOWS_TABLE_NAME);
        this.migrateTable(METASETS_TABLE_NAME);
        this.migrateTable(EXECUTIONS_TABLE_NAME);
        this.migrateTable(TASK_LISTS_TABLE_NAME);
        this.migrateTable(JOBS_TABLE_NAME);
        this.migrateTable(TRIGGERS_TABLE_NAME);
        this.migrateTable(TEMPLATES_TABLE_NAME);
    }

    private void migrateTable(String tableName) throws Exception {
        if (this.existsTableInSDS(tableName)) {
            Trace.logInfo(this, "Migrating table [" + tableName + "] to SCH...");
            try {
                this.checkWithException(this.accessor.invokeLanguageRequest("create collection " + SchedulerStore.getTableName("SCH", tableName) + " like " + SchedulerStore.getTableName("SDS", tableName)), "Migrating table [" + tableName + "]");
            }
            catch (Exception exception) {
                Trace.logError(this, "Migration of table [" + tableName + "] failed.");
                try {
                    this.dropTable(tableName, "SCH");
                }
                catch (Exception dropException) {
                    this.logDropTableError(tableName, "SCH", dropException);
                }
                throw exception;
            }
            this.dropTable(tableName, "SDS");
        }
    }

    private void dropOldTables() {
        this.dropOldTable("SCHEDULED_JOBS");
        this.dropOldTable("SCHEDULED_ITERATIONS");
    }

    private void dropOldTable(String tableName) {
        try {
            if (this.existsTableInSDS(tableName)) {
                this.dropTable(tableName, "SDS");
            }
        }
        catch (Exception exception) {
            this.logDropTableError(tableName, "SDS", exception);
        }
    }

    private void dropTable(String tableName, String schema) throws Exception {
        Trace.logInfo(this, "Dropping table [" + tableName + "] from " + schema + "...");
        this.checkWithException(this.accessor.invokeLanguageRequest("drop collection " + SchedulerStore.getTableName(schema, tableName)), "Dropping table [" + tableName + "]");
    }

    private void logDropTableError(String tableName, String schema, Throwable exception) {
        Trace.logException(this, exception, false);
        Trace.logError(this, "Dropping table [" + tableName + "] from " + schema + " failed.");
    }

    private boolean existsTableInSDS(String tableName) throws Exception {
        return this.accessor.invokeLanguageRequest("select count(*) from " + SchedulerStore.getTableName("SDS", tableName)).isOK();
    }

    private static String getTableName(String schema, String tableName) {
        return schema + "." + tableName;
    }

    private RowSet loadTaskListsFromOldFormat_2024_1() {
        return this.loadTaskListsFromOldFormat(OldFormatVersion.FORMAT_2024_1, Pair.of(TaskList.class, this.createSerialSchemaTaskList_2024_1()), Pair.of(AbstractTask.class, null), Pair.of(ActionTask.class, this.createSerialSchemaActionTask_2024_1()), Pair.of(EventTask.class, null), Pair.of(ExceptionTask.class, null));
    }

    private SerialSchema createSerialSchemaTaskList_2024_1() {
        SerialSchema result = new SerialSchema();
        result.addField("eventScope", "com.streamscape.sef.enums.EventScope", false, false);
        result.addField("exceptionTask", "com.streamscape.sef.scheduler.AbstractTask", false, false);
        result.addField("exceptionTasks", "java.util.List", false, false);
        result.addField("metasetId", "java.util.UUID", false, false);
        result.addField("model", "java.lang.Boolean", false, false);
        result.addField("retentionInterval", "java.lang.Long", false, false);
        result.addField("retentionIntervalUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskListState", false, false);
        result.addField("taskDelay", "long", false, false);
        result.addField("taskListWindow", "java.lang.Long", false, false);
        result.addField("taskListWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("tasks", "java.util.List", false, false);
        result.addField("unordered", "java.lang.Boolean", false, false);
        return result;
    }

    private SerialSchema createSerialSchemaActionTask_2024_1() {
        SerialSchema result = new SerialSchema();
        result.addField("encrypted", "boolean", false, false);
        result.addField("model", "java.lang.String", false, false);
        result.addField("script", "java.lang.String", false, false);
        return result;
    }

    private RowSet loadTaskListsFromOldFormat_2023_2() throws SchedulerException {
        return this.loadTaskListsFromOldFormat(OldFormatVersion.FORMAT_2023_2, Pair.of(TaskList.class, this.createSerialSchemaTaskList_2023_2()));
    }

    private SerialSchema createSerialSchemaTaskList_2023_2() {
        SerialSchema result = new SerialSchema();
        result.addField("eventScope", "com.streamscape.sef.enums.EventScope", false, false);
        result.addField("exceptionTasks", "com.streamscape.sef.scheduler.AbstractTask", false, false);
        result.addField("metasetId", "java.util.UUID", false, false);
        result.addField("retentionInterval", "java.lang.Long", false, false);
        result.addField("retentionIntervalUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskListState", false, false);
        result.addField("taskDelay", "long", false, false);
        result.addField("tasks", "java.util.List", false, false);
        return result;
    }

    private RowSet loadTaskListsFromOldFormat_2023_1() throws SchedulerException {
        return this.loadTaskListsFromOldFormat(OldFormatVersion.FORMAT_2023_1, Pair.of(AbstractExecutableObject.class, this.createSerialSchemaExecutableObject_2023_1()), Pair.of(TaskList.class, this.createSerialSchemaTaskList_2023_1()), Pair.of(AbstractTask.class, null), Pair.of(ActionTask.class, null), Pair.of(EventTask.class, this.createSerialSchemaEventTask_2023_1()));
    }

    private SerialSchema createSerialSchemaExecutableObject_2023_1() {
        SerialSchema result = new SerialSchema();
        result.addField("metadata", "java.lang.String", false, false);
        result.addField("properties", "java.util.HashMap", false, false);
        result.addField("tags", "java.util.HashSet", false, false);
        return result;
    }

    private SerialSchema createSerialSchemaTaskList_2023_1() {
        SerialSchema result = new SerialSchema();
        result.addField("metasetId", "java.util.UUID", false, false);
        result.addField("retentionInterval", "java.lang.Long", false, false);
        result.addField("retentionIntervalUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskListState", false, false);
        result.addField("taskDelay", "long", false, false);
        result.addField("tasks", "java.util.List", false, false);
        return result;
    }

    private SerialSchema createSerialSchemaEventTask_2023_1() {
        SerialSchema result = new SerialSchema();
        result.addField("eventScope", "com.streamscape.sef.enums.EventScope", false, false).removed();
        return result;
    }

    private RowSet loadTaskListsFromOldFormat_2022() throws SchedulerException {
        return this.loadTaskListsFromOldFormat(OldFormatVersion.FORMAT_2022, Pair.of(AbstractTask.class, this.createSerialSchemaAbstractTask_2022()), Pair.of(ActionTask.class, null), Pair.of(EventTask.class, null));
    }

    private SerialSchema createSerialSchemaAbstractTask_2022() {
        SerialSchema result = new SerialSchema();
        result.addField("condition", "java.lang.String", false, false);
        result.addField("conditionName", "java.lang.String", false, false);
        result.addField("resumptionStates", "byte", false, false);
        result.addField("taskWindow", "long", false, false);
        result.addField("taskWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("weight", "byte", false, false);
        return result;
    }

    private RowSet loadTaskListsFromOldFormat(OldFormatVersion version, Pair<Class, SerialSchema> ... serialSchemas) {
        return this.loadFromOldFormat("Task Lists", TASK_LISTS_TABLE_NAME, version, rowSet -> {}, serialSchemas);
    }

    private RowSet loadTaskExecutionsFromOldFormat_2024_4() {
        return this.loadTaskExecutionsFromOldFormat(OldFormatVersion.FORMAT_2024_4, Pair.of(AbstractExecution.class, this.createSerialSchemaAbstractExecution_2024_4()), Pair.of(TaskListExecution.class, null), Pair.of(TaskExecution.class, null));
    }

    private SerialSchema createSerialSchemaAbstractExecution_2024_4() {
        SerialSchema result = new SerialSchema();
        result.addField("endTime", "java.util.Date", false, false);
        result.addField("startTime", "java.util.Date", false, false);
        return result;
    }

    private RowSet loadTaskExecutionsFromOldFormat_2024_3() {
        return this.loadTaskExecutionsFromOldFormat(OldFormatVersion.FORMAT_2024_3, Pair.of(TaskListExecution.class, this.createSerialSchemaTaskListExecution_2024_3()));
    }

    private SerialSchema createSerialSchemaTaskListExecution_2024_3() {
        SerialSchema result = new SerialSchema();
        result.addField("afterMetasetValues", "java.util.Map", false, false);
        result.addField("autoComplete", "java.lang.Boolean", false, false);
        result.addField("beforeMetasetValues", "java.util.Map", false, false);
        result.addField("eid", "java.util.UUID", false, false);
        result.addField("errorCode", "int", false, false);
        result.addField("errorMessage", "java.lang.String", false, false);
        result.addField("executionMode", "com.streamscape.sef.scheduler.ExecutionMode", false, false);
        result.addField("isCompleted", "boolean", false, false);
        result.addField("jobName", "java.lang.String", false, false);
        result.addField("metasetName", "java.lang.String", false, false);
        result.addField("owner", "java.lang.String", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskListState", false, false);
        result.addField("taskExecutions", "java.util.List", false, false);
        result.addField("taskListWindow", "java.lang.Long", false, false);
        result.addField("taskListWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("transacted", "java.lang.Boolean", false, false);
        result.addField("unordered", "java.lang.Boolean", false, false);
        result.addField("untilTime", "java.util.Date", false, false);
        return result;
    }

    private RowSet loadTaskExecutionsFromOldFormat_2024_2() {
        return this.loadTaskExecutionsFromOldFormat(OldFormatVersion.FORMAT_2024_2, Pair.of(TaskListExecution.class, this.createSerialSchemaTaskListExecution_2024_2()));
    }

    private SerialSchema createSerialSchemaTaskListExecution_2024_2() {
        SerialSchema result = new SerialSchema();
        result.addField("afterMetasetValues", "java.util.Map", false, false);
        result.addField("autoComplete", "java.lang.Boolean", false, false);
        result.addField("beforeMetasetValues", "java.util.Map", false, false);
        result.addField("eid", "java.util.UUID", false, false);
        result.addField("errorCode", "int", false, false);
        result.addField("errorMessage", "java.lang.String", false, false);
        result.addField("executionMode", "com.streamscape.sef.scheduler.ExecutionMode", false, false);
        result.addField("isCompleted", "boolean", false, false);
        result.addField("jobName", "java.lang.String", false, false);
        result.addField("metasetName", "java.lang.String", false, false);
        result.addField("owner", "java.lang.String", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskListState", false, false);
        result.addField("taskExecutions", "java.util.List", false, false);
        result.addField("taskListWindow", "java.lang.Long", false, false);
        result.addField("taskListWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("transacted", "java.lang.Boolean", false, false);
        result.addField("unordered", "java.lang.Boolean", false, false);
        return result;
    }

    private void loadTaskExecutionsFromOldFormat_2024_1() {
        this.loadTaskExecutionsFromOldFormat(OldFormatVersion.FORMAT_2024_1, Pair.of(TaskExecution.class, this.createSerialSchemaTaskExecution_2024_1()), Pair.of(TaskListExecution.class, this.createSerialSchemaTaskListExecution_2024_1()));
    }

    private SerialSchema createSerialSchemaTaskExecution_2024_1() {
        SerialSchema result = new SerialSchema();
        result.addField("autoComplete", "java.lang.Boolean", false, false);
        result.addField("completionEndTime", "java.util.Date", false, false);
        result.addField("completionStartTime", "java.util.Date", false, false);
        result.addField("completionState", "com.streamscape.sef.scheduler.TaskState", false, false);
        result.addField("errorCode", "int", false, false);
        result.addField("errorMessage", "java.lang.String", false, false);
        result.addField("resumptionStates", "byte", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskState", false, false);
        result.addField("taskName", "java.lang.String", false, false);
        result.addField("taskType", "com.streamscape.sef.scheduler.TaskType", false, false);
        result.addField("taskWindow", "long", false, false);
        result.addField("taskWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("weight", "byte", false, false);
        return result;
    }

    private SerialSchema createSerialSchemaTaskListExecution_2024_1() {
        SerialSchema result = new SerialSchema();
        result.addField("afterMetasetValues", "java.util.Map", false, false);
        result.addField("autoComplete", "java.lang.Boolean", false, false);
        result.addField("beforeMetasetValues", "java.util.Map", false, false);
        result.addField("eid", "java.util.UUID", false, false);
        result.addField("errorCode", "int", false, false);
        result.addField("errorMessage", "java.lang.String", false, false);
        result.addField("executionMode", "com.streamscape.sef.scheduler.ExecutionMode", false, false);
        result.addField("isCompleted", "boolean", false, false);
        result.addField("jobName", "java.lang.String", false, false);
        result.addField("metasetName", "java.lang.String", false, false);
        result.addField("owner", "java.lang.String", false, false);
        result.addField("taskExecutions", "java.util.List", false, false);
        result.addField("taskListWindow", "java.lang.Long", false, false);
        result.addField("taskListWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("unordered", "java.lang.Boolean", false, false);
        return result;
    }

    private void loadTaskExecutionsFromOldFormatInSDS_2023_2() {
        this.loadTaskExecutionsFromOldFormat(OldFormatVersion.FORMAT_2023_2, Pair.of(TaskListExecution.class, this.createSerialSchemaTaskListExecution_2023_2()));
    }

    private SerialSchema createSerialSchemaTaskListExecution_2023_2() {
        SerialSchema result = new SerialSchema();
        result.addField("afterMetasetValues", "java.util.Map", false, false);
        result.addField("beforeMetasetValues", "java.util.Map", false, false);
        result.addField("eid", "java.util.UUID", false, false);
        result.addField("errorCode", "int", false, false);
        result.addField("errorMessage", "java.lang.String", false, false);
        result.addField("exceptionTaskExecutions", "java.util.List", false, false).removed();
        result.addField("executionMode", "com.streamscape.sef.scheduler.ExecutionMode", false, false);
        result.addField("isCompleted", "boolean", false, false);
        result.addField("jobName", "java.lang.String", false, false);
        result.addField("metasetName", "java.lang.String", false, false);
        result.addField("owner", "java.lang.String", false, false);
        result.addField("taskExecutions", "java.util.List", false, false);
        return result;
    }

    private void loadTaskExecutionsFromOldFormatInSDS_2023_1() {
        this.loadTaskExecutionsFromOldFormat(OldFormatVersion.FORMAT_2023_1, Pair.of(TaskExecution.class, this.createSerialSchemaTaskExecution_2023_1()), Pair.of(TaskListExecution.class, this.createSerialSchemaTaskListExecution_2023_1()));
    }

    private SerialSchema createSerialSchemaTaskExecution_2023_1() {
        SerialSchema result = new SerialSchema();
        result.addField("errorCode", "int", false, false);
        result.addField("errorMessage", "java.lang.String", false, false);
        result.addField("resumptionStates", "byte", false, false);
        result.addField("state", "com.streamscape.sef.scheduler.TaskState", false, false);
        result.addField("taskName", "java.lang.String", false, false);
        result.addField("taskType", "com.streamscape.sef.scheduler.TaskType", false, false);
        result.addField("taskWindow", "long", false, false);
        result.addField("taskWindowUnit", "java.util.concurrent.TimeUnit", false, false);
        result.addField("weight", "byte", false, false);
        return result;
    }

    private SerialSchema createSerialSchemaTaskListExecution_2023_1() {
        SerialSchema result = new SerialSchema();
        result.addField("afterMetasetValues", "java.util.Map", false, false);
        result.addField("beforeMetasetValues", "java.util.Map", false, false);
        result.addField("eid", "java.util.UUID", false, false);
        result.addField("executionMode", "com.streamscape.sef.scheduler.ExecutionMode", false, false);
        result.addField("isCompleted", "boolean", false, false);
        result.addField("jobName", "java.lang.String", false, false);
        result.addField("metasetName", "java.lang.String", false, false);
        result.addField("owner", "java.lang.String", false, false);
        result.addField("taskExecutions", "java.util.List", false, false);
        return result;
    }

    private RowSet loadTaskExecutionsFromOldFormat(OldFormatVersion version, Pair<Class, SerialSchema> ... serialSchemas) {
        return this.loadFromOldFormat("Executions", EXECUTIONS_TABLE_NAME, version, rowSet -> {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                TaskListExecution execution = (TaskListExecution)this.getData((RowSet)rowSet);
                execution.initOnLoad(version);
                this.updateExecution(this.getOID((RowSet)rowSet), execution);
            }
        }, serialSchemas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowSet loadFromOldFormat(String entity, String tableName, OldFormatVersion version, Utils.Consumer<RowSet> processor, Pair<Class, SerialSchema> ... serialSchemas) {
        Trace.logInfo(this, "WARNING: Trying to load {} from old format ({})...", new Object[]{entity, version});
        ArrayList<Triple> types = new ArrayList<Triple>();
        for (Pair<Class, SerialSchema> schema : serialSchemas) {
            SemanticType type = this.lookupSemanticClass((Class)schema.first);
            types.add(Triple.of((Object)type, (Object)SchedulerStore.getSerialSupport(type), schema));
        }
        try {
            for (Triple type : types) {
                this.setSerialSupport((SemanticType)type.getLeft(), (Class)((Pair)type.getRight()).first, (SerialSchema)((Pair)type.getRight()).second);
            }
            RowSet result = this.getTableWithCheck(tableName);
            processor.accept(result);
            this.invokeStatement("check collection " + tableName);
            Trace.logInfo(this, "{} loaded from old format.", entity);
            RowSet rowSet = result;
            return rowSet;
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Loading {} from old format failed.", entity);
            RowSet rowSet = null;
            return rowSet;
        }
        finally {
            for (Triple type : types) {
                SchedulerStore.setSerialSupport((SemanticType)type.getLeft(), (SerialSupport)type.getMiddle());
            }
        }
    }

    private void convertToNewFormatInSDSDataspace() throws Exception {
        DataspaceComponent sds = SchedulerStore.getContext().getDataspaceManager().lookup("SDS");
        this.doConvert(sds, METASETS_TABLE_NAME, "DATA", this::createMetasetsTable, rowSet -> this.doAddObject((RowSet)rowSet, this::doAddMetaset));
        this.doConvert(sds, TASK_LISTS_TABLE_NAME, "DATA", this::createTaskListsTable, rowSet -> this.doAddObject((RowSet)rowSet, this::doAddTaskList));
        this.doConvert(sds, EXECUTIONS_TABLE_NAME, "DATA", this::createExecutionsTable, this::doAddExecution);
        this.doConvert(sds, JOBS_TABLE_NAME, "DATA", this::createJobsTable, rowSet -> this.doAddObject((RowSet)rowSet, this::doAddJob));
        this.doConvert(sds, TEMPLATES_TABLE_NAME, "VALUE", this::createTemplatesTable, this::doAddTemplate);
        this.doConvert(sds, TRIGGERS_TABLE_NAME, "DATA", this::createTriggersTable, rowSet -> this.doAddObject((RowSet)rowSet, this::doAddTrigger));
    }

    private void doConvert(DataspaceComponent sds, String tableName, String columnName, Utils.Runnable tableCreator, Utils.Consumer<RowSet> addObject) throws Exception {
        Tuple tuple;
        CollectionMetaData collectionMetadata = sds.lookupCollectionMetaData(tableName);
        if (collectionMetadata != null && (tuple = collectionMetadata.lookupTuple(columnName)) != null && tuple.getDataspaceType().getNameString().equalsIgnoreCase("CLOB")) {
            Trace.logInfo(this, "Migrating table [" + tableName + "] to new format...");
            RowSet rowSet = this.getTableWithCheck(tableName);
            this.dropTable(tableName, "SDS");
            tableCreator.run();
            rowSet.beforeFirst();
            while (rowSet.next()) {
                addObject.accept(rowSet);
            }
            Trace.logInfo(this, "Table [" + tableName + "] converted to new format.");
        }
    }

    private <T extends SchedulerObject> void doAddObject(RowSet rowSet, Utils.Consumer<T> addObject) throws Exception {
        addObject.accept((SchedulerObject)this.deserialize(this.doGetData(rowSet)));
    }

    private void doAddExecution(RowSet rowSet) throws Exception {
        this.doAddExecution(this.getOID(rowSet), (TaskListExecution)this.deserialize(this.doGetData(rowSet)));
    }

    private void doAddTemplate(RowSet rowSet) throws Exception {
        this.addTemplate(TemplateType.valueOf(rowSet.getString("TYPE")), rowSet.getString("NAME"), rowSet.getObject("VALUE").toString());
    }

    private void dropTable(String name) {
        this.checkWithException(this.invokeStatement("DROP TABLE " + name), "Deletion table [" + name + "]");
    }

    private byte[] doGetData(RowSet rowSet) throws SQLException {
        return Base64.decode(rowSet.getObject("DATA").toString());
    }

    private synchronized String serialize(Object object) throws SchedulerException {
        try {
            return Base64.encodeBytes(this.serializer.serialize(object).getBytes());
        }
        catch (Throwable exception) {
            throw new SchedulerException(6113, exception);
        }
    }

    private synchronized Object deserialize(byte[] data) throws SchedulerException {
        try {
            return this.serializer.deserialize(data);
        }
        catch (Throwable exception) {
            throw new SchedulerException(6113, exception);
        }
    }

    private void initOldTriggers() {
        try {
            if (RepositoryUtils.existsObject("/sys/task", "SystemTask")) {
                Trace.logDebug(this, "Loading old Event Task Triggers...");
                SystemTaskImpl systemTask = (SystemTaskImpl)new SystemTaskFactory().create();
                if (systemTask.triggers != null) {
                    for (SystemTaskTriggerImpl oldTrigger : systemTask.triggers.values()) {
                        EventTaskTrigger trigger = new EventTaskTrigger(oldTrigger.name, this.scheduler.getDefaultOwner().getName().toString());
                        trigger.jobName = oldTrigger.jobName;
                        trigger.taskName = oldTrigger.taskName;
                        trigger.nodeName = oldTrigger.nodeName;
                        trigger.userName = oldTrigger.userName;
                        trigger.eventScope = oldTrigger.eventScope;
                        trigger.dispatchMode = oldTrigger.dispatchMode;
                        trigger.script = oldTrigger.script;
                        trigger.init(this.scheduler);
                        try {
                            this.addTrigger(trigger);
                        }
                        catch (SchedulerException exception) {
                            Trace.logException(this, exception, false);
                        }
                    }
                }
                RepositoryUtils.unbindObject("/sys/task", "SystemTask");
                RepositoryUtils.destroyReferenceContext(RepositoryUtils.getReferenceContext("/sys/task", false, false));
                Trace.logDebug(this, "Old Event Task Triggers loaded.");
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    private void addModifiedColumnToTable(String tableName) throws Exception {
        Tuple tuple;
        DataspaceComponent sch = SchedulerStore.getContext().getDataspaceManager().lookup("SCH");
        CollectionMetaData collectionMetadata = sch.lookupCollectionMetaData(tableName);
        if (collectionMetadata != null && (tuple = collectionMetadata.lookupTuple("MODIFIED")) == null) {
            Trace.logInfo(this, "Adding MODIFIED column to table [" + tableName + "].");
            this.checkWithException(this.accessor.invokeLanguageRequest("ALTER COLLECTION " + tableName + " ADD TUPLE MODIFIED SQLTIMESTAMP"), "Adding MODIFIED column to table [" + tableName + "]");
            this.checkWithException(this.accessor.invokeLanguageRequest("UPDATE " + tableName + " SET MODIFIED = '1970-01-01 00:00:00.000' WHERE MODIFIED=NULL"), "Updating MODIFIED to '1970-01-01 00:00:00.000' in table [" + tableName + "]");
        }
    }

    long getSessionId() throws SchedulerException {
        try {
            return this.accessor.getSessionId();
        }
        catch (DataspaceComponentException exception) {
            throw new SchedulerException(this.getErrorCode(), (Throwable)exception);
        }
    }

    RowSet describeSession() throws SchedulerException {
        return this.getInfo("DESCRIBE SESSION", "Obtaining session info");
    }

    RowSet describeDataspace() throws SchedulerException {
        return this.getInfo("DESCRIBE DATASPACE", "Obtaining dataspace info");
    }

    RowSet describeDataspaceHealth() throws SchedulerException {
        return this.getInfo("CHECK DATASPACE", "Checking dataspace health");
    }

    RowSet describeDataspaceConsistency() throws SchedulerException {
        return this.getInfo("CHECK DATASPACE CONSISTENCY", "Checking dataspace consistency");
    }

    RowSet describeCollections() throws SchedulerException {
        return this.getCollectionsInfo("DESCRIBE COLLECTION %s", "Obtaining info", null);
    }

    RowSet describeCollectionsHealth() throws SchedulerException {
        return this.getCollectionsInfo("CHECK COLLECTION %s", "Checking health", GetInfoOption.ADD_NAME_ROW);
    }

    RowSet describeCollectionsConsistency() throws SchedulerException {
        return this.getCollectionsInfo("CHECK COLLECTION %s CONSISTENCY", "Checking consistency", GetInfoOption.ADD_NAME_COLUMN);
    }

    RowSet getCollectionsInfo(String statement, String description, GetInfoOption option) throws SchedulerException {
        try {
            ArrayList<RowSet> rowSets = new ArrayList<RowSet>();
            rowSets.add(this.getCollectionInfo(TASK_LISTS_TABLE_NAME, statement, description, option));
            this.addNonEmpty(rowSets, this.getCollectionInfo(JOBS_TABLE_NAME, statement, description, option));
            this.addNonEmpty(rowSets, this.getCollectionInfo(EXECUTIONS_TABLE_NAME, statement, description, option));
            this.addNonEmpty(rowSets, this.getCollectionInfo(METASETS_TABLE_NAME, statement, description, option));
            this.addNonEmpty(rowSets, this.getCollectionInfo(TIME_WINDOWS_TABLE_NAME, statement, description, option));
            return this.merge(rowSets);
        }
        catch (Exception exception) {
            throw new SchedulerException(this.getErrorCode(), (Throwable)exception);
        }
    }

    private void addNonEmpty(List<RowSet> rowSets, RowSet rowSet) {
        if (!rowSet.isEmpty()) {
            rowSets.add(rowSet);
        }
    }

    private RowSet merge(List<RowSet> rowSets) throws Exception {
        RowSet result = rowSets.get(0);
        int nColumns = result.getMeta().getColumnCount();
        int[] dividerWidths = new int[nColumns];
        Arrays.fill(dividerWidths, 0);
        for (RowSet rowSet : rowSets) {
            RowSetPrinter printer = new RowSetPrinter();
            printer.doPseudoPrint(rowSet);
            for (int i2 = 1; i2 <= nColumns; ++i2) {
                int dividerWidth = printer.getMaxColumnWidth(i2);
                if (dividerWidth <= dividerWidths[i2 - 1]) continue;
                dividerWidths[i2 - 1] = dividerWidth;
            }
        }
        Object[] dividers = IntStream.range(0, nColumns).mapToObj(i -> RowSetPrinter.divider(dividerWidths[i])).toArray();
        for (int i3 = 1; i3 < rowSets.size(); ++i3) {
            result.addToRowSet(dividers);
            result.addAll(rowSets.get(i3));
        }
        return result;
    }

    private RowSet getCollectionInfo(String collectionName, String statement, String description, GetInfoOption option) throws Exception {
        RowSet result = this.getInfo(String.format(statement, collectionName), description + " of collection [" + collectionName + "]");
        if (option == GetInfoOption.ADD_NAME_ROW) {
            result.insertIntoRowSet(1, new Object[]{"Name", collectionName});
        } else if (option == GetInfoOption.ADD_NAME_COLUMN) {
            RowMetaData newMeta = new RowMetaData();
            newMeta.addColumn("Collection Name", String.class);
            RowMetaData meta = result.getMeta();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                newMeta.addColumn(meta.getColumnName(i));
            }
            int newColumnCount = newMeta.getColumnCount();
            RowSet newResult = new RowSet(newMeta);
            for (int iRow = 1; iRow <= result.getRowCount(); ++iRow) {
                Object[] rowData = result.getRowAt(iRow).getRawData();
                Object[] newRowData = new Object[newColumnCount];
                newRowData[0] = collectionName;
                System.arraycopy(rowData, 0, newRowData, 1, newColumnCount - 1);
                newResult.addToRowSet(newRowData);
            }
            return newResult;
        }
        return result;
    }

    private RowSet getInfo(String statement, String description) throws SchedulerException {
        SLResponse response = this.invokeStatement(statement);
        this.checkWithException(response, description);
        return response.getRowSet();
    }

    private static enum GetInfoOption {
        ADD_NAME_ROW,
        ADD_NAME_COLUMN;

    }
}

