/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.scheduler.AbstractJob;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.scheduler.SingleJob;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TemplateType;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class SchedulerProxy
implements Scheduler {
    private SchedulerImpl schedulerIml;
    private String userName;

    SchedulerProxy(SchedulerImpl schedulerIml, String userName) {
        this.schedulerIml = schedulerIml;
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public SchedulerState getState() {
        return this.schedulerIml.getState();
    }

    @Override
    public String getParameter(String name) {
        return this.schedulerIml.getParameter(name);
    }

    @Override
    public void setParameter(String name, String value) throws SchedulerException {
        this.schedulerIml.setParameter(name, value, this.userName);
    }

    @Override
    public List<String> listParameters() {
        return this.schedulerIml.listParameters();
    }

    @Override
    public long getSessionId() throws SchedulerException {
        return this.schedulerIml.getSessionId();
    }

    RowSet describeSession() throws SchedulerException {
        return this.schedulerIml.describeSession();
    }

    RowSet describeDataspace() throws SchedulerException {
        return this.schedulerIml.describeDataspace();
    }

    RowSet describeDataspaceHealth() throws SchedulerException {
        return this.schedulerIml.describeDataspaceHealth();
    }

    RowSet describeDataspaceConsistency() throws SchedulerException {
        return this.schedulerIml.describeDataspaceConsistency();
    }

    RowSet describeCollections() throws SchedulerException {
        return this.schedulerIml.describeCollections();
    }

    RowSet describeCollectionsHealth() throws SchedulerException {
        return this.schedulerIml.describeCollectionsHealth();
    }

    RowSet describeCollectionsConsistency() throws SchedulerException {
        return this.schedulerIml.describeCollectionsConsistency();
    }

    @Override
    public TaskList createTaskList(String name) throws SchedulerException {
        return this.createTaskList(name, (String)null);
    }

    @Override
    public TaskList createTaskList(String name, String sourceName) throws SchedulerException {
        return this.schedulerIml.createTaskList(name, sourceName, this.userName);
    }

    @Override
    public TaskList createTaskList(String name, TaskList source) throws SchedulerException {
        return this.createTaskList(name, source, false);
    }

    @Override
    public TaskList createTaskList(String name, TaskList source, boolean asModel) throws SchedulerException {
        return this.schedulerIml.createTaskList(name, source, asModel, this.userName);
    }

    @Override
    public void dropTaskList(String name) throws SchedulerException {
        this.schedulerIml.dropTaskList(name, this.userName);
    }

    @Override
    public void updateTaskList(TaskList taskList) throws SchedulerException {
        this.schedulerIml.updateTaskList(taskList, this.userName);
    }

    @Override
    public void setTaskListOwner(String listName, String ownerName) throws SchedulerException {
        this.schedulerIml.setTaskListOwner(listName, ownerName, this.userName);
    }

    @Override
    public void enableTaskList(String name) throws SchedulerException {
        this.schedulerIml.enableTaskList(name, this.userName);
    }

    @Override
    public void disableTaskList(String name) throws SchedulerException {
        this.disableTaskList(name, false);
    }

    @Override
    public void disableTaskList(String name, boolean force) throws SchedulerException {
        this.schedulerIml.disableTaskList(name, force, this.userName);
    }

    @Override
    public boolean existsTaskList(String name) {
        return this.schedulerIml.existsTaskList(name);
    }

    @Override
    public TaskList getTaskList(String name) {
        return this.schedulerIml.getTaskList(name, this.userName);
    }

    @Override
    public TaskList getTaskList(UUID oid) {
        return this.schedulerIml.getTaskList(oid, this.userName);
    }

    @Override
    public List<TaskList> getTaskLists() {
        return this.schedulerIml.getTaskLists(this.userName);
    }

    @Override
    public List<String> listTaskLists() {
        return this.schedulerIml.listTaskListNames();
    }

    @Override
    public TaskListState executeTaskList(String name) throws SchedulerException {
        return this.executeTaskList(name, null);
    }

    @Override
    public TaskListState executeTaskList(String name, Metaset metaset) throws SchedulerException {
        return this.executeTaskList(name, metaset, null);
    }

    @Override
    public TaskListState executeTaskList(String name, Metaset metaset, Date untilTime) throws SchedulerException {
        return this.executeTaskList(name, metaset, untilTime, false);
    }

    @Override
    public TaskListState executeTaskList(String name, Metaset metaset, Date untilTime, boolean autoexpire) throws SchedulerException {
        return this.executeTaskList(name, metaset, null, untilTime, autoexpire);
    }

    @Override
    public TaskListState executeTaskList(String name, Metaset metaset, ExecutionListener listener, Date untilTime, boolean autoExpire) throws SchedulerException {
        return this.schedulerIml.executeTaskList(name, metaset, listener, untilTime, autoExpire, this.userName);
    }

    @Override
    public String startTaskList(String name) throws SchedulerException {
        return this.startTaskList(name, null);
    }

    @Override
    public String startTaskList(String name, Metaset metaset) throws SchedulerException {
        return this.startTaskList(name, metaset, null);
    }

    @Override
    public String startTaskList(String name, Metaset metaset, Date untilTime) throws SchedulerException {
        return this.startTaskList(name, metaset, untilTime, false);
    }

    @Override
    public String startTaskList(String name, Metaset metaset, Date untilTime, boolean autoExpire) throws SchedulerException {
        return this.schedulerIml.startTaskList(name, metaset, untilTime, autoExpire, this.userName);
    }

    @Override
    public void abortTaskList(String listName) throws SchedulerException {
        this.schedulerIml.stopTaskList(listName, this.userName);
    }

    @Override
    public void completeTaskList(String listName) throws SchedulerException {
        this.completeTaskList(listName, null);
    }

    @Override
    public void completeTaskList(String listName, Map<String, Object> facets) throws SchedulerException {
        this.completeTaskList(null, listName, facets);
    }

    @Override
    public void completeTaskList(String nodeName, String listName, Map<String, Object> facets) throws SchedulerException {
        this.schedulerIml.completeTask(nodeName, listName, null, this.userName, facets, false, false);
    }

    @Override
    public void failTaskList(String listName) throws SchedulerException {
        this.failTaskList(null, listName);
    }

    @Override
    public void failTaskList(String nodeName, String listName) throws SchedulerException {
        this.schedulerIml.completeTask(nodeName, listName, null, this.userName, null, true, false);
    }

    @Override
    public void expireTaskList(String listName) throws SchedulerException {
        this.expireTaskList(null, listName);
    }

    @Override
    public void expireTaskList(String nodeName, String listName) throws SchedulerException {
        this.schedulerIml.completeTask(nodeName, listName, null, this.userName, null, false, true);
    }

    @Override
    public TaskListState executeTask(String listName, String taskName) throws SchedulerException {
        return this.executeTask(listName, taskName, null);
    }

    @Override
    public TaskListState executeTask(String listName, String taskName, Metaset metaset) throws SchedulerException {
        return this.executeTask(listName, taskName, metaset, null);
    }

    @Override
    public TaskListState executeTask(String listName, String taskName, Metaset metaset, Date untilTime) throws SchedulerException {
        return this.executeTask(listName, taskName, metaset, untilTime, false);
    }

    @Override
    public TaskListState executeTask(String listName, String taskName, Metaset metaset, Date untilTime, boolean autoExpire) throws SchedulerException {
        return this.executeTask(listName, taskName, metaset, null, untilTime, autoExpire);
    }

    @Override
    public TaskListState executeTask(String listName, String taskName, Metaset metaset, ExecutionListener listener, Date untilTime, boolean autoExpire) throws SchedulerException {
        return this.schedulerIml.executeTask(listName, taskName, metaset, listener, untilTime, autoExpire, this.userName);
    }

    @Override
    public String startTask(String listName, String taskName) throws SchedulerException {
        return this.startTask(listName, taskName, null);
    }

    @Override
    public String startTask(String listName, String taskName, Metaset metaset) throws SchedulerException {
        return this.startTask(listName, taskName, metaset, null);
    }

    @Override
    public String startTask(String listName, String taskName, Metaset metaset, Date untilTime) throws SchedulerException {
        return this.startTask(listName, taskName, metaset, untilTime, false);
    }

    @Override
    public String startTask(String listName, String taskName, Metaset metaset, Date untilTime, boolean autoExpire) throws SchedulerException {
        return this.schedulerIml.startTask(listName, taskName, metaset, untilTime, autoExpire, this.userName);
    }

    @Override
    public void abortTask(String listName, String taskName) throws SchedulerException {
        this.schedulerIml.stopTask(listName, taskName, this.userName);
    }

    @Override
    public void completeTask(String listName, String taskName) throws SchedulerException {
        this.completeTask(listName, taskName, null);
    }

    @Override
    public void completeTask(String listName, String taskName, Map<String, Object> facets) throws SchedulerException {
        this.completeTask(null, listName, taskName, facets);
    }

    @Override
    public void completeTask(String nodeName, String listName, String taskName, Map<String, Object> facets) throws SchedulerException {
        this.schedulerIml.completeTask(nodeName, listName, taskName, this.userName, facets, false, false);
    }

    @Override
    public void failTask(String listName, String taskName) throws SchedulerException {
        this.failTask(null, listName, taskName);
    }

    @Override
    public void failTask(String nodeName, String listName, String taskName) throws SchedulerException {
        this.schedulerIml.completeTask(nodeName, listName, taskName, this.userName, null, true, false);
    }

    @Override
    public void expireTask(String listName, String taskName) throws SchedulerException {
        this.expireTask(null, listName, taskName);
    }

    @Override
    public void expireTask(String nodeName, String listName, String taskName) throws SchedulerException {
        this.schedulerIml.completeTask(nodeName, listName, taskName, this.userName, null, false, true);
    }

    @Override
    public void setPostCompleteTaskList(String listName, Date endTime) throws SchedulerException {
        this.setPostCompleteTaskList(listName, null, endTime);
    }

    @Override
    public void setPostCompleteTaskList(String listName, String eid, Date endTime) throws SchedulerException {
        this.schedulerIml.setPostCompleteState(listName, eid, null, endTime, this.userName);
    }

    @Override
    public void setPostCompleteTask(String listName, String taskName, Date endTime) throws SchedulerException {
        this.setPostCompleteTask(listName, null, taskName, endTime);
    }

    @Override
    public void setPostCompleteTask(String listName, String eid, String taskName, Date endTime) throws SchedulerException {
        if (StringUtils.isEmpty(taskName)) {
            throw new SchedulerException(6005, "Task name cannot be null or empty.");
        }
        this.schedulerIml.setPostCompleteState(listName, eid, taskName, endTime, this.userName);
    }

    @Override
    public TaskListExecution getExecution(String listName, UUID eid) throws SchedulerException {
        return this.schedulerIml.getExecution(listName, eid);
    }

    @Override
    public TaskListExecution getExecution(String listName, String eid) throws SchedulerException {
        return this.schedulerIml.getExecution(listName, eid);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName) throws SchedulerException {
        return this.getExecutions(listName, true);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName, boolean orderByAsc) throws SchedulerException {
        return this.schedulerIml.getExecutions(listName, orderByAsc);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName, Date fromTime, Date toTime) throws SchedulerException {
        return this.getExecutions(listName, fromTime, toTime, true);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName, Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        return this.schedulerIml.getExecutions(listName, fromTime, toTime, orderByAsc);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName, Date fromTime, Date toTime, String condition) throws SchedulerException {
        return this.schedulerIml.getExecutions(listName, fromTime, toTime, condition);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName, String condition) throws SchedulerException {
        return this.getExecutions(listName, null, null, condition);
    }

    @Override
    public List<TaskListExecution> getExecutions(String listName, int fromIndex, int toIndex) throws SchedulerException {
        return this.schedulerIml.getExecutions(listName, fromIndex, toIndex);
    }

    @Override
    public Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime) throws SchedulerException {
        return this.getAllExecutions(fromTime, toTime, true);
    }

    @Override
    public Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        return this.schedulerIml.getAllExecutions(fromTime, toTime, orderByAsc);
    }

    @Override
    public Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, String condition) throws SchedulerException {
        return this.schedulerIml.getAllExecutions(fromTime, toTime, condition);
    }

    @Override
    public Map<UUID, List<TaskListExecution>> getAllExecutions(String condition) throws SchedulerException {
        return this.getAllExecutions(null, null, condition);
    }

    Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, SelectorExpression condition) throws SchedulerException {
        return this.schedulerIml.getAllExecutions(fromTime, toTime, condition);
    }

    @Override
    public TaskListExecution getLastExecution(UUID oid) {
        return this.schedulerIml.getLastExecution(oid);
    }

    @Override
    public TaskListExecution getLastExecution(String listName) throws SchedulerException {
        return this.schedulerIml.getLastExecution(listName);
    }

    @Override
    public List<TaskListExecution> getLastExecutions(String listName, int count) throws SchedulerException {
        return this.getLastExecutions(listName, count, false);
    }

    @Override
    public List<TaskListExecution> getLastExecutions(String listName, int count, boolean orderByAsc) throws SchedulerException {
        return this.schedulerIml.getLastExecutions(listName, count, orderByAsc);
    }

    @Override
    public int getExecutionsNumber(String listName) throws SchedulerException {
        return this.schedulerIml.getExecutionsNumber(listName);
    }

    @Override
    public int getExecutionsNumber(String listName, Date fromTime, Date toTime) throws SchedulerException {
        return this.schedulerIml.getExecutionsNumber(listName, fromTime, toTime);
    }

    @Override
    public void purgeExecutions(String listName) throws SchedulerException {
        this.schedulerIml.purgeExecutions(listName, this.userName);
    }

    @Override
    public void purgeExecutions(String listName, Date fromTime, Date toTime) throws SchedulerException {
        this.schedulerIml.purgeExecutions(listName, fromTime, toTime, this.userName);
    }

    @Override
    public SingleJob createSingleJob(String name) throws SchedulerException {
        return this.createSingleJob(name, (String)null);
    }

    @Override
    public SingleJob createSingleJob(String name, String sourceName) throws SchedulerException {
        return this.schedulerIml.createSingleJob(name, sourceName, this.userName);
    }

    @Override
    public SingleJob createSingleJob(String name, SingleJob source) throws SchedulerException {
        return this.schedulerIml.createSingleJob(name, source, this.userName);
    }

    @Override
    public RepeatingJob createRepeatingJob(String name) throws SchedulerException {
        return this.createRepeatingJob(name, (String)null);
    }

    @Override
    public RepeatingJob createRepeatingJob(String name, String sourceName) throws SchedulerException {
        return this.schedulerIml.createRepeatingJob(name, sourceName, this.userName);
    }

    @Override
    public RepeatingJob createRepeatingJob(String name, RepeatingJob source) throws SchedulerException {
        return this.schedulerIml.createRepeatingJob(name, source, this.userName);
    }

    @Override
    public ScheduledJob createJob(String name, ScheduledJob source) throws SchedulerException {
        return this.schedulerIml.createJob(name, source, this.userName);
    }

    @Override
    public void dropJob(String name) throws SchedulerException {
        this.schedulerIml.dropJob(name, this.userName);
    }

    @Override
    public void updateJob(ScheduledJob job) throws SchedulerException {
        this.schedulerIml.updateJob((AbstractJob)job, this.userName);
    }

    @Override
    public void setJobOwner(String jobName, String ownerName) throws SchedulerException {
        this.schedulerIml.setJobOwner(jobName, ownerName, this.userName);
    }

    @Override
    public void setJobTaskList(String jobName, String listName) throws SchedulerException {
        this.schedulerIml.setJobTaskList(jobName, listName, this.userName);
    }

    @Override
    public void enableJob(String name) throws SchedulerException {
        this.schedulerIml.enableJob(name, this.userName);
    }

    @Override
    public void disableJob(String name) throws SchedulerException {
        this.schedulerIml.disableJob(name, this.userName);
    }

    @Override
    public boolean existsJob(String name) {
        return this.schedulerIml.existsJob(name);
    }

    @Override
    public ScheduledJob getJob(String name) {
        return this.schedulerIml.getJob(name);
    }

    @Override
    public ScheduledJob getJob(UUID oid) {
        return this.schedulerIml.getJob(oid);
    }

    @Override
    public List<ScheduledJob> getJobs() {
        return this.schedulerIml.getJobs();
    }

    @Override
    public List<String> listJobs() {
        return this.schedulerIml.listJobs();
    }

    @Override
    public List<ScheduledJob> getJobs(Date time) {
        return this.schedulerIml.getJobs(time);
    }

    @Override
    public List<ScheduledJob> getJobs(Date fromTime, Date toTime) {
        return this.schedulerIml.getJobs(fromTime, toTime);
    }

    @Override
    public void purgeJobs() {
        this.schedulerIml.purgeJobs(this.userName);
    }

    @Override
    public void purgeJobs(Date time) {
        this.schedulerIml.purgeJobs(time, this.userName);
    }

    @Override
    public void purgeJobs(Date fromTime, Date toTime) {
        this.schedulerIml.purgeJobs(fromTime, toTime, this.userName);
    }

    @Override
    public void addTimeWindow(TimeWindow window) throws SchedulerException {
        this.schedulerIml.addTimeWindow(window);
    }

    @Override
    public void removeTimeWindow(String name) throws SchedulerException {
        this.schedulerIml.removeTimeWindow(name);
    }

    @Override
    public void setTimeWindow(TimeWindow window) throws SchedulerException {
        this.schedulerIml.setTimeWindow(window);
    }

    @Override
    public boolean existsTimeWindow(String name) {
        return this.schedulerIml.existsTimeWindow(name);
    }

    @Override
    public TimeWindow getTimeWindow(String name) {
        return this.schedulerIml.getTimeWindow(name);
    }

    @Override
    public List<TimeWindow> getTimeWindows() {
        return this.schedulerIml.getTimeWindows();
    }

    @Override
    public List<String> listTimeWindows() {
        return this.schedulerIml.listTimeWindows();
    }

    @Override
    public void addTemplate(TemplateType type, String name, String value) throws SchedulerException {
        this.schedulerIml.addTemplate(type, name, value, this.userName);
    }

    @Override
    public void removeTemplate(TemplateType type, String name) throws SchedulerException {
        this.schedulerIml.removeTemplate(type, name, this.userName);
    }

    @Override
    public void setTemplate(TemplateType type, String name, String value) throws SchedulerException {
        this.schedulerIml.setTemplate(type, name, value, this.userName);
    }

    @Override
    public String getTemplate(TemplateType type, String name) {
        return this.schedulerIml.getTemplate(type, name);
    }

    @Override
    public boolean existsTemplate(TemplateType type, String name) {
        return this.schedulerIml.existsTemplate(type, name);
    }

    @Override
    public List<String> listTemplates(TemplateType type) {
        return this.schedulerIml.listTemplates(type);
    }

    Metaset createMetaset(String name, String description, Map<String, Object> values, boolean isStatic) throws SchedulerException {
        return this.schedulerIml.createMetaset(name, description, values, isStatic, this.userName);
    }

    Metaset updateMetaset(String name, String description, Map<String, Object> values, Boolean isStatic) throws SchedulerException {
        return this.schedulerIml.updateMetaset(name, description, values, isStatic, this.userName);
    }

    @Override
    public Metaset createMetaset(String name) throws SchedulerException {
        return this.createMetaset(name, null);
    }

    @Override
    public Metaset createMetaset(String name, String sourceName) throws SchedulerException {
        return this.schedulerIml.createMetaset(name, sourceName, this.userName);
    }

    @Override
    public Metaset updateMetaset(Metaset metaset) throws SchedulerException {
        return this.schedulerIml.updateMetaset(metaset, null, this.userName);
    }

    @Override
    public Metaset updateMetaset(Metaset metaset, boolean isStatic) throws SchedulerException {
        return this.schedulerIml.updateMetaset(metaset, isStatic, this.userName);
    }

    @Override
    public void dropMetaset(String name) throws SchedulerException {
        this.schedulerIml.dropMetaset(name, this.userName);
    }

    @Override
    public boolean existsMetaset(String name) {
        return this.schedulerIml.existsMetaset(name);
    }

    @Override
    public Metaset getMetaset(String name) {
        return this.schedulerIml.getMetaset(name);
    }

    @Override
    public Metaset newMetasetInstance(String name) {
        return this.schedulerIml.newMetasetInstance(name);
    }

    @Override
    public List<Metaset> getMetasets() {
        return this.schedulerIml.getMetasets();
    }

    @Override
    public List<String> listMetasets() {
        return this.schedulerIml.listMetasets();
    }

    @Override
    public void setMetasetInstance(String listName, Metaset metaset) throws SchedulerException {
        this.schedulerIml.setMetasetInstance(listName, metaset, this.userName);
    }

    @Override
    public Metaset getMetasetInstance(String listName) throws SchedulerException {
        return this.schedulerIml.getMetasetInstance(listName);
    }

    @Override
    public boolean existsMetasetInstance(String listName) throws SchedulerException {
        return this.schedulerIml.existsMetasetInstance(listName);
    }

    @Override
    public Map<UUID, Metaset> getAllMetasetInstances() throws SchedulerException {
        return this.schedulerIml.getAllMetasetInstances();
    }

    @Override
    public EventTaskTrigger createTrigger(String name) throws SchedulerException {
        return this.createTrigger(name, null);
    }

    @Override
    public EventTaskTrigger createTrigger(String name, String sourceName) throws SchedulerException {
        return this.schedulerIml.createTrigger(name, sourceName, this.userName);
    }

    @Override
    public void dropTrigger(String name) throws SchedulerException {
        this.schedulerIml.dropTrigger(name);
    }

    @Override
    public boolean existsTrigger(String name) {
        return this.schedulerIml.existsTrigger(name);
    }

    @Override
    public EventTaskTrigger getTrigger(String name) {
        return this.schedulerIml.getTrigger(name);
    }

    @Override
    public List<EventTaskTrigger> getTriggers() {
        return this.schedulerIml.getTriggers();
    }

    @Override
    public List<String> listTriggers() {
        return this.schedulerIml.listTriggers();
    }
}

