/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MailEvent;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.dispatcher.AbstractSchedulerImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.scheduler.AbstractExecutableObject;
import com.streamscape.sef.scheduler.AbstractJob;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.NotifyTemplateType;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerAdvisory;
import com.streamscape.sef.scheduler.SchedulerAdvisoryType;
import com.streamscape.sef.scheduler.SchedulerCompletionEvent;
import com.streamscape.sef.scheduler.SchedulerEvent;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerObject;
import com.streamscape.sef.scheduler.SchedulerProxy;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.scheduler.SchedulerStore;
import com.streamscape.sef.scheduler.SingleJob;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TemplateType;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.User;
import com.streamscape.sef.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;

public class SchedulerImpl
extends AbstractSchedulerImpl {
    private Map<String, String> parameters = new HashMap<String, String>();
    private transient SchedulerStore store;
    private transient MacroProcessor macroProcessor;
    private transient JSONSerializer emailSerializer;
    private transient SchedulerState state = SchedulerState.NOT_INITIALIZED;
    private transient Object mutex = new Object();
    private transient Object templateMutex = new Object();
    private static final String TEMPLATE_START = "$t:{";
    private static final String TEMPLATE_END = "}";
    private static final String DEFAULT_TEMPLATE_NAME = "Default";
    private static final String DEFAULT_NOTIFY_SUBJECT_TEMPLATE_VALUE = "[$gvar:(SYS.system)] [$gvar:(SYS.sys_type)] [@nodeName] [@advisoryType] [JOB:@jobName] Scheduler Status";
    private static final String DEFAULT_NOTIFY_BODY_TEMPLATE_VALUE = "@fullAdvisory";
    private static final String DEFAULT_TEMPLATE_PARAMETER = "$t:{Default}";

    protected SchedulerImpl() {
    }

    protected void initEmailSerializer(JSONSerializer serializer) {
        this.emailSerializer = serializer.withPrettyPrint(true);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.state = SchedulerState.INITIALIZING;
        this.macroProcessor = new MacroProcessor();
        this.mutex = new Object();
        this.templateMutex = new Object();
        this.initStore(false);
    }

    private void initStore(boolean recovery) throws Exception {
        try {
            this.store = new SchedulerStore(this);
            this.store.init();
            this.initTemplates();
        }
        catch (Exception exception) {
            if (!recovery) {
                this.setState(SchedulerState.SUSPENDED);
                Trace.logException(this, exception, true);
                Trace.logError(this, "Initialization of Scheduler failed.");
            }
            Trace.logError(this, "Scheduler recovery failed.");
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void open() {
        Object object = this.mutex;
        synchronized (object) {
            this.store.open();
            this.state = SchedulerState.ACTIVE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy() {
        Object object = this.mutex;
        synchronized (object) {
            this.state = SchedulerState.DESTROYING;
            if (this.store != null) {
                this.store.destroy();
                this.store = null;
            }
            super.destroy();
            this.state = SchedulerState.DESTROYED;
        }
    }

    @Override
    protected Scheduler getScheduler(String userName) {
        return new SchedulerProxy(this, userName);
    }

    protected void setState(SchedulerState state) {
        this.state = state;
    }

    @Override
    protected SchedulerState getState() {
        return this.state;
    }

    protected void checkState() throws SchedulerException {
        if (this.state != SchedulerState.ACTIVE) {
            throw new SchedulerException(6151, "Scheduler not active (in " + String.valueOf((Object)this.state) + " state).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recover() throws Exception {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != SchedulerState.SUSPENDED) {
                throw new SchedulerException(6151, "Scheduler not in SUSPENDED state.");
            }
            Trace.logInfo(this, "Scheduler Recovery...");
            this.initStore(true);
            this.open();
            Trace.logInfo(this, "Scheduler recovered.");
        }
    }

    private void initParameters() {
        boolean needSave = false;
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
            needSave = true;
        }
        if (needSave) {
            this.update();
        }
    }

    private boolean setDefaultParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, value);
            return true;
        }
        return false;
    }

    String getParameter(String name) {
        return this.parameters.get(name);
    }

    String getResolvedParameter(String name) {
        return this.macroProcessor.process(this.parameters.get(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParameter(String name, String value, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            String oldValue = this.getParameter(name);
            if (oldValue == null) {
                throw new SchedulerException(6008, "Unknown Scheduler parameter '" + name + "'.");
            }
            if (!oldValue.equals(value)) {
                if (!this.getUser(userName).isAdministrator()) {
                    SchedulerImpl.throwInsufficientRights("User '" + userName + "' has insufficient rights for this operation.");
                }
                this.parameters.put(name, value);
                this.update();
            }
        }
    }

    List<String> listParameters() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    long getSessionId() throws SchedulerException {
        return this.store.getSessionId();
    }

    RowSet describeSession() throws SchedulerException {
        return this.store.describeSession();
    }

    RowSet describeDataspace() throws SchedulerException {
        return this.store.describeDataspace();
    }

    RowSet describeDataspaceHealth() throws SchedulerException {
        return this.store.describeDataspaceHealth();
    }

    RowSet describeDataspaceConsistency() throws SchedulerException {
        return this.store.describeDataspaceConsistency();
    }

    RowSet describeCollections() throws SchedulerException {
        return this.store.describeCollections();
    }

    RowSet describeCollectionsHealth() throws SchedulerException {
        return this.store.describeCollectionsHealth();
    }

    RowSet describeCollectionsConsistency() throws SchedulerException {
        return this.store.describeCollectionsConsistency();
    }

    @Override
    protected void addTimeWindow(TimeWindow window) throws SchedulerException {
        super.addTimeWindow(window);
    }

    @Override
    protected void doAddTimeWindow(TimeWindow window) throws SchedulerException {
        this.store.addTimeWindow(window);
    }

    @Override
    protected void removeTimeWindow(String name) throws SchedulerException {
        super.removeTimeWindow(name);
    }

    @Override
    protected boolean doRemoveTimeWindow(String name) throws SchedulerException {
        return this.store.removeTimeWindow(name);
    }

    @Override
    protected void setTimeWindow(TimeWindow window) throws SchedulerException {
        super.setTimeWindow(window);
    }

    @Override
    protected boolean doSetTimeWindow(TimeWindow window) throws SchedulerException {
        return this.store.setTimeWindow(window);
    }

    boolean existsTimeWindow(String name) {
        return this.store.existsTimeWindow(name);
    }

    TimeWindow getTimeWindow(String name) {
        return this.store.getTimeWindow(name);
    }

    List<TimeWindow> getTimeWindows() {
        return this.store.getTimeWindows();
    }

    List<String> listTimeWindows() {
        return this.store.listTimeWindows();
    }

    @Override
    protected Map<String, TimeWindow> getTimeWindowsMap() {
        return this.store.getTimeWindowMap();
    }

    @Override
    protected void synchronizeTimeWindowsInSysplex(Map<String, TimeWindow> timeWindows, boolean newOnly) throws SchedulerException {
        if (!newOnly) {
            Utils.removeAll(timeWindows, this.store.getTimeWindowMap());
        }
        for (TimeWindow window : timeWindows.values()) {
            this.store.addTimeWindow(window);
        }
    }

    @Override
    protected void synchronizeTimeWindowsInNode(Map<String, TimeWindow> timeWindows) throws SchedulerException {
        for (TimeWindow window : timeWindows.values()) {
            this.store.addOrUpdateTimeWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metaset createMetaset(String name, String description, Map<String, Object> values, boolean isStatic, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.checkMetasetName(name);
            Metaset result = new Metaset(name, this.getUser(userName).getName().toString(), isStatic);
            result.setDescription(description);
            result.addPredefinedValues(values, false);
            result.init(this);
            this.addMetaset(result);
            return this.doCopy(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metaset updateMetaset(String name, String description, Map<String, Object> values, Boolean isStatic, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            Metaset result = this.getExistingMetaset(name, this.getUser(userName));
            if (description != null) {
                result.setDescription(description);
            }
            if (values != null) {
                result.addPredefinedValues(values, true);
            }
            if (isStatic != null) {
                result.setStatic(isStatic);
            }
            result.onUpdate();
            return this.doUpdateWithException(result);
        }
    }

    private Metaset getExistingMetaset(String name, User user) throws SchedulerException {
        Metaset result = this.doGetMetaset(name);
        if (result == null) {
            throw new SchedulerException(6153, Metaset.toLogNameWithPrefix(name) + " does not exist.");
        }
        return this.checkRights(user, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metaset createMetaset(String name, String sourceName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.checkMetasetName(name);
            Metaset result = this.createMetasetInstance(name, sourceName, this.getUser(userName).getName().toString());
            result.init(this);
            this.addMetaset(result);
            return this.doCopy(result);
        }
    }

    private void checkMetasetName(String metasetName) throws SchedulerException {
        SchedulerImpl.checkName(metasetName);
        if (this.store.existsMetaset(metasetName)) {
            throw new SchedulerException(6154, Metaset.toLogNameWithPrefix(metasetName) + " already exists.");
        }
    }

    private void addMetaset(Metaset metaset) throws SchedulerException {
        while (this.store.existsMetaset(metaset.getOID())) {
            metaset.setOID();
        }
        this.store.addMetaset(metaset);
    }

    private Metaset createMetasetInstance(String name, String sourceName, String owner) throws SchedulerException {
        Metaset sourceMetaset = null;
        if (sourceName != null && (sourceMetaset = this.doGetMetaset(sourceName)) == null) {
            throw new SchedulerException(6153, Metaset.toLogNameWithPrefix(sourceName) + " does not exist.");
        }
        return sourceMetaset != null ? new Metaset(name, sourceMetaset, owner) : new Metaset(name, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Metaset updateMetaset(Metaset metaset, Boolean isStatic, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            Metaset updatedMetaset = this.getExistingMetaset(metaset.getOID(), this.getUser(userName));
            updatedMetaset.update(metaset);
            if (isStatic != null) {
                updatedMetaset.setStatic(isStatic);
            }
            return this.doUpdateWithException(updatedMetaset);
        }
    }

    private Metaset getExistingMetaset(UUID oid, User user) throws SchedulerException {
        Metaset result = this.doGetMetaset(oid);
        if (result == null) {
            throw new SchedulerException(6153, Metaset.toLogNameWithPrefix(oid.toString()) + " does not exist.");
        }
        return this.checkRights(user, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropMetaset(String metasetName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            Metaset metaset = this.doGetMetaset(metasetName);
            if (metaset != null) {
                this.checkRights(userName);
                if (this.hasAssociatedTaskList(metaset) || this.hasAssociatedDataspace(metaset)) {
                    throw new SchedulerException(6152, metaset.toLogNameWithPrefix() + " attached at least to one Task List or Dataspace and cannot be dropped.");
                }
                this.store.removeMetaset(metaset.getOID());
            }
        }
    }

    boolean existsMetaset(String name) {
        return this.store.existsMetaset(name);
    }

    Metaset getMetaset(String name) {
        return this.newMetasetInstance(name);
    }

    Metaset newMetasetInstance(String name) {
        return this.doCopy(this.doGetMetaset(name));
    }

    Metaset getMetaset(UUID oid) {
        return this.newMetasetInstance(oid);
    }

    Metaset newMetasetInstance(UUID oid) {
        return this.doCopy(this.doGetMetaset(oid));
    }

    List<Metaset> getMetasets() {
        return this.store.getMetasets().stream().map(this::doCopy).collect(Collectors.toList());
    }

    List<String> listMetasets() {
        return this.store.listMetasetNames();
    }

    Metaset doGetMetaset(UUID oid) {
        return this.store.getMetaset(oid);
    }

    Metaset doGetMetaset(String name) {
        return this.store.getMetaset(name);
    }

    Metaset doCopy(Metaset other) {
        return other != null ? other.clone() : null;
    }

    private Metaset doUpdateWithException(Metaset metaset) throws SchedulerException {
        this.store.updateMetaset(metaset);
        return this.doCopy(metaset);
    }

    private boolean hasAssociatedTaskList(Metaset metaset) {
        return this.store.getTaskLists().stream().anyMatch(tl -> Utils.equalsNullSafe(tl.getMetasetOID(), metaset.getOID()));
    }

    private boolean hasAssociatedDataspace(Metaset metaset) {
        return SchedulerImpl.getContext().getDataspaceManager().getDataspaces().stream().anyMatch(ds -> Utils.equalsNullSafe(((AbstractDataspace)ds).getMetasetName(), metaset.getName()));
    }

    void setMetasetInstance(String listName, Metaset metaset, String userName) throws SchedulerException {
        this.getExistingTaskList(listName, userName).setMetasetInstance(metaset);
    }

    void setMetasetInstance(UUID oid, Metaset metaset) throws SchedulerException {
        if (metaset != null) {
            this.store.setMetasetInstance(oid, metaset);
        } else {
            this.store.removeMetasetInstance(oid);
        }
    }

    Metaset getMetasetInstance(String listName) throws SchedulerException {
        return this.getMetasetInstance(this.getExistingTaskListOID(listName));
    }

    Metaset getMetasetInstance(UUID oid) throws SchedulerException {
        Metaset result = this.store.getMetasetInstance(oid);
        if (result != null) {
            result.init(this);
        }
        return result;
    }

    boolean existsMetasetInstance(String listName) throws SchedulerException {
        return this.store.existsMetasetInstance(this.getExistingTaskListOID(listName));
    }

    boolean existsMetasetInstance(UUID oid) {
        try {
            return this.store.existsMetasetInstance(oid);
        }
        catch (SchedulerException exception) {
            Trace.logException(this, exception, true);
            return false;
        }
    }

    Map<UUID, Metaset> getAllMetasetInstances() throws SchedulerException {
        Map<UUID, Metaset> result = this.store.getAllMetasetInstances();
        result.forEach((uuid, metaset) -> metaset.init(this));
        return result;
    }

    TaskList createTaskList(String name, String sourceName, String userName) throws SchedulerException {
        return this.doCreateTaskList(name, sourceName, null, false, userName);
    }

    TaskList createTaskList(String name, TaskList sourceList, boolean asModel, String userName) throws SchedulerException {
        return this.doCreateTaskList(name, null, sourceList, asModel, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskList doCreateTaskList(String name, String sourceName, TaskList sourceList, boolean asModel, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.checkTaskListName(name);
            TaskList result = this.createTaskListInstance(name, sourceName, sourceList, asModel, this.getUser(userName).getName().toString());
            result.init(this);
            this.addTaskList(result);
            return this.doCopy(result, userName);
        }
    }

    private TaskList createTaskListInstance(String name, String sourceName, TaskList sourceList, boolean asModel, String owner) throws SchedulerException {
        if (sourceName != null && (sourceList = this.doGetTaskList(sourceName)) == null) {
            throw new SchedulerException(6135, TaskList.toLogNameWithPrefix(sourceName) + " does not exist.");
        }
        return sourceList != null ? new TaskList(name, sourceList, asModel, owner) : new TaskList(name, owner);
    }

    private void addTaskList(TaskList taskList) throws SchedulerException {
        while (this.store.existsTaskList(taskList.getOID())) {
            taskList.setOID();
        }
        this.store.addTaskList(taskList);
    }

    private void checkTaskListName(String listName) throws SchedulerException {
        SchedulerImpl.checkName(listName);
        if (this.store.existsTaskList(listName)) {
            throw new SchedulerException(6136, TaskList.toLogNameWithPrefix(listName) + " already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropTaskList(String listName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            TaskList taskList = this.getTaskListOrNull(listName, userName);
            if (taskList != null) {
                if (taskList.getState() != TaskListState.DISABLED) {
                    throw new SchedulerException(6138, taskList.toLogNameWithPrefix() + " is enabled and cannot be dropped.");
                }
                this.store.removeTaskList(taskList.getOID());
                taskList.onDrop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTaskList(TaskList taskList, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            User user = this.getUser(userName);
            TaskList updatedTaskList = this.getExistingTaskList(taskList.getOID(), user);
            updatedTaskList.checkDisabled();
            updatedTaskList.update(taskList);
            this.doUpdateWithException(updatedTaskList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTaskListOwner(String listName, String ownerName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            User user = this.getUser(userName);
            ComponentOwner owner = this.getOwner(user, ownerName);
            TaskList taskList = this.getExistingTaskList(listName, user);
            ScheduledJob job = taskList.getJob();
            if (job != null && !this.hasRights(job.getOwner(), owner)) {
                SchedulerImpl.throwInsufficientRights(TaskList.toLogNameWithPrefix(listName) + " is set for " + AbstractJob.toLogNameWithPrefix(job.getName()) + ". Owner of this Job has insufficient rights compared to the new owner of the Task List.");
            }
            taskList.setOwner(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableTaskList(String listName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.getExistingTaskList(listName, userName).enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableTaskList(String listName, boolean force, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.getExistingTaskList(listName, userName).disable(force);
        }
    }

    boolean existsTaskList(String name) {
        return this.store.existsTaskList(name);
    }

    TaskList getTaskList(String name, String userName) {
        return this.doCopy(this.doGetTaskList(name), userName);
    }

    TaskList getTaskList(UUID oid, String userName) {
        return this.doCopy(this.doGetTaskList(oid), userName);
    }

    List<TaskList> getTaskLists(String userName) {
        return this.store.getTaskLists().stream().map(tl -> this.doCopy((TaskList)tl, userName)).collect(Collectors.toList());
    }

    List<String> listTaskListNames() {
        return this.store.listTaskListNames();
    }

    TaskListState executeTaskList(String listName, Metaset metaset, ExecutionListener listener, Date untilTime, boolean autoExpire, String userName) throws SchedulerException {
        TaskList taskList = this.prepareExecution(listName, metaset, userName, untilTime, autoExpire);
        return taskList.executeDirect(listener);
    }

    TaskListState executeTask(String listName, String taskName, Metaset metaset, ExecutionListener listener, Date untilTime, boolean autoExpire, String userName) throws SchedulerException {
        AbstractTask task = this.prepareExecution(listName, taskName, metaset, userName, untilTime, autoExpire);
        return task.executeDirect(listener);
    }

    private String startObject(ExecutableObjectPreparer preparer, String userName, String entity) throws SchedulerException {
        AbstractExecutableObject object = preparer.prepare();
        String eid = object.getEID().toString();
        this.executeInThread(object, entity);
        return eid;
    }

    String startTaskList(String listName, Metaset metaset, Date untilTime, boolean autoExpire, String userName) throws SchedulerException {
        return this.startObject(() -> this.prepareExecution(listName, metaset, userName, untilTime, autoExpire), userName, "TaskList");
    }

    String startTask(String listName, String taskName, Metaset metaset, Date untilTime, boolean autoExpire, String userName) throws SchedulerException {
        return this.startObject(() -> this.prepareExecution(listName, taskName, metaset, userName, untilTime, autoExpire), userName, "Task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskList prepareExecution(String listName, Metaset metaset, String userName, Date untilTime, boolean autoExpire) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            TaskList taskList = this.getExistingTaskList(listName, userName);
            this.prepareExecution(taskList, metaset, userName, null, null, untilTime, autoExpire);
            return taskList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTask prepareExecution(String listName, String taskName, Metaset metaset, String userName, Date untilTime, boolean autoExpire) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            TaskList taskList = this.getExistingTaskList(listName, userName);
            AbstractTask task = this.getExistingTask(taskList, taskName);
            this.prepareExecution(task, metaset, userName, null, null, untilTime, autoExpire);
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareExecution(AbstractExecutableObject object, Metaset metaset, String userName, ExecutionMode executionMode, Date startTime, Date untilTime, boolean autoExpire) throws SchedulerException {
        Object object2 = this.mutex;
        synchronized (object2) {
            object.prepareExecution(metaset, userName, executionMode, startTime, untilTime, autoExpire);
        }
    }

    private void executeInThread(AbstractExecutableObject object, String entity) {
        FabricThreadManager.getInstance().createThread("FSYS:Scheduler.Executor:" + entity, "Directly executes a " + entity.toLowerCase() + ".", () -> {
            Utils.sleep(100L);
            object.setExecutionThread();
            object.executeDirect(null);
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTaskList(String listName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            TaskList taskList = this.getExistingTaskList(listName, userName);
            taskList.checkRunning();
            taskList.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTask(String listName, String taskName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            TaskList taskList = this.getExistingTaskList(listName, userName);
            AbstractTask task = this.getExistingTask(taskList, taskName);
            task.checkRunning();
            task.stop();
        }
    }

    void completeTask(String nodeName, String listName, String taskName, String userName, Map<String, Object> values, boolean failed, boolean expired) throws SchedulerException {
        try {
            SchedulerCompletionEvent event = (SchedulerCompletionEvent)EventDatagramFactory.getInstance().createEvent("event.Scheduler.Completion");
            if (nodeName != null) {
                event.setEventStringProperty("nodeName", nodeName);
            }
            event.setEventStringProperty("listName", listName);
            if (taskName != null) {
                event.setEventStringProperty("taskName", taskName);
            }
            event.setEventStringProperty("userName", userName);
            event.setFailed(failed);
            event.setExpired(expired);
            if (MapUtils.isNotEmpty(values)) {
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    event.setObject(entry.getKey(), entry.getValue());
                }
            }
            this.raiseEvent(event, EventScope.GLOBAL);
        }
        catch (Exception exception) {
            throw new SchedulerException(6151, (Throwable)exception);
        }
    }

    void setPostCompleteState(String listName, String eid, String taskName, Date endTime, String userName) throws SchedulerException {
        this.setPostCompleteState(this.getExistingTaskList(listName, userName).getOID(), eid, taskName, endTime);
    }

    void setPostCompleteState(UUID oid, String eid, String taskName, Date endTime, String userName) throws SchedulerException {
        this.setPostCompleteState(this.getExistingTaskList(oid, userName).getOID(), eid, taskName, endTime);
    }

    private void setPostCompleteState(UUID oid, String eid, String taskName, Date endTime) throws SchedulerException {
        TaskListExecution execution;
        TaskListExecution taskListExecution = execution = eid != null ? this.getExecution(oid, eid) : this.getLastExecution(oid);
        if (execution == null) {
            throw new SchedulerException(6166, "Execution does not exist.");
        }
        if (!execution.isCompleted()) {
            throw new SchedulerException(6167, "Execution is running.");
        }
        if (execution.isAutoComplete().booleanValue()) {
            throw new SchedulerException(6168, "Execution is auto-complete and cannot be post-completed.");
        }
        if (endTime == null) {
            endTime = new Date();
        }
        if (taskName != null) {
            TaskExecution taskExecution = execution.getTaskExecution(taskName);
            if (taskExecution == null) {
                throw new SchedulerException(6145, AbstractTask.toLogNameWithPrefix(taskName) + " does not exist in Execution.");
            }
            taskExecution.doSetCompletionState(TaskState.POST_COMPLETE);
            taskExecution.doSetCompletionEndTime(endTime);
        }
        execution.doSetState(TaskListState.POST_COMPLETE);
        execution.doSetEndTime(endTime);
        this.doUpdate(oid, execution);
    }

    private AbstractTask getExistingTask(TaskList taskList, String taskName) throws SchedulerException {
        AbstractTask result = (AbstractTask)taskList.getTask(taskName);
        if (result == null) {
            throw new SchedulerException(6145, AbstractTask.toLogNameWithPrefix(taskName) + " does not exist in " + taskList.toLogNameWithPrefix() + ".");
        }
        return result;
    }

    TaskList doCopy(TaskList other, String currentUser) {
        return other != null ? new TaskList(other, currentUser) : null;
    }

    void doUpdate(TaskList taskList) {
        try {
            this.doUpdateWithException(taskList);
        }
        catch (SchedulerException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Update Task List [" + String.valueOf(taskList.getOID()) + "] failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateWithException(TaskList taskList) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.store.updateTaskList(taskList);
        }
    }

    void addExecution(UUID oid, TaskListExecution execution, long backlogInterval) throws SchedulerException {
        this.checkState();
        this.store.addExecution(oid, execution, backlogInterval);
    }

    TaskListExecution getExecution(UUID oid, UUID eid) throws SchedulerException {
        return this.store.getExecution(oid, eid);
    }

    TaskListExecution getExecution(String listName, UUID eid) throws SchedulerException {
        return this.getExecution(this.getExistingTaskListOID(listName), eid);
    }

    TaskListExecution getExecution(UUID oid, String eid) throws SchedulerException {
        return this.getExecution(oid, UUID.fromString(eid));
    }

    TaskListExecution getExecution(String listName, String eid) throws SchedulerException {
        return this.getExecution(this.getExistingTaskListOID(listName), eid);
    }

    Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        return this.store.getAllExecutions(fromTime, toTime, orderByAsc);
    }

    Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, String condition) throws SchedulerException {
        return this.getAllExecutions(fromTime, toTime, SchedulerImpl.getConditionExpression(condition));
    }

    Map<UUID, List<TaskListExecution>> getAllExecutions(Date fromTime, Date toTime, SelectorExpression conditionExpression) throws SchedulerException {
        Map<UUID, List<TaskListExecution>> executions = this.getAllExecutions(fromTime, toTime, true);
        if (conditionExpression == null) {
            return executions;
        }
        HashMap<UUID, List<TaskListExecution>> result = new HashMap<UUID, List<TaskListExecution>>();
        executions.forEach((key, value) -> {
            List<TaskListExecution> filteredExecs = SchedulerImpl.filterByTaskFacets(value, conditionExpression);
            if (!filteredExecs.isEmpty()) {
                result.put((UUID)key, filteredExecs);
            }
        });
        return result;
    }

    List<TaskListExecution> getExecutions(String listName, boolean orderByAsc) throws SchedulerException {
        return this.getExecutions(this.getExistingTaskListOID(listName), orderByAsc);
    }

    List<TaskListExecution> getExecutions(UUID oid, boolean orderByAsc) throws SchedulerException {
        return this.store.getExecutions(oid, orderByAsc);
    }

    List<TaskListExecution> getExecutions(UUID oid, Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        if (fromTime == null && toTime == null) {
            return this.getExecutions(oid, orderByAsc);
        }
        return this.store.getExecutions(oid, fromTime, toTime, orderByAsc);
    }

    List<TaskListExecution> getExecutions(String listName, Date fromTime, Date toTime, boolean orderByAsc) throws SchedulerException {
        return this.getExecutions(this.getExistingTaskListOID(listName), fromTime, toTime, orderByAsc);
    }

    List<TaskListExecution> getExecutions(String listName, Date fromTime, Date toTime, String condition) throws SchedulerException {
        return this.getExecutions(this.getExistingTaskListOID(listName), fromTime, toTime, condition);
    }

    List<TaskListExecution> getExecutions(UUID oid, Date fromTime, Date toTime, String condition) throws SchedulerException {
        SelectorExpression conditionExpression = SchedulerImpl.getConditionExpression(condition);
        List<TaskListExecution> executions = this.getExecutions(oid, fromTime, toTime, true);
        return SchedulerImpl.filterByTaskFacets(executions, conditionExpression);
    }

    private static SelectorExpression getConditionExpression(String condition) throws SchedulerException {
        if (condition != null) {
            try {
                return SelectorParser.parse(condition);
            }
            catch (SelectorFormatException exception) {
                throw new SchedulerException(6155, "Condition is not valid.", exception);
            }
        }
        return null;
    }

    static List<TaskListExecution> filterByTaskFacets(List<TaskListExecution> executions, SelectorExpression condition) {
        return condition == null ? executions : executions.stream().filter(execution -> execution.matchesTaskCondition(condition)).collect(Collectors.toList());
    }

    List<TaskListExecution> getExecutions(String listName, int fromIndex, int toIndex) throws SchedulerException {
        if (fromIndex < 0 && toIndex < 0) {
            return this.getExecutions(listName, true);
        }
        return this.store.getExecutions(this.getExistingTaskListOID(listName), fromIndex, toIndex);
    }

    int getExecutionsNumber(String listName) throws SchedulerException {
        return this.store.getExecutionsNumber(this.getExistingTaskListOID(listName));
    }

    int getExecutionsNumber(String listName, Date fromTime, Date toTime) throws SchedulerException {
        if (fromTime == null && toTime == null) {
            return this.getExecutionsNumber(listName);
        }
        return this.store.getExecutionsNumber(this.getExistingTaskListOID(listName), fromTime, toTime);
    }

    TaskListExecution getLastExecution(UUID oid) {
        return this.store.getLastExecution(oid);
    }

    TaskListExecution getLastExecution(String listName) throws SchedulerException {
        return this.getLastExecution(this.getExistingTaskListOID(listName));
    }

    List<TaskListExecution> getLastExecutions(UUID oid, int count, boolean orderByAsc) throws SchedulerException {
        return this.store.getLastExecutions(oid, count, orderByAsc);
    }

    List<TaskListExecution> getLastExecutions(String listName, int count, boolean orderByAsc) throws SchedulerException {
        return this.getLastExecutions(this.getExistingTaskListOID(listName), count, orderByAsc);
    }

    void purgeExecutions(String listName, String userName) throws SchedulerException {
        this.checkState();
        this.store.removeExecutions(this.getExistingTaskListOID(listName, userName));
    }

    void purgeExecutions(String listName, Date fromTime, Date toTime, String userName) throws SchedulerException {
        this.checkState();
        if (fromTime == null && toTime == null) {
            this.purgeExecutions(listName, userName);
        }
        this.store.removeExecutions(this.getExistingTaskListOID(listName, userName), fromTime, toTime);
    }

    void doUpdate(UUID oid, TaskListExecution execution) {
        try {
            this.doUpdateWithException(oid, execution);
        }
        catch (SchedulerException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Update Execution [" + String.valueOf(execution.getEID()) + "] failed.");
        }
    }

    void doUpdateWithException(UUID oid, TaskListExecution execution) throws SchedulerException {
        this.store.updateExecution(oid, execution);
    }

    SingleJob createSingleJob(String name, String sourceName, String userName) throws SchedulerException {
        return (SingleJob)this.doCreateJob(JobType.SINGLE, name, sourceName, null, userName);
    }

    SingleJob createSingleJob(String name, SingleJob sourceJob, String userName) throws SchedulerException {
        return (SingleJob)this.doCreateJob(JobType.SINGLE, name, null, sourceJob, userName);
    }

    RepeatingJob createRepeatingJob(String name, String sourceName, String userName) throws SchedulerException {
        return (RepeatingJob)this.doCreateJob(JobType.REPEATING, name, sourceName, null, userName);
    }

    RepeatingJob createRepeatingJob(String name, RepeatingJob sourceJob, String userName) throws SchedulerException {
        return (RepeatingJob)this.doCreateJob(JobType.REPEATING, name, null, sourceJob, userName);
    }

    public ScheduledJob createJob(String name, ScheduledJob sourceJob, String userName) throws SchedulerException {
        return this.doCreateJob(sourceJob.getType(), name, null, sourceJob, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractJob doCreateJob(JobType type, String name, String sourceName, ScheduledJob sourceJob, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.checkJobName(name);
            AbstractJob result = this.createJobInstance(type, name, sourceName, sourceJob, this.getUser(userName).getName().toString());
            result.init(this);
            this.addJob(result);
            return this.doCopy(result);
        }
    }

    private AbstractJob createJobInstance(JobType type, String name, String sourceName, ScheduledJob sourceJob, String owner) throws SchedulerException {
        if (sourceName != null) {
            sourceJob = this.getJob(sourceName);
            if (sourceJob == null) {
                throw new SchedulerException(6114, AbstractJob.toLogNameWithPrefix(sourceName) + " does not exist.");
            }
            if (sourceJob.getType() != type) {
                throw new SchedulerException(6118, AbstractJob.toLogNameWithPrefix(sourceName) + " is not " + String.valueOf((Object)type) + " Job.");
            }
        }
        if (sourceJob != null) {
            return type == JobType.SINGLE ? new SingleJob(name, (SingleJob)sourceJob, owner) : new RepeatingJob(name, (RepeatingJob)sourceJob, owner);
        }
        return type == JobType.SINGLE ? new SingleJob(name, owner) : new RepeatingJob(name, owner);
    }

    private void addJob(AbstractJob job) throws SchedulerException {
        while (this.store.existsJob(job.getOID())) {
            job.setOID();
        }
        this.store.addJob(job);
    }

    private void checkJobName(String jobName) throws SchedulerException {
        SchedulerImpl.checkName(jobName);
        if (this.store.existsJob(jobName)) {
            throw new SchedulerException(6115, AbstractJob.toLogNameWithPrefix(jobName) + " already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropJob(String jobName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            AbstractJob job = this.getJob(jobName, userName);
            if (job != null) {
                if (job.getState() == JobState.ENABLED) {
                    throw new SchedulerException(6116, job.toLogNameWithPrefix() + " is enabled and cannot be dropped.");
                }
                this.doDropJob(job);
            }
        }
    }

    private void doDropJob(AbstractJob job) throws SchedulerException {
        this.store.removeJob(job.getOID());
        job.onDrop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateJob(AbstractJob job, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            User user = this.getUser(userName);
            AbstractJob updatedJob = this.getExistingJob(job.getOID(), user);
            updatedJob.checkDisabled();
            updatedJob.update(job);
            this.doUpdateWithException(updatedJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJobOwner(String jobName, String ownerName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            User user = this.getUser(userName);
            ComponentOwner owner = this.getOwner(user, ownerName);
            AbstractJob job = this.getExistingJob(jobName, user);
            if (job.taskList != null && !this.hasRights(owner, job.taskList.getOwner())) {
                SchedulerImpl.throwInsufficientRights(AbstractJob.toLogNameWithPrefix(jobName) + " has " + TaskList.toLogNameWithPrefix(job.getTaskListName()) + ". New owner of the Job has insufficient rights for this Task List.");
            }
            job.setOwner(owner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJobTaskList(String jobName, String listName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            TaskList list;
            this.checkState();
            User user = this.getUser(userName);
            AbstractJob job = this.getExistingJob(jobName, user);
            TaskList taskList = list = listName != null ? this.getExistingTaskList(listName, user) : null;
            if (list != null && !this.hasRights(job.getOwner(), list.getOwner())) {
                SchedulerImpl.throwInsufficientRights("Owner of " + AbstractJob.toLogNameWithPrefix(jobName) + " has insufficient rights for " + TaskList.toLogNameWithPrefix(listName) + ".");
            }
            job.setTaskList(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableJob(String jobName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.getExistingJob(jobName, userName).enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableJob(String jobName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.getExistingJob(jobName, userName).disable();
        }
    }

    boolean existsJob(String name) {
        return this.store.existsJob(name);
    }

    ScheduledJob getJob(String name) {
        return this.doCopy(this.doGetJob(name));
    }

    ScheduledJob getJob(UUID oid) {
        return this.doCopy(this.doGetJob(oid));
    }

    List<ScheduledJob> getJobs() {
        return this.store.getJobs().stream().map(job -> this.doCopy((AbstractJob)job)).collect(Collectors.toList());
    }

    List<String> listJobs() {
        return this.store.listJobNames();
    }

    List<ScheduledJob> getJobs(Date time) {
        return this.getJobs().stream().filter(job -> ((AbstractJob)job).matches(time)).map(job -> this.doCopy((AbstractJob)job)).collect(Collectors.toList());
    }

    List<ScheduledJob> getJobs(Date fromTime, Date toTime) {
        if (fromTime == null && toTime == null) {
            return this.getJobs();
        }
        TimeWindow window = new TimeWindow(fromTime, toTime);
        return this.getJobs().stream().filter(job -> ((AbstractJob)job).matches(window)).map(job -> this.doCopy((AbstractJob)job)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeJobs(String userName) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.checkState();
                User user = this.getUser(userName);
                this.store.getJobs().stream().filter(job -> this.matchesForPurge((ScheduledJob)job, user)).forEach(this::dropJobQuiet);
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeJobs(Date time, String userName) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.checkState();
                User user = this.getUser(userName);
                this.store.getJobs().stream().filter(job -> this.matchesForPurge((ScheduledJob)job, user) && ((AbstractJob)job).matches(time)).forEach(this::dropJobQuiet);
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeJobs(Date fromTime, Date toTime, String userName) {
        Object object = this.mutex;
        synchronized (object) {
            if (fromTime == null && toTime == null) {
                this.purgeJobs(userName);
            } else {
                try {
                    this.checkState();
                    User user = this.getUser(userName);
                    TimeWindow window = new TimeWindow(fromTime, toTime);
                    this.store.getJobs().stream().filter(job -> this.matchesForPurge((ScheduledJob)job, user) && ((AbstractJob)job).matches(window)).forEach(this::dropJobQuiet);
                }
                catch (SchedulerException schedulerException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean matchesForPurge(ScheduledJob job, User user) {
        return job.getState() == JobState.FINISHED && this.matchesOwner(user, job);
    }

    private boolean matchesOwner(User user, ScheduledJob job) {
        try {
            ComponentOwner owner = this.getOwner(job.getOwner());
            return user.isAdministrator() || (owner instanceof User ? user.getName().equals(owner.getName()) : user.isMemberOf(owner.getName().toString()));
        }
        catch (SchedulerException exception) {
            return false;
        }
    }

    private void dropJobQuiet(ScheduledJob job) {
        try {
            this.doDropJob((AbstractJob)job);
        }
        catch (SchedulerException exception) {
            Trace.logException(this, exception, true);
        }
    }

    AbstractJob doCopy(AbstractJob other) {
        return other != null ? other.copy() : null;
    }

    void doUpdate(AbstractJob job) {
        try {
            this.doUpdateWithException(job);
        }
        catch (SchedulerException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Update Job '" + job.getName() + "' failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateWithException(AbstractJob job) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.store.updateJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventTaskTrigger createTrigger(String name, String sourceName, String userName) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.checkTriggerName(name);
            EventTaskTrigger result = this.createTriggerInstance(name, sourceName, this.getOwner(userName).getName().toString());
            result.init(this);
            this.addTrigger(result);
            return result;
        }
    }

    private EventTaskTrigger createTriggerInstance(String name, String sourceName, String owner) throws SchedulerException {
        if (sourceName != null) {
            EventTaskTrigger sourceTrigger = this.getTrigger(sourceName);
            if (sourceTrigger == null) {
                throw new SchedulerException(6121, "Trigger [" + sourceName + "] does not exist.");
            }
            return new EventTaskTrigger(name, sourceTrigger, owner);
        }
        return new EventTaskTrigger(name, owner);
    }

    private void addTrigger(EventTaskTrigger trigger) throws SchedulerException {
        while (this.store.existsTrigger(trigger.getOID())) {
            trigger.setOID();
        }
        this.store.addTrigger(trigger);
    }

    private void checkTriggerName(String name) throws SchedulerException {
        SchedulerImpl.checkName(name);
        if (this.store.existsTrigger(name)) {
            throw new SchedulerException(6122, "Trigger [" + name + "] already exists.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropTrigger(String name) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.doDropTrigger(this.getTrigger(name));
        }
    }

    private void doDropTrigger(EventTaskTrigger trigger) throws SchedulerException {
        if (trigger != null) {
            if (trigger.isEnabled()) {
                throw new SchedulerException(6123, "Trigger [" + trigger.getName() + "] is enabled and cannot be dropped.");
            }
            this.store.removeTrigger(trigger.getOID());
        }
    }

    boolean existsTrigger(String name) {
        return this.store.existsTrigger(name);
    }

    EventTaskTrigger getTrigger(String name) {
        return this.store.getTrigger(name);
    }

    List<EventTaskTrigger> getTriggers() {
        return this.store.getTriggers();
    }

    List<String> listTriggers() {
        return this.store.listTriggerNames();
    }

    void update(EventTaskTrigger trigger) {
        try {
            this.updateWithException(trigger);
        }
        catch (SchedulerException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Update Trigger [" + String.valueOf(trigger.getOID()) + "] failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWithException(EventTaskTrigger trigger) throws SchedulerException {
        Object object = this.mutex;
        synchronized (object) {
            this.checkState();
            this.store.updateTrigger(trigger);
        }
    }

    private void initTemplates() throws SchedulerException {
        this.initDefaultTemplate(NotifyTemplateType.SUBJECT, DEFAULT_NOTIFY_SUBJECT_TEMPLATE_VALUE);
        this.initDefaultTemplate(NotifyTemplateType.BODY, DEFAULT_NOTIFY_BODY_TEMPLATE_VALUE);
    }

    private void initDefaultTemplate(NotifyTemplateType type, String defaultValue) throws SchedulerException {
        String defaultName = type.getFullName(DEFAULT_TEMPLATE_NAME);
        if (!this.store.existsTemplate(TemplateType.NOTIFY, defaultName)) {
            this.store.addTemplate(TemplateType.NOTIFY, defaultName, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTemplate(TemplateType type, String name, String value, String userName) throws SchedulerException {
        this.checkState();
        this.checkRights(userName);
        Object object = this.templateMutex;
        synchronized (object) {
            if (this.store.existsTemplate(type, name)) {
                throw new SchedulerException(6150, "Template [" + type.getFullName(name) + "] already exists.");
            }
            this.store.addTemplate(type, name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTemplate(TemplateType type, String name, String userName) throws SchedulerException {
        this.checkState();
        this.checkRights(userName);
        if (type == TemplateType.NOTIFY && (name.equals(NotifyTemplateType.SUBJECT.getFullName(DEFAULT_TEMPLATE_NAME)) || name.equals(NotifyTemplateType.BODY.getFullName(DEFAULT_TEMPLATE_NAME)))) {
            throw new SchedulerException(6151, "Template [" + type.getFullName(name) + "] cannot be dropped.");
        }
        Object object = this.templateMutex;
        synchronized (object) {
            if (this.store.existsTemplate(type, name)) {
                this.store.removeTemplate(type, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTemplate(TemplateType type, String name, String value, String userName) throws SchedulerException {
        this.checkState();
        this.checkRights(userName);
        Object object = this.templateMutex;
        synchronized (object) {
            if (!this.store.existsTemplate(type, name)) {
                throw new SchedulerException(6149, "Template [" + type.getFullName(name) + "] does not exist.");
            }
            this.store.setTemplate(type, name, value);
        }
    }

    String getTemplate(TemplateType type, String name) {
        return this.store.getTemplate(type, name);
    }

    boolean existsTemplate(TemplateType type, String name) {
        return this.store.existsTemplate(type, name);
    }

    List<String> listTemplates(TemplateType type) {
        return this.store.listTemplates(type);
    }

    static void checkName(String objectName) throws SchedulerException {
        if (StringUtils.isEmpty(objectName)) {
            throw new SchedulerException(6005, "Name cannot be null or empty string.");
        }
        SchedulerImpl.validateName(objectName);
    }

    static void validateName(String objectName) throws SchedulerException {
        if (!StringUtils.validateSemanticName(objectName)) {
            throw new SchedulerException(6007, "Name '" + objectName + "' contains invalid characters.");
        }
    }

    @Override
    protected FabricComponent getComponent() {
        return super.getComponent();
    }

    @Override
    protected EventConsumer createEventConsumer(String name, FabricEventListener listener, String eventId, String selector, EventScope eventScope) throws Exception {
        return super.createEventConsumer(name, listener, eventId, selector, eventScope);
    }

    @Override
    protected EventConsumer createEventAsyncConsumer(String name, FabricEventListener listener, String eventId, String selector, EventScope eventScope) throws Exception {
        return super.createEventAsyncConsumer(name, listener, eventId, selector, eventScope);
    }

    @Override
    protected void completeSinkEventFlow(EventConsumer consumer, EventTaskTrigger trigger) {
        super.completeSinkEventFlow(consumer, trigger);
    }

    @Override
    protected void raiseEvent(EventDatagram event, EventScope eventScope) throws Exception {
        super.raiseEvent(event, eventScope);
    }

    @Override
    protected AcknowledgementEvent raiseRequest(SchedulerEvent event, EventScope eventScope, long timeout) throws Exception {
        return super.raiseRequest(event, eventScope, timeout);
    }

    @Override
    protected void raiseAcknowledgement(AcknowledgementEvent event, EventScope eventScope) throws Exception {
        super.raiseAcknowledgement(event, eventScope);
    }

    protected SchedulerAdvisory raiseAdvisory(SchedulerAdvisoryType type, String jobName, String listName, String taskName, TaskListExecution execution, Map<String, Object> facets, Long delay, EventScope eventScope) {
        SchedulerAdvisory advisory = new SchedulerAdvisory(type, SchedulerImpl.getContext().getName(), jobName, listName, taskName, execution, facets, delay);
        super.raiseAdvisory(advisory, eventScope);
        return advisory;
    }

    protected SchedulerAdvisory raiseException(Throwable cause, String jobName, String listName, String taskName, TaskListExecution execution, EventScope eventScope) {
        SchedulerException exception = new SchedulerException(cause, jobName, listName, taskName, execution);
        super.raiseException(exception, eventScope);
        return new SchedulerAdvisory(SchedulerAdvisoryType.TASK_EXECUTION_FAILED, SchedulerImpl.getContext().getName(), jobName, listName, taskName, execution, null, null);
    }

    protected void raiseMailEvent(String to, String subject, String body, SchedulerAdvisory advisory, EventScope eventScope) {
        try {
            MailEvent event = (MailEvent)SchedulerImpl.getContext().getEventDatagramFactory().createEvent("event.Scheduler.Email");
            event.setContentType("text/plain");
            this.setTo(event, to, advisory);
            this.setSubject(event, subject, advisory);
            this.setBody(event, body, advisory);
            super.raiseEvent(event, eventScope);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Raising Scheduler Mail Event failed.");
        }
    }

    private void setTo(MailEvent event, String parameter, SchedulerAdvisory advisory) throws Exception {
        String to = this.resolveTo(parameter, advisory);
        if (!StringUtils.isEmpty(to)) {
            event.setTo(StringUtils.split(to, ";"));
        }
    }

    private void setSubject(MailEvent event, String parameter, SchedulerAdvisory advisory) throws Exception {
        event.setSubject(this.resolveSubject(parameter, advisory));
    }

    private void setBody(MailEvent event, String parameter, SchedulerAdvisory advisory) throws Exception {
        event.setBody(this.resolveBody(parameter, advisory));
    }

    String resolveTo(String parameter, SchedulerAdvisory advisory) throws Exception {
        return !StringUtils.isEmpty(parameter) ? this.resolve(NotifyTemplateType.TO, parameter, advisory) : null;
    }

    String resolveSubject(String parameter, SchedulerAdvisory advisory) throws Exception {
        return this.resolveSubjectOrBody(NotifyTemplateType.SUBJECT, parameter, advisory);
    }

    String resolveBody(String parameter, SchedulerAdvisory advisory) throws Exception {
        return this.resolveSubjectOrBody(NotifyTemplateType.BODY, parameter, advisory);
    }

    private String resolveSubjectOrBody(NotifyTemplateType type, String parameter, SchedulerAdvisory advisory) throws Exception {
        String result = null;
        if (!StringUtils.isEmpty(parameter)) {
            result = this.resolve(type, parameter, advisory);
        }
        return StringUtils.isEmpty(result) ? this.resolve(type, DEFAULT_TEMPLATE_PARAMETER, advisory) : result;
    }

    private String resolve(NotifyTemplateType type, String parameter, SchedulerAdvisory advisory) throws Exception {
        return this.resolveSpecialMacros(this.resolveTemplates(type, this.resolveValue(parameter), 0), advisory);
    }

    String resolveTemplates(NotifyTemplateType type, String source, int iStart) {
        int iTemplateEnd;
        int iTemplateStart = source.indexOf(TEMPLATE_START, iStart);
        if (iTemplateStart != -1 && (iTemplateEnd = source.indexOf(TEMPLATE_END, iTemplateStart + TEMPLATE_END.length())) != -1) {
            String templateName = source.substring(iTemplateStart + TEMPLATE_START.length(), iTemplateEnd);
            String templateValue = this.getTemplate(TemplateType.NOTIFY, type.getFullName(templateName));
            if (templateValue != null) {
                String resolvedPart = source.substring(0, iTemplateStart) + templateValue;
                return this.resolveTemplates(type, resolvedPart + source.substring(iTemplateEnd + TEMPLATE_END.length()), resolvedPart.length());
            }
            return this.resolveTemplates(type, source, iTemplateEnd + TEMPLATE_END.length());
        }
        return source;
    }

    private String resolveSpecialMacros(String parameter, SchedulerAdvisory advisory) throws Exception {
        if (advisory != null) {
            parameter = parameter.replaceAll(DEFAULT_NOTIFY_BODY_TEMPLATE_VALUE, this.emailSerializer.serialize(advisory));
            parameter = parameter.replaceAll("@advisoryType", advisory.getType().name());
            parameter = parameter.replaceAll("@jobName", advisory.getJobName());
            parameter = parameter.replaceAll("@listName", advisory.getListName());
            parameter = parameter.replaceAll("@taskName", advisory.getTaskName());
        }
        return parameter.replaceAll("@nodeName", SchedulerImpl.getContext().getName());
    }

    String resolveValue(String value) {
        return this.macroProcessor.process(value);
    }

    @Override
    protected EventReceiver createCompletionEventReceiver(TaskList taskList) throws SchedulerException {
        return super.createCompletionEventReceiver(taskList);
    }

    private TaskList getTaskListOrNull(String listName, String userName) throws SchedulerException {
        return this.checkRights(userName, this.doGetTaskList(listName));
    }

    private TaskList getExistingTaskList(String listName, String userName) throws SchedulerException {
        return this.checkRights(userName, this.doGetExistingTaskList(listName));
    }

    private TaskList getExistingTaskList(String listName, User user) throws SchedulerException {
        return this.checkRights(user, this.doGetExistingTaskList(listName));
    }

    private TaskList getExistingTaskList(UUID oid, String userName) throws SchedulerException {
        return this.checkRights(userName, this.doGetExistingTaskList(oid));
    }

    private TaskList getExistingTaskList(UUID oid, User user) throws SchedulerException {
        return this.checkRights(user, this.doGetExistingTaskList(oid));
    }

    private TaskList doGetExistingTaskList(String listName) throws SchedulerException {
        TaskList result = this.doGetTaskList(listName);
        if (result == null) {
            throw new SchedulerException(6135, TaskList.toLogNameWithPrefix(listName) + " does not exist.");
        }
        return result;
    }

    private TaskList doGetExistingTaskList(UUID oid) throws SchedulerException {
        TaskList result = this.doGetTaskList(oid);
        if (result == null) {
            throw new SchedulerException(6135, TaskList.toLogNameWithPrefix(oid.toString()) + " does not exist.");
        }
        return result;
    }

    TaskList doGetTaskList(String name) {
        return this.store.getTaskList(name);
    }

    TaskList doGetTaskList(UUID oid) {
        return this.store.getTaskList(oid);
    }

    private UUID getExistingTaskListOID(String listName) throws SchedulerException {
        return this.doGetExistingTaskList(listName).getOID();
    }

    private UUID getExistingTaskListOID(String listName, String userName) throws SchedulerException {
        return this.getExistingTaskList(listName, userName).getOID();
    }

    private AbstractJob getJob(String jobName, String userName) throws SchedulerException {
        return this.checkRights(userName, this.doGetJob(jobName));
    }

    private AbstractJob getExistingJob(String jobName, String userName) throws SchedulerException {
        return this.checkRights(userName, this.doGetExistingJob(jobName));
    }

    private AbstractJob getExistingJob(String jobName, User user) throws SchedulerException {
        return this.checkRights(user, this.doGetExistingJob(jobName));
    }

    private AbstractJob getExistingJob(UUID oid, User user) throws SchedulerException {
        return this.checkRights(user, this.doGetExistingJob(oid));
    }

    private AbstractJob doGetExistingJob(String jobName) throws SchedulerException {
        AbstractJob result = this.doGetJob(jobName);
        if (result == null) {
            throw new SchedulerException(6135, AbstractJob.toLogNameWithPrefix(jobName) + " does not exist.");
        }
        return result;
    }

    private AbstractJob doGetExistingJob(UUID oid) throws SchedulerException {
        AbstractJob result = this.doGetJob(oid);
        if (result == null) {
            throw new SchedulerException(6135, AbstractJob.toLogNameWithPrefix(oid.toString()) + " does not exist.");
        }
        return result;
    }

    AbstractJob doGetJob(String name) {
        return this.store.getJob(name);
    }

    AbstractJob doGetJob(UUID oid) {
        return this.store.getJob(oid);
    }

    @Override
    protected User getUser(String userName) throws SchedulerException {
        return super.getUser(userName);
    }

    @Override
    protected ComponentOwner getOwner(String ownerName) throws SchedulerException {
        return super.getOwner(ownerName);
    }

    protected ComponentOwner getDefaultOwner() {
        return SchedulerImpl.getContext().getSecurityContext().getUser();
    }

    protected String getDefaultOwnerName() {
        return this.getDefaultOwner().getName().toString();
    }

    @Override
    protected boolean existsUser(String userName) {
        return super.existsUser(userName);
    }

    protected ComponentOwner getOwner(User currentUser, String ownerName) throws SchedulerException {
        if (!currentUser.isAdministrator()) {
            SchedulerImpl.throwInsufficientRights("User '" + String.valueOf(currentUser.getName()) + "' has insufficient rights for this operation.");
        }
        return this.getOwner(ownerName);
    }

    private <T extends SchedulerObject> T checkRights(User user, T object) throws SchedulerException {
        if (object != null) {
            this.checkRights(user, object.getOwner());
        }
        return object;
    }

    private <T extends SchedulerObject> T checkRights(String userName, T object) throws SchedulerException {
        return this.checkRights(this.getUser(userName), object);
    }

    protected void checkRights(User user, String ownerName) throws SchedulerException {
        ComponentOwner owner = this.getOwner(ownerName);
        if (!this.hasRights(user, ownerName)) {
            SchedulerImpl.throwInsufficientRights("User '" + String.valueOf(user.getName()) + "' has insufficient rights for this operation.");
        }
    }

    protected boolean hasRights(String jobOwnerName, String listOwnerName) throws SchedulerException {
        return this.hasRights(this.getOwner(jobOwnerName), this.getOwner(jobOwnerName));
    }

    protected boolean hasRights(String jobOwnerName, ComponentOwner listOwner) throws SchedulerException {
        return this.hasRights(this.getOwner(jobOwnerName), listOwner);
    }

    protected boolean hasRights(ComponentOwner jobOwner, String listOwnerName) throws SchedulerException {
        return this.hasRights(jobOwner, this.getOwner(listOwnerName));
    }

    protected boolean hasRights(ComponentOwner jobOwner, ComponentOwner listOwner) throws SchedulerException {
        if (jobOwner instanceof User) {
            return this.hasRights((User)jobOwner, listOwner);
        }
        if (jobOwner.isAdministrator()) {
            return true;
        }
        return listOwner instanceof User ? ((User)listOwner).isMemberOf(jobOwner.getName().toString()) : jobOwner.getName().equals(listOwner.getName());
    }

    protected boolean hasRights(User user, String ownerName) throws SchedulerException {
        return this.hasRights(user, this.getOwner(ownerName));
    }

    protected boolean hasRights(User user, ComponentOwner owner) throws SchedulerException {
        if (owner instanceof User) {
            return this.hasRightsForUser(user, (User)owner);
        }
        return this.hasRightsForGroup(user, (Group)owner);
    }

    private boolean hasRightsForUser(User user, User owner) throws SchedulerException {
        return user.isAdministrator() || user.getName().equals(owner.getName());
    }

    private boolean hasRightsForGroup(User user, Group owner) throws SchedulerException {
        return user.isAdministrator() || user.isMemberOf(owner.getName().toString());
    }

    protected void checkRights(String userName) throws SchedulerException {
        if (!this.getUser(userName).isAdministrator()) {
            SchedulerImpl.throwInsufficientRights("User '" + userName + "' has insufficient rights for this operation.");
        }
    }

    @Override
    protected Operation<?> getDSLOperation(String command) throws SchedulerException {
        return super.getDSLOperation(command);
    }

    protected static void throwInsufficientRights(String errorMessage) throws SchedulerException {
        AbstractSchedulerImpl.throwInsufficientRights(errorMessage);
    }

    @Override
    protected void checkSemanticType(String key, Object value) throws SchedulerException {
        super.checkSemanticType(key, value);
    }

    private static interface ExecutableObjectPreparer {
        public AbstractExecutableObject prepare() throws SchedulerException;
    }
}

