/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.RepeatingJob;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.scheduler.SingleJob;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TemplateType;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface Scheduler {
    public static final String ADVISORY_EMAIL_SUBJECT = "advisory.email.subject";
    public static final String ADVISORY_EMAIL_TO = "advisory.email.to";

    public SchedulerState getState();

    public String getUserName();

    public String getParameter(String var1);

    public void setParameter(String var1, String var2) throws SchedulerException;

    public List<String> listParameters();

    public long getSessionId() throws SchedulerException;

    public TaskList createTaskList(String var1) throws SchedulerException;

    public TaskList createTaskList(String var1, String var2) throws SchedulerException;

    public TaskList createTaskList(String var1, TaskList var2) throws SchedulerException;

    public TaskList createTaskList(String var1, TaskList var2, boolean var3) throws SchedulerException;

    public void dropTaskList(String var1) throws SchedulerException;

    public void updateTaskList(TaskList var1) throws SchedulerException;

    public void setTaskListOwner(String var1, String var2) throws SchedulerException;

    public void enableTaskList(String var1) throws SchedulerException;

    public void disableTaskList(String var1) throws SchedulerException;

    public void disableTaskList(String var1, boolean var2) throws SchedulerException;

    public boolean existsTaskList(String var1);

    public TaskList getTaskList(String var1);

    public TaskList getTaskList(UUID var1);

    public List<TaskList> getTaskLists();

    public List<String> listTaskLists();

    public TaskListState executeTaskList(String var1) throws SchedulerException;

    public TaskListState executeTaskList(String var1, Metaset var2) throws SchedulerException;

    public TaskListState executeTaskList(String var1, Metaset var2, Date var3) throws SchedulerException;

    public TaskListState executeTaskList(String var1, Metaset var2, Date var3, boolean var4) throws SchedulerException;

    public TaskListState executeTaskList(String var1, Metaset var2, ExecutionListener var3, Date var4, boolean var5) throws SchedulerException;

    public String startTaskList(String var1) throws SchedulerException;

    public String startTaskList(String var1, Metaset var2) throws SchedulerException;

    public String startTaskList(String var1, Metaset var2, Date var3) throws SchedulerException;

    public String startTaskList(String var1, Metaset var2, Date var3, boolean var4) throws SchedulerException;

    public void abortTaskList(String var1) throws SchedulerException;

    public void completeTaskList(String var1) throws SchedulerException;

    public void completeTaskList(String var1, Map<String, Object> var2) throws SchedulerException;

    public void completeTaskList(String var1, String var2, Map<String, Object> var3) throws SchedulerException;

    public void failTaskList(String var1) throws SchedulerException;

    public void failTaskList(String var1, String var2) throws SchedulerException;

    public void expireTaskList(String var1) throws SchedulerException;

    public void expireTaskList(String var1, String var2) throws SchedulerException;

    public TaskListState executeTask(String var1, String var2) throws SchedulerException;

    public TaskListState executeTask(String var1, String var2, Metaset var3) throws SchedulerException;

    public TaskListState executeTask(String var1, String var2, Metaset var3, Date var4) throws SchedulerException;

    public TaskListState executeTask(String var1, String var2, Metaset var3, Date var4, boolean var5) throws SchedulerException;

    public TaskListState executeTask(String var1, String var2, Metaset var3, ExecutionListener var4, Date var5, boolean var6) throws SchedulerException;

    public String startTask(String var1, String var2) throws SchedulerException;

    public String startTask(String var1, String var2, Metaset var3) throws SchedulerException;

    public String startTask(String var1, String var2, Metaset var3, Date var4) throws SchedulerException;

    public String startTask(String var1, String var2, Metaset var3, Date var4, boolean var5) throws SchedulerException;

    public void abortTask(String var1, String var2) throws SchedulerException;

    public void completeTask(String var1, String var2) throws SchedulerException;

    public void completeTask(String var1, String var2, Map<String, Object> var3) throws SchedulerException;

    public void completeTask(String var1, String var2, String var3, Map<String, Object> var4) throws SchedulerException;

    public void failTask(String var1, String var2) throws SchedulerException;

    public void failTask(String var1, String var2, String var3) throws SchedulerException;

    public void expireTask(String var1, String var2) throws SchedulerException;

    public void expireTask(String var1, String var2, String var3) throws SchedulerException;

    public void setPostCompleteTaskList(String var1, Date var2) throws SchedulerException;

    public void setPostCompleteTaskList(String var1, String var2, Date var3) throws SchedulerException;

    public void setPostCompleteTask(String var1, String var2, Date var3) throws SchedulerException;

    public void setPostCompleteTask(String var1, String var2, String var3, Date var4) throws SchedulerException;

    public TaskListExecution getExecution(String var1, UUID var2) throws SchedulerException;

    public TaskListExecution getExecution(String var1, String var2) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1, boolean var2) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1, Date var2, Date var3) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1, Date var2, Date var3, boolean var4) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1, Date var2, Date var3, String var4) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1, String var2) throws SchedulerException;

    public Map<UUID, List<TaskListExecution>> getAllExecutions(Date var1, Date var2) throws SchedulerException;

    public Map<UUID, List<TaskListExecution>> getAllExecutions(Date var1, Date var2, boolean var3) throws SchedulerException;

    public Map<UUID, List<TaskListExecution>> getAllExecutions(Date var1, Date var2, String var3) throws SchedulerException;

    public Map<UUID, List<TaskListExecution>> getAllExecutions(String var1) throws SchedulerException;

    public List<TaskListExecution> getExecutions(String var1, int var2, int var3) throws SchedulerException;

    public TaskListExecution getLastExecution(UUID var1);

    public TaskListExecution getLastExecution(String var1) throws SchedulerException;

    public List<TaskListExecution> getLastExecutions(String var1, int var2) throws SchedulerException;

    public List<TaskListExecution> getLastExecutions(String var1, int var2, boolean var3) throws SchedulerException;

    public int getExecutionsNumber(String var1) throws SchedulerException;

    public int getExecutionsNumber(String var1, Date var2, Date var3) throws SchedulerException;

    public void purgeExecutions(String var1) throws SchedulerException;

    public void purgeExecutions(String var1, Date var2, Date var3) throws SchedulerException;

    public SingleJob createSingleJob(String var1) throws SchedulerException;

    public SingleJob createSingleJob(String var1, String var2) throws SchedulerException;

    public SingleJob createSingleJob(String var1, SingleJob var2) throws SchedulerException;

    public RepeatingJob createRepeatingJob(String var1) throws SchedulerException;

    public RepeatingJob createRepeatingJob(String var1, String var2) throws SchedulerException;

    public RepeatingJob createRepeatingJob(String var1, RepeatingJob var2) throws SchedulerException;

    public ScheduledJob createJob(String var1, ScheduledJob var2) throws SchedulerException;

    public void dropJob(String var1) throws SchedulerException;

    public void updateJob(ScheduledJob var1) throws SchedulerException;

    public void setJobOwner(String var1, String var2) throws SchedulerException;

    public void setJobTaskList(String var1, String var2) throws SchedulerException;

    public void enableJob(String var1) throws SchedulerException;

    public void disableJob(String var1) throws SchedulerException;

    public boolean existsJob(String var1);

    public ScheduledJob getJob(String var1);

    public ScheduledJob getJob(UUID var1);

    public List<ScheduledJob> getJobs();

    public List<ScheduledJob> getJobs(Date var1);

    public List<ScheduledJob> getJobs(Date var1, Date var2);

    public List<String> listJobs();

    public void purgeJobs();

    public void purgeJobs(Date var1);

    public void purgeJobs(Date var1, Date var2);

    public void addTimeWindow(TimeWindow var1) throws SchedulerException;

    public void removeTimeWindow(String var1) throws SchedulerException;

    public void setTimeWindow(TimeWindow var1) throws SchedulerException;

    public boolean existsTimeWindow(String var1);

    public TimeWindow getTimeWindow(String var1);

    public List<TimeWindow> getTimeWindows();

    public List<String> listTimeWindows();

    public void addTemplate(TemplateType var1, String var2, String var3) throws SchedulerException;

    public void removeTemplate(TemplateType var1, String var2) throws SchedulerException;

    public void setTemplate(TemplateType var1, String var2, String var3) throws SchedulerException;

    public String getTemplate(TemplateType var1, String var2);

    public boolean existsTemplate(TemplateType var1, String var2);

    public List<String> listTemplates(TemplateType var1);

    public Metaset createMetaset(String var1) throws SchedulerException;

    public Metaset createMetaset(String var1, String var2) throws SchedulerException;

    public Metaset updateMetaset(Metaset var1) throws SchedulerException;

    public Metaset updateMetaset(Metaset var1, boolean var2) throws SchedulerException;

    public void dropMetaset(String var1) throws SchedulerException;

    public boolean existsMetaset(String var1);

    public Metaset getMetaset(String var1);

    public Metaset newMetasetInstance(String var1);

    public List<Metaset> getMetasets();

    public List<String> listMetasets();

    public void setMetasetInstance(String var1, Metaset var2) throws SchedulerException;

    public Metaset getMetasetInstance(String var1) throws SchedulerException;

    public boolean existsMetasetInstance(String var1) throws SchedulerException;

    public Map<UUID, Metaset> getAllMetasetInstances() throws SchedulerException;

    public EventTaskTrigger createTrigger(String var1) throws SchedulerException;

    public EventTaskTrigger createTrigger(String var1, String var2) throws SchedulerException;

    public void dropTrigger(String var1) throws SchedulerException;

    public boolean existsTrigger(String var1);

    public EventTaskTrigger getTrigger(String var1);

    public List<EventTaskTrigger> getTriggers();

    public List<String> listTriggers();
}

