/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.DescribedNamedObject;
import com.streamscape.sef.scheduler.Rule;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class RuleSet
extends AbstractNamedObject
implements DescribedNamedObject {
    transient AbstractTask task;
    private String description;
    private List<Rule> rules = new ArrayList<Rule>();

    RuleSet(String name, String description) {
        super(name);
        this.description = description;
    }

    protected void init(AbstractTask task) {
        this.task = task;
        this.rules.forEach(rule -> rule.init(this));
    }

    protected void checkOnLoad() throws SchedulerException {
        for (Rule rule : this.rules) {
            rule.initConditionOnLoad();
        }
    }

    public Task getTask() {
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws SchedulerException {
        TaskList taskList = this.task.taskList;
        synchronized (taskList) {
            if (!StringUtils.equalsNullSafe(this.name, name)) {
                this.task.taskList.checkRuleSetName(name);
                this.name = name;
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rule addRule(String ruleName, String description, String condition, String execTaskName) throws SchedulerException {
        TaskList taskList = this.task.taskList;
        synchronized (taskList) {
            this.checkRuleName(ruleName);
            AbstractTask execTask = this.task.taskList.getTaskWithCheck(execTaskName);
            this.checkExecTask(execTask);
            this.task.taskList.resetExecutionTree();
            Rule rule = new Rule(ruleName, description, condition, execTask.getOID());
            rule.init(this);
            this.rules.add(rule);
            return rule;
        }
    }

    public synchronized void removeRule(String ruleName) {
        this.rules.removeIf(rule -> rule.getName().equals(ruleName));
    }

    synchronized boolean removeRuleByExecTask(UUID taskOID) {
        return this.rules.removeIf(rule -> rule.getExecTaskOID().equals(taskOID));
    }

    public synchronized Rule getRule(String ruleName) {
        return this.rules.stream().filter(rule -> rule.getName().equals(ruleName)).findFirst().orElse(null);
    }

    public synchronized Rule getRuleByExecTask(UUID taskOID) {
        return this.rules.stream().filter(rule -> rule.getExecTaskOID().equals(taskOID)).findFirst().orElse(null);
    }

    public synchronized boolean existsRule(String ruleName) {
        return this.rules.stream().anyMatch(rule -> rule.getName().equals(ruleName));
    }

    public synchronized boolean existsRuleByExecTask(UUID taskOID) {
        return this.rules.stream().anyMatch(rule -> rule.getExecTaskOID().equals(taskOID));
    }

    public synchronized boolean hasRules() {
        return !this.rules.isEmpty();
    }

    public synchronized List<Rule> getRules() {
        return new ArrayList<Rule>(this.rules);
    }

    public synchronized List<String> listRules() {
        return this.rules.stream().map(AbstractNamedObject::getName).collect(Collectors.toList());
    }

    void checkExecTask(AbstractTask execTask) throws SchedulerException {
        if (this.task.getOID().equals(execTask.getOID())) {
            throw new SchedulerException(6148, "Recursive State Transition is not allowed ([" + this.task.getName() + "] -> [" + execTask.getName() + "]).");
        }
        if (execTask.getAfterTaskOID() != null) {
            throw new SchedulerException(6147, "State Transition after another Task already exists for " + execTask.toLogNameWithPrefix() + ".");
        }
        this.task.taskList.checkAbsenceRuleSetByExecTask(execTask);
    }

    void checkRuleName(String ruleName) throws SchedulerException {
        TaskList.doCheckName(ruleName, this::existsRule, "Rule", 6160);
    }

    @Override
    public RuleSet clone() {
        RuleSet result = (RuleSet)super.clone();
        if (this.rules != null) {
            result.rules = new ArrayList<Rule>();
            this.rules.forEach(rule -> result.rules.add(rule.clone()));
        }
        return result;
    }

    RuleSet copy(AbstractTask task, Map<UUID, UUID> taskIdMap) {
        RuleSet result = (RuleSet)super.clone();
        result.task = task;
        if (this.rules != null) {
            result.rules = new ArrayList<Rule>();
            this.rules.forEach(rule -> result.rules.add(rule.copy(result, taskIdMap)));
        }
        return result;
    }
}

