/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.selector.SelectorEvaluationException;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.SelectorValueSource;
import com.streamscape.lib.selector.VariableSelectorExpression;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.DescribedNamedObject;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import java.util.Map;
import java.util.UUID;

public class Rule
extends AbstractNamedObject
implements DescribedNamedObject,
SelectorValueSource {
    transient RuleSet ruleSet;
    private String description;
    private String condition;
    private UUID execTaskId;
    transient SelectorExpression conditionExpression;

    Rule(String name, String description, String condition, UUID execTaskId) throws SchedulerException {
        super(name);
        this.description = description;
        this.doSetCondition(condition);
        this.execTaskId = execTaskId;
    }

    protected void init(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) throws SchedulerException {
        RuleSet ruleSet = this.ruleSet;
        synchronized (ruleSet) {
            if (!StringUtils.equalsNullSafe(this.name, name)) {
                this.ruleSet.checkRuleName(name);
                this.name = name;
            }
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public UUID getExecTaskOID() {
        return this.execTaskId;
    }

    public String getExecTaskName() {
        Task execTask = this.ruleSet.task.taskList.getTask(this.execTaskId);
        return execTask != null ? execTask.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecTask(String taskName) throws SchedulerException {
        TaskList taskList = this.ruleSet.task.taskList;
        synchronized (taskList) {
            AbstractTask newExecTask = this.ruleSet.task.taskList.getTaskWithCheck(taskName);
            if (!Utils.equalsNullSafe(this.execTaskId, newExecTask.getOID())) {
                this.ruleSet.checkExecTask(newExecTask);
                this.ruleSet.task.taskList.resetExecutionTree();
                this.setExecTaskId(newExecTask.getOID());
            }
        }
    }

    void setExecTaskId(UUID execTaskId) {
        this.execTaskId = execTaskId;
    }

    public String getCondition() {
        return this.condition;
    }

    SelectorExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public synchronized void setCondition(String condition) throws SchedulerException {
        this.doSetCondition(condition);
    }

    private void doSetCondition(String condition) throws SchedulerException {
        this.initConditionExpression(condition);
        this.condition = condition;
    }

    private static void checkCondition(String condition) throws SchedulerException {
        if (StringUtils.isEmpty(condition)) {
            throw new SchedulerException(6005, "Condition cannot be null or an empty string.");
        }
    }

    void initConditionOnLoad() throws SchedulerException {
        if (this.condition != null) {
            this.initConditionExpression(this.condition);
        }
    }

    private void initConditionExpression(String condition) throws SchedulerException {
        Rule.checkCondition(condition);
        try {
            this.conditionExpression = SelectorParser.parse(condition);
        }
        catch (SelectorFormatException exception) {
            throw new SchedulerException(6155, "Condition is not valid.", exception);
        }
    }

    boolean matchesCondition() {
        return this.conditionExpression.matches(this);
    }

    boolean matchesCondition(Metaset metaset) {
        return this.conditionExpression.matches(metaset);
    }

    @Override
    public Object getValue(VariableSelectorExpression expression) throws SelectorEvaluationException {
        if (expression.isCompletion() && this.ruleSet.task.taskList.completionEvent != null) {
            return this.ruleSet.task.taskList.completionEvent.getValue(expression);
        }
        return this.ruleSet.task.taskList.executionMetaset != null ? this.ruleSet.task.taskList.executionMetaset.getValue(expression) : null;
    }

    @Override
    public Rule clone() {
        return (Rule)super.clone();
    }

    Rule copy(RuleSet ruleSet, Map<UUID, UUID> taskIdMap) {
        Rule result = this.clone();
        result.ruleSet = ruleSet;
        result.execTaskId = taskIdMap.get(this.execTaskId);
        return result;
    }
}

