/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.sef.scheduler.AbstractJob;
import com.streamscape.sef.scheduler.DayOfWeek;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.SchedulerAdvisoryType;
import com.streamscape.sef.scheduler.SchedulerException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class RepeatingJob
extends AbstractJob
implements ScheduledJob {
    private Long repeatInterval;
    private TimeUnit repeatIntervalUnit;
    private Integer repeatCount;
    private Set<TimeWindow> exclusionWindows;
    private Set<DayOfWeek> exclusionDaysOfWeek;
    private Date lastExecutionTime;
    private Date nextExecutionTime;
    private int remainingRepeatCount;

    RepeatingJob(String name, String author) throws SchedulerException {
        super(name, author);
    }

    RepeatingJob(String name, RepeatingJob other, String owner) {
        super(name, other, owner);
        this.copyFields(other);
    }

    RepeatingJob(RepeatingJob other) {
        super(other);
        this.copyFields(other);
        this.lastExecutionTime = other.lastExecutionTime;
        this.nextExecutionTime = other.nextExecutionTime;
        this.remainingRepeatCount = other.remainingRepeatCount;
    }

    @Override
    protected AbstractJob copy() {
        return new RepeatingJob(this);
    }

    @Override
    protected void update(AbstractJob other) throws SchedulerException {
        super.update(other);
        this.copyFields((RepeatingJob)other);
    }

    private void copyFields(RepeatingJob other) {
        this.copyMainFields(other);
        this.exclusionWindows = other.exclusionWindows != null ? new TreeSet<TimeWindow>(other.exclusionWindows) : null;
        this.exclusionDaysOfWeek = other.exclusionDaysOfWeek != null ? new HashSet<DayOfWeek>(other.exclusionDaysOfWeek) : null;
    }

    private void copyMainFields(RepeatingJob other) {
        this.repeatInterval = other.repeatInterval;
        this.repeatIntervalUnit = other.repeatIntervalUnit;
        this.repeatCount = other.repeatCount;
    }

    @Override
    public JobType getType() {
        return JobType.REPEATING;
    }

    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    public synchronized void setRepeatInterval(long repeatInterval) throws SchedulerException {
        RepeatingJob.checkRepeatInterval(repeatInterval);
        this.repeatInterval = repeatInterval;
    }

    private static void checkRepeatInterval(long repeatInterval) throws SchedulerException {
        if (repeatInterval <= 0L) {
            throw new SchedulerException(6007, "Repeat interval must be positive.");
        }
    }

    public TimeUnit getRepeatIntervalUnit() {
        return this.repeatIntervalUnit;
    }

    public synchronized void setRepeatIntervalUnit(TimeUnit repeatIntervalUnit) {
        this.repeatIntervalUnit = repeatIntervalUnit;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public synchronized void setRepeatCount(int repeatCount) {
        this.repeatCount = this.normalizeRepeatCount(repeatCount);
    }

    public int getRemainingRepeatCount() {
        return this.state == JobState.ENABLED ? this.remainingRepeatCount : this.repeatCount;
    }

    private int normalizeRepeatCount(int repeatCount) {
        return repeatCount <= 0 ? -1 : repeatCount;
    }

    public synchronized void addExclusionWindow(TimeWindow window) {
        this.initExclusionWindows();
        this.exclusionWindows.add(window);
    }

    public synchronized void removeExclusionWindow(TimeWindow window) {
        if (this.exclusionWindows != null) {
            this.exclusionWindows.remove(window);
            if (this.exclusionWindows.isEmpty()) {
                this.exclusionWindows = null;
            }
        }
    }

    public synchronized void clearExclusionWindows() {
        if (this.exclusionWindows != null) {
            this.exclusionWindows.clear();
            this.exclusionWindows = null;
        }
    }

    public synchronized List<TimeWindow> getExclusionWindows() {
        return this.exclusionWindows != null ? new ArrayList<TimeWindow>(this.exclusionWindows) : new ArrayList();
    }

    private void initExclusionWindows() {
        if (this.exclusionWindows == null) {
            this.exclusionWindows = new TreeSet<TimeWindow>();
        }
    }

    public synchronized void addExclusionDayOfWeek(DayOfWeek day) {
        this.initExclusionDays();
        this.exclusionDaysOfWeek.add(day);
    }

    public synchronized void removeExclusionDayOfWeek(DayOfWeek day) {
        if (this.exclusionDaysOfWeek != null) {
            this.exclusionDaysOfWeek.remove((Object)day);
            if (this.exclusionDaysOfWeek.isEmpty()) {
                this.exclusionDaysOfWeek = null;
            }
        }
    }

    public synchronized void clearExclusionDaysOfWeek() {
        if (this.exclusionDaysOfWeek != null) {
            this.exclusionDaysOfWeek.clear();
            this.exclusionDaysOfWeek = null;
        }
    }

    public synchronized List<DayOfWeek> getExclusionDaysOfWeek() {
        return this.exclusionDaysOfWeek != null ? new ArrayList<DayOfWeek>(this.exclusionDaysOfWeek) : new ArrayList();
    }

    private void initExclusionDays() {
        if (this.exclusionDaysOfWeek == null) {
            this.exclusionDaysOfWeek = new HashSet<DayOfWeek>();
        }
    }

    @Override
    public Date getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    @Override
    public Date getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    @Override
    protected void checkParameters() throws SchedulerException {
        super.checkParameters();
        if (this.repeatInterval == null) {
            throw new SchedulerException(6004, "Repeat interval is not set.");
        }
        RepeatingJob.checkRepeatInterval(this.repeatInterval);
        if (this.repeatIntervalUnit == null) {
            throw new SchedulerException(6004, "Repeat interval unit is not set.");
        }
        if (this.repeatCount == null) {
            throw new SchedulerException(6004, "Repeat count is not set.");
        }
        this.repeatCount = this.normalizeRepeatCount(this.repeatCount);
    }

    @Override
    void checkStartTime() throws SchedulerException {
        if (this.startTime == null) {
            this.startTime = new Date(System.currentTimeMillis() + this.getRepeatIntervalMsec());
        }
    }

    @Override
    boolean scheduleEvent(boolean onLoad) {
        this.remainingRepeatCount = this.repeatCount;
        this.updateExecutionParameters(onLoad && this.lastExecutionTime != null ? this.lastExecutionTime : this.startTime);
        return this.doScheduleEvent(this.nextExecutionTime);
    }

    @Override
    Date getExecutionTime() {
        return this.nextExecutionTime;
    }

    @Override
    boolean isEventAvailable() {
        return this.nextExecutionTime != null;
    }

    @Override
    synchronized void afterTaskListExecution(boolean completed) {
        if (this.taskThread != null) {
            this.taskTimer = null;
            this.taskThread = null;
            this.lastExecutionTime = this.nextExecutionTime;
            if (this.remainingRepeatCount != -1) {
                --this.remainingRepeatCount;
            }
            this.updateInStorage();
            if (completed) {
                this.raiseAdvisory(SchedulerAdvisoryType.JOB_EXECUTION_COMPLETED, true);
            }
            if (this.remainingRepeatCount != 0) {
                this.updateExecutionParameters(this.nextExecutionTime);
                this.doScheduleEvent(this.nextExecutionTime);
            } else {
                this.nextExecutionTime = null;
                this.finish();
            }
        }
    }

    private void updateExecutionParameters(Date startTime) {
        if (this.remainingRepeatCount != 0) {
            long repeatInterval = this.getRepeatIntervalMsec();
            long distance = RepeatingJob.distance(startTime, new Date());
            if (distance <= 0L) {
                this.nextExecutionTime = startTime;
            } else {
                int nMissedRepeats = (int)(distance / repeatInterval);
                this.nextExecutionTime = this.calculateNextExecutionTime(startTime, nMissedRepeats + 1, repeatInterval);
            }
            if (this.nextExecutionTime != null) {
                while (this.isExcluded(this.nextExecutionTime)) {
                    this.nextExecutionTime = this.calculateNextExecutionTime(this.nextExecutionTime, 1, repeatInterval);
                }
            }
        } else {
            this.setExecutionParameters(null, 0);
        }
    }

    private boolean isExcluded(Date time) {
        if (this.exclusionWindows != null) {
            for (TimeWindow window : this.exclusionWindows) {
                if (!window.contains(time)) continue;
                return true;
            }
        }
        return this.exclusionDaysOfWeek != null && this.exclusionDaysOfWeek.contains((Object)DayOfWeek.get(time));
    }

    private void setExecutionParameters(Date nextTaskTime, int remainingRepeatCount) {
        this.nextExecutionTime = nextTaskTime;
        this.remainingRepeatCount = remainingRepeatCount;
    }

    private long getRepeatIntervalMsec() {
        if (this.repeatInterval != null && this.repeatIntervalUnit != null) {
            return this.repeatIntervalUnit.toMillis(this.repeatInterval);
        }
        return 0L;
    }

    @Override
    synchronized boolean matches(Date time) {
        if (this.startTime != null) {
            long distance = RepeatingJob.distance(this.startTime, time);
            return distance >= 0L && distance % this.getRepeatIntervalMsec() == 0L && !this.isExcluded(time);
        }
        return false;
    }

    @Override
    boolean matches(Date fromTime, Date toTime) {
        if (this.startTime != null) {
            if (toTime != null && this.startTime.after(toTime)) {
                return false;
            }
            long fromTimeMsec = fromTime != null ? fromTime.getTime() : 0L;
            long toTimeMsec = toTime != null ? toTime.getTime() : Long.MAX_VALUE;
            long startTimeMsec = this.startTime.getTime();
            long repeatInterval = this.getRepeatIntervalMsec();
            Date nextTime = this.startTime;
            long distance = RepeatingJob.distance(this.startTime, fromTime);
            long nRemainingRepeats = this.repeatCount.intValue();
            if (distance > 0L) {
                int nRepeats = (int)(distance / repeatInterval);
                if (nRemainingRepeats != -1L && (nRemainingRepeats -= (long)nRepeats) < 0L) {
                    return false;
                }
                nextTime = this.calculateNextExecutionTime(this.startTime, nRepeats, repeatInterval);
                if (nextTime.getTime() < fromTimeMsec) {
                    if (nRemainingRepeats != -1L) {
                        if (nRemainingRepeats == 0L) {
                            return false;
                        }
                        --nRemainingRepeats;
                    }
                    nextTime = this.calculateNextExecutionTime(nextTime, 1, repeatInterval);
                }
            }
            while (nextTime.getTime() <= toTimeMsec) {
                if (!this.isExcluded(nextTime)) {
                    return true;
                }
                if (nRemainingRepeats != -1L && --nRemainingRepeats <= 0L) {
                    return false;
                }
                nextTime = this.calculateNextExecutionTime(nextTime, 1, repeatInterval);
            }
        }
        return false;
    }

    private Date calculateNextExecutionTime(Date lastExecutionTime, int nRepeats, long repeatInterval) {
        if (this.repeatIntervalUnit == TimeUnit.DAYS) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(lastExecutionTime);
            calendar.add(5, nRepeats);
            return calendar.getTime();
        }
        return new Date(lastExecutionTime.getTime() + (long)nRepeats * repeatInterval);
    }

    private static long distance(Date fromDate, Date toDate) {
        TimeZone zone = GregorianCalendar.getInstance().getTimeZone();
        long distance = toDate.getTime() - fromDate.getTime();
        if (zone.inDaylightTime(fromDate) && !zone.inDaylightTime(toDate)) {
            return distance - (long)zone.getDSTSavings();
        }
        if (!zone.inDaylightTime(fromDate) && zone.inDaylightTime(toDate)) {
            return distance + (long)zone.getDSTSavings();
        }
        return distance;
    }
}

