/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.selector.SelectorEvaluationException;
import com.streamscape.lib.selector.SelectorValueSource;
import com.streamscape.lib.selector.VariableSelectorExpression;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sef.scheduler.AbstractSchedulerObject;
import com.streamscape.sef.scheduler.SchedulerException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Metaset
extends AbstractSchedulerObject
implements SelectorValueSource {
    private HashMap<String, Object> predefinedValues;
    private HashMap<String, Object> dynamicValues;
    private boolean isStatic = false;

    Metaset(String name, String owner) {
        super(name, owner);
    }

    Metaset(String name, Metaset other, String owner) throws SchedulerException {
        super(name, other, owner);
        this.copyFields(other);
    }

    Metaset(String name, String owner, boolean isStatic) {
        super(name, owner);
        this.setStatic(isStatic);
    }

    protected void update(Metaset other) throws SchedulerException {
        super.update(other);
        this.copyFields(other);
    }

    private void copyFields(Metaset other) throws SchedulerException {
        this.addPredefinedValues(other.getValues(), true);
        this.setStatic(other.isStatic);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public synchronized void set(String key, Object value) throws SchedulerException {
        if (this.predefinedValues != null && this.predefinedValues.containsKey(key)) {
            if (value == null) {
                throw new SchedulerException(6004, "Predefined key '" + key + "' cannot have null value.");
            }
            Object oldValue = this.predefinedValues.get(key);
            if (oldValue != null && !oldValue.getClass().equals(value.getClass())) {
                value = Metaset.checkValue(key, oldValue, value);
            }
            this.predefinedValues.put(key, value);
        } else {
            if (this.isStatic) {
                throw new SchedulerException(6152, "New key '" + key + "' cannot be added to static Metaset.");
            }
            this.scheduler.checkSemanticType(key, value);
            this.initDynamicValues();
            this.dynamicValues.put(key, value);
        }
        this.onUpdate();
    }

    public synchronized void remove(String key) throws SchedulerException {
        if (this.existsPredefinedValue(key)) {
            if (this.isStatic) {
                throw new SchedulerException(6152, "Existing key '" + key + "' cannot be removed from static Metaset.");
            }
            this.predefinedValues.remove(key);
            this.onUpdate();
        } else if (this.dynamicValues != null) {
            this.dynamicValues.remove(key);
            this.onUpdate();
        }
    }

    public synchronized Object get(String key) {
        Object result = null;
        if (this.predefinedValues != null) {
            result = this.predefinedValues.get(key);
        }
        if (result == null && this.dynamicValues != null) {
            result = this.dynamicValues.get(key);
        }
        return result;
    }

    public synchronized boolean exists(String key) {
        return this.predefinedValues != null && this.predefinedValues.containsKey(key) || this.dynamicValues != null && this.dynamicValues.containsKey(key);
    }

    public synchronized List<String> listPredefinedKeys() {
        return this.predefinedValues != null ? new ArrayList<String>(this.predefinedValues.keySet()) : new ArrayList();
    }

    public synchronized List<String> listDynamicKeys() {
        return this.dynamicValues != null ? new ArrayList<String>(this.dynamicValues.keySet()) : new ArrayList();
    }

    public synchronized List<String> listKeys() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.predefinedValues != null) {
            result.addAll(this.predefinedValues.keySet());
        }
        if (this.dynamicValues != null) {
            result.addAll(this.dynamicValues.keySet());
        }
        return result;
    }

    public synchronized List<Object> listValues() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.predefinedValues != null) {
            result.addAll(this.predefinedValues.values());
        }
        if (this.dynamicValues != null) {
            result.addAll(this.dynamicValues.values());
        }
        return result;
    }

    public Map<String, Object> getPredefinedFacets() {
        return this.getPredefinedProperties();
    }

    public Map<String, Object> getDynamicFacets() {
        return this.getDynamicProperties();
    }

    public Map<String, Object> getFacets() {
        return this.getValues();
    }

    public Map<String, Object> toMap() {
        return this.getValues();
    }

    synchronized void addPredefinedValues(Map<String, Object> values, boolean clear) throws SchedulerException {
        if (values != null) {
            this.initPredefinedValues(clear);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                this.doAddPredefinedValue(entry.getKey(), entry.getValue());
            }
        }
    }

    private void doAddPredefinedValue(String key, Object value) throws SchedulerException {
        if (this.existsPredefinedValue(key)) {
            throw new SchedulerException(6152, "Predefined value with key '" + key + "' already exists.");
        }
        if (value == null) {
            throw new SchedulerException("Null value for key '" + key + "'.");
        }
        if (!(value instanceof String || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Date)) {
            throw new SchedulerException("Invalid value type for key '" + key + "'.");
        }
        this.predefinedValues.put(key, value);
    }

    synchronized boolean existsPredefinedValue(String key) {
        return this.predefinedValues != null && this.predefinedValues.containsKey(key);
    }

    public synchronized Map<String, Object> getPredefinedProperties() {
        return this.predefinedValues != null ? new HashMap<String, Object>(this.predefinedValues) : new HashMap();
    }

    synchronized void getPredefinedProperties(Map<String, Object> result) {
        if (this.predefinedValues != null) {
            result.putAll(this.predefinedValues);
        }
    }

    public synchronized Map<String, Object> getDynamicProperties() {
        return this.dynamicValues != null ? new HashMap<String, Object>(this.dynamicValues) : new HashMap();
    }

    public synchronized Map<String, Object> getValues() {
        HashMap<String, Object> result = null;
        if (this.predefinedValues != null) {
            result = new HashMap<String, Object>(this.predefinedValues);
        }
        if (this.dynamicValues != null) {
            if (result == null) {
                result = new HashMap<String, Object>(this.dynamicValues);
            } else {
                result.putAll(this.dynamicValues);
            }
        }
        return result;
    }

    private synchronized void initPredefinedValues(boolean clear) {
        this.initPredefinedValues();
        if (clear) {
            this.predefinedValues.clear();
        }
    }

    private synchronized void initPredefinedValues() {
        if (this.predefinedValues == null) {
            this.predefinedValues = new HashMap();
        }
    }

    private synchronized void initDynamicValues() {
        if (this.dynamicValues == null) {
            this.dynamicValues = new HashMap();
        }
    }

    private static Object checkValue(String key, Object oldValue, Object newValue) throws SchedulerException {
        if (oldValue instanceof Date) {
            if (newValue instanceof Date) {
                return newValue;
            }
            if (newValue instanceof Long) {
                return new Date((Long)newValue);
            }
            throw Metaset.invalidValueException(key, "Date");
        }
        PropertyType type = PropertyType.resolveType(oldValue);
        try {
            return EventPropertyValidator.checkValue(type, newValue);
        }
        catch (SDOPropertyException exception) {
            throw Metaset.invalidValueException(key, type.name());
        }
    }

    private static SchedulerException invalidValueException(String key, String type) throws SchedulerException {
        return new SchedulerException(6152, "Invalid value type for key '" + key + "' (expected " + type + ").");
    }

    @Override
    public Metaset clone() {
        Metaset result = (Metaset)super.clone();
        result.predefinedValues = this.predefinedValues != null ? (HashMap)this.predefinedValues.clone() : null;
        result.dynamicValues = this.dynamicValues != null ? (HashMap)this.dynamicValues.clone() : null;
        return result;
    }

    @Override
    protected void checkDisabled() throws SchedulerException {
    }

    @Override
    protected void checkNameUniqueness(String name) throws SchedulerException {
        if (this.scheduler.existsMetaset(name)) {
            throw new SchedulerException(6154, this.toLogNameWithPrefix() + " already exists.");
        }
    }

    @Override
    protected void doUpdateInStorage() {
    }

    @Override
    public String toString() {
        Map<String, Object> values = this.getValues();
        return super.toString() + (String)(values != null ? " " + new TreeMap<String, Object>(values).toString() : "");
    }

    @Override
    public Object getValue(VariableSelectorExpression expression) throws SelectorEvaluationException {
        return expression.forExists() ? Boolean.valueOf(this.exists(expression.getVariableName())) : this.get(expression.getVariableName());
    }

    @Override
    String toLogNameWithPrefix() {
        return Metaset.toLogNameWithPrefix(this.getName());
    }

    static String toLogNameWithPrefix(String name) {
        return "Metaset " + Metaset.toLogName(name);
    }
}

