/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.CompletionState;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class ExceptionTask
extends ActionTask {
    protected static final String DEFAULT_TASK_NAME = "Exception";
    private UUID triggerTaskId;
    private transient AbstractTask triggerTask;

    ExceptionTask(String name, String author) {
        super(name, author);
    }

    ExceptionTask(String name, ExceptionTask other, String owner) {
        super(name, other, owner);
    }

    @Override
    protected ExceptionTask doCopy(String name, AbstractTask other, String owner) {
        return new ExceptionTask(name, (ExceptionTask)other, owner);
    }

    ExceptionTask(ExceptionTask other) {
        super(other);
        this.doSetTriggerTask(other.triggerTaskId, other.triggerTask);
    }

    @Override
    protected AbstractTask doCopy(AbstractTask other) {
        return new ExceptionTask((ExceptionTask)other);
    }

    @Override
    protected void copyLinks(TaskList sourceList, Map<UUID, UUID> taskIdMap) {
        ExceptionTask sourceTask = sourceList.getExceptionTask(this.getName());
        if (sourceTask.triggerTaskId != null) {
            UUID triggerTaskId = taskIdMap.get(sourceTask.triggerTaskId);
            this.doSetTriggerTask(triggerTaskId, (AbstractTask)this.taskList.getTask(triggerTaskId));
        }
    }

    @Override
    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        boolean result = super.checkOnLoad(oldFormatVersion);
        this.initTriggerTask(this.triggerTaskId);
        return result;
    }

    @Override
    public TaskType getType() {
        return TaskType.EXCEPTION;
    }

    public boolean isForTaskList() {
        return ExceptionTask.isExceptionTask(this.getName());
    }

    public UUID getTriggerTaskId() {
        return this.triggerTaskId;
    }

    public Task getTriggerTask() {
        return this.triggerTask;
    }

    private void initTriggerTask(UUID triggerTaskId) throws SchedulerException {
        if (triggerTaskId != null) {
            this.setTriggerTask(this.taskList.getTaskWithCheck(triggerTaskId));
        }
    }

    void setTriggerTask(AbstractTask triggerTask) {
        if (triggerTask == null) {
            this.doSetTriggerTask(null, null);
        } else {
            this.doSetTriggerTask(triggerTask.getOID(), triggerTask);
        }
    }

    private void doSetTriggerTask(UUID triggerTaskId, AbstractTask triggerTask) {
        this.triggerTaskId = triggerTaskId;
        this.triggerTask = triggerTask;
    }

    @Override
    protected String getFullName() {
        return Task.getFullName(this.taskList.getName(), this.getExtendedName());
    }

    @Override
    protected String getExtendedName() {
        return this.getName() + ".Exception";
    }

    @Override
    protected String getScriptPrefix() {
        return "TaskList TaskList = scheduler.getTaskList('" + this.taskList.getName() + "');\nTask Task = TaskList.getExceptionTask(" + (String)(this.isForTaskList() ? "" : "'" + this.getName() + "'") + ");\nMetaset TaskMetaset = TaskList.doGetExecutionMetaset();\n";
    }

    @Override
    protected AbstractTask.ExecutionResult doExecute(Date startTime, ExecutionListener listener) {
        this.calculateEndTime(startTime.getTime());
        this.taskList.execution.addExceptionTask(this, startTime);
        this.onExecutionStarted(startTime, listener);
        CompletionState completionState = null;
        if (this.taskList.isTimeExpired()) {
            completionState = this.onExecutionExpired(listener, CompletionState.TASKLIST_EXPIRED);
        } else {
            completionState = this.doExecutionPartInThread(listener);
            if (completionState == CompletionState.TASK_COMPLETED) {
                this.onExecutionCompleted(listener);
            }
        }
        return new AbstractTask.ExecutionResult(completionState, this.taskList.executionMetaset);
    }

    @Override
    protected void onExecutionStarted(Date startTime, ExecutionListener listener) {
        this.doOnExecutionStarted(startTime, listener, ExecutionListener::onExceptionTaskStarted);
    }

    @Override
    protected void onExecutionCompleted(ExecutionListener listener) {
        this.doOnExecutionCompleted(listener, ExecutionListener::onExceptionTaskCompleted);
    }

    @Override
    protected CompletionState onExecutionExpired(ExecutionListener listener, CompletionState completionState) {
        this.doOnExecutionExpired(listener, ExecutionListener::onExceptionTaskExpired);
        return completionState;
    }

    @Override
    protected void onExecutionFailed(Throwable exception, ExecutionListener listener) {
        this.doOnExecutionFailed(exception, listener, ExecutionListener::onExceptionTaskFailed);
    }

    @Override
    protected void onExecutionInterrupted(String errorMessage, Integer errorCode, ExecutionListener listener) {
        this.doOnExecutionInterrupted(errorMessage, errorCode, listener, ExecutionListener::onExceptionTaskInterrupted);
    }

    @Override
    public void enableResumptionOn(TaskState state) throws SchedulerException {
        this.throwsNotSupportedOperation("enableResumptionOn");
    }

    @Override
    public void enableResumptionTotally() throws SchedulerException {
        this.throwsNotSupportedOperation("enableResumptionTotally");
    }

    @Override
    public void disableResumptionOn(TaskState state) throws SchedulerException {
        this.throwsNotSupportedOperation("disableResumptionOn");
    }

    @Override
    public void disableResumptionTotally() throws SchedulerException {
        this.throwsNotSupportedOperation("disableResumptionTotally");
    }

    @Override
    public void putProperty(String name, Object value) throws SchedulerException {
        this.throwsNotSupportedOperation("addProperty");
    }

    @Override
    public void removeProperty(String name) throws SchedulerException {
        this.throwsNotSupportedOperation("removeProperty");
    }

    @Override
    public void clearProperties() throws SchedulerException {
        this.throwsNotSupportedOperation("clearProperties");
    }

    @Override
    public void addTag(String tag) throws SchedulerException {
        this.throwsNotSupportedOperation("addTag");
    }

    @Override
    public void removeTag(String tag) throws SchedulerException {
        this.throwsNotSupportedOperation("removeTag");
    }

    @Override
    public void clearTags() throws SchedulerException {
        this.throwsNotSupportedOperation("clearTags");
    }

    @Override
    public void setWeight(byte weight) throws SchedulerException {
        this.throwsNotSupportedOperation("setWeight");
    }

    @Override
    public void setMetadata(String metadata) throws SchedulerException {
        this.throwsNotSupportedOperation("setMetadata");
    }

    @Override
    public void setUndoLimit(int undoLimit) throws SchedulerException {
        this.throwsNotSupportedOperation("setUndoLimit");
    }

    @Override
    public void setModel(String model) throws SchedulerException {
        this.throwsNotSupportedOperation("setModel");
    }

    @Override
    public void undo() throws SchedulerException {
        this.throwsNotSupportedOperation("undo");
    }

    @Override
    public void undo(long delay) throws SchedulerException {
        this.throwsNotSupportedOperation("undo");
    }
}

