/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.EventTaskEventTriggerImpl;
import com.streamscape.sef.enums.DispatchMode;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.scheduler.AbstractSchedulerObject;
import com.streamscape.sef.scheduler.SchedulerEvent;
import com.streamscape.sef.scheduler.SchedulerException;

public class EventTaskTrigger
extends AbstractSchedulerObject {
    String jobName;
    String listName;
    String taskName;
    String nodeName;
    String userName;
    EventScope eventScope = EventScope.OBSERVABLE;
    DispatchMode dispatchMode = DispatchMode.ASYNC;
    String script;
    boolean enabled = false;
    private transient EventTaskEventTriggerImpl eventTrigger;
    private transient EventConsumer eventConsumer;

    EventTaskTrigger(String name, String author) {
        super(name, author);
    }

    EventTaskTrigger(String name, EventTaskTrigger other, String owner) {
        super(name, other, owner);
        this.jobName = other.jobName;
        this.listName = other.listName;
        this.taskName = other.taskName;
        this.nodeName = other.nodeName;
        this.userName = other.userName;
        this.eventScope = other.eventScope;
        this.dispatchMode = other.dispatchMode;
        this.script = other.script;
    }

    @Override
    protected void checkNameUniqueness(String name) throws SchedulerException {
        if (this.scheduler.existsTrigger(name)) {
            throw new SchedulerException(6122, this.toLogNameWithPrefix() + " already exists.");
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public synchronized void setJobName(String jobName) throws SchedulerException {
        this.checkDisabled();
        if (!Utils.equalsNullSafe(this.jobName, jobName)) {
            this.jobName = jobName;
            this.updateInStorage();
        }
    }

    public String getListName() {
        return this.listName;
    }

    public synchronized void setListName(String listName) throws SchedulerException {
        this.checkDisabled();
        if (!Utils.equalsNullSafe(this.listName, listName)) {
            this.listName = listName;
            this.updateInStorage();
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public synchronized void setTaskName(String taskName) throws SchedulerException {
        this.checkDisabled();
        if (!Utils.equalsNullSafe(this.taskName, taskName)) {
            this.taskName = taskName;
            this.updateInStorage();
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public synchronized void setNodeName(String nodeName) throws SchedulerException {
        this.checkDisabled();
        if (!Utils.equalsNullSafe(this.nodeName, nodeName)) {
            this.nodeName = nodeName;
            this.updateInStorage();
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public synchronized void setUserName(String userName) throws SchedulerException {
        this.checkDisabled();
        if (!Utils.equalsNullSafe(this.userName, userName)) {
            this.userName = userName;
            this.updateInStorage();
        }
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public synchronized void setEventScope(EventScope eventScope) throws SchedulerException {
        this.checkDisabled();
        if (eventScope != EventScope.OBSERVABLE && eventScope != EventScope.GLOBAL) {
            throw new SchedulerException(6017, "Trigger cannot have '" + String.valueOf((Object)eventScope) + "' event scope.");
        }
        if (this.eventScope != eventScope) {
            this.eventScope = eventScope;
            this.updateInStorage();
        }
    }

    public DispatchMode getDispatchMode() {
        return this.dispatchMode;
    }

    public synchronized void setDispatchMode(DispatchMode dispatchMode) throws SchedulerException {
        this.checkDisabled();
        if (dispatchMode == null) {
            throw new SchedulerException(6004, "Dispatch mode is null.");
        }
        if (this.dispatchMode != dispatchMode) {
            this.dispatchMode = dispatchMode;
            this.updateInStorage();
        }
    }

    public String getScript() {
        return this.script;
    }

    public synchronized void setScript(String script) throws SchedulerException {
        this.checkDisabled();
        if (this.script == null || !this.script.equals(script)) {
            this.script = script;
            this.updateInStorage();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void enable() throws SchedulerException {
        if (!this.enabled) {
            this.doEnable();
            this.enabled = true;
            this.updateInStorage();
        }
    }

    void enableOnInit() throws SchedulerException {
        try {
            this.doEnable();
        }
        catch (SchedulerException exception) {
            this.enabled = false;
            this.updateInStorage();
            throw exception;
        }
    }

    void doEnable() throws SchedulerException {
        this.eventTrigger = new EventTaskEventTriggerImpl(this.createDefinition(), this.scheduler.getComponent(), AbstractRuntimeFactory.getContext());
        if (this.eventTrigger.getState() == EventTriggerState.INVALID) {
            throw new SchedulerException(6026, "Enabling " + this.toLogNameWithPrefix() + " failed.\nCause: " + this.eventTrigger.getLastError());
        }
        this.eventTrigger.enable();
        this.createEventConsumer(this.getName() + "_Consumer", "event.Scheduler", this.createEventSelector());
    }

    private EventTriggerDefinition createDefinition() throws SchedulerException {
        EventTriggerDefinition result = new EventTriggerDefinition();
        try {
            result.setName(this.getName());
            result.setTriggerScript(this.script);
            result.setActionableEventId("event.Scheduler");
            result.setEventScope(this.eventScope);
            result.setAutoEnable(true);
        }
        catch (Exception exception) {
            if (exception instanceof SchedulerException) {
                throw (SchedulerException)exception;
            }
            throw new SchedulerException(6026, "Creation of event trigger definition failed.", exception);
        }
        return result;
    }

    private void createEventConsumer(String name, String eventId, String eventSelector) throws SchedulerException {
        try {
            if (this.dispatchMode == DispatchMode.DIRECT) {
                this.eventConsumer = this.scheduler.createEventConsumer(name, new Listener(), eventId, eventSelector, this.eventScope);
            } else {
                this.eventConsumer = this.scheduler.createEventAsyncConsumer(name, new Listener(), eventId, eventSelector, this.eventScope);
                ((EventAsyncConsumer)this.eventConsumer).start();
            }
            this.scheduler.completeSinkEventFlow(this.eventConsumer, this);
        }
        catch (Exception exception) {
            throw new SchedulerException(6011, "Enabling trigger failed.", exception);
        }
    }

    private String createEventSelector() {
        StringBuilder builder = new StringBuilder();
        if (this.listName != null && !this.listName.isEmpty()) {
            EventTaskTrigger.addSelectorItem(builder, "listName", this.listName);
        }
        if (this.taskName != null && !this.taskName.isEmpty()) {
            EventTaskTrigger.addSelectorItem(builder, "taskName", this.taskName);
        }
        if (this.nodeName != null && !this.nodeName.isEmpty()) {
            EventTaskTrigger.addSelectorItem(builder, "nodeName", this.nodeName);
        }
        if (this.jobName != null && !this.jobName.isEmpty()) {
            EventTaskTrigger.addSelectorItem(builder, "jobName", this.jobName);
        }
        if (this.userName != null && !this.userName.isEmpty()) {
            EventTaskTrigger.addSelectorItem(builder, "userName", this.userName);
        }
        return builder.length() != 0 ? builder.toString() : null;
    }

    private static void addSelectorItem(StringBuilder builder, String name, String value) {
        if (builder.length() != 0) {
            builder.append(" AND ");
        }
        builder.append(name).append("='").append(value).append("'");
    }

    public synchronized String getEventSelector() throws SchedulerException {
        return this.eventConsumer != null ? this.eventConsumer.getEventSelector() : this.createEventSelector();
    }

    public void disable() {
        this.doDisable();
    }

    synchronized boolean doDisable() {
        if (this.enabled) {
            if (this.eventTrigger != null) {
                this.eventTrigger.disable();
                this.eventTrigger = null;
            }
            if (this.eventConsumer != null) {
                this.eventConsumer.close();
                this.eventConsumer = null;
            }
            this.enabled = false;
            this.updateInStorage();
            return true;
        }
        return false;
    }

    @Override
    protected void checkDisabled() throws SchedulerException {
        if (this.enabled) {
            throw new SchedulerException(6123, this.toLogNameWithPrefix() + " is enabled and cannot be changed.");
        }
    }

    @Override
    protected void doUpdateInStorage() {
        this.scheduler.update(this);
    }

    @Override
    public String toString() {
        return this.getName() + "(" + super.toString() + ")";
    }

    @Override
    String toLogNameWithPrefix() {
        return EventTaskTrigger.toLogNameWithPrefix(this.getName());
    }

    static String toLogNameWithPrefix(String name) {
        return "Event Task Trigger " + EventTaskTrigger.toLogName(name);
    }

    private class Listener
    implements FabricEventListener {
        private Listener() {
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
            SchedulerEvent schedulerEvent = (SchedulerEvent)event;
            Throwable processingException = null;
            try {
                EventTaskTrigger.this.eventTrigger.onEvent(event);
            }
            catch (Throwable exception) {
                processingException = exception instanceof FabricEventException ? (exception.getCause() != null ? exception.getCause() : exception) : exception;
            }
            try {
                AcknowledgementEvent ackEvent = EventDatagramFactory.getInstance().createAcknowledgement(schedulerEvent, true);
                if (processingException != null) {
                    ackEvent.setData(processingException);
                }
                EventTaskTrigger.this.scheduler.raiseAcknowledgement(ackEvent, EventTaskTrigger.this.eventScope);
            }
            catch (Exception exception) {
                if (exception instanceof FabricEventException) {
                    throw (FabricEventException)exception;
                }
                throw new FabricEventException(exception);
            }
        }
    }
}

