/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.CompletionState;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.SchedulerEvent;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class EventTask
extends AbstractTask {
    private static final List<String> EVENT_IDS = Collections.singletonList("event.Scheduler");

    EventTask(String name, String author) {
        super(name, author);
    }

    @Override
    protected void initTaskWindow() {
        this.doSetTaskWindow(30L);
    }

    EventTask(String name, EventTask other, String owner) {
        super(name, other, owner);
    }

    @Override
    protected AbstractTask doCopy(String name, AbstractTask other, String owner) {
        return new EventTask(name, (EventTask)other, owner);
    }

    EventTask(EventTask other) {
        super(other);
    }

    @Override
    protected AbstractTask doCopy(AbstractTask other) {
        return new EventTask((EventTask)other);
    }

    @Override
    public TaskType getType() {
        return TaskType.EVENT;
    }

    @Override
    public Long getTaskWindow() {
        return super.getTaskWindow();
    }

    @Override
    protected TaskState getRunningState() {
        return TaskState.WAITING_ACK;
    }

    @Override
    protected TaskState getState(TaskState state) {
        return state;
    }

    @Override
    protected boolean needsExecution() {
        return true;
    }

    @Override
    public List<String> listEventIds() {
        return EVENT_IDS;
    }

    @Override
    protected CompletionState doExecute(ExecutionListener listener) {
        SchedulerEvent event = this.createEvent(this.execution.getCaller(), this.execution.getStartTime(), listener);
        if (event != null) {
            if (this.getTaskWindow() == 0L) {
                return this.raiseEvent(event, listener);
            }
            long timeWindowMsec = this.taskList.adjustTimeAgainstTaskListWindow(this.getTaskWindowMsec());
            return this.raiseRequest(event, timeWindowMsec, listener);
        }
        return CompletionState.TASK_FAILED;
    }

    private CompletionState raiseEvent(SchedulerEvent event, ExecutionListener listener) {
        try {
            this.scheduler.raiseEvent(event, this.taskList.getEventScope());
            return CompletionState.TASK_COMPLETED;
        }
        catch (Throwable exception) {
            this.logException(exception);
            this.logError("Raising of 'event.Scheduler' event failed.");
            this.onExecutionFailed(EventTask.getCause(exception), listener);
            return CompletionState.TASK_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionState raiseRequest(SchedulerEvent event, long timeout, ExecutionListener listener) {
        try {
            AcknowledgementEvent reply = this.scheduler.raiseRequest(event, this.taskList.getEventScope(), timeout);
            Object replyData = reply.getData();
            if (replyData instanceof Throwable) {
                this.onExecutionFailed(EventTask.getCause((Throwable)replyData), listener);
                return CompletionState.TASK_FAILED;
            }
            if (replyData instanceof Metaset) {
                this.taskList.setNonNullExecutionMetaset((Metaset)replyData);
            }
            return CompletionState.TASK_COMPLETED;
        }
        catch (Throwable exception) {
            EventTask eventTask = this;
            synchronized (eventTask) {
                if (this.execution != null && this.getExecutionState() == this.getRunningState()) {
                    if (exception instanceof FabricEventSourceException) {
                        if (((FabricEventSourceException)exception).getErrorCode() == 6042) {
                            this.onExecutionExpired(listener, CompletionState.TASK_FAILED);
                        } else if (((FabricEventSourceException)exception).getErrorCode() == 6049) {
                            this.onExecutionInterrupted("Waiting of acknowledgement interrupted.", 6049, listener);
                        }
                    } else {
                        this.onExecutionFailed(EventTask.getCause(exception), listener);
                    }
                }
            }
            return CompletionState.TASK_FAILED;
        }
    }

    @Override
    protected CompletionState waitForResult() throws InterruptedException, CancellationException, ExecutionException {
        return (CompletionState)((Object)this.thread.getResult());
    }

    @Override
    public void undo() throws SchedulerException {
        this.throwsNotSupportedOperation("undo");
    }

    @Override
    public void undo(long delay) throws SchedulerException {
        this.throwsNotSupportedOperation("undo");
    }
}

