/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.EventTaskEventTriggerImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.CompletionState;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.SchedulerEvent;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class ActionTask
extends AbstractTask {
    private String script;
    private String model;
    private boolean encrypted;
    private int undoLimit;
    private transient EventTaskEventTriggerImpl eventTrigger;
    private volatile transient boolean isScriptRunning;

    ActionTask(String name, String author) {
        super(name, author);
    }

    ActionTask(String name, ActionTask other, String owner) {
        super(name, other, owner);
    }

    @Override
    protected AbstractTask doCopy(String name, AbstractTask other, String owner) {
        return new ActionTask(name, (ActionTask)other, owner);
    }

    ActionTask(ActionTask other) {
        super(other);
    }

    @Override
    protected AbstractTask doCopy(AbstractTask other) {
        return new ActionTask((ActionTask)other);
    }

    @Override
    protected void copyFields(AbstractTask other) {
        super.copyFields(other);
        this.doSetUndoLimit(((ActionTask)other).undoLimit);
        this.doSetScript(((ActionTask)other).script);
        this.doSetModel(((ActionTask)other).model);
        this.doSetEncrypted(((ActionTask)other).encrypted);
        this.eventTrigger = ((ActionTask)other).eventTrigger;
        this.isScriptRunning = ((ActionTask)other).isScriptRunning;
    }

    @Override
    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        boolean result = super.checkOnLoad(oldFormatVersion);
        if (oldFormatVersion == OldFormatVersion.FORMAT_2024_1) {
            this.undoLimit = 3;
        }
        return result;
    }

    @Override
    protected void initTaskWindow() {
        this.doSetTaskWindow(-1L);
    }

    @Override
    public TaskType getType() {
        return TaskType.ACTION;
    }

    @Override
    public Long getTaskWindow() {
        return super.getTaskWindow();
    }

    public String getScript() {
        return this.script;
    }

    public boolean hasScript() {
        return this.script != null;
    }

    public synchronized void setScript(String script) throws SchedulerException {
        this.doSetScript(script);
        this.onUpdate();
    }

    protected void doSetScript(String script) {
        this.script = script;
    }

    public String getModel() {
        return this.model;
    }

    public synchronized void setModel(String model) throws SchedulerException {
        this.doSetModel(model);
        this.onUpdate();
    }

    protected void doSetModel(String model) {
        this.model = model;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public synchronized void setEncrypted(boolean encrypted) throws SchedulerException {
        this.doSetEncrypted(encrypted);
        this.onUpdate();
    }

    protected void doSetEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public synchronized void setUndoLimit(int undoLimit) throws SchedulerException {
        this.doSetUndoLimit(undoLimit);
        this.onUpdate();
    }

    public void doSetUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    @Override
    public List<String> listEventIds() {
        return this.eventTrigger != null ? new ArrayList(this.eventTrigger.getTriggerEventIds()) : new ArrayList();
    }

    @Override
    protected void enable() throws SchedulerException {
        super.enable();
        this.checkScriptFormat();
        this.initTrigger();
    }

    private void checkScriptFormat() throws SchedulerException {
        if (this.script != null) {
            this.script = this.script.trim();
            if (this.script.isEmpty()) {
                this.script = "{}";
            } else if (!this.script.startsWith("{")) {
                this.throwInvalidScript("must start with {.", false);
            } else if (!this.script.endsWith("}")) {
                this.throwInvalidScript("must end with }.", false);
            }
        } else if (this.isAutoComplete()) {
            throw new SchedulerException(6007, "RPL script is not set in " + this.toLogNameWithPrefix() + ".");
        }
    }

    private void initTrigger() throws SchedulerException {
        if (this.script != null) {
            this.eventTrigger = new ActionTaskEventTrigger(this);
            if (this.eventTrigger.getState() == EventTriggerState.INVALID) {
                if (this.eventTrigger.getLastErrorException() != null) {
                    this.throwInvalidScript(this.eventTrigger.getLastErrorException());
                } else {
                    this.throwInvalidScript(this.eventTrigger.getLastError(), true);
                }
            }
            this.eventTrigger.enable();
        }
    }

    private void throwInvalidScript(String errorMessage, boolean newLineCause) throws SchedulerException {
        throw new SchedulerException(6007, this.getInvalidScriptPrefix() + "." + (newLineCause ? "\n" : " ") + "Cause: " + errorMessage);
    }

    private void throwInvalidScript(Throwable cause) throws SchedulerException {
        throw new SchedulerException(6007, this.getInvalidScriptPrefix() + ".", cause);
    }

    private String getInvalidScriptPrefix() {
        return "Invalid RPL script in Task '" + this.getName() + "'";
    }

    private EventTriggerDefinition createDefinition() throws SchedulerException {
        EventTriggerDefinition result = new EventTriggerDefinition();
        try {
            result.setName(this.getExtendedName());
            result.setTriggerScript(this.prepareScript());
            result.setActionableEventId("event.Scheduler");
            result.setEventScope(EventScope.GLOBAL);
            result.setAutoEnable(true);
        }
        catch (Exception exception) {
            throw new SchedulerException(6026, "Creation of event trigger definition failed.", exception);
        }
        return result;
    }

    private String prepareScript() {
        String rplPrefix = this.getScriptPrefix();
        Object rpl = this.script.trim();
        rpl = ((String)rpl).substring(1, ((String)rpl).length() - 1).trim();
        rpl = " { exec block for '" + this.getFullName() + "' {\n" + rplPrefix + (String)rpl + "}; }";
        return rpl;
    }

    protected String getScriptPrefix() {
        return "TaskList TaskList = scheduler.getTaskList('" + this.taskList.getName() + "');\nTask Task = TaskList.getTask('" + this.getName() + "');\nMetaset TaskMetaset = TaskList.doGetExecutionMetaset();\nSchedulerCompletionEvent Completion = TaskList.doGetCompletionEvent();\n";
    }

    protected String getExtendedName() {
        return this.getName();
    }

    @Override
    protected void disable() {
        this.doDisable();
    }

    private void doDisable() {
        if (this.eventTrigger != null) {
            this.eventTrigger.disable();
            this.eventTrigger = null;
        }
    }

    @Override
    protected TaskState getRunningState() {
        return TaskState.RUNNING;
    }

    @Override
    protected TaskState getState(TaskState state) {
        return this.needsExecution() ? state : null;
    }

    @Override
    protected boolean needsExecution() {
        return this.script != null;
    }

    @Override
    protected CompletionState doExecute(ExecutionListener listener) {
        if (this.script != null) {
            SchedulerEvent event = this.createEvent(this.execution.getCaller(), this.execution.getStartTime(), listener);
            return event != null ? this.doExecuteTrigger(event, listener) : CompletionState.TASK_FAILED;
        }
        return CompletionState.TASK_COMPLETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionState doExecuteTrigger(SchedulerEvent event, ExecutionListener listener) {
        try {
            this.isScriptRunning = true;
            this.eventTrigger.setExecutionWindowMs(this.getTaskWindowMsec());
            this.eventTrigger.setDataspaceAccessorProvider(this.taskList.getDataspaceAccessorProvider());
            this.eventTrigger.onEvent(event);
            this.resetTrigger();
            CompletionState completionState = CompletionState.TASK_COMPLETED;
            return completionState;
        }
        catch (Throwable exception) {
            Object object = this;
            synchronized (object) {
                if (this.isTaskRunning() && !this.execution.isUndone()) {
                    if (exception instanceof FabricEventException) {
                        Throwable cause = ActionTask.getCause(exception);
                        if (cause instanceof FabricEventSourceException && ((FabricEventSourceException)cause).getErrorCode() == 6049 || cause instanceof InterruptedException) {
                            this.onExecutionInterrupted(cause.getMessage(), 6049, listener);
                        } else {
                            this.onExecutionFailed(ActionTask.getCause(exception), listener);
                        }
                    } else {
                        this.onExecutionFailed(exception, listener);
                    }
                }
                this.resetTrigger();
            }
            object = CompletionState.TASK_FAILED;
            return object;
        }
        finally {
            this.isScriptRunning = false;
        }
    }

    @Override
    protected CompletionState waitForResult() throws InterruptedException, CancellationException, ExecutionException, TimeoutException {
        long timeWindowMsec = this.taskList.adjustTimeAgainstTaskListWindow(this.getTaskWindowMsec());
        return timeWindowMsec <= 0L ? (CompletionState)((Object)this.thread.getResult()) : (CompletionState)((Object)this.thread.getResult(timeWindowMsec));
    }

    private void resetTrigger() {
        this.doDisable();
        try {
            this.initTrigger();
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    private boolean isTaskRunning() {
        return this.execution != null && this.getExecutionState() == this.getRunningState();
    }

    @Override
    public synchronized void undo() throws SchedulerException {
        this.doUndo(0L);
    }

    @Override
    public synchronized void undo(long delay) throws SchedulerException {
        if (delay < 0L) {
            throw new SchedulerException(6007, "Undo delay must not be a negative number.");
        }
        this.doUndo(delay);
    }

    private synchronized void doUndo(long delay) throws SchedulerException {
        if (this.isScriptRunning) {
            if (this.execution.isUndone()) {
                this.logError("Undo declined (already called in the current RPL script).");
            } else if (this.undoLimit >= 0 && this.undoLimit <= this.execution.getUndoCount()) {
                this.logError("Undo declined (maximum number of attempts (" + this.undoLimit + ") exceeded).");
            } else {
                this.execution.setUndone(delay);
            }
        } else {
            throw new SchedulerException(6091, "Method 'undo' can only be called within a running RPL script.");
        }
    }

    @Override
    protected boolean isUndone() {
        return this.execution.isUndone();
    }

    @Override
    protected void resetUndo() {
        this.execution.resetUndone();
    }

    @Override
    protected long getUndoDelay() {
        return this.execution.getUndoDelay();
    }

    private static class ActionTaskEventTrigger
    extends EventTaskEventTriggerImpl {
        private transient ActionTask task;

        public ActionTaskEventTrigger(ActionTask task) throws SchedulerException {
            super(task.createDefinition(), task.taskList.scheduler.getComponent(), AbstractRuntimeFactory.getContext());
            this.task = task;
        }

        @Override
        protected String getOnEventErrorMessage() {
            return "Action Script in " + AbstractTask.toLogNameWithPrefix(this.task.getFullName()) + " execution failed.";
        }
    }
}

