/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.scheduler.AbstractExecutableObject;
import com.streamscape.sef.scheduler.CompletionState;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.RuleSet;
import com.streamscape.sef.scheduler.SchedulerAdvisoryType;
import com.streamscape.sef.scheduler.SchedulerCompletionEvent;
import com.streamscape.sef.scheduler.SchedulerEvent;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskExecution;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractTask
extends AbstractExecutableObject
implements Task {
    transient TaskList taskList;
    private long taskWindow;
    private TimeUnit taskWindowUnit = TimeUnit.SECONDS;
    private byte resumptionStates = 0;
    private byte weight = 0;
    private UUID afterTaskId;
    private RuleSet ruleSet;
    transient TaskExecution execution;

    protected AbstractTask(String name, String author) {
        super(name, author);
        this.initTaskWindow();
    }

    protected abstract void initTaskWindow();

    protected AbstractTask(String name, AbstractTask other, String owner) {
        super(name, other, owner);
        this.copyFields(other);
    }

    protected AbstractTask copy(String owner, Map<UUID, UUID> taskIdMap) {
        AbstractTask result = this.doCopy(this.getName(), this, owner);
        taskIdMap.put(this.getOID(), result.getOID());
        return result;
    }

    protected abstract AbstractTask doCopy(String var1, AbstractTask var2, String var3);

    protected void copyLinks(TaskList sourceList, Map<UUID, UUID> taskIdMap) {
        AbstractTask sourceTask = (AbstractTask)sourceList.getTask(this.getName());
        if (sourceTask.afterTaskId != null) {
            this.afterTaskId = sourceTask.afterTaskId;
            if (!AbstractTask.isStartTask(this.afterTaskId)) {
                this.afterTaskId = taskIdMap.get(this.afterTaskId);
            }
        }
        if (sourceTask.ruleSet != null) {
            this.ruleSet = sourceTask.ruleSet.copy(this, taskIdMap);
        }
    }

    protected AbstractTask(AbstractTask other) {
        super(other);
        this.copyFields(other);
        this.taskList = other.taskList;
        this.execution = other.execution;
        this.afterTaskId = other.afterTaskId;
        this.ruleSet = other.ruleSet != null ? other.ruleSet.clone() : null;
    }

    protected AbstractTask copy() {
        return this.doCopy(this);
    }

    protected abstract AbstractTask doCopy(AbstractTask var1);

    protected void copyFields(AbstractTask other) {
        this.taskWindow = other.taskWindow;
        this.taskWindowUnit = other.taskWindowUnit;
        this.resumptionStates = other.resumptionStates;
        this.weight = other.weight;
    }

    protected void init(TaskList taskList) {
        super.init(taskList.scheduler);
        this.taskList = taskList;
        if (this.ruleSet != null) {
            this.ruleSet.init(this);
        }
    }

    @Override
    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        boolean result = super.checkOnLoad(oldFormatVersion);
        if (this.ruleSet != null) {
            this.ruleSet.checkOnLoad();
        }
        return result;
    }

    protected void enable() throws SchedulerException {
        if (this.ruleSet != null && !this.taskList.isUnordered()) {
            if (!this.ruleSet.hasRules()) {
                throw new SchedulerException(6158, "No Rules are specified in Rule Set '" + this.ruleSet.getName() + "'.");
            }
            if (this.taskList.isAutoComplete() && !this.taskList.hasMetaset()) {
                throw new SchedulerException(6152, "At least one Task has Rule Set, but Metaset is not assigned.");
            }
        }
    }

    protected void disable() {
    }

    @Override
    public String getOwner() {
        return this.taskList.getOwner();
    }

    @Override
    public TaskList getTaskList() {
        return this.taskList;
    }

    @Override
    public UUID getAfterTaskOID() {
        return this.afterTaskId;
    }

    void setAfterTaskId(UUID afterTaskId) {
        this.afterTaskId = afterTaskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAfterTaskName() {
        TaskList taskList = this.taskList;
        synchronized (taskList) {
            return this.afterTaskId != null ? (AbstractTask.isStartTask(this.afterTaskId) ? "Start" : this.taskList.getTask(this.afterTaskId).getName()) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAfterTask(String taskName) throws SchedulerException {
        TaskList taskList = this.taskList;
        synchronized (taskList) {
            this.taskList.resetExecutionTree();
            if (taskName != null) {
                AbstractTask.checkRecursiveTransition(this.getName(), taskName);
                UUID newAfterTaskId = this.taskList.getAfterTaskId(taskName);
                if (!Utils.equalsNullSafe(this.afterTaskId, newAfterTaskId)) {
                    this.taskList.checkAbsenceNextTaskAfter(newAfterTaskId, taskName);
                    this.taskList.checkAbsenceRuleSetByExecTask(this);
                    this.setAfterTaskId(newAfterTaskId);
                }
            } else {
                this.setAfterTaskId(null);
            }
            this.onUpdate();
        }
    }

    @Override
    public Task getPrecedent() {
        return this.taskList.doGetTaskBefore(this);
    }

    @Override
    public Task getConsequent() {
        return this.taskList.doGetNextTaskAfter(this);
    }

    static boolean isStartTask(String taskName) {
        return taskName.equalsIgnoreCase("Start");
    }

    static boolean isStartTask(UUID taskOid) {
        return taskOid.equals(START_TASK_OID);
    }

    static boolean isExceptionTask(String taskName) {
        return taskName.equalsIgnoreCase("Exception");
    }

    static void checkRecursiveTransition(String taskName, String afterTaskName) throws SchedulerException {
        if (taskName.equals(afterTaskName)) {
            throw new SchedulerException(6148, "Recursive State Transition is not allowed (" + AbstractTask.toLogName(taskName) + " -> " + AbstractTask.toLogName(afterTaskName) + ").");
        }
    }

    protected String getFullName() {
        return Task.getFullName(this.taskList.getName(), this.getName());
    }

    @Override
    public Long getTaskWindow() {
        return this.taskWindow;
    }

    @Override
    protected void doSetTaskWindow(long taskWindow) {
        this.taskWindow = taskWindow;
    }

    @Override
    public TimeUnit getTaskWindowUnit() {
        return this.taskWindowUnit;
    }

    @Override
    protected void doSetTaskWindowUnit(TimeUnit unit) {
        this.taskWindowUnit = unit;
    }

    protected byte getResumptionStates() {
        return this.resumptionStates;
    }

    @Override
    protected void doEnableResumptionOn(byte state) {
        this.setResumptionState(state);
    }

    @Override
    protected void doEnableResumptionTotally() {
        this.resumptionStates = (byte)127;
    }

    @Override
    public void doDisableResumptionOn(byte state) {
        this.unsetResumptionState(state);
    }

    @Override
    protected void doDisableResumptionTotally() {
        this.resumptionStates = 0;
    }

    @Override
    public boolean isResumptionEnabledOn(TaskState state) {
        byte value = AbstractTask.convertState(state);
        return value != -1 && this.existsResumptionState(value);
    }

    @Override
    public boolean isResumptionEnabledTotally() {
        return this.resumptionStates == 127;
    }

    @Override
    public List<TaskState> listResumptionStates() {
        return AbstractTask.doListResumptionStates(this.resumptionStates);
    }

    static List<TaskState> doListResumptionStates(byte resumptionStates) {
        ArrayList<TaskState> result = new ArrayList<TaskState>();
        if (AbstractTask.existsResumptionState((byte)1, resumptionStates)) {
            result.add(TaskState.EXPIRED_INCOMPLETE);
            result.add(TaskState.EXECUTION_EXPIRED);
        }
        if (AbstractTask.existsResumptionState((byte)4, resumptionStates)) {
            result.add(TaskState.INTERRUPTED_INCOMPLETE);
            result.add(TaskState.EXECUTION_INTERRUPTED);
        }
        if (AbstractTask.existsResumptionState((byte)2, resumptionStates)) {
            result.add(TaskState.FAILED);
        }
        if (AbstractTask.existsResumptionState((byte)8, resumptionStates)) {
            result.add(TaskState.EXECUTION_EXCEPTION);
        }
        return result;
    }

    private boolean existsResumptionState(byte state) {
        return AbstractTask.existsResumptionState(state, this.resumptionStates);
    }

    private static boolean existsResumptionState(byte state, byte resumptionStates) {
        return resumptionStates == state || (resumptionStates & state) != 0;
    }

    private void setResumptionState(byte state) {
        this.resumptionStates = (byte)(this.resumptionStates | state);
    }

    private void unsetResumptionState(byte state) {
        this.resumptionStates = (byte)(this.resumptionStates & ~state);
    }

    @Override
    protected void checkNameUniqueness(String name) throws SchedulerException {
        if (this.taskList.existsTask(name)) {
            throw new SchedulerException(6146, this.toLogNameWithPrefix() + " already exists.");
        }
    }

    @Override
    public double getWeight() {
        return this.weight != 0 || this.taskList == null || this.taskList.getState() == TaskListState.DISABLED ? (double)this.weight : this.taskList.getNormalizedWeight();
    }

    byte doGetWeight() {
        return this.weight;
    }

    @Override
    public synchronized void setWeight(byte weight) throws SchedulerException {
        this.checkWeight(weight);
        this.weight = weight;
        this.onUpdate();
    }

    private void checkWeight(int weight) throws SchedulerException {
        if (weight < 0 || weight > 100) {
            throw new SchedulerException(6007, "Task weight must be in [1,100] range.");
        }
    }

    @Override
    protected Object resolveMetaset(String source) {
        return this.taskList != null ? this.taskList.resolveMetaset(source) : source;
    }

    @Override
    public TaskState getState() {
        if (this.execution != null) {
            TaskState execState = this.execution.getState();
            TaskState completionState = this.execution.getCompletionState();
            if (execState != null) {
                return (execState == TaskState.SKIPPED || execState == TaskState.PENDING) && completionState != null ? completionState : execState;
            }
            if (completionState != null) {
                return completionState;
            }
        }
        return TaskState.IDLE;
    }

    protected TaskState getExecutionState() {
        return this.execution != null ? this.execution.getState() : TaskState.IDLE;
    }

    @Override
    public TaskExecution getExecution() {
        return this.execution;
    }

    @Override
    protected UUID getEID() {
        return this.execution != null ? this.execution.getEID() : null;
    }

    protected void reset() {
        this.execution = null;
        this.endTimeMsec = null;
    }

    @Override
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    void setRuleSet(RuleSet ruleSet) {
        if (ruleSet != null) {
            ruleSet.init(this);
        }
        this.ruleSet = ruleSet;
    }

    boolean hasRuleSet() {
        return this.ruleSet != null;
    }

    @Override
    protected ExecutionMode getDirectMode() {
        return ExecutionMode.TASK_DIRECT;
    }

    @Override
    protected void createExecutionInstance(String userName, ExecutionMode executionMode, Date startTime) throws SchedulerException {
        this.taskList.doCreateExecutionInstance(userName, executionMode, startTime, this);
    }

    @Override
    protected TaskListState executeDirect(ExecutionListener listener) {
        Date startTime = this.execution.taskListExecution.getStartTime();
        this.taskList.calculateEndTime(startTime);
        CompletionState completionState = null;
        do {
            CompletionState undoState;
            if ((completionState = this.doExecute((Date)startTime, (ExecutionListener)listener).state) != CompletionState.TASK_UNDONE || (undoState = this.taskList.completeTaskUndo(this, listener)) == null) continue;
            this.execution.setStates(TaskState.SKIPPED, TaskState.SKIPPED);
            return this.taskList.completeExecution(undoState, listener);
        } while (completionState == CompletionState.TASK_UNDONE);
        return this.taskList.completeExecution(completionState, listener);
    }

    protected ExecutionResult doExecute(Date startTime, ExecutionListener listener) {
        this.calculateEndTime(startTime.getTime());
        CompletionState completionState = null;
        if (this.isManuallyCompleted()) {
            try {
                this.onCompletionStarted(listener);
                Pair<CompletionState, SchedulerCompletionEvent> completion = this.taskList.receiveCompletionEvent(this.getName(), this.getTaskWindowMsec());
                SchedulerCompletionEvent event = (SchedulerCompletionEvent)completion.second;
                if (event == null) {
                    completionState = this.onCompletionExpired(listener, completion.first == CompletionState.TASKLIST_EXPIRED ? CompletionState.TASKLIST_EXPIRED : CompletionState.TASK_FAILED);
                } else if (event.isFailed()) {
                    completionState = this.onCompletionFailed(listener, event.isForTaskList(), event.getValues());
                    if (event.isForTaskList()) {
                        completionState = CompletionState.TASKLIST_FAILED;
                    }
                } else {
                    this.onCompletionCompleted(listener, event.isForTaskList(), event.getValues());
                    if (event.isForTaskList()) {
                        completionState = CompletionState.TASKLIST_COMPLETED;
                    } else if (this.needsExecution()) {
                        this.calculateEndTime(System.currentTimeMillis());
                        completionState = this.doExecutionPart(new Date(), listener);
                    }
                }
            }
            catch (SchedulerException exception) {
                this.logError(exception, "Waiting for Completion Event interrupted.");
                completionState = this.onCompletionInterrupted(listener);
            }
        } else {
            completionState = this.doExecutionPart(startTime, listener);
        }
        if (completionState == CompletionState.TASK_UNDONE) {
            this.onTaskUndone(listener);
        }
        return new ExecutionResult(completionState, this.taskList.executionMetaset);
    }

    protected void calculateEndTime(long startTimeMsec) {
        long taskListEndTimeMsec = this.taskList.getEndTimeMsec();
        long taskWindowMsec = this.getTaskWindowMsec();
        if (taskWindowMsec <= 0L) {
            this.endTimeMsec = taskListEndTimeMsec > 0L ? taskListEndTimeMsec : -1L;
        } else {
            this.endTimeMsec = startTimeMsec + taskWindowMsec;
            if (taskListEndTimeMsec > 0L) {
                this.endTimeMsec = Math.min(this.endTimeMsec, taskListEndTimeMsec);
            }
        }
    }

    protected CompletionState doExecutionPart(Date startTime, ExecutionListener listener) {
        this.onExecutionStarted(startTime, listener);
        CompletionState completionState = null;
        if (this.taskList.isTimeExpired()) {
            completionState = this.onExecutionExpired(listener, CompletionState.TASKLIST_EXPIRED);
        } else {
            completionState = this.doExecutionPartInThread(listener);
            if (!this.isUndone()) {
                if (completionState == CompletionState.TASK_COMPLETED) {
                    this.onExecutionCompleted(listener);
                } else {
                    this.taskList.executeExceptionTask(this, listener);
                }
            }
        }
        return completionState;
    }

    protected CompletionState doExecutionPartInThread(ExecutionListener listener) {
        this.setThread(FabricThreadManager.getInstance().createThread("FSYS:Scheduler.Executor:Task_" + this.getFullName(), "Executes a task.", () -> this.doExecute(listener)));
        this.thread.start();
        CompletionState completionState = CompletionState.TASK_FAILED;
        try {
            completionState = this.waitForResult();
        }
        catch (InterruptedException exception) {
            this.onExecutionInterrupted("Task execution interrupted.", null, listener);
            this.thread.stop();
        }
        catch (CancellationException exception) {
            this.onExecutionInterrupted("Task execution cancelled.", null, listener);
            this.thread.stop();
        }
        catch (ExecutionException exception) {
            this.onExecutionFailed(exception.getCause(), listener);
            this.thread.stop();
        }
        catch (TimeoutException exception) {
            completionState = this.onExecutionExpired(listener, this.taskList.isTimeExpired() ? CompletionState.TASKLIST_EXPIRED : CompletionState.TASK_FAILED);
            this.thread.stop();
        }
        this.setThread(null);
        return this.adjustCompletionState(completionState);
    }

    private void setThread(FabricThread thread) {
        this.doSetThread(thread);
    }

    protected abstract TaskState getRunningState();

    protected abstract TaskState getState(TaskState var1);

    protected abstract boolean needsExecution();

    protected abstract CompletionState doExecute(ExecutionListener var1);

    protected abstract CompletionState waitForResult() throws InterruptedException, CancellationException, ExecutionException, TimeoutException;

    @Override
    protected void checkEnabled() throws SchedulerException {
        if (this.taskList.getState() == TaskListState.DISABLED) {
            throw new SchedulerException(6139, this.taskList.toLogNameWithPrefix() + " is disabled. Task cannot be executed.");
        }
    }

    @Override
    protected void checkDisabled() throws SchedulerException {
        if (this.taskList.getState() != TaskListState.DISABLED) {
            throw new SchedulerException(6138, this.taskList.toLogNameWithPrefix() + " is enabled. Task cannot be changed.");
        }
    }

    @Override
    protected boolean isRunning() {
        return this.taskList.isRunning();
    }

    protected void checkRunning() throws SchedulerException {
        if (!this.isRunning() && this.getExecutionState() != this.getRunningState()) {
            throw new SchedulerException(6141, this.toLogNameWithPrefix() + " is not running.");
        }
    }

    @Override
    protected void checkNotRunning() throws SchedulerException {
        if (this.taskList.isRunning()) {
            throw new SchedulerException(6140, this.taskList.toLogNameWithPrefix() + " (or one of its Tasks) is running.");
        }
    }

    @Override
    protected void setRunning() {
        this.taskList.setRunning(true);
    }

    @Override
    protected void setNotRunning() {
        this.taskList.setNotRunning();
    }

    @Override
    protected void checkExecutionMode(ExecutionMode executionMode) throws SchedulerException {
        this.taskList.checkExecutionMode(executionMode);
    }

    @Override
    protected void setExecutionMetaset(Metaset metaset) throws SchedulerException {
        this.taskList.setExecutionMetaset(metaset);
    }

    @Override
    protected void setUntilTime(Date untilTime, boolean autoExpire) throws SchedulerException {
        this.taskList.setUntilTime(untilTime, autoExpire);
    }

    @Override
    protected void initExecutionContext() throws SchedulerException {
        this.taskList.initExecutionContext();
    }

    boolean isResumptionEnabled() {
        return this.isResumptionEnabledOn(this.getState());
    }

    protected long getTaskWindowMsec() {
        return this.taskWindow > 0L ? this.taskWindowUnit.toMillis(this.taskWindow) : this.taskWindow;
    }

    protected void onExecutionStarted(Date startTime, ExecutionListener listener) {
        this.doOnExecutionStarted(startTime, listener, ExecutionListener::onTaskExecutionStarted);
    }

    synchronized void doOnExecutionStarted(Date time, ExecutionListener listener, ListenerHelper listenerHelper) {
        this.execution.onExecutionStarted(time, this.getRunningState());
        this.onExecution(SchedulerAdvisoryType.TASK_EXECUTION_STARTED, listener, listenerHelper);
    }

    protected void onExecutionCompleted(ExecutionListener listener) {
        this.doOnExecutionCompleted(listener, ExecutionListener::onTaskExecutionCompleted);
    }

    synchronized void doOnExecutionCompleted(ExecutionListener listener, ListenerHelper listenerHelper) {
        this.execution.onExecutionCompleted();
        this.onExecution(SchedulerAdvisoryType.TASK_EXECUTION_COMPLETED, listener, listenerHelper);
    }

    protected CompletionState onExecutionExpired(ExecutionListener listener, CompletionState completionState) {
        if (completionState == CompletionState.TASKLIST_EXPIRED || !this.isUndone()) {
            this.doOnExecutionExpired(listener, ExecutionListener::onTaskExecutionExpired);
        }
        return completionState;
    }

    synchronized void doOnExecutionExpired(ExecutionListener listener, ListenerHelper listenerHelper) {
        if (!this.isUndone()) {
            this.execution.onExecutionExpired();
            this.onExecution(SchedulerAdvisoryType.TASK_EXECUTION_EXPIRED, listener, listenerHelper);
        }
    }

    protected void onExecutionFailed(Throwable exception, ExecutionListener listener) {
        this.doOnExecutionFailed(exception, listener, ExecutionListener::onTaskExecutionFailed);
    }

    synchronized void doOnExecutionFailed(Throwable exception, ExecutionListener listener, ListenerHelper listenerHelper) {
        if (!this.isUndone()) {
            this.taskList.setLastException(exception);
            this.execution.onExecutionFailed(exception.getMessage(), SchedulerException.getErrorCode(exception));
            this.onException(exception, listener, listenerHelper);
        }
    }

    protected void onExecutionInterrupted(String errorMessage, Integer errorCode, ExecutionListener listener) {
        this.doOnExecutionInterrupted(errorMessage, errorCode, listener, ExecutionListener::onTaskExecutionInterrupted);
    }

    synchronized void doOnExecutionInterrupted(String errorMessage, Integer errorCode, ExecutionListener listener, ListenerHelper listenerHelper) {
        if (!this.isUndone()) {
            this.execution.onExecutionInterrupted(errorMessage, errorCode);
            this.onExecution(SchedulerAdvisoryType.TASK_EXECUTION_INTERRUPTED, listener, listenerHelper);
        }
    }

    protected synchronized void onCompletionStarted(ExecutionListener listener) {
        this.execution.onCompletionStarted();
        this.onExecution(SchedulerAdvisoryType.TASK_WAITING_COMPLETION, listener, ExecutionListener::onTaskWaiting);
    }

    protected synchronized void onCompletionCompleted(ExecutionListener listener, boolean forTaskList, Map<String, Object> facets) {
        this.execution.onCompletionCompleted(forTaskList, facets);
        this.onExecution(SchedulerAdvisoryType.TASK_COMPLETED, facets, listener, ExecutionListener::onTaskCompleted);
    }

    protected synchronized CompletionState onCompletionFailed(ExecutionListener listener, boolean forTaskList, Map<String, Object> facets) {
        this.execution.onCompletionFailed(this.needsExecution(), forTaskList, facets);
        this.onExecution(SchedulerAdvisoryType.TASK_FAILED, facets, listener, ExecutionListener::onTaskFailed);
        return CompletionState.TASK_FAILED;
    }

    protected synchronized CompletionState onCompletionExpired(ExecutionListener listener, CompletionState completionState) {
        this.execution.onCompletionExpired(this.needsExecution());
        this.onExecution(SchedulerAdvisoryType.TASK_EXPIRED_INCOMPLETE, listener, ExecutionListener::onTaskExpiredIncomplete);
        return completionState;
    }

    protected synchronized CompletionState onCompletionInterrupted(ExecutionListener listener) {
        this.execution.onCompletionInterrupted(this.needsExecution());
        this.onExecution(SchedulerAdvisoryType.TASK_INTERRUPTED_INCOMPLETE, listener, ExecutionListener::onTaskInterruptedIncomplete);
        return CompletionState.TASK_FAILED;
    }

    protected synchronized void onTaskUndone(ExecutionListener listener) {
        this.execution.doSetState(TaskState.PENDING);
        this.onExecution(SchedulerAdvisoryType.TASK_UNDONE, listener, ExecutionListener::onTaskUndone);
    }

    protected SchedulerEvent createEvent(String userName, Date time, ExecutionListener listener) {
        try {
            SchedulerEvent event = (SchedulerEvent)EventDatagramFactory.getInstance().createEvent("event.Scheduler");
            event.setReplyTo("e.reply." + this.taskList.getExecution().getEID().toString());
            event.setTaskList(this.taskList);
            event.setMetaset(this.taskList.executionMetaset);
            if (this.taskList.job != null) {
                event.setEventStringProperty("jobName", this.taskList.job.getName());
                if (this.taskList.job.getExecutionTime() != null) {
                    event.setEventLongProperty("jobTime", this.taskList.job.getExecutionTime().getTime());
                }
            }
            event.setEventStringProperty("listName", this.taskList.getName());
            event.setEventStringProperty("taskName", this.getName());
            event.setEventStringProperty("nodeName", AbstractRuntimeFactory.getContext().getName());
            event.setEventStringProperty("userName", userName);
            event.setEventLongProperty("taskTime", time.getTime());
            this.setProperties(event);
            this.addTags(event);
            return event;
        }
        catch (Throwable exception) {
            this.logException(exception);
            this.logError("Creation of Scheduler Event failed.");
            this.onExecutionFailed(exception, listener);
            return null;
        }
    }

    private void setProperties(MapEvent event) throws Exception {
        if (this.taskList.properties != null) {
            this.doSetProperties(event, this.taskList.properties);
        }
        if (this.properties != null) {
            this.doSetProperties(event, this.properties);
        }
    }

    private void doSetProperties(MapEvent event, Map<String, Object> properties) throws Exception {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            event.setObject(entry.getKey(), entry.getValue());
        }
    }

    private void addTags(MapEvent event) throws Exception {
        if (this.taskList.tags != null) {
            this.doAddTags(event, this.taskList.tags);
        }
        if (this.tags != null) {
            this.doAddTags(event, this.tags);
        }
    }

    private void doAddTags(MapEvent event, Set<String> tags) throws Exception {
        for (String tag : tags) {
            event.addTag((String)(tag.startsWith("#") ? tag : "#" + tag));
        }
    }

    @Override
    public ExceptionTask getExceptionTask() {
        return this.taskList.getExceptionTask(this.getName());
    }

    @Override
    public Throwable getLastException() {
        return this.taskList.getLastException();
    }

    boolean existsExceptionTask() {
        return this.taskList.existsExceptionTask(this.getName());
    }

    @Override
    public int getOrder() {
        return this.taskList.getTaskOrder(this.getName());
    }

    void onExecution(SchedulerAdvisoryType type, ExecutionListener listener, ListenerHelper helper) {
        this.onExecution(type, null, listener, helper);
    }

    void onExecution(SchedulerAdvisoryType type, Map<String, Object> facets, ExecutionListener listener, ListenerHelper helper) {
        this.doListen(listener, helper);
        this.raiseAdvisory(type, facets, null);
    }

    private void onException(Throwable exception, ExecutionListener listener, ListenerHelper listenerHelper) {
        this.doListen(listener, listenerHelper);
        this.raiseException(exception);
    }

    private void doListen(ExecutionListener listener, ListenerHelper helper) {
        if (listener != null) {
            helper.listen(listener, this, this.execution.taskListExecution);
        }
    }

    void onDelay(SchedulerAdvisoryType type, ExecutionListener listener, ListenerHelperForDelay helper, long delay) {
        this.doListen(listener, helper, delay);
        this.raiseAdvisory(type, null, delay);
    }

    private void doListen(ExecutionListener listener, ListenerHelperForDelay helper, long delay) {
        if (listener != null) {
            helper.listen(listener, this, this.execution.taskListExecution, delay);
        }
    }

    private void raiseAdvisory(SchedulerAdvisoryType type, Map<String, Object> facets, Long delay) {
        this.taskList.raiseAdvisory(type, this, this.execution.taskListExecution, facets, delay);
    }

    private void raiseException(Throwable exception) {
        this.taskList.raiseException(exception, this, this.execution.taskListExecution);
    }

    protected static Throwable getCause(Throwable exception) {
        while (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return exception;
    }

    @Override
    protected void doUpdateInStorage() {
        if (this.taskList != null) {
            this.taskList.updateInStorage();
        }
    }

    @Override
    protected String toLogName() {
        return AbstractTask.toLogName(this.getFullName());
    }

    @Override
    String toLogNameWithPrefix() {
        return AbstractTask.toLogNameWithPrefix(this.getName());
    }

    static String toLogNameWithPrefix(String name) {
        return "Task " + AbstractTask.toLogName(name);
    }

    protected boolean isUndone() {
        return false;
    }

    protected void resetUndo() {
    }

    protected long getUndoDelay() {
        return 0L;
    }

    private CompletionState adjustCompletionState(CompletionState state) {
        if (state == CompletionState.TASKLIST_EXPIRED) {
            return state;
        }
        return this.isUndone() ? CompletionState.TASK_UNDONE : state;
    }

    protected void throwsNotSupportedOperation(String operationName) throws SchedulerException {
        throw new SchedulerException(6001, "Operation '" + operationName + "' is not supported in " + String.valueOf((Object)this.getType()) + " Task.");
    }

    @Override
    public String toString() {
        return this.getName() + "(" + super.toString() + ", state=" + String.valueOf((Object)this.getState()) + ")";
    }

    static class ExecutionResult {
        CompletionState state = null;
        Metaset metaset = null;

        ExecutionResult(CompletionState state, Metaset metaset) {
            this.state = state;
            this.metaset = metaset;
        }
    }

    public static interface ListenerHelper {
        public void listen(ExecutionListener var1, AbstractTask var2, TaskListExecution var3);
    }

    public static interface ListenerHelperForDelay {
        public void listen(ExecutionListener var1, AbstractTask var2, TaskListExecution var3, long var4);
    }
}

