/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeMFSession;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.scheduler.AbstractSchedulerObject;
import com.streamscape.sef.scheduler.AbstractTask;
import com.streamscape.sef.scheduler.ActionTask;
import com.streamscape.sef.scheduler.DescribedNamedObject;
import com.streamscape.sef.scheduler.EventTask;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.ExceptionTask;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.JobType;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.NotifyLevel;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.SchedulerProxy;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import com.streamscape.sef.scheduler.TaskState;
import com.streamscape.sef.scheduler.TaskType;
import com.streamscape.sef.security.User;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.DataspaceVariableReferenceParameter;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSchedulerOperation
extends AbstractOperation<RuntimeContext> {
    public static final String SCHEDULER_ACTION_TASK_PREFIX = "SCHEDULER_TASK_";
    public static final String RPL_COMPLETION_WRAPPER = "create function SCHEDULER_TASK_FAKE_FUNC() returns int as ";
    public static final List<String> SCHEDULER_ACTION_VARIABLES = Arrays.asList("TaskList", "Task", "TaskMetaset", "Completion");
    private static final TimeUnit[] TIME_UNITS = new TimeUnit[]{TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS};
    private static final TimeUnit[] TIME_UNITS_SHORT = new TimeUnit[]{TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS};
    protected static final String TASKLIST_NAME = "TaskListName";
    protected static final String TASK_NAME = "TaskName";
    protected static final String EXCEPTION = "Exception";

    protected AbstractSchedulerOperation() {
        this(false);
    }

    protected AbstractSchedulerOperation(boolean isAdministrative) {
        super(isAdministrative, false);
        this.setExportable();
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.scheduler);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.checkSchedulerReady();
        return this.doInvoke(statement, session, timeout);
    }

    protected abstract SLResponse doInvoke(SLStatement var1, MFSession var2, long var3) throws Exception;

    @Override
    protected Scheduler getScheduler(User user) {
        return super.getScheduler(user);
    }

    public static String formatDate(Date date) {
        return date != null ? DateParameter.formatDate(date, SCHEDULER_DATE_FORMAT) : "";
    }

    protected static Date parseDate(String str) throws ParsingException {
        try {
            return DateParameter.parseDate(str, SCHEDULER_DATE_FORMAT);
        }
        catch (ParseException exception) {
            throw new ParsingException(exception.getMessage());
        }
    }

    protected void addLikeModifier() {
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("LIKE", false).addParameter(this.createLikeParameter())).setSyntaxHintSpace());
    }

    protected AbstractParameter createLikeParameter() {
        return null;
    }

    protected void addNameModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("NAME", false).addParameter(new IdentifierParameter("NewName")));
    }

    protected void addOwnerModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("OWNER", false).addParameter(new IdentifierParameter("Owner")));
    }

    protected void addDescriptionModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description")));
    }

    protected void addModelModifier() {
        this.syntax.addModifier(new Modifier("MODEL", false));
    }

    protected void addEncryptModifier() {
        this.syntax.addModifier(new Modifier("ENCRYPT", false));
    }

    protected void addEncryptDecryptModifier() {
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("ENCRYPT"))).addModifier(new Modifier("DECRYPT")));
    }

    protected void addScriptModifier(boolean required) {
        this.syntax.addModifier(this.createScriptModifier(required));
    }

    protected ChoiceModifier createScriptModifier(boolean required) {
        return (ChoiceModifier)((ChoiceModifier)new ChoiceModifier("AsModifier", required).addModifier(new Modifier("NO RPL"))).addModifier((AbstractModifier)new Modifier("AS").addParameter((SyntaxParameter)new ExpressionParameter("RPL", '{', '}').setIgnoreQuotes(false).setSkipOneLineComments(true).setCompleter((script, processedScript, callable, session) -> {
            Object rpl = script.trim();
            if (!((String)rpl).startsWith("{")) {
                if (((String)rpl).isEmpty()) {
                    return new DSLCompletion().setCompletion(new TokenSuggestion("{"));
                }
                return new DSLCompletion(new Exception("Expected parameter with syntax {<RPL>}, after 'as'."));
            }
            rpl = ((String)rpl).substring(1).trim();
            rpl = "create function SCHEDULER_TASK_FAKE_FUNC() returns int as \n{\nTaskList TaskList;\nTask Task;\nMetaset TaskMetaset;\nSchedulerCompletionEvent Completion;\n" + (String)rpl;
            return ((RuntimeMFSession)session).getDataspaceSDSSession().complete((String)rpl);
        })));
    }

    protected void addEnableModifier() {
        this.syntax.addModifier(new Modifier("ENABLE", false));
    }

    protected static EnumParameter createTimeUnitParameter(String name) {
        return AbstractSchedulerOperation.createTimeUnitParameter(name, true);
    }

    protected static EnumParameter createTimeUnitParameter(String name, boolean withMilliseconds) {
        return new EnumParameter(name, TimeUnit.class, withMilliseconds ? TIME_UNITS : TIME_UNITS_SHORT).setDefaultValue(TimeUnit.SECONDS.name());
    }

    protected static String getNodeName(Definition definition) {
        return AtNodeOrAtDomainModifier.getValue(definition.statement);
    }

    protected static String getTimeFormat() {
        return AbstractSchedulerOperation.getTimeFormat(null);
    }

    protected static String getTimeFormat(String indent) {
        return (indent != null ? indent : "") + "Time format is '" + SCHEDULER_DATE_FORMAT.toPattern() + "' (e.g. 05-31-2013 08:31:12 PM).";
    }

    protected IdentifierParameter createJobNameParameter() {
        return new IdentifierParameter("JobName");
    }

    protected IdentifierParameter createJobNameParameterWithAdviser(JobState ... states) {
        return (IdentifierParameter)this.createJobNameParameter().setCompletionAdviser(new JobNameCompletionAdviser(states));
    }

    protected ScheduledJob createJob(Scheduler scheduler, JobType type, Definition definition) throws SchedulerException {
        return type == JobType.SINGLE ? scheduler.createSingleJob(AbstractSchedulerOperation.getJobName(definition.statement), AbstractSchedulerOperation.getSourceName(definition.statement)) : scheduler.createRepeatingJob(AbstractSchedulerOperation.getJobName(definition.statement), AbstractSchedulerOperation.getSourceName(definition.statement));
    }

    protected ScheduledJob lookupJob(Scheduler scheduler, String jobName) throws Exception {
        ScheduledJob result = scheduler.getJob(jobName);
        if (result == null) {
            throw new Exception("Job not found.");
        }
        return result;
    }

    protected ScheduledJob lookupJob(Scheduler scheduler, DSLStatement statement) throws Exception {
        return this.lookupJob(scheduler, AbstractSchedulerOperation.getJobName(statement));
    }

    protected static String getJobName(DSLStatement statement) {
        return statement.getParameter("JobName").getValue();
    }

    protected IdentifierParameter createTaskListNameParameter() {
        return this.doCreateTaskListNameParameter();
    }

    protected IdentifierParameter createTaskListNameParameterWithAdviser(TaskListState ... states) {
        return (IdentifierParameter)this.createTaskListNameParameter().setCompletionAdviser(new TaskListNameCompletionAdviser(states));
    }

    protected IdentifierParameter doCreateTaskListNameParameter() {
        return new IdentifierParameter(TASKLIST_NAME);
    }

    protected static TaskList createTaskList(Scheduler scheduler, Definition definition) throws SchedulerException {
        return scheduler.createTaskList(AbstractSchedulerOperation.getTaskListName(definition.statement), AbstractSchedulerOperation.getSourceName(definition.statement));
    }

    protected static TaskList lookupTaskList(Scheduler scheduler, Definition definition) throws Exception {
        return AbstractSchedulerOperation.lookupTaskList(scheduler, AbstractSchedulerOperation.getTaskListName(definition.statement));
    }

    protected static TaskList lookupTaskList(Scheduler scheduler, DSLStatement statement) throws Exception {
        return AbstractSchedulerOperation.lookupTaskList(scheduler, AbstractSchedulerOperation.getTaskListName(statement));
    }

    protected static TaskList lookupTaskList(Scheduler scheduler, String name) throws Exception {
        TaskList result = scheduler.getTaskList(name);
        if (result == null) {
            throw new Exception("Task List not found.");
        }
        return result;
    }

    protected static String getTaskListName(DSLStatement statement) {
        return statement.getParameter(TASKLIST_NAME).getValue();
    }

    protected static String getTaskListName(Definition definition) {
        return AbstractSchedulerOperation.getTaskListName(definition.statement);
    }

    protected ActionTask addActionTask(TaskList taskList, DSLStatement statement, MFSession session) throws SchedulerException {
        return taskList.addActionTask(AbstractSchedulerOperation.getTaskName(statement), AbstractSchedulerOperation.getSourceListName(statement), AbstractSchedulerOperation.getSourceTaskName(statement), session.getOwnerName(), AbstractSchedulerOperation.getScript(statement));
    }

    protected EventTask addEventTask(TaskList taskList, DSLStatement statement, MFSession session) throws SchedulerException {
        return taskList.addEventTask(AbstractSchedulerOperation.getTaskName(statement), AbstractSchedulerOperation.getSourceListName(statement), AbstractSchedulerOperation.getSourceTaskName(statement), session.getOwnerName());
    }

    protected ExceptionTask addExceptionTask(TaskList taskList, DSLStatement statement, MFSession session) throws SchedulerException {
        String taskName = statement.existsParameter(TASK_NAME) ? AbstractSchedulerOperation.getTaskName(statement) : null;
        return taskList.addExceptionTask(taskName, AbstractSchedulerOperation.getSourceListName(statement), AbstractSchedulerOperation.getSourceTaskName(statement), session.getOwnerName(), AbstractSchedulerOperation.getScript(statement));
    }

    protected static String getTaskName(Definition definition) {
        return AbstractSchedulerOperation.getTaskName(definition.statement);
    }

    protected static String getTaskName(DSLStatement statement) {
        return AbstractSchedulerOperation.getTaskName(statement, TASK_NAME);
    }

    protected static String getTaskName(DSLStatement statement, String parameterName) {
        return statement.getParameter(parameterName).getValue();
    }

    protected static boolean hasExceptionTaskName(Definition definition) {
        return AbstractSchedulerOperation.hasExceptionTaskName(definition.statement);
    }

    protected static boolean hasExceptionTaskName(DSLStatement statement) {
        return statement.existsParameter(EXCEPTION);
    }

    protected static String getExceptionTaskName(Definition definition) {
        return AbstractSchedulerOperation.getExceptionTaskName(definition.statement);
    }

    protected static String getExceptionTaskName(DSLStatement statement) {
        return statement.getParameter(EXCEPTION).getValue();
    }

    protected static String getScript(DSLStatement statement) {
        if (statement.existsParameter("RPL")) {
            String rpl = statement.getParameter("RPL").getValue();
            return StringUtils.isBlank((CharSequence)rpl) ? "{}" : "{" + rpl + "}";
        }
        return null;
    }

    protected IdentifierParameter createTriggerNameParameter() {
        return new IdentifierParameter("TriggerName");
    }

    protected IdentifierParameter createTriggerNameParameterWithAdviser() {
        return (IdentifierParameter)this.createTriggerNameParameter().setCompletionAdviser(new TriggerNameCompletionAdviser(null));
    }

    protected EventTaskTrigger createTrigger(Scheduler scheduler, Definition definition) throws SchedulerException {
        return scheduler.createTrigger(AbstractSchedulerOperation.getTriggerName(definition.statement), AbstractSchedulerOperation.getSourceName(definition.statement));
    }

    protected EventTaskTrigger getTrigger(String triggerName) throws Exception {
        EventTaskTrigger result = ((RuntimeContext)this.callable).getScheduler().getTrigger(triggerName);
        if (result == null) {
            throw new Exception("Trigger not found.");
        }
        return result;
    }

    protected EventTaskTrigger getTrigger(DSLStatement statement) throws Exception {
        return this.getTrigger(AbstractSchedulerOperation.getTriggerName(statement));
    }

    protected static String getTriggerName(DSLStatement statement) {
        return statement.getParameter("TriggerName").getValue();
    }

    protected static String getSourceName(DSLStatement statement) {
        return statement.getParameter("SourceName").getValue();
    }

    protected static String getSourceListName(DSLStatement statement) {
        return statement.getParameter("SourceList").getValue();
    }

    protected static String getSourceTaskName(DSLStatement statement) {
        return statement.getParameter("SourceTask").getValue();
    }

    protected static void setName(DescribedNamedObject object, Definition definition) throws Exception {
        if (definition.statement.existsParameter("NewName")) {
            object.setName(definition.statement.getParameter("NewName").getValue());
        }
    }

    protected static void setDescription(DescribedNamedObject object, Definition definition) throws Exception {
        if (definition.statement.existsParameter("Description")) {
            object.setDescription(definition.statement.getParameter("Description").getValue());
        }
    }

    protected void checkParametersPresence(DSLStatement statement) throws ParsingException {
        List<String> modifiers = statement.listModifiers();
        if (modifiers.size() == 1 && modifiers.get(0).equals("ACTION_VERB")) {
            throw new ParsingException("At least one parameter must be specified.");
        }
    }

    protected CompoundModifier createExecModifier(boolean withCount, boolean withAscDesc) {
        CompoundModifier lastAll = new CompoundModifier().addModifier(new Modifier("*"));
        if (withCount) {
            lastAll.addModifier(new Modifier("COUNT", false));
        }
        lastAll.addModifier(this.createFromToModifier("Exec"));
        CompoundModifier last = new CompoundModifier().addModifier(new Modifier("LAST")).addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(lastAll)).addParameter((AbstractParameter)new IntegerParameter("N").setRange(1, Integer.MAX_VALUE).addExclusionValues("AS", "AT", "METASET", "FACETS", "ASC", "DESC", "WHERE", "ALL", "*"))).addModifier(this.createWhereModifier("Exec"));
        if (withAscDesc) {
            last.addModifier(new ChoiceModifier(false).addPossibleValues("ASC", "DESC"));
        }
        return new CompoundModifier().addModifier(new Modifier("EXEC")).addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(last)).addModifier((AbstractModifier)new Modifier("ID").addParameter(new IdentifierParameter("ExecId"))));
    }

    protected CompoundModifier createFromToModifier() {
        return new CompoundModifier(false).addModifier((AbstractModifier)new Modifier("FROM", false).addParameter(new DateParameter("FromTime", SCHEDULER_DATE_FORMAT))).addModifier((AbstractModifier)new Modifier("TO", false).addParameter(new DateParameter("ToTime", SCHEDULER_DATE_FORMAT)));
    }

    protected CompoundModifier createFromToModifier(String prefix) {
        CompoundModifier fromTo = this.createFromToModifier();
        this.setFromToItem(fromTo, "From", prefix);
        this.setFromToItem(fromTo, "To", prefix);
        return fromTo;
    }

    private void setFromToItem(CompoundModifier fromTo, String itemName, String prefix) {
        Modifier item = (Modifier)fromTo.lookupModifier(itemName.toUpperCase());
        item.setName(prefix + itemName);
        item.getParameter(itemName + "Time").setName(prefix + itemName + "Time");
    }

    protected Modifier createWhereModifier() {
        return (Modifier)new Modifier("WHERE", false).addParameter(new ExpressionParameter("Condition", '(', ')'));
    }

    protected Modifier createWhereModifier(String prefix) {
        Modifier modifier = this.createWhereModifier();
        modifier.setName(prefix + "Where");
        modifier.getParameter("Condition").setName(prefix + "Condition");
        return modifier;
    }

    protected static Map<UUID, List<TaskListExecution>> getAllExecutions(Scheduler scheduler, ExecDefinition exec) throws Exception {
        return ((SchedulerProxy)scheduler).getAllExecutions(exec.fromTime, exec.toTime, exec.condition);
    }

    protected static List<TaskListExecution> filterByTaskFacets(List<TaskListExecution> executions, SelectorExpression condition) {
        return SchedulerImpl.filterByTaskFacets(executions, condition);
    }

    protected static String formatExecTime(Date time) {
        return AbstractSchedulerOperation.formatDate(time);
    }

    protected static String formatExecTime(Long timeMsec) {
        return timeMsec != null && timeMsec > 0L ? AbstractSchedulerOperation.formatExecTime(new Date(timeMsec)) : "infinite";
    }

    protected static String convertNull(String value) {
        return value == null ? "*" : value;
    }

    protected static String formatNonNegativeInterval(Long interval, TimeUnit intervalUnit) {
        if (interval == null || interval == 0L) {
            return "none";
        }
        return AbstractSchedulerOperation.formatInterval(interval, intervalUnit);
    }

    protected static String formatInterval(Long interval, TimeUnit intervalUnit) {
        if (interval == null) {
            return AbstractSchedulerOperation.skipNull(interval);
        }
        return interval > 0L ? interval + " " + intervalUnit.name().toLowerCase() : "infinite";
    }

    protected static RowMetaData createResultDescriptorDescription() {
        RowMetaData result = new RowMetaData();
        AbstractSchedulerOperation.addColumn(result, "Description");
        return result;
    }

    protected static RowMetaData createResultDescriptorRpl() {
        RowMetaData result = new RowMetaData();
        AbstractSchedulerOperation.addColumn(result, "RPL");
        return result;
    }

    protected List<String> listEvents(TaskList taskList) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("advisory.Scheduler");
        result.add("exception.Scheduler");
        ScheduledJob job = taskList.getJob();
        if (job != null && job.isNotify() && (job.getNotifyLevel() == NotifyLevel.TASK || job.getNotifyLevel() == NotifyLevel.TASKLIST)) {
            result.add("event.Scheduler.Email");
        }
        HashSet taskEvents = new HashSet();
        taskList.getTasks().forEach(task -> taskEvents.addAll(task.listEventIds()));
        result.addAll(taskEvents);
        return result;
    }

    protected IdentifierParameter createMetasetNameParameterWithAdviser() {
        return (IdentifierParameter)this.createMetasetNameParameter().setCompletionAdviser(new MetasetNameCompletionAdviser());
    }

    protected IdentifierParameter createMetasetNameParameter() {
        return new IdentifierParameter("MetasetName");
    }

    protected Metaset lookupMetaset(Scheduler scheduler, DSLStatement statement) throws Exception {
        return this.lookupMetaset(scheduler, AbstractSchedulerOperation.getMetasetName(statement));
    }

    protected Metaset lookupMetaset(Scheduler scheduler, String name) throws Exception {
        Metaset result = scheduler.getMetaset(name);
        if (result == null) {
            throw new Exception("Metaset not found.");
        }
        return result;
    }

    protected static String getMetasetName(DSLStatement statement) {
        return statement.getParameter("MetasetName").getValue();
    }

    protected void getPredefinedValues(Metaset metaset, Map<String, Object> result) {
        metaset.getPredefinedProperties(result);
    }

    protected Metaset getMetaset(Definition definition, MFSession session) throws Exception {
        if (definition.statement.existsParameter("Metaset")) {
            return (Metaset)DataspaceVariableReferenceParameter.getVariableValue(session, definition.statement.getParameter("Metaset").getValue());
        }
        return null;
    }

    protected Metaset lookupMetasetInstance(Scheduler scheduler, String listName) throws Exception {
        TaskList taskList = AbstractSchedulerOperation.lookupTaskList(scheduler, listName);
        Metaset result = taskList.getMetasetInstance();
        if (result == null) {
            throw new Exception("Metaset instance not found.");
        }
        return result;
    }

    protected CompoundModifier createPropertyModifier(boolean withType) {
        return this.createPropertyModifier(withType, "");
    }

    protected CompoundModifier createPropertyModifier(boolean withType, String indent) {
        return this.createPropertyModifier(withType, indent, "DefaultValue");
    }

    protected CompoundModifier createPropertyModifier(boolean withType, String indent, String valueParameterName) {
        CompoundModifier result = this.createPropertyNameModifier("Key");
        if (withType) {
            result.addModifier(this.createPropertyTypeModifierExtended(AbstractDSLOperation.PropertyTypes.ALL, true, indent, true));
        }
        return result.addParameter((AbstractParameter)new ExpressionParameter(valueParameterName).setRequired(!withType));
    }

    protected void setValues(DSLStatement dslStatement, Map<String, Object> result, String valueParameterName, boolean predefinedOnly) throws Exception {
        if (dslStatement.existsBlock("SetFacetsBlock")) {
            StatementBlockValue valuesBlock = dslStatement.getBlock("SetFacetsBlock");
            for (int i = 0; i < valuesBlock.getLinesCount(); ++i) {
                StatementValueList line = valuesBlock.getLineByIndex(i).getBlock("SetFacetsInnerBlock").getLineByIndex(0);
                String key = line.getParameter("Key").getValue();
                if (predefinedOnly && !result.containsKey(key)) {
                    throw new Exception("Facet '" + key + "' not found.");
                }
                AbstractDSLOperation.PropertyValue value = new AbstractDSLOperation.PropertyValue(line.getParameter(valueParameterName).getValue());
                this.parseTypeAndFormat(line, value);
                this.putValue(key, value, result);
            }
        }
    }

    protected void putValue(String key, AbstractDSLOperation.PropertyValue value, Map<String, Object> result) throws Exception {
        if (value.getValue() == null) {
            result.put(key, value.getType() == AbstractDSLOperation.PropertyValue.Type.DATE ? new Date() : EventPropertyValidator.getDefaultValue(value.toPropertyType()));
        } else {
            result.put(key, this.parseValue(value, true));
        }
    }

    protected static RowSet describeSession(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeSession();
    }

    protected static RowSet describeDataspace(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeDataspace();
    }

    protected static RowSet describeDataspaceHealth(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeDataspaceHealth();
    }

    protected static RowSet describeDataspaceConsistency(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeDataspaceConsistency();
    }

    protected static RowSet describeCollections(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeCollections();
    }

    protected static RowSet describeCollectionsHealth(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeCollectionsHealth();
    }

    protected static RowSet describeCollectionsConsistency(Scheduler scheduler) throws SchedulerException {
        return ((SchedulerProxy)scheduler).describeCollectionsConsistency();
    }

    protected static boolean isRunning(TaskList taskList) {
        return taskList != null && taskList.isRunning();
    }

    protected static boolean isRunning(ScheduledJob job) {
        return AbstractSchedulerOperation.isRunning(job.getTaskList());
    }

    protected static Metaset createMetaset(Scheduler scheduler, String name, String description, Map<String, Object> values, boolean isStatic) throws Exception {
        return ((SchedulerProxy)scheduler).createMetaset(name, description, values, isStatic);
    }

    protected static Metaset updateMetaset(Scheduler scheduler, String name, String description, Map<String, Object> values, boolean isStatic) throws Exception {
        return ((SchedulerProxy)scheduler).updateMetaset(name, description, values, isStatic);
    }

    protected static String toFullNameWithPrefix(TaskList taskList) {
        return taskList.toLogNameWithPrefix();
    }

    protected static String toFullNameWithPrefix(Task task) {
        return AbstractTask.toLogNameWithPrefix(((AbstractTask)task).getFullName());
    }

    protected static class Definition
    extends AbstractSLStatement {
        public DSLStatement statement;

        public Definition(String operationName, DSLStatement statement) {
            super(operationName);
            this.statement = statement;
        }
    }

    protected class JobNameCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        protected List<JobState> states;

        public JobNameCompletionAdviser(JobState ... states) {
            this.states = states == null || states.length == 0 ? null : Arrays.asList(states);
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            return this.getJobs().map(NamedObject::getName).collect(Collectors.toList());
        }

        protected Stream<ScheduledJob> getJobs() {
            return ((RuntimeContext)AbstractSchedulerOperation.this.callable).getScheduler().getJobs().stream().filter(this::matchesState);
        }

        protected boolean matchesState(ScheduledJob job) {
            return this.states == null || this.states.contains((Object)job.getState());
        }
    }

    protected class TaskListNameCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        protected List<TaskListState> states;

        public TaskListNameCompletionAdviser() {
            this(null);
        }

        public TaskListNameCompletionAdviser(TaskListState ... states) {
            this.states = states == null || states.length == 0 ? null : Arrays.asList(states);
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            return this.getTaskLists(session).map(AbstractSchedulerObject::getName).collect(Collectors.toList());
        }

        protected Stream<TaskList> getTaskLists(MFSession session) {
            return AbstractSchedulerOperation.this.getScheduler(session).getTaskLists().stream().filter(tl -> this.states == null || this.states.contains((Object)tl.getState()));
        }
    }

    protected class TriggerNameCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        protected Boolean enabled;

        public TriggerNameCompletionAdviser(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            return this.getTriggers().map(AbstractSchedulerObject::getName).collect(Collectors.toList());
        }

        protected Stream<EventTaskTrigger> getTriggers() {
            return ((RuntimeContext)AbstractSchedulerOperation.this.callable).getScheduler().getTriggers().stream().filter(trigger -> this.enabled == null || trigger.isEnabled() == this.enabled.booleanValue());
        }
    }

    protected static class ExecDefinition {
        public boolean last;
        public Integer N;
        public boolean count;
        public UUID eid;
        public Date fromTime;
        public Date toTime;
        public SelectorExpression condition;
        public boolean facets;
        public boolean metaset;
        public Boolean orderByAsc;
        public boolean all;

        public ExecDefinition(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            this.last = statement.existsModifier("LAST");
            this.count = statement.existsModifier("COUNT");
            this.all = statement.existsModifier("ALL");
            this.facets = statement.existsModifier("FACETS");
            this.metaset = statement.existsModifier("METASET");
            this.initEID(operation, statement);
            this.initCondition(operation, statement);
            if (this.last) {
                this.N = 1;
                if (statement.existsParameter("N")) {
                    this.N = Integer.parseInt(statement.getParameter("N").getValue());
                } else if (statement.existsModifier("*")) {
                    this.N = -1;
                }
            }
            if (statement.existsParameter("FromTime")) {
                this.fromTime = AbstractSchedulerOperation.parseDate(statement.getParameter("FromTime").getValue());
            }
            if (statement.existsParameter("ToTime")) {
                this.toTime = AbstractSchedulerOperation.parseDate(statement.getParameter("ToTime").getValue());
            }
            if (statement.existsModifier("ASC")) {
                this.orderByAsc = true;
            } else if (statement.existsModifier("DESC")) {
                this.orderByAsc = false;
            }
        }

        private void initEID(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            if (statement.existsParameter("ExecId")) {
                try {
                    this.eid = UUID.fromString(statement.getParameter("ExecId").getValue());
                }
                catch (IllegalArgumentException exception) {
                    throw new ParsingException(AbstractDSLOperation.getSyntaxErrorMessage(operation, "Invalid format of ExecId parameter."));
                }
            }
        }

        private void initCondition(AbstractSchedulerOperation operation, DSLStatement statement) throws ParsingException {
            String conditionStr = null;
            if (statement.existsParameter("ExecCondition")) {
                conditionStr = statement.getParameter("ExecCondition").getValue();
            } else if (statement.existsParameter("ExecsCondition")) {
                conditionStr = statement.getParameter("ExecsCondition").getValue();
            }
            if (conditionStr != null) {
                if ((conditionStr = conditionStr.trim()).isEmpty()) {
                    throw new ParsingException(AbstractDSLOperation.getSyntaxErrorMessage(operation, "Condition cannot be null or an empty string."));
                }
                try {
                    this.condition = SelectorParser.parse(conditionStr);
                }
                catch (SelectorFormatException exception) {
                    throw new ParsingException(AbstractDSLOperation.getSyntaxErrorMessage(operation, "Condition is not valid:\n   Cause: " + Utils.formatException(exception, "\n   ")));
                }
            }
        }
    }

    protected class MetasetNameCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            return ((RuntimeContext)AbstractSchedulerOperation.this.callable).getScheduler().listMetasets();
        }
    }

    protected static class AbstractPurgeDefinition
    extends Definition {
        public Date fromTime;
        public Date toTime;
        public String nodeName;

        public AbstractPurgeDefinition(String operationName, DSLStatement statement) throws ParsingException {
            super(operationName, statement);
            this.fromTime = statement.existsParameter("FromTime") ? AbstractSchedulerOperation.parseDate(statement.getParameter("FromTime").getValue()) : null;
            this.toTime = statement.existsParameter("ToTime") ? AbstractSchedulerOperation.parseDate(statement.getParameter("ToTime").getValue()) : null;
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
        }
    }

    protected class FullTaskNameCompletionAdviser
    extends TaskListNameCompletionAdviser {
        protected TaskType taskType;
        protected List<TaskState> taskStates;
        protected boolean withExceptions = false;
        protected boolean reducible = false;

        protected FullTaskNameCompletionAdviser(AbstractSchedulerOperation this$0, TaskListState ... states) {
            super(states);
        }

        protected FullTaskNameCompletionAdviser(AbstractSchedulerOperation this$0, List<TaskListState> listStates, List<TaskState> taskStates) {
            super(listStates.toArray(new TaskListState[0]));
            this.taskStates = taskStates;
        }

        protected FullTaskNameCompletionAdviser(AbstractSchedulerOperation this$0, TaskType taskType, TaskListState ... states) {
            super(states);
            this.taskType = taskType;
        }

        public FullTaskNameCompletionAdviser withExceptions() {
            this.withExceptions = true;
            return this;
        }

        public FullTaskNameCompletionAdviser reducible() {
            this.reducible = true;
            return this;
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            this.getTaskLists(session).forEach(tl -> {
                if (this.reducible && this.checkTaskList((TaskList)tl)) {
                    result.add(tl.getName());
                }
                tl.getTasks().stream().filter(this.checkTaskPredicate()).forEach(task -> result.add(tl.getName() + "." + task.getName()));
                if (this.withExceptions) {
                    ExceptionTask exceptionTask = tl.getExceptionTask();
                    if (exceptionTask != null && this.checkTask(exceptionTask)) {
                        result.add(tl.getName() + "." + exceptionTask.getName());
                    }
                    tl.getExceptionTasks().stream().filter(this.checkTaskPredicate()).forEach(task -> result.add(tl.getName() + "." + task.getName() + ".Exception"));
                }
            });
            return result;
        }

        protected boolean checkTaskList(TaskList taskList) {
            return true;
        }

        protected boolean checkTask(Task task) {
            return !(this.taskType != null && !task.getType().equals((Object)this.taskType) || this.taskStates != null && !this.taskStates.contains((Object)task.getState()));
        }

        private Predicate<Task> checkTaskPredicate() {
            return this::checkTask;
        }
    }

    protected class FullTaskNameParameterWithException
    extends CompoundParameter {
        public FullTaskNameParameterWithException(TaskListState ... states) {
            this((TaskType)null, states);
        }

        public FullTaskNameParameterWithException(TaskType taskType) {
            this(taskType, (TaskListState[])null);
        }

        public FullTaskNameParameterWithException(TaskType taskType, TaskListState ... states) {
            this();
            this.setCompletionAdviser(new FullTaskNameCompletionAdviser(this$0, taskType, states).withExceptions());
        }

        private FullTaskNameParameterWithException() {
            this.setReverseOrder(true);
            this.setParametersDelimiter('.');
            this.setCompactSyntax("<TaskListName>.<TaskName>[.Exception] | <TaskListName>.Exception");
            this.addParameter(this.createParameter(AbstractSchedulerOperation.TASKLIST_NAME, true));
            this.addParameter(this.createParameter(AbstractSchedulerOperation.TASK_NAME, true));
            this.addParameter(this.createParameter(AbstractSchedulerOperation.EXCEPTION, false));
        }

        private IdentifierParameter createParameter(String name, boolean required) {
            return (IdentifierParameter)new IdentifierParameter(name).setRequired(required);
        }
    }

    protected class FullTaskNameParameter
    extends CompoundParameter {
        public FullTaskNameParameter(TaskListState ... states) {
            this();
            this.setCompletionAdviser(new FullTaskNameCompletionAdviser(this$0, states));
        }

        public FullTaskNameParameter(List<TaskListState> listStates, List<TaskState> taskStates) {
            this();
            this.setCompletionAdviser(new FullTaskNameCompletionAdviser(this$0, listStates, taskStates));
        }

        public FullTaskNameParameter(TaskType taskType, TaskListState ... states) {
            this();
            this.setCompletionAdviser(new FullTaskNameCompletionAdviser(this$0, taskType, states));
        }

        public FullTaskNameParameter(String listName, String taskName, TaskType taskType) {
            this(listName, taskName, false);
            this.setCompletionAdviser(new FullTaskNameCompletionAdviser(this$0, taskType, (TaskListState[])null));
        }

        public FullTaskNameParameter(TaskType taskType, boolean asteriskAllowed) {
            this(asteriskAllowed);
            this.setCompletionAdviser(new FullTaskNameCompletionAdviser(this$0, taskType, (TaskListState[])null));
        }

        private FullTaskNameParameter() {
            this(false);
        }

        private FullTaskNameParameter(boolean asteriskAllowed) {
            this(AbstractSchedulerOperation.TASKLIST_NAME, AbstractSchedulerOperation.TASK_NAME, asteriskAllowed);
        }

        private FullTaskNameParameter(String listName, String taskName, boolean asteriskAllowed) {
            this.setParametersDelimiter('.');
            this.addParameter(this.createParameter(listName, asteriskAllowed));
            this.addParameter(this.createParameter(taskName, asteriskAllowed));
        }

        private IdentifierParameter createParameter(String name, boolean asteriskAllowed) {
            return new IdentifierParameter(name).setAsteriskAllowed(asteriskAllowed);
        }
    }
}

