/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.Trace;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.SchedulerObject;
import com.streamscape.sef.security.ComponentOwner;
import java.util.Date;
import java.util.UUID;

abstract class AbstractSchedulerObject
extends CloneableDataObject
implements SchedulerObject {
    transient SchedulerImpl scheduler;
    private UUID oid;
    private String name;
    private String description;
    private String author;
    private String owner;
    private Date creationTime;
    private Date lastUpdateTime;

    protected AbstractSchedulerObject(String name, String author) {
        this(name, author, author);
    }

    protected AbstractSchedulerObject(String name, AbstractSchedulerObject other, String owner) {
        this(name, other.author, owner);
        this.description = other.description;
    }

    protected AbstractSchedulerObject(AbstractSchedulerObject other) {
        this.scheduler = other.scheduler;
        this.oid = other.oid;
        this.name = other.name;
        this.description = other.description;
        this.author = other.author;
        this.owner = other.owner;
        this.creationTime = other.creationTime;
        this.lastUpdateTime = other.lastUpdateTime;
    }

    private AbstractSchedulerObject() {
        this.setOID();
        this.creationTime = new Date();
        this.lastUpdateTime = new Date();
    }

    private AbstractSchedulerObject(String name, String author, String owner) {
        this();
        this.doSetName(name);
        this.doSetAuthor(author);
        this.doSetOwner(owner);
    }

    protected void update(AbstractSchedulerObject other) throws SchedulerException {
        if (!Utils.equalsNullSafe(this.name, other.name)) {
            this.checkNameUniqueness(other.name);
            this.doSetName(other.name);
        }
        this.description = other.description;
        this.onUpdate();
    }

    protected void init(SchedulerImpl scheduler) {
        this.scheduler = scheduler;
    }

    void initOnLoad(SchedulerImpl scheduler, OldFormatVersion oldFormatVersion) throws SchedulerException {
        this.init(scheduler);
        boolean needUpdate = this.checkOnLoad(oldFormatVersion);
        if (needUpdate) {
            this.updateInStorage();
        }
    }

    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        if (this.owner == null) {
            this.doSetOwner(this.scheduler.getDefaultOwnerName());
            return true;
        }
        return false;
    }

    @Override
    public UUID getOID() {
        return this.oid;
    }

    void setOID() {
        this.oid = UUID.randomUUID();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void setName(String name) throws SchedulerException {
        SchedulerImpl.checkName(name);
        this.doSetName(name);
        this.onUpdate();
    }

    void doSetName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.description = description;
        this.onUpdate();
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    private void doSetAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    void setOwner(ComponentOwner owner) throws SchedulerException {
        this.checkDisabled();
        this.doSetOwner(owner.getName().toString());
        this.onUpdate();
    }

    private void doSetOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    protected abstract void checkDisabled() throws SchedulerException;

    protected abstract void checkNameUniqueness(String var1) throws SchedulerException;

    protected void updateInStorage() {
        this.onUpdate();
        this.doUpdateInStorage();
    }

    protected abstract void doUpdateInStorage();

    protected void onUpdate() {
        this.lastUpdateTime = new Date();
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, this.toLogName() + " " + message);
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, false);
    }

    protected void logError(String errorMessage) {
        Trace.logError(this, this.toLogName() + " " + errorMessage);
    }

    protected void logError(Throwable exception, String errorMessage) {
        this.logException(exception);
        this.logError(errorMessage);
    }

    protected String toLogName() {
        return AbstractSchedulerObject.toLogName(this.getName());
    }

    protected static String toLogName(NamedObject namedObject) {
        return AbstractSchedulerObject.toLogName(namedObject.getName());
    }

    protected static String toLogName(String name) {
        return "[" + name + "]";
    }

    abstract String toLogNameWithPrefix();

    public String toString() {
        return "author=" + this.author;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof AbstractSchedulerObject && Utils.equalsNullSafe(this.oid, ((AbstractSchedulerObject)other).oid);
    }
}

