/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.scheduler;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.timer.AbstractFabricTimerTask;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerException;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.scheduler.AbstractSchedulerObject;
import com.streamscape.sef.scheduler.ExecutionMode;
import com.streamscape.sef.scheduler.JobState;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.NotifyLevel;
import com.streamscape.sef.scheduler.OldFormatVersion;
import com.streamscape.sef.scheduler.ScheduledJob;
import com.streamscape.sef.scheduler.SchedulerAdvisory;
import com.streamscape.sef.scheduler.SchedulerAdvisoryType;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.Task;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TaskListExecution;
import com.streamscape.sef.scheduler.TaskListState;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;

abstract class AbstractJob
extends AbstractSchedulerObject
implements ScheduledJob {
    Date startTime;
    JobState state = JobState.DISABLED;
    private UUID taskListId;
    transient TaskList taskList;
    private boolean notify;
    private NotifyLevel level = NotifyLevel.JOB;
    private String to;
    private String subject;
    private String body;
    private Metaset executionMetaset;
    transient FabricTimer taskTimer;
    transient FabricThread taskThread;
    private static final String TIMER_GROUP = "Scheduler";

    AbstractJob(String name, String author) {
        super(name, author);
    }

    AbstractJob(String name, AbstractJob other, String owner) {
        super(name, other, owner);
        this.copyFields(other);
        this.state = JobState.DISABLED;
    }

    AbstractJob(AbstractJob other) {
        super(other);
        this.copyFields(other);
        this.state = other.state;
        this.taskListId = other.taskListId;
        this.taskList = other.taskList;
    }

    protected abstract AbstractJob copy();

    protected void update(AbstractJob other) throws SchedulerException {
        super.update(other);
        this.copyFields(other);
    }

    private void copyFields(AbstractJob other) {
        this.startTime = other.startTime;
        this.notify = other.notify;
        this.level = other.level;
        this.to = other.to;
        this.subject = other.subject;
        this.body = other.body;
        this.executionMetaset = other.executionMetaset;
    }

    @Override
    protected void init(SchedulerImpl scheduler) {
        super.init(scheduler);
        if (this.executionMetaset != null) {
            this.executionMetaset.init(scheduler);
        }
    }

    @Override
    protected boolean checkOnLoad(OldFormatVersion oldFormatVersion) throws SchedulerException {
        boolean result = super.checkOnLoad(oldFormatVersion);
        if (this.taskListId != null) {
            this.taskList = this.scheduler.doGetTaskList(this.taskListId);
            if (this.taskList != null) {
                this.taskList.setJob(this);
            }
        }
        if (this.level == null) {
            this.level = NotifyLevel.JOB;
            result = true;
        }
        return result;
    }

    @Override
    protected void checkNameUniqueness(String name) throws SchedulerException {
        if (this.scheduler.existsJob(name)) {
            throw new SchedulerException(6115, "Job '" + name + "' already exists.");
        }
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized void setStartTime(Date startTime) throws SchedulerException {
        this.startTime = startTime;
    }

    Date getExecutionTime() {
        return this.startTime;
    }

    @Override
    public Date getNextExecutionTime() {
        return this.isEventAvailable() ? this.startTime : null;
    }

    @Override
    public Date getLastExecutionTime() {
        return this.isEventAvailable() ? null : this.startTime;
    }

    @Override
    public JobState getState() {
        return this.state;
    }

    @Override
    public boolean isNotify() {
        return this.notify;
    }

    @Override
    public synchronized void setNotify(boolean notify) throws SchedulerException {
        this.notify = notify;
    }

    @Override
    public NotifyLevel getNotifyLevel() {
        return this.level;
    }

    @Override
    public synchronized void setNotifyLevel(NotifyLevel level) throws SchedulerException {
        this.level = level;
    }

    @Override
    public String getNotifyTo() {
        return this.to;
    }

    @Override
    public String getNotifyToResolved() {
        return this.getResolvedParameter(() -> this.scheduler.resolveTo(this.to, null));
    }

    @Override
    public synchronized void setNotifyTo(String to) throws SchedulerException {
        this.to = to;
    }

    @Override
    public String getNotifySubject() {
        return this.subject;
    }

    @Override
    public String getNotifySubjectResolved() {
        return this.getResolvedParameter(() -> this.scheduler.resolveSubject(this.subject, null));
    }

    @Override
    public synchronized void setNotifySubject(String subject) throws SchedulerException {
        this.subject = subject;
    }

    @Override
    public String getNotifyBody() {
        return this.body;
    }

    @Override
    public String getNotifyBodyResolved() {
        return this.getResolvedParameter(() -> this.scheduler.resolveBody(this.body, null));
    }

    @Override
    public synchronized void setNotifyBody(String body) throws SchedulerException {
        this.body = body;
    }

    private String getResolvedParameter(Callable<String> caller) {
        try {
            return caller.call();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    void enable() throws SchedulerException {
        this.checkNotFinished();
        if (this.state == JobState.DISABLED) {
            this.checkParameters();
            this.checkTaskListState();
            this.taskList.checkNotRunning();
            this.taskList.setScheduled();
            this.doEnable(false);
            this.raiseAdvisory(SchedulerAdvisoryType.JOB_ENABLED, false);
        }
    }

    boolean enableOnLoad() throws SchedulerException {
        try {
            if (this.taskList.getState() == TaskListState.DISABLED) {
                throw new SchedulerException(6139, "Enabling " + this.toLogNameWithPrefix() + " failed. Cause: Associated " + this.taskList.toLogNameWithPrefix() + " disabled.");
            }
            this.checkParameters();
        }
        catch (SchedulerException exception) {
            this.state = JobState.DISABLED;
            this.updateInStorage();
            throw exception;
        }
        this.taskList.setScheduled();
        if (this.taskList.isRunning()) {
            return false;
        }
        this.doEnable(true);
        return true;
    }

    private void checkTaskListState() throws SchedulerException {
        if (this.taskList != null && this.taskList.getState() == TaskListState.DISABLED) {
            throw new SchedulerException(6139, "Associated " + this.taskList.toLogNameWithPrefix() + " disabled. Enable it first.");
        }
    }

    protected void checkParameters() throws SchedulerException {
        this.checkTaskList();
        this.checkStartTime();
        if (this.executionMetaset != null) {
            this.checkMetaset(this.executionMetaset);
        }
    }

    void checkTaskList() throws SchedulerException {
        if (this.taskList == null) {
            throw new SchedulerException(6004, "Task List is not set.");
        }
    }

    void checkStartTime() throws SchedulerException {
        if (this.startTime == null) {
            throw new SchedulerException(6004, "Start time is not set.");
        }
    }

    private void doEnable(boolean onLoad) {
        if (this.scheduleEvent(onLoad)) {
            this.state = JobState.ENABLED;
            this.updateInStorage();
        } else {
            this.finish();
        }
    }

    boolean scheduleEvent(boolean onLoad) {
        return this.doScheduleEvent(this.startTime);
    }

    void disable() throws SchedulerException {
        this.checkNotFinished();
        this.disableWithoutCheck();
    }

    void disableWithoutCheck() throws SchedulerException {
        if (this.state == JobState.ENABLED) {
            this.state = JobState.DISABLED;
            this.doDisable();
        }
    }

    void doDisable() throws SchedulerException {
        this.destroyTimer();
        this.taskList.setScheduled(false);
        this.updateInStorage();
        this.raiseAdvisory(SchedulerAdvisoryType.JOB_DISABLED, false);
    }

    void destroy() {
        this.destroyTimer();
        this.scheduler = null;
    }

    private void destroyTimer() {
        if (this.taskTimer != null) {
            if (this.taskThread != null) {
                this.taskThread.stop();
                this.taskThread = null;
            }
            this.taskTimer.stop();
            this.taskTimer = null;
        }
    }

    void onDrop() {
        if (this.taskList != null) {
            this.taskList.clearJob();
        }
    }

    @Override
    public UUID getTaskListOID() {
        return this.taskListId;
    }

    @Override
    public String getTaskListName() {
        return this.taskList != null ? this.taskList.getName() : null;
    }

    @Override
    public TaskList getTaskList() {
        return this.scheduler.doCopy(this.taskList, this.getOwner());
    }

    void setTaskList(TaskList taskList) throws SchedulerException {
        this.checkDisabled();
        if (taskList == null) {
            this.clearTaskList();
        } else if (taskList.job != this) {
            if (taskList.job != null) {
                if (taskList.job.getState() == JobState.FINISHED) {
                    taskList.job.clearTaskList();
                } else {
                    throw new SchedulerException(6142, taskList.toLogNameWithPrefix() + " already set for another Job.");
                }
            }
            this.doSetTaskList(taskList, taskList.getOID());
            this.taskList.setJob(this);
        }
    }

    void clearTaskList() {
        this.doSetTaskList(null, null);
    }

    private void doSetTaskList(TaskList taskList, UUID taskListId) {
        if (this.taskList != null) {
            this.taskList.clearJob();
        }
        this.taskList = taskList;
        this.taskListId = taskListId;
        this.updateInStorage();
    }

    @Override
    public boolean hasExecutionMetaset() {
        return this.executionMetaset != null;
    }

    @Override
    public Metaset getExecutionMetaset() {
        return this.scheduler.doCopy(this.executionMetaset);
    }

    @Override
    public synchronized void setExecutionMetaset(Metaset metaset) throws SchedulerException {
        this.checkDisabled();
        if (metaset == null) {
            this.executionMetaset = null;
        } else {
            this.checkTaskList();
            this.checkMetaset(metaset);
            this.executionMetaset = this.scheduler.doCopy(metaset);
        }
    }

    private void checkMetaset(Metaset metaset) throws SchedulerException {
        UUID metasetId = this.taskList.getMetasetOID();
        if (metasetId == null) {
            throw new SchedulerException(6004, "Metaset is not set for associated Task List.");
        }
        if (!metaset.getOID().equals(metasetId)) {
            throw new SchedulerException(6007, "Execution Metaset does not match the Metaset of associated Task List.");
        }
    }

    @Override
    protected void checkDisabled() throws SchedulerException {
        this.checkNotFinished();
        if (this.state != JobState.DISABLED) {
            throw new SchedulerException(6116, this.toLogNameWithPrefix() + " is enabled and cannot be changed.");
        }
    }

    void checkNotFinished() throws SchedulerException {
        if (this.state == JobState.FINISHED) {
            throw new SchedulerException(6117, this.toLogNameWithPrefix() + " is finished and cannot be changed.");
        }
    }

    boolean isEventAvailable() {
        return this.startTime != null && !this.isExpired();
    }

    protected boolean doScheduleEvent(Date time) {
        if (!this.isEventAvailable()) {
            return false;
        }
        try {
            this.taskTimer = FabricTimerManager.getInstance().createTimer(TIMER_GROUP, this.getName() + time.getTime(), new TimerTask(), 1L, 1);
            this.taskTimer.start(time);
        }
        catch (FabricTimerException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Starting " + this.toLogNameWithPrefix() + " failed.");
            return false;
        }
        return true;
    }

    boolean beforeTaskListExecution() {
        if (this.taskTimer != null) {
            try {
                this.scheduler.prepareExecution(this.taskList, this.executionMetaset, this.getOwner(), ExecutionMode.SCHEDULED, this.getExecutionTime(), null, false);
                this.raiseAdvisory(SchedulerAdvisoryType.JOB_EXECUTION_STARTED, true);
                return true;
            }
            catch (SchedulerException exception) {
                this.logError(exception, "Executing " + this.toLogNameWithPrefix() + " skipped.");
                this.raiseAdvisory(SchedulerAdvisoryType.JOB_EXECUTION_SKIPPED, true);
                this.afterTaskListExecution(false);
            }
        }
        return false;
    }

    private boolean executeTaskList() throws SchedulerException {
        return this.taskTimer != null && this.taskList.executeDirect(null) == TaskListState.COMPLETED;
    }

    synchronized void afterTaskListExecution(boolean completed) {
        if (this.taskThread != null) {
            this.taskTimer = null;
            this.taskThread = null;
            if (completed) {
                this.raiseAdvisory(SchedulerAdvisoryType.JOB_EXECUTION_COMPLETED, true);
            } else {
                this.raiseAdvisory(SchedulerAdvisoryType.JOB_EXECUTION_FAILED, true);
            }
            this.finish();
        }
    }

    void finish() {
        this.taskList.setScheduled(false);
        this.state = JobState.FINISHED;
        this.updateInStorage();
        this.raiseAdvisory(SchedulerAdvisoryType.JOB_FINISHED, false);
    }

    void resume() {
        this.taskThread = FabricThreadManager.getInstance().createThread("FSYS:Scheduler.Executor:Job_" + this.getName(), "Resumes a job.", () -> {
            try {
                this.logInfo("Last Execution was not completed. Trying to resume...");
                boolean completed = this.resumeTaskList();
                this.afterTaskListExecution(completed);
            }
            catch (SchedulerException exception) {
                this.afterTaskListExecution(false);
            }
            this.taskList.setNotRunning();
        });
        this.taskThread.start();
    }

    private boolean resumeTaskList() throws SchedulerException {
        return this.taskList.resume() == TaskListState.COMPLETED;
    }

    boolean isExpired() {
        return AbstractJob.isExpired(this.startTime);
    }

    static boolean isExpired(Date time) {
        return time.getTime() < System.currentTimeMillis();
    }

    synchronized boolean matches(Date time) {
        return this.startTime.equals(time);
    }

    synchronized boolean matches(TimeWindow window) {
        return this.matches(window.getStartTime(), window.getEndTime());
    }

    boolean matches(Date fromTime, Date toTime) {
        return !(this.startTime == null || fromTime != null && this.startTime.before(fromTime) || toTime != null && this.startTime.after(toTime));
    }

    protected void raiseAdvisory(SchedulerAdvisoryType type, boolean withEmail) {
        SchedulerAdvisory advisory = this.scheduler.raiseAdvisory(type, this.getName(), null, null, null, null, null, this.getEventScope());
        if (withEmail) {
            this.raiseMailEvent(advisory);
        }
    }

    protected void raiseAdvisory(SchedulerAdvisoryType type, Task task, TaskListExecution execution, Map<String, Object> facets, Long delay) {
        SchedulerAdvisory advisory = this.scheduler.raiseAdvisory(type, this.getName(), this.taskList.getName(), task != null ? task.getName() : null, execution, facets, delay, this.getEventScope());
        this.raiseMailEvent(advisory);
    }

    protected void raiseException(Throwable cause, Task task, TaskListExecution execution) {
        SchedulerAdvisory advisory = this.scheduler.raiseException(cause, this.getName(), this.taskList.getName(), task != null ? task.getName() : null, execution, this.getEventScope());
        this.raiseMailEvent(advisory);
    }

    private void raiseMailEvent(SchedulerAdvisory advisory) {
        if (this.notify && this.matchNotifyLevel(advisory.getType())) {
            this.scheduler.raiseMailEvent(this.to, this.subject, this.body, advisory, this.getEventScope());
        }
    }

    private boolean matchNotifyLevel(SchedulerAdvisoryType type) {
        switch (this.level) {
            case JOB: {
                return type.ordinal() <= SchedulerAdvisoryType.JOB_EXECUTION_SKIPPED.ordinal();
            }
            case TASKLIST: {
                return type.ordinal() <= SchedulerAdvisoryType.TASKLIST_FAILED.ordinal();
            }
            case TASK: {
                return type.ordinal() <= SchedulerAdvisoryType.TASK_UNDO_DELAY_COMPLETED.ordinal();
            }
        }
        throw new RuntimeException("Invalid NotifyLevel!");
    }

    private EventScope getEventScope() {
        return this.taskList.getEventScope();
    }

    @Override
    protected void doUpdateInStorage() {
        this.scheduler.doUpdate(this);
    }

    @Override
    public String toString() {
        return this.getName() + "(" + super.toString() + "type=" + String.valueOf((Object)this.getType()) + ", state=" + String.valueOf((Object)this.getState()) + (String)(this.taskList != null ? ", task list(" + String.valueOf(this.taskList.getOID()) + "))" : ")");
    }

    @Override
    String toLogNameWithPrefix() {
        return AbstractJob.toLogNameWithPrefix(this.getName());
    }

    static String toLogNameWithPrefix(String name) {
        return "Job " + AbstractJob.toLogName(name);
    }

    class TimerTask
    extends AbstractFabricTimerTask {
        TimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(FabricTimer timer) {
            AbstractJob abstractJob = AbstractJob.this;
            synchronized (abstractJob) {
                if (AbstractJob.this.taskTimer != null) {
                    AbstractJob.this.taskThread = FabricThreadManager.getInstance().createThread("FSYS:Scheduler.Executor:Job_" + AbstractJob.this.getName(), "Executes a job.", () -> {
                        if (AbstractJob.this.beforeTaskListExecution()) {
                            try {
                                boolean completed = AbstractJob.this.executeTaskList();
                                AbstractJob.this.afterTaskListExecution(completed);
                            }
                            catch (SchedulerException exception) {
                                AbstractJob.this.afterTaskListExecution(false);
                            }
                            AbstractJob.this.taskList.setNotRunning();
                        }
                    });
                    AbstractJob.this.taskThread.start();
                }
            }
        }
    }
}

